/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.securityUtil.monitorSysDef;

import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.sysdef.BProviderEvent;
import com.tridium.nd.sysdef.BSysDefProvider;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.securityUtil.monitorSysDef.BMonitorSysDefEvent;
import com.tridiumx.entsec.securityUtil.monitorSysDef.BMonitorSysDefSecurity;
import javax.baja.nd.BINiagaraStation;
import javax.baja.nd.BStationRole;
import javax.baja.nd.SysDefSession;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="handleProviderEvent", parameterType="BProviderEvent", defaultValue="new BProviderEvent()", flags=4), @NiagaraAction(name="execute")})
@NiagaraTopic(name="monitorSysDefEvent", eventType="BMonitorSysDefEvent")
public final class BMonitorSysDef
extends BComponent {
    public static final Action handleProviderEvent = BMonitorSysDef.newAction((int)4, (BValue)new BProviderEvent(), null);
    public static final Action execute = BMonitorSysDef.newAction((int)0, null);
    public static final Topic monitorSysDefEvent = BMonitorSysDef.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BMonitorSysDef.class);
    private static final BIcon icon = BIcon.std((String)"remoteMgmt.png");
    private BMonitorSysDefSecurity monitorSysDefSecurity = null;

    public void handleProviderEvent(BProviderEvent parameter) {
        this.invoke(handleProviderEvent, (BValue)parameter, null);
    }

    public void execute() {
        this.invoke(execute, null, null);
    }

    public void fireMonitorSysDefEvent(BMonitorSysDefEvent event) {
        this.fire(monitorSysDefEvent, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        new InitSystem("EntSec:InitSysDefThread", true).start();
    }

    public void stopped() throws Exception {
        super.stopped();
        this.unlinkFromProvider();
    }

    public void doExecute() {
        this.unlinkFromProvider();
        this.initMonitor();
    }

    public void doHandleProviderEvent(BProviderEvent event) {
        if (event.getStationName().equals(Sys.getStation().getStationName())) {
            return;
        }
        switch (event.getId()) {
            case 0: {
                this.handleInsertStation(event.getStationName());
                break;
            }
            case 1: {
                this.handleUpdateStation(event.getStationName());
                break;
            }
            case 2: {
                this.handleDeleteStation(event.getStationName());
                break;
            }
        }
    }

    public BTypeSpec getServiceTypeSpec() {
        return this.getParent().getType().getTypeSpec();
    }

    private void linkToProvider() {
        if (this.get("providerLink") != null) {
            return;
        }
        BSysDefProvider provider = this.getSysDefProvider();
        if (provider != null) {
            this.linkTo("providerLink", (BComponent)provider, (Slot)BSysDefProvider.providerEvent, (Slot)handleProviderEvent);
        }
    }

    private void unlinkFromProvider() {
        Property p = this.getProperty("providerLink");
        if (p != null) {
            this.remove(p);
        }
    }

    private BNiagaraNetwork getNiagaraNetwork() {
        return (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
    }

    private BSysDefProvider getSysDefProvider() {
        return this.getNiagaraNetwork().getSysDefProvider();
    }

    private SysDefSession getProviderSession(Context cx) {
        return this.getNiagaraNetwork().createSysDefSession(cx);
    }

    private BMonitorSysDefSecurity getMonitorSysDefSecurity() {
        if (this.monitorSysDefSecurity != null) {
            return this.monitorSysDefSecurity;
        }
        BEnterpriseSecurityService entsecService = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        this.monitorSysDefSecurity = entsecService.getMonitorSysDefSecurity();
        return this.monitorSysDefSecurity;
    }

    private void initMonitor() {
        BINiagaraStation[] stations = null;
        int i = 0;
        stations = this.getSecuritySupervisors();
        if (stations.length > 0) {
            for (i = 0; i < stations.length; ++i) {
                this.handleInsertStation(stations[i].getStationName());
            }
        }
        if ((stations = this.getSecuritySubordinates()).length > 0) {
            for (i = 0; i < stations.length; ++i) {
                this.handleInsertStation(stations[i].getStationName());
            }
        }
        this.linkToProvider();
        this.initService();
    }

    private void handleInsertStation(String stationName) {
        if (this.isStationSecuritySupervisor(stationName)) {
            this.insertStationRole(stationName, BStationRole.supervisor);
        } else if (this.isStationSecuritySubordinate(stationName)) {
            this.insertStationRole(stationName, BStationRole.subordinate);
        }
    }

    private void handleUpdateStation(String stationName) {
        if (this.isStationSecuritySupervisor(stationName)) {
            this.updateStationRole(stationName, BStationRole.supervisor);
        } else if (this.isStationSecuritySubordinate(stationName)) {
            this.updateStationRole(stationName, BStationRole.subordinate);
        }
    }

    private void handleDeleteStation(String stationName) {
        this.removeStationRole(stationName);
    }

    private boolean isStationSecuritySupervisor(String stationName) {
        BINiagaraStation[] stations = this.getSecuritySupervisors();
        if (stationName == null) {
            return stations.length > 0;
        }
        for (int i = 0; i < stations.length; ++i) {
            if (!stations[i].getStationName().equals(stationName)) continue;
            return true;
        }
        return false;
    }

    private boolean isStationSecuritySubordinate(String stationName) {
        BINiagaraStation[] stations = this.getSecuritySubordinates();
        if (stationName == null) {
            return stations.length > 0;
        }
        for (int i = 0; i < stations.length; ++i) {
            if (!stations[i].getStationName().equals(stationName)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BINiagaraStation[] getSecuritySupervisors() {
        Array securityStations = new Array(BINiagaraStation.class);
        SysDefSession session = this.getProviderSession(null);
        if (session != null && session.getLocalStation() != null) {
            try {
                BINiagaraStation[] stations = session.getSupervisors(session.getLocalStation());
                for (int i = 0; i < stations.length; ++i) {
                    if (!session.getServices(session.getStation(stations[i].getStationName())).contains((Object)this.getServiceTypeSpec())) continue;
                    securityStations.add((Object)stations[i]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (session != null && session.isOpen()) {
                    session.close();
                }
            }
        }
        return (BINiagaraStation[])securityStations.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BINiagaraStation[] getSecuritySubordinates() {
        Array securityStations = new Array(BINiagaraStation.class);
        SysDefSession session = this.getProviderSession(null);
        if (session != null && session.getLocalStation() != null) {
            try {
                BINiagaraStation[] stations = session.getSubordinates(session.getLocalStation());
                for (int i = 0; i < stations.length; ++i) {
                    if (!session.getServices(session.getStation(stations[i].getStationName())).contains((Object)this.getServiceTypeSpec())) continue;
                    securityStations.add((Object)stations[i]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (session != null && session.isOpen()) {
                    session.close();
                }
            }
        }
        return (BINiagaraStation[])securityStations.trim();
    }

    private void initService() {
        BMonitorSysDefSecurity monitorSysDefSecurity = this.getMonitorSysDefSecurity();
        if (monitorSysDefSecurity != null) {
            monitorSysDefSecurity.init();
        }
    }

    private void insertStationRole(String stationName, BStationRole stationRole) {
        int flags = 1;
        BMonitorSysDefSecurity monitorSysDefSecurity = this.getMonitorSysDefSecurity();
        if (monitorSysDefSecurity != null) {
            monitorSysDefSecurity.insertStationRole(stationName, stationRole, this.getServiceTypeSpec(), this.getSlotPathOrd(), flags);
        }
    }

    private void updateStationRole(String stationName, BStationRole stationRole) {
        BMonitorSysDefSecurity monitorSysDefSecurity = this.getMonitorSysDefSecurity();
        if (monitorSysDefSecurity != null) {
            monitorSysDefSecurity.updateStationRole(stationName, stationRole, this.getServiceTypeSpec());
        }
    }

    private void removeStationRole(String stationName) {
        BMonitorSysDefSecurity monitorSysDefSecurity = this.getMonitorSysDefSecurity();
        if (monitorSysDefSecurity != null) {
            monitorSysDefSecurity.removeStationRole(stationName, this.getServiceTypeSpec());
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    class InitSystem
    extends Thread {
        public InitSystem(String name, boolean daemon) {
            super(name);
            this.setDaemon(daemon);
        }

        @Override
        public void run() {
            try {
                boolean done = false;
                boolean sysDefProviderReady = false;
                int count = 0;
                BSysDefProvider provider = null;
                BMonitorSysDefSecurity monitorSysDefSecurity = null;
                while (!done) {
                    try {
                        if (provider == null) {
                            provider = BMonitorSysDef.this.getSysDefProvider();
                        }
                        if (!sysDefProviderReady && provider != null && provider.getState().getOrdinal() == 0) {
                            sysDefProviderReady = true;
                        }
                        if (monitorSysDefSecurity == null) {
                            monitorSysDefSecurity = BMonitorSysDef.this.getMonitorSysDefSecurity();
                        }
                        if (sysDefProviderReady && monitorSysDefSecurity != null) {
                            BMonitorSysDef.this.initMonitor();
                            done = true;
                            continue;
                        }
                        Thread.sleep(500L);
                    }
                    catch (Exception e) {
                        try {
                            if (++count == 20) {
                                done = true;
                                continue;
                            }
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            BMonitorSysDef.this.linkToProvider();
        }
    }
}

