/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.securityUtil.alarm;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.nd.BINiagaraDeviceExt;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.sysdef.BNiagaraSysDefDeviceExt;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionSession;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.intrusion.BIntrusionService;
import com.tridiumx.entsec.intrusion.BIntrusionZone;
import com.tridiumx.entsec.intrusion.orion.BIntrusionZoneGroup;
import com.tridiumx.entsec.intrusion.orion.BIntrusionZoneRec;
import com.tridiumx.entsec.orionTools.MappingSupport;
import com.tridiumx.entsec.securityUtil.alarm.AlarmClassSyncException;
import com.tridiumx.entsec.securityUtil.alarm.BAlarmClassEvent;
import com.tridiumx.entsec.securityUtil.alarm.BAlarmClassSyncChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BIAlarmClassFolder;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDeviceExt;
import javax.baja.nd.BStationRole;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType(agent={@AgentOn(types={"niagaraDriver:NiagaraStation"})})
@NiagaraProperties(value={@NiagaraProperty(name="syncInEnabled", type="boolean", defaultValue="false"), @NiagaraProperty(name="syncOutEnabled", type="boolean", defaultValue="false"), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=3), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=3), @NiagaraProperty(name="syncRequired", type="boolean", defaultValue="true", flags=1), @NiagaraProperty(name="syncDelay", type="BRelTime", defaultValue="BRelTime.makeSeconds(30)", facets={@Facet(value="BFacets.make(BFacets.MIN, BRelTime.makeSeconds(1))")}), @NiagaraProperty(name="syncRetry", type="BRelTime", defaultValue="BRelTime.makeMinutes(5)", facets={@Facet(value="BFacets.make(BFacets.MIN, BRelTime.makeSeconds(15))")}), @NiagaraProperty(name="lastSyncAttempt", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1, facets={@Facet(value="BFacets.make(BFacets.SHOW_SECONDS, true)")}), @NiagaraProperty(name="lastSyncSuccess", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1, facets={@Facet(value="BFacets.make(BFacets.SHOW_SECONDS, true)")})})
@NiagaraActions(value={@NiagaraAction(name="handleAlarmClassEvent", parameterType="BAlarmClassEvent", defaultValue="new BAlarmClassEvent()", flags=4), @NiagaraAction(name="sync", flags=16), @NiagaraAction(name="scheduleSyncSoon", flags=5)})
public class BNiagaraAlarmClassDeviceExt
extends BDeviceExt
implements BIStatus,
BINiagaraDeviceExt,
BFoxClientConnection.Interest,
BIMixIn {
    public static final Property syncInEnabled = BNiagaraAlarmClassDeviceExt.newProperty((int)0, (boolean)false, null);
    public static final Property syncOutEnabled = BNiagaraAlarmClassDeviceExt.newProperty((int)0, (boolean)false, null);
    public static final Property status = BNiagaraAlarmClassDeviceExt.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property faultCause = BNiagaraAlarmClassDeviceExt.newProperty((int)3, (String)"", null);
    public static final Property syncRequired = BNiagaraAlarmClassDeviceExt.newProperty((int)1, (boolean)true, null);
    public static final Property syncDelay = BNiagaraAlarmClassDeviceExt.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)30), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1)));
    public static final Property syncRetry = BNiagaraAlarmClassDeviceExt.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)5), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)15)));
    public static final Property lastSyncAttempt = BNiagaraAlarmClassDeviceExt.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (boolean)true));
    public static final Property lastSyncSuccess = BNiagaraAlarmClassDeviceExt.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (boolean)true));
    public static final Action handleAlarmClassEvent = BNiagaraAlarmClassDeviceExt.newAction((int)4, (BValue)new BAlarmClassEvent(), null);
    public static final Action sync = BNiagaraAlarmClassDeviceExt.newAction((int)16, null);
    public static final Action scheduleSyncSoon = BNiagaraAlarmClassDeviceExt.newAction((int)5, null);
    public static final Type TYPE = Sys.loadType(BNiagaraAlarmClassDeviceExt.class);
    private static final BIcon icon = BIcon.make((String)"module://icons/x16/alarm/alarmClass.png");
    private Clock.Ticket ticket;
    public static Logger log = Logger.getLogger("niagara.alarmClasses");

    public boolean getSyncInEnabled() {
        return this.getBoolean(syncInEnabled);
    }

    public void setSyncInEnabled(boolean v) {
        this.setBoolean(syncInEnabled, v, null);
    }

    public boolean getSyncOutEnabled() {
        return this.getBoolean(syncOutEnabled);
    }

    public void setSyncOutEnabled(boolean v) {
        this.setBoolean(syncOutEnabled, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public boolean getSyncRequired() {
        return this.getBoolean(syncRequired);
    }

    public void setSyncRequired(boolean v) {
        this.setBoolean(syncRequired, v, null);
    }

    public BRelTime getSyncDelay() {
        return (BRelTime)this.get(syncDelay);
    }

    public void setSyncDelay(BRelTime v) {
        this.set(syncDelay, (BValue)v, null);
    }

    public BRelTime getSyncRetry() {
        return (BRelTime)this.get(syncRetry);
    }

    public void setSyncRetry(BRelTime v) {
        this.set(syncRetry, (BValue)v, null);
    }

    public BAbsTime getLastSyncAttempt() {
        return (BAbsTime)this.get(lastSyncAttempt);
    }

    public void setLastSyncAttempt(BAbsTime v) {
        this.set(lastSyncAttempt, (BValue)v, null);
    }

    public BAbsTime getLastSyncSuccess() {
        return (BAbsTime)this.get(lastSyncSuccess);
    }

    public void setLastSyncSuccess(BAbsTime v) {
        this.set(lastSyncSuccess, (BValue)v, null);
    }

    public void handleAlarmClassEvent(BAlarmClassEvent parameter) {
        this.invoke(handleAlarmClassEvent, (BValue)parameter, null);
    }

    public void sync() {
        this.invoke(sync, null, null);
    }

    public void scheduleSyncSoon() {
        this.invoke(scheduleSyncSoon, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BNiagaraAlarmClassDeviceExt getForStation(BNiagaraStation station) {
        SlotCursor c = station.getProperties();
        if (c.next(BNiagaraAlarmClassDeviceExt.class)) {
            return (BNiagaraAlarmClassDeviceExt)c.get();
        }
        return null;
    }

    public static void setReadonly(BComplex root) {
        Property p;
        int flags;
        BComplex parent = root.getParent();
        if (parent != null && ((flags = parent.getFlags((Slot)(p = root.getPropertyInParent()))) & 1) != 0) {
            parent.setFlags((Slot)p, flags | 1);
        }
        BNiagaraAlarmClassDeviceExt.setChildrenReadonly(root);
    }

    private static void setChildrenReadonly(BComplex root) {
        SlotCursor c = root.getProperties();
        while (c.next()) {
            Property p = c.property();
            if (!Flags.isReadonly((BComplex)root, (Slot)p)) {
                root.setFlags((Slot)p, root.getFlags((Slot)p) | 1);
            }
            if (!p.getType().is(BComplex.TYPE)) continue;
            BNiagaraAlarmClassDeviceExt.setChildrenReadonly((BComplex)c.get());
        }
    }

    public void clientOpened() {
    }

    public void clientClosed() {
    }

    public void serverOpened() {
    }

    public void serverClosed() {
    }

    public final BFoxClientConnection getClientConnection() {
        return ((BNiagaraStation)this.getParent()).getClientConnection();
    }

    public final BAlarmClassSyncChannel getClientAlarmClassChannel() {
        return (BAlarmClassSyncChannel)((BNiagaraStation)this.getParent()).getClientConnection().getChannels().get("alarmClassSync", BAlarmClassSyncChannel.TYPE);
    }

    public void checkConfig() {
        BNiagaraStation station;
        BNiagaraSysDefDeviceExt sysDef;
        BStationRole role;
        BEnterpriseSecurityService acService = null;
        try {
            acService = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
        if (acService == null) {
            this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause("SecurityUtilService not found.");
            return;
        }
        boolean fault = false;
        this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (!this.getSyncInEnabled() && !this.getSyncOutEnabled() ? 1 : 0) != 0));
        if (this.getSyncInEnabled() && this.getSyncOutEnabled()) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause("syncIn and syncOut cannot be enabled for the same station.");
            fault = true;
        }
        if (!fault) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
            this.setFaultCause("");
        }
        if ((role = (sysDef = (station = (BNiagaraStation)this.getParent()).getSysDef()).getRoleManager().getActualRole()).equals((Object)BStationRole.supervisor)) {
            this.setSyncInEnabled(false);
            this.setSyncOutEnabled(true);
            this.setFlags((Slot)syncInEnabled, this.getFlags((Slot)syncInEnabled) | 1);
            this.setFlags((Slot)syncOutEnabled, this.getFlags((Slot)syncOutEnabled) & 0xFFFFFFFE);
        } else if (role.equals((Object)BStationRole.subordinate)) {
            this.setSyncOutEnabled(false);
            this.setSyncInEnabled(true);
            this.setFlags((Slot)syncOutEnabled, this.getFlags((Slot)syncOutEnabled) | 1);
            this.setFlags((Slot)syncInEnabled, this.getFlags((Slot)syncInEnabled) & 0xFFFFFFFE);
        }
    }

    public void syncAlarmClasses(BIAlarmClassFolder alarmClassFolder) {
        if (!this.getSyncInEnabled()) {
            return;
        }
        BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        this.recurseAlarmClassFolder((BIAlarmClassFolder)alarmService, alarmClassFolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recurseAlarmClassFolder(BIAlarmClassFolder localFolder, BIAlarmClassFolder toAdd) {
        SlotCursor c = ((BComponent)toAdd).getProperties();
        while (c.next()) {
            BValue o = c.get();
            if (!(o instanceof BAlarmClass) && !(o instanceof BIAlarmClassFolder)) continue;
            BComponent comp = (BComponent)o;
            if (((BComponent)localFolder).get(comp.getName()) == null) {
                BComponent copy = (BComponent)comp.newCopy();
                try {
                    BLink[] links = (BLink[])copy.getChildren(BLink.class);
                    for (int l = 0; l < links.length; ++l) {
                        Property prop;
                        BValue value;
                        String slotName = links[l].getTargetSlotName();
                        Slot s = copy.getSlot(slotName);
                        copy.remove(links[l].getPropertyInParent());
                        if (!(s instanceof Property) || (value = copy.get(prop = s.asProperty())).equals((Object)prop.getDefaultValue())) continue;
                        copy.set(prop, prop.getDefaultValue());
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Cannot properly remove links from  AlarmClass:" + copy.getName(), e);
                }
                ((BComponent)localFolder).add(comp.getName(), (BValue)copy);
                if (copy instanceof BIntrusionZone) {
                    BIntrusionZone zone = (BIntrusionZone)copy;
                    OrionSession session = null;
                    try {
                        BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
                        session = service.createSession(null);
                        BIntrusionZoneRec intrusionZoneRec = (BIntrusionZoneRec)session.mappedRead((BObject)zone);
                        String stationName = this.getDevice().getName();
                        BIntrusionZoneGroup group = new BIntrusionZoneGroup();
                        group.init(BIntrusionZoneGroup.stationName, (BValue)BString.make((String)stationName));
                        group.init(BIntrusionZoneGroup.intrusionZone, (BValue)BRef.make((BIOrionObject)intrusionZoneRec));
                        session.persist((BIOrionObject)group);
                        BIntrusionZone jaceZone = (BIntrusionZone)comp;
                        BIntrusionZoneRec jaceIntrusionZoneRec = (BIntrusionZoneRec)session.mappedRead((BObject)jaceZone);
                        if (jaceIntrusionZoneRec == null) {
                            stationName = this.getDevice().getName();
                            jaceIntrusionZoneRec = (BIntrusionZoneRec)intrusionZoneRec.newCopy();
                            jaceIntrusionZoneRec.setUuid(MappingSupport.getMappedUuid((BComponent)jaceZone));
                            jaceIntrusionZoneRec.setStationName(stationName);
                            session.insert((BIOrionObject)jaceIntrusionZoneRec);
                            group = new BIntrusionZoneGroup();
                            group.init(BIntrusionZoneGroup.stationName, (BValue)BString.make((String)stationName));
                            group.init(BIntrusionZoneGroup.intrusionZone, (BValue)BRef.make((BIOrionObject)jaceIntrusionZoneRec));
                            session.insert((BIOrionObject)group);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        if (session != null) {
                            session.close();
                            session = null;
                        }
                    }
                }
            }
            if (!(o instanceof BIAlarmClassFolder)) continue;
            try {
                this.recurseAlarmClassFolder((BIAlarmClassFolder)((BComponent)localFolder).get(comp.getName()), (BIAlarmClassFolder)o);
            }
            catch (ClassCastException e) {
                throw new AlarmClassSyncException("AlarmClassFolder name already exists as an AlarmClass", e);
            }
        }
    }

    public void started() {
        this.checkConfig();
        if (!this.getStatus().isDisabled()) {
            this.linkToService();
        }
        if (this.getSyncOutEnabled() && this.getSyncRequired() && Sys.atSteadyState()) {
            this.scheduleSync(false);
        }
    }

    public void atSteadyState() {
        if (this.getSyncOutEnabled() && this.getSyncRequired()) {
            this.scheduleSync(false);
        }
    }

    public void stopped() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = null;
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (!Flags.isReadonly((BComplex)this, (Slot)p)) {
            this.checkConfig();
        }
        if (p == status) {
            if (this.getStatus().isDisabled()) {
                this.unlinkFromService();
            } else {
                this.linkToService();
            }
        }
        if (this.getStatus().isFault()) {
            return;
        }
        if (p == syncRequired) {
            if (this.getSyncRequired()) {
                this.scheduleSync(false);
            } else {
                this.cancelSync();
            }
        } else if (p == syncOutEnabled && this.getSyncOutEnabled() && this.getSyncRequired()) {
            this.scheduleSync(false);
        } else if (p == syncInEnabled && this.getSyncInEnabled() && this.getSyncRequired()) {
            this.scheduleSync(false);
        } else if (p == syncDelay && this.ticket != null) {
            this.scheduleSync(false);
        }
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        BNiagaraStation station;
        if (action == sync && (station = (BNiagaraStation)this.getDevice()) != null) {
            station.getWorker().postAsync((Runnable)new Invocation((BComponent)this, action, arg, cx));
        }
        return null;
    }

    public String getDisplayNameInParent(Context cx) {
        return "AlarmClasses";
    }

    public void doHandleAlarmClassEvent(BAlarmClassEvent event) {
        this.setSyncRequired(true);
    }

    private void linkToService() {
        if (this.get("serviceLink") != null) {
            return;
        }
        BEnterpriseSecurityService acService = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        this.linkTo("serviceLink", (BComponent)acService, (Slot)BEnterpriseSecurityService.alarmClassEvent, (Slot)handleAlarmClassEvent);
    }

    private void unlinkFromService() {
        Property p = this.getProperty("serviceLink");
        if (p != null) {
            this.remove(p);
        }
    }

    public void doSync() {
        if (this.ticket != null) {
            this.ticket.cancel();
            this.ticket = null;
        }
        if (!this.getSyncInEnabled() && !this.getSyncOutEnabled()) {
            return;
        }
        BNiagaraStation station = (BNiagaraStation)this.getParent();
        if (station.getStatus().isDisabled()) {
            return;
        }
        if (station.getStatus().isDown()) {
            return;
        }
        this.setLastSyncAttempt(BAbsTime.now());
        BFoxClientConnection conn = this.getClientConnection();
        try {
            conn.engageNoRetry((BFoxClientConnection.Interest)this);
            if (this.getSyncOutEnabled()) {
                this.syncToRemote();
            }
            this.syncComplete();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Cannot sync alarmClasses with remote station.", ex);
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause(ex.getMessage());
            this.scheduleSync(true);
        }
        if (conn.isEngaged((BFoxClientConnection.Interest)this)) {
            conn.disengage((BFoxClientConnection.Interest)this);
        }
    }

    public void doScheduleSyncSoon() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.makeSeconds((int)5), (Action)sync, null);
        if (log.isLoggable(Level.FINE)) {
            log.fine("sync soon scheduled for " + this.getDevice().getName());
        }
    }

    public void scheduleSync(boolean retry) {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = Clock.schedule((BComponent)this, (BRelTime)(retry ? this.getSyncRetry() : this.getSyncDelay()), (Action)sync, null);
        if (log.isLoggable(Level.FINE)) {
            log.fine("sync scheduled for " + this.getDevice().getName());
        }
    }

    public void cancelSync() {
        if (this.ticket != null) {
            this.ticket.cancel();
            if (log.isLoggable(Level.FINE)) {
                log.fine("sync cancelled for " + this.getDevice().getName());
            }
        }
    }

    private void syncToRemote() throws Exception {
        if (log.isLoggable(Level.FINE)) {
            log.fine("sync alarmClasses to " + this.getDevice().getName());
        }
        BAlarmClassSyncChannel channel = this.getClientAlarmClassChannel();
        channel.startSync(true);
        BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BAlarmClass[] alarmClasses = alarmService.getAlarmClasses();
        channel.updateAlarmClasses(alarmClasses);
        channel.endSync();
    }

    public void syncComplete() {
        this.setSyncRequired(false);
        this.setLastSyncSuccess(BAbsTime.now());
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
        this.setFaultCause("");
        try {
            BEnterpriseSecurityService entService = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
            if (entService.getMonitorSysDefSecurity().getHasSecuritySubordinate()) {
                BIntrusionService intService = (BIntrusionService)Sys.getService((Type)BIntrusionService.TYPE);
                intService.cleanupAfterReplication();
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
    }

    public BIcon getIcon() {
        return icon;
    }
}

