/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.securityUtil;

import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.LocalSessionUtil;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.DeleteStationMessage;
import javax.baja.job.BSimpleJob;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="oldStationName", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="runOnStationStarted", type="boolean", defaultValue="true")})
public class BSupervisorRenameJob
extends BSimpleJob {
    public static final Property oldStationName = BSupervisorRenameJob.newProperty((int)0, (BValue)BString.DEFAULT, null);
    public static final Property runOnStationStarted = BSupervisorRenameJob.newProperty((int)0, (boolean)true, null);
    public static final Type TYPE = Sys.loadType(BSupervisorRenameJob.class);

    public String getOldStationName() {
        return this.getString(oldStationName);
    }

    public void setOldStationName(String v) {
        this.setString(oldStationName, v, null);
    }

    public boolean getRunOnStationStarted() {
        return this.getBoolean(runOnStationStarted);
    }

    public void setRunOnStationStarted(boolean v) {
        this.setBoolean(runOnStationStarted, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void stationStarted() throws Exception {
        super.stationStarted();
        if (this.getRunOnStationStarted()) {
            this.removeAndSubmit();
        }
    }

    public void removeAndSubmit() {
        this.setRunOnStationStarted(false);
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                BSupervisorRenameJob.this.getParent().asComponent().remove(BSupervisorRenameJob.this.getName());
                BSupervisorRenameJob.this.submit(null);
            }
        }.start();
    }

    public void run(Context cx) throws Exception {
        this.setRunOnStationStarted(false);
        this.setProgress(50);
        if (Sys.getStation().getStationName().equals(this.getOldStationName())) {
            throw new Exception("Cannot rename station; station files must locked by another process.");
        }
        BDaemonSession daemon = LocalSessionUtil.getLocalSession();
        daemon.sendMessage((DaemonMessage)new DeleteStationMessage(this.getOldStationName()));
        this.log().success("Supervisor rename from " + this.getOldStationName() + " to " + Sys.getStation().getStationName() + " complete.");
        this.setProgress(100);
    }
}

