/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.securityUtil;

import com.tridium.history.audit.BAuditRecord;
import com.tridium.history.log.BLogRecord;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BSourceState;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraEnum(range={@Range(value="access"), @Range(value="ackedAlarm"), @Range(value="alarm"), @Range(value="alert"), @Range(value="attendance"), @Range(value="audit"), @Range(value="intrusion"), @Range(value="log"), @Range(value="normal"), @Range(value="unackedAlarm"), @Range(value="unknown")})
public final class BActivityRecordType
extends BFrozenEnum {
    public static final int ACCESS = 0;
    public static final int ACKED_ALARM = 1;
    public static final int ALARM = 2;
    public static final int ALERT = 3;
    public static final int ATTENDANCE = 4;
    public static final int AUDIT = 5;
    public static final int INTRUSION = 6;
    public static final int LOG = 7;
    public static final int NORMAL = 8;
    public static final int UNACKED_ALARM = 9;
    public static final int UNKNOWN = 10;
    public static final BActivityRecordType access = new BActivityRecordType(0);
    public static final BActivityRecordType ackedAlarm = new BActivityRecordType(1);
    public static final BActivityRecordType alarm = new BActivityRecordType(2);
    public static final BActivityRecordType alert = new BActivityRecordType(3);
    public static final BActivityRecordType attendance = new BActivityRecordType(4);
    public static final BActivityRecordType audit = new BActivityRecordType(5);
    public static final BActivityRecordType intrusion = new BActivityRecordType(6);
    public static final BActivityRecordType log = new BActivityRecordType(7);
    public static final BActivityRecordType normal = new BActivityRecordType(8);
    public static final BActivityRecordType unackedAlarm = new BActivityRecordType(9);
    public static final BActivityRecordType unknown = new BActivityRecordType(10);
    public static final BActivityRecordType DEFAULT = access;
    public static final Type TYPE = Sys.loadType(BActivityRecordType.class);

    public static BActivityRecordType make(int ordinal) {
        return (BActivityRecordType)access.getRange().get(ordinal, false);
    }

    public static BActivityRecordType make(String tag) {
        return (BActivityRecordType)access.getRange().get(tag);
    }

    private BActivityRecordType(int ordinal) {
        super(ordinal);
    }

    public Type getType() {
        return TYPE;
    }

    public static final BActivityRecordType getActivityRecordType(BObject sourceRec) {
        Type resolvedType = sourceRec.getType();
        if (resolvedType.is(BAlarmRecord.TYPE)) {
            BAlarmRecord rec = (BAlarmRecord)sourceRec;
            BAckState ackState = rec.getAckState();
            BSourceState sourceState = rec.getSourceState();
            if (sourceState == BSourceState.alert) {
                if (ackState == BAckState.acked) {
                    return normal;
                }
                return alert;
            }
            if (ackState == BAckState.acked && sourceState != BSourceState.normal) {
                return ackedAlarm;
            }
            if (ackState != BAckState.acked && sourceState != BSourceState.normal) {
                return alarm;
            }
            if (ackState != BAckState.acked && sourceState == BSourceState.normal) {
                return unackedAlarm;
            }
            return normal;
        }
        if (resolvedType.is(BAuditRecord.TYPE)) {
            return audit;
        }
        if (resolvedType.is(BLogRecord.TYPE)) {
            return log;
        }
        String spec = resolvedType.toString();
        if (spec.equals("entsec:BadgeSwipeRecord") || spec.equals("entsec:BadgeSwipeOrionRec")) {
            return access;
        }
        if (spec.equals("entsec:AttendanceRecord") || spec.equals("entsec:AttendanceOrionRec")) {
            return attendance;
        }
        if (spec.equals("entsec:IntrusionRecord") || spec.equals("entsec:IntrusionOrionRec")) {
            return intrusion;
        }
        if (spec.equals("entsec:AuditOrionRec")) {
            return audit;
        }
        if (spec.equals("entsec:LogOrionRec")) {
            return log;
        }
        return unknown;
    }
}

