/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.securityUtil;

import com.tridium.alarm.BConsoleRecipient;
import com.tridium.bql.BSelect;
import com.tridium.bql.Range;
import com.tridium.bql.RangeSet;
import com.tridium.bql.SelectQuery;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.history.audit.BAuditRecord;
import com.tridium.history.log.BLogRecord;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.BTypeDependency;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.dt.BDynamicTableColumn;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.orion.sql.SqlColumns;
import com.tridium.query.BOrderByCol;
import com.tridium.query.expression.BField;
import com.tridium.query.expression.BFunction;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.filter.BSecAbsTimeFilter;
import com.tridiumx.entsec.orionTools.history.BAuditOrionRec;
import com.tridiumx.entsec.orionTools.history.BLogOrionRec;
import com.tridiumx.entsec.orionTools.history.BOrionHistoryRecord;
import com.tridiumx.entsec.securityUtil.ArrayTableCursor;
import com.tridiumx.entsec.securityUtil.BActivityQuery;
import com.tridiumx.entsec.securityUtil.BActivityQueryResult;
import com.tridiumx.entsec.securityUtil.BActivityRecord;
import com.tridiumx.entsec.securityUtil.BActivityRecordType;
import com.tridiumx.entsec.securityUtil.BISecurityActivity;
import com.tridiumx.entsec.securityUtil.orion.BSecurityHistoryConsolidator;
import javax.baja.agent.AgentList;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.bql.BqlQuery;
import javax.baja.bql.Queryable;
import javax.baja.collection.BITable;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IFilter;
import javax.baja.query.BExpression;
import javax.baja.query.BOrderByColumn;
import javax.baja.query.BOrdering;
import javax.baja.query.BProjection;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.BQuery;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.IterableCursor;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BFormat;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Queue;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="historyConsolidation", type="BOrdList", defaultValue="BOrdList.DEFAULT", facets={@Facet(value="BFacets.make(BFacets.MULTI_LINE, BBoolean.TRUE, BFacets.TARGET_TYPE, BString.make(\"entsec:SecurityHistoryConsolidator\"), BFacets.FIELD_EDITOR, BString.make(\"entsec:HistoryConsolidatorListFE\"))")}), @NiagaraProperty(name="query", type="BActivityQuery", defaultValue="new BActivityQuery()", flags=4)})
public class BActivityMonitor
extends BConsoleRecipient
implements Queryable {
    public static final Property historyConsolidation = BActivityMonitor.newProperty((int)0, (BValue)BOrdList.DEFAULT, (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE, (String)"targetType", (BIDataValue)BString.make((String)"entsec:SecurityHistoryConsolidator"), (String)"fieldEditor", (BIDataValue)BString.make((String)"entsec:HistoryConsolidatorListFE")));
    public static final Property query = BActivityMonitor.newProperty((int)4, (BValue)new BActivityQuery(), null);
    public static final Type TYPE = Sys.loadType(BActivityMonitor.class);
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"history.png"), (BIcon)BIcon.std((String)"badges/alarm.png"));
    public static Object staticLock = new Object();
    static int ACTIVITY_TYPE_SIZE = BActivityRecordType.access.getRange().getOrdinals().length;
    public static final int MAX_RESULT_SIZE = Integer.getInteger("niagara.query.maxActivityMonitorResultSize", 5000);
    private static boolean DESC_TIMESTAMP = true;

    public BOrdList getHistoryConsolidation() {
        return (BOrdList)this.get(historyConsolidation);
    }

    public void setHistoryConsolidation(BOrdList v) {
        this.set(historyConsolidation, (BValue)v, null);
    }

    public BActivityQuery getQuery() {
        return (BActivityQuery)this.get(query);
    }

    public void setQuery(BActivityQuery v) {
        this.set(query, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        BValue obj = this.getQuery().get("base");
        if (obj == null || obj.equals((Object)BOrd.NULL)) {
            this.setQuery(new BActivityQuery(this));
        } else {
            this.getQuery().set("base", (BValue)this.getAbsoluteOrd());
        }
        BValue oldHistoryConsolidatorsFrozenSlot = this.get("historyConsolidators");
        if (oldHistoryConsolidatorsFrozenSlot instanceof BOrdList) {
            this.remove("historyConsolidators");
        }
    }

    public static BActivityRecord convertToActivity(BObject origRec, Context cx) {
        if (origRec instanceof BISecurityActivity) {
            return ((BISecurityActivity)origRec).convertToActivity(cx);
        }
        if (origRec instanceof BAlarmRecord) {
            return BActivityMonitor.alarmConversion((BAlarmRecord)origRec, cx);
        }
        if (origRec instanceof BAuditRecord) {
            return BActivityMonitor.auditConversion((BAuditRecord)origRec, cx);
        }
        if (origRec instanceof BAuditOrionRec) {
            return BActivityMonitor.auditConversion((BAuditOrionRec)origRec, cx);
        }
        if (origRec instanceof BLogRecord) {
            return BActivityMonitor.logConversion((BLogRecord)origRec, cx);
        }
        if (origRec instanceof BLogOrionRec) {
            return BActivityMonitor.logConversion((BLogOrionRec)origRec, cx);
        }
        return null;
    }

    static BActivityRecord auditConversion(BAuditRecord rec, Context cx) {
        StringBuffer desc = new StringBuffer();
        desc.append(BAuditRecord.slotName.getDefaultDisplayName(cx)).append(": ");
        desc.append(rec.getSlotName()).append("; ");
        desc.append(BAuditRecord.oldValue.getDefaultDisplayName(cx)).append(": ");
        desc.append(rec.getOldValue()).append("; ");
        desc.append(BAuditRecord.value.getDefaultDisplayName(cx)).append(": ");
        desc.append(rec.getValue());
        return new BActivityRecord(rec.getTimestamp(), (BObject)rec, rec.getOperation(), rec.getTarget(), rec.getUserName(), desc.toString());
    }

    static BActivityRecord auditConversion(BAuditOrionRec rec, Context cx) {
        StringBuffer desc = new StringBuffer();
        desc.append(BAuditRecord.slotName.getDefaultDisplayName(cx)).append(": ");
        desc.append(rec.getSlotName()).append("; ");
        desc.append(BAuditRecord.oldValue.getDefaultDisplayName(cx)).append(": ");
        desc.append(rec.getOldValue()).append("; ");
        desc.append(BAuditRecord.value.getDefaultDisplayName(cx)).append(": ");
        desc.append(rec.getValue());
        return new BActivityRecord(rec.getTimestamp(), (BObject)rec, rec.getOperation(), rec.getTarget(), rec.getUserName(), desc.toString());
    }

    static BActivityRecord logConversion(BLogRecord rec, Context cx) {
        return new BActivityRecord(rec.getTimestamp(), (BObject)rec, rec.getLogName(), rec.getMessage(), Integer.toString(rec.getSeverity()), rec.getException());
    }

    static BActivityRecord logConversion(BLogOrionRec rec, Context cx) {
        return new BActivityRecord(rec.getTimestamp(), (BObject)rec, rec.getLogName(), rec.getMessage(), Integer.toString(rec.getSeverity()), rec.getException());
    }

    static BActivityRecord alarmConversion(BAlarmRecord rec, Context cx) {
        BString source;
        String badge;
        StringBuffer desc = new StringBuffer();
        desc.append(rec.getPriority()).append(": [");
        desc.append(((BAlarmService)Sys.getService((Type)BAlarmService.TYPE)).lookupAlarmClass(rec.getAlarmClass()).getDisplayName(cx));
        desc.append("]: ");
        BString msg = (BString)rec.getAlarmData().get("msgText");
        if (msg == null) {
            msg = BString.make((String)"");
        }
        BFormat msgFormat = BFormat.make((String)msg.toString());
        desc.append(msgFormat.format((Object)rec, cx));
        String user = rec.getUser();
        if (!user.equals(BAlarmRecord.user.getDefaultValue().toString()) && user.length() > 0) {
            desc.append(": ").append(user);
        }
        if ((badge = rec.getAlarmData().gets("badge", "")).length() > 0) {
            desc.append(": ").append(badge);
        }
        if ((source = (BString)rec.getAlarmData().get("sourceName")) == null) {
            source = BString.make((String)rec.getSource().toString(cx));
        }
        return new BActivityRecord(rec.getTimestamp(), (BObject)rec, rec.getSourceState().toString(cx), source.toString(), rec.getUser(), desc.toString());
    }

    public String getInitialAlarmQuery(BUser user) {
        String query = super.getInitialAlarmQuery(user);
        String toStrip = " from openAlarms";
        int index = query.indexOf(toStrip);
        StringBuffer sb = new StringBuffer(query.substring(0, index));
        sb.append(query.substring(index + toStrip.length(), query.length()));
        return sb.toString();
    }

    Cursor<?> scan(boolean[] inclRecTypes, IFilter cFilter, boolean descTimestamp, Context cx) {
        return this.timeQueryCursor(null, null, inclRecTypes, cFilter, descTimestamp, cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Cursor<?> timeQueryCursor(BAbsTime startTime, BAbsTime endTime, boolean[] inclRecTypes, IFilter cFilter, boolean descTimestamp, Context cx) {
        Array cursors = new Array(Cursor.class);
        BOrdList list = this.getHistoryConsolidation();
        int len = list.size();
        BNiagaraNetwork network = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        Counter counter = new Counter(len);
        Array workers = new Array(Work.class, len);
        try {
            for (int i = 0; i < len; ++i) {
                BSecurityHistoryConsolidator consolidator = null;
                try {
                    consolidator = (BSecurityHistoryConsolidator)list.get(i).get((BObject)this);
                    consolidator.lease();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (consolidator == null) {
                    Counter counter2 = counter;
                    synchronized (counter2) {
                        --counter.count;
                        continue;
                    }
                }
                if (inclRecTypes != null) {
                    Counter counter3;
                    Counter counter4;
                    Type recType = consolidator.getHistoryRecordType().getResolvedType();
                    if (recType.is(BAuditRecord.TYPE) && !inclRecTypes[BActivityRecordType.audit.getOrdinal()]) {
                        counter4 = counter;
                        synchronized (counter4) {
                            --counter.count;
                            continue;
                        }
                    }
                    if (recType.is(BLogRecord.TYPE) && !inclRecTypes[BActivityRecordType.log.getOrdinal()]) {
                        counter4 = counter;
                        synchronized (counter4) {
                            --counter.count;
                            continue;
                        }
                    }
                    String spec = recType.toString();
                    if (spec.equals("entsec:BadgeSwipeRecord") && !inclRecTypes[BActivityRecordType.access.getOrdinal()]) {
                        counter3 = counter;
                        synchronized (counter3) {
                            --counter.count;
                            continue;
                        }
                    }
                    if (spec.equals("entsec:AttendanceRecord") && !inclRecTypes[BActivityRecordType.attendance.getOrdinal()]) {
                        counter3 = counter;
                        synchronized (counter3) {
                            --counter.count;
                            continue;
                        }
                    }
                    if (spec.equals("entsec:IntrusionRecord") && !inclRecTypes[BActivityRecordType.intrusion.getOrdinal()]) {
                        counter3 = counter;
                        synchronized (counter3) {
                            --counter.count;
                            continue;
                        }
                    }
                }
                Work work = new Work(this, consolidator, startTime, endTime, counter, descTimestamp, cx);
                workers.add((Object)work);
                network.getWorkers().process((Object)work);
            }
            if (inclRecTypes == null || inclRecTypes[BActivityRecordType.alert.getOrdinal()] || inclRecTypes[BActivityRecordType.alarm.getOrdinal()] || inclRecTypes[BActivityRecordType.ackedAlarm.getOrdinal()] || inclRecTypes[BActivityRecordType.unackedAlarm.getOrdinal()] || inclRecTypes[BActivityRecordType.normal.getOrdinal()]) {
                String bqlQuery = null;
                bqlQuery = inclRecTypes != null && !inclRecTypes[BActivityRecordType.normal.getOrdinal()] ? super.getInitialAlarmQuery(cx.getUser()) : this.getInitialAlarmQuery(cx.getUser());
                if (!bqlQuery.endsWith(" where alarmClass = 'null'")) {
                    if (startTime != null || endTime != null) {
                        BSecAbsTimeFilter filter = new BSecAbsTimeFilter();
                        if (startTime != null) {
                            filter.setStartTime(startTime);
                            filter.setMinEnabled(true);
                        }
                        if (endTime != null) {
                            filter.setEndTime(endTime);
                            filter.setMaxEnabled(true);
                        }
                        bqlQuery = bqlQuery + " and " + filter.getPredicate(BAlarmRecord.lastUpdate.getName());
                    }
                    BOrd ord = BOrd.make((String)bqlQuery);
                    BITable result = (BITable)ord.resolve().get();
                    cursors.add((Object)result.cursor());
                }
            }
            Counter bqlQuery = counter;
            synchronized (bqlQuery) {
                while (counter.count > 0) {
                    try {
                        counter.wait(20000L);
                    }
                    catch (InterruptedException e) {
                        throw new BajaRuntimeException(e.getMessage(), (Throwable)e);
                    }
                }
                Work[] finishedWork = (Work[])workers.trim();
                for (int i = 0; i < finishedWork.length; ++i) {
                    if (finishedWork[i].cursor == null) continue;
                    cursors.add(finishedWork[i].cursor);
                }
            }
            return new ConsolidatedCursor((Cursor[])cursors.trim(), cFilter, descTimestamp);
        }
        catch (RuntimeException e) {
            Work[] finishedWork = (Work[])workers.trim();
            for (int i = 0; i < finishedWork.length; ++i) {
                if (finishedWork[i] == null || finishedWork[i].session == null || !finishedWork[i].session.isOpen()) continue;
                finishedWork[i].session.close();
            }
            throw e;
        }
    }

    public BObject bqlQuery(OrdTarget base, OrdQuery q) {
        return new BActivityQueryResult(this, (BqlQuery)q, (Context)base);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Cursor<?> doBqlQuery(BqlQuery query, IFilter cFilter, Context cx) {
        Object object = staticLock;
        synchronized (object) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                throw new BajaRuntimeException(e.getMessage(), (Throwable)e);
            }
            SelectQuery select = (SelectQuery)query;
            boolean descTimestamp = DESC_TIMESTAMP;
            BSelect bSelect = select.getSelect();
            BOrdering ordering = bSelect.getOrdering();
            if (ordering != null) {
                BOrderByColumn[] cols = ordering.getOrderByColumns();
                for (int i = 0; i < cols.length; ++i) {
                    BExpression e = cols[i].getColumnExpression();
                    if (!BActivityMonitor.getColumnName(e).equals(BActivityRecord.timestamp.getName()) || !cols[i].isAscending()) continue;
                    descTimestamp = !DESC_TIMESTAMP;
                }
            }
            if (!select.hasPredicate()) {
                return this.scan(null, cFilter, descTimestamp, cx);
            }
            RangeSet range = select.getRange(BActivityRecord.timestamp.getName(), BAbsTime.TYPE, false);
            RangeSet recTypeRange = null;
            recTypeRange = range.isAll() ? select.getRange(BActivityRecord.recordType.getName(), BActivityRecordType.TYPE, true) : select.getRange(BActivityRecord.recordType.getName(), BActivityRecordType.TYPE, false);
            boolean[] inclRecTypes = null;
            if (!recTypeRange.isAll()) {
                inclRecTypes = new boolean[ACTIVITY_TYPE_SIZE];
                int size = recTypeRange.getCount();
                for (int i = 0; i < size; ++i) {
                    inclRecTypes[((BActivityRecordType)recTypeRange.getRange((int)i).min).getOrdinal()] = true;
                }
            }
            if (range.isAll()) {
                return this.scan(inclRecTypes, cFilter, descTimestamp, cx);
            }
            range.sort();
            Range min = range.getRange(0);
            Range max = range.getRange(range.getCount() - 1);
            return this.timeQueryCursor((BAbsTime)min.min, (BAbsTime)max.max, inclRecTypes, cFilter, descTimestamp, cx);
        }
    }

    public static String getColumnName(BExpression e) {
        if (e instanceof BField) {
            return ((BField)e).getFieldPath();
        }
        return ((BFunction)e).getFunctionName();
    }

    static Cursor<?> getCursor(BSecurityHistoryConsolidator consolidator, BAbsTime startTime, BAbsTime endTime, boolean descTimestamp, Context cx, Work work) throws Exception {
        BOrionDatabase db = consolidator.getOrionDatabase();
        BOrionTypeId rowType = consolidator.getRowType();
        BSqlQuery q = BSqlQuery.make((OrionType)((OrionType)rowType.getTypeSpec().getResolvedType()));
        BProjection projection = new BProjection();
        BOrionHistoryRecord rec = (BOrionHistoryRecord)rowType.getTypeSpec().getInstance();
        Property timestampProp = rec.timestampProperty();
        Property[] props = rec.getPropertiesArray();
        for (int i = 0; i < props.length; ++i) {
            BDynamicTableColumn col = new BDynamicTableColumn(props[i].getName(), props[i].getDefaultDisplayName(cx), rowType, props[i].getName(), BTypeDependency.NULL);
            BProjectionColumn projectionColumn = SqlColumns.make((BTypeSpec)col.getFromType().getTypeSpec(), (String)col.getFromProperty());
            projection.add(projectionColumn);
            if (timestampProp != props[i]) continue;
            BExpression expression = (BExpression)projectionColumn.getColumnExpression().newCopy();
            BOrderByCol ordBy = new BOrderByCol(expression);
            if (descTimestamp) {
                ordBy.desc();
            } else {
                ordBy.asc();
            }
            q.orderBy(BOrdering.make((BOrderByColumn)ordBy));
            if (startTime == null && endTime == null) break;
            BSecAbsTimeFilter filter = new BSecAbsTimeFilter();
            if (startTime != null) {
                filter.setStartTime(startTime);
                filter.setMinEnabled(true);
            }
            if (endTime != null) {
                filter.setEndTime(endTime);
                filter.setMaxEnabled(true);
            }
            q.where(filter.getExpression((BExpression)expression.newCopy()));
            break;
        }
        BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        work.session = service.createManagedSession(cx);
        return work.session.select((BQuery)q);
    }

    public String getDisplayName(Slot slot, Context cx) {
        if (slot == query) {
            return this.getDisplayName(cx);
        }
        return super.getDisplayName(slot, cx);
    }

    public AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        list.toTop("entsecHx:HxActivityMonitorView");
        return list;
    }

    public BIcon getIcon() {
        return icon;
    }

    static class ConsolidatedCursor
    implements IterableCursor<BObject> {
        Cursor<?>[] cursors;
        IFilter filter;
        BActivityRecord[] recs;
        boolean[] cursorEmpty;
        BActivityRecord currentRec;
        BActivityRecord iteratorRec = null;
        int count = 0;
        boolean descTimestamp;

        ConsolidatedCursor(Cursor<?>[] cursors, IFilter filter, boolean descTimestamp) {
            this.cursors = cursors;
            this.filter = filter;
            int len = cursors != null ? cursors.length : 0;
            this.recs = new BActivityRecord[len];
            this.cursorEmpty = new boolean[len];
            this.descTimestamp = descTimestamp;
        }

        public void close() {
            for (int i = 0; i < this.cursors.length; ++i) {
                OrionCursor orionCursor;
                if (!(this.cursors[i] instanceof OrionCursor) || !(orionCursor = (OrionCursor)this.cursors[i]).getSession().isOpen()) continue;
                orionCursor.getSession().close();
            }
        }

        public Context getContext() {
            if (this.cursors.length > 0) {
                return this.cursors[0].getContext();
            }
            return null;
        }

        public Cursor<?> getDescCursor(BActivityRecord activity, Cursor<?> cursor) {
            Queue q = new Queue(MAX_RESULT_SIZE);
            q.enqueue((Object)activity);
            while (cursor.next()) {
                BActivityRecord a = BActivityMonitor.convertToActivity((BObject)cursor.get(), cursor.getContext());
                if (a == null || this.filter != null && !this.filter.accept((Object)a)) continue;
                if (q.size() >= MAX_RESULT_SIZE) {
                    q.dequeue();
                }
                q.enqueue((Object)a);
            }
            Array array = new Array(q.toArray());
            array = array.reverse();
            ArrayTableCursor prefilteredCursor = new ArrayTableCursor(array, cursor.getContext());
            return prefilteredCursor;
        }

        public boolean next() {
            if (this.count < MAX_RESULT_SIZE) {
                for (int i = 0; i < this.recs.length; ++i) {
                    OrionCursor orionCursor;
                    if (this.cursorEmpty[i] || this.recs[i] != null) continue;
                    boolean foundNext = false;
                    while (this.cursors[i].next()) {
                        boolean alreadyPassedFilter = false;
                        BObject o = (BObject)this.cursors[i].get();
                        BActivityRecord activity = null;
                        if (o instanceof BActivityRecord) {
                            activity = (BActivityRecord)o;
                            alreadyPassedFilter = true;
                        } else {
                            activity = BActivityMonitor.convertToActivity(o, this.cursors[i].getContext());
                        }
                        if (!alreadyPassedFilter && (activity == null || this.filter != null && !this.filter.accept((Object)activity))) continue;
                        if (this.descTimestamp && (o instanceof BHistoryRecord || o instanceof BAlarmRecord) && !(o instanceof BActivityRecord)) {
                            this.cursors[i] = this.getDescCursor(activity, this.cursors[i]);
                            if (this.cursors[i].next()) {
                                activity = (BActivityRecord)this.cursors[i].get();
                            }
                        }
                        foundNext = true;
                        this.recs[i] = activity;
                        break;
                    }
                    if (foundNext) continue;
                    this.recs[i] = null;
                    this.cursorEmpty[i] = true;
                    if (!(this.cursors[i] instanceof OrionCursor) || !(orionCursor = (OrionCursor)this.cursors[i]).getSession().isOpen()) continue;
                    orionCursor.getSession().close();
                }
                int bestIndex = -1;
                BAbsTime bestTime = BAbsTime.DEFAULT;
                if (!this.descTimestamp) {
                    bestTime = BAbsTime.END_OF_TIME;
                }
                for (int i = 0; i < this.recs.length; ++i) {
                    if (this.cursorEmpty[i]) continue;
                    if (this.recs[i] == null) {
                        throw new BajaRuntimeException("rec cannot be null if cursor is empty");
                    }
                    if (!this.recs[i].getTimestamp().equals((Object)bestTime) && (!this.descTimestamp || !this.recs[i].getTimestamp().isAfter(bestTime)) && (this.descTimestamp || !this.recs[i].getTimestamp().isBefore(bestTime))) continue;
                    bestTime = this.recs[i].getTimestamp();
                    bestIndex = i;
                }
                if (bestIndex == -1) {
                    return false;
                }
                this.currentRec = this.recs[bestIndex];
                this.recs[bestIndex] = null;
                ++this.count;
                return true;
            }
            return false;
        }

        public boolean nextComponent() {
            for (int i = 0; i < this.cursors.length; ++i) {
                while (this.cursors[i].next()) {
                }
            }
            return false;
        }

        public boolean next(Class<?> cls) {
            if (cls.isAssignableFrom(BActivityRecord.class)) {
                return this.next();
            }
            return this.nextComponent();
        }

        public BObject get() {
            if (this.currentRec != null) {
                this.iteratorRec = this.currentRec;
            }
            return this.iteratorRec;
        }
    }

    static class Counter {
        int count = 0;

        Counter(int count) {
            this.count = count;
        }
    }

    static class Work
    implements Runnable {
        Cursor<?> cursor = null;
        BActivityMonitor monitor = null;
        BSecurityHistoryConsolidator consolidator = null;
        BAbsTime startTime = null;
        BAbsTime endTime = null;
        Counter counter = null;
        Context cx = null;
        boolean descTimestamp;
        OrionSession session = null;

        Work(BActivityMonitor monitor, BSecurityHistoryConsolidator consolidator, BAbsTime startTime, BAbsTime endTime, Counter counter, boolean descTimestamp, Context cx) {
            this.monitor = monitor;
            this.consolidator = consolidator;
            this.startTime = startTime;
            this.endTime = endTime;
            this.counter = counter;
            this.cx = cx;
            this.descTimestamp = descTimestamp;
            this.session = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block28: {
                try {
                    if (this.consolidator.isUnoperational()) {
                        Object spaceOrd = BOrd.make((BOrd)this.monitor.getAbsoluteOrd(), (String)"history:");
                        BHistorySpace space = (BHistorySpace)spaceOrd.get();
                        String stationName = null;
                        BISession session = this.monitor.getSession();
                        stationName = session instanceof BFoxSession ? ((BFoxSession)session).getStationName() : Sys.getStation().getStationName();
                        BHistoryId id = this.consolidator.getDefaultLocalHistory().fromShorthand(stationName);
                        try (HistorySpaceConnection conn = space.getConnection(null);){
                            BIHistory history = conn.getHistory(id);
                            this.cursor = conn.timeQuery(history, this.startTime, this.endTime).cursor();
                            break block28;
                        }
                    }
                    this.cursor = BActivityMonitor.getCursor(this.consolidator, this.startTime, this.endTime, this.descTimestamp, this.cx, this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    Counter counter = this.counter;
                    synchronized (counter) {
                        --this.counter.count;
                        if (this.counter.count < 1) {
                            this.counter.notifyAll();
                        }
                    }
                }
            }
        }
    }
}

