/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.scheme;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BRef;
import com.tridium.orion.BTypeDependency;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.PropertyValue;
import com.tridiumx.entsec.orionTools.MappingSupport;
import com.tridiumx.entsec.photoID.BPhotoIDTemplate;
import com.tridiumx.entsec.scheme.EntsecRefQuery;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(ordScheme="entsecref")
@NiagaraSingleton
public class BEntsecRefScheme
extends BOrdScheme {
    public static final BEntsecRefScheme INSTANCE = new BEntsecRefScheme();
    public static final Type TYPE = Sys.loadType(BEntsecRefScheme.class);

    public Type getType() {
        return TYPE;
    }

    private BEntsecRefScheme() {
        super("entsecref");
    }

    public OrdQuery parse(String body) {
        return new EntsecRefQuery(body);
    }

    public OrdTarget resolve(OrdTarget base, OrdQuery query) throws UnresolvedException {
        if (base.get() instanceof BPhotoIDTemplate) {
            String[] path = ((EntsecRefQuery)query).getPath();
            if (path[path.length - 1].equals("portrait")) {
                return new OrdTarget(base, (BObject)BOrd.make((String)"module://icons/x32/user.png"));
            }
            return new OrdTarget(base, (BObject)BString.make((String)("<<" + path[path.length - 1] + ">>")));
        }
        if (!(base.get() instanceof BIOrionObject)) {
            throw new UnresolvedException("Cannot resolve references to non-orionObjects : " + base.get());
        }
        try {
            BIOrionObject o = (BIOrionObject)base.get();
            String[] path = ((EntsecRefQuery)query).getPath();
            if (path.length == 0) {
                return new OrdTarget(base, (BObject)o);
            }
            if (path.length > 0) {
                return this.resolveDeep(path, 0, (BValue)o, base);
            }
        }
        catch (UnresolvedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new UnresolvedException("Cannot resolve nav path.", (Throwable)ex);
        }
        throw new UnresolvedException("Cannot resolve nav path..");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrdTarget resolveDeep(String[] path, int depth, BValue o, OrdTarget target) {
        if (depth == path.length) {
            return new OrdTarget(target, (BObject)o);
        }
        if (o instanceof BComplex) {
            BComplex c = (BComplex)o;
            BValue value = c.get(path[depth]);
            if (value == null) {
                BIOrionObject base = (BIOrionObject)c;
                BOrionDatabase db = base.getOrionDatabase();
                BTypeDependency[] dependencies = db.getDependentTypes(base.getOrionType());
                for (int i = 0; i < dependencies.length; ++i) {
                    OrionType orionType = (OrionType)dependencies[i].getFromTypeId().getTypeSpec().getResolvedType();
                    String escapedName = MappingSupport.getMixInName((Type)orionType);
                    if (!escapedName.equals(path[depth])) continue;
                    Property p = orionType.getProperty(dependencies[i].getFromProperty());
                    OrionSession session = null;
                    try {
                        session = base.getOrionDatabase().createSession((Context)target);
                        OrionCursor cursor = session.select(orionType, new PropertyValue(p, (BValue)BRef.make((BIOrionObject)base)));
                        if (!cursor.next()) continue;
                        value = (BValue)cursor.get();
                        continue;
                    }
                    finally {
                        if (session != null) {
                            session.close();
                            session = null;
                        }
                    }
                }
            } else if (value instanceof BRef) {
                BRef ref = (BRef)value;
                BIOrionObject base = (BIOrionObject)target.get();
                OrionSession session = null;
                try {
                    session = base.getOrionDatabase().createSession((Context)target);
                    value = (BValue)ref.getTarget(session);
                }
                finally {
                    if (session != null) {
                        session.close();
                        session = null;
                    }
                }
            }
            if (value == null) {
                throw new UnresolvedException("Cannot resolve path for '" + path[depth] + "' in " + o.getType());
            }
            return this.resolveDeep(path, ++depth, value, target);
        }
        throw new UnresolvedException("Cannot resolve path for '" + path[depth] + "' in " + o.getType());
    }
}

