/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.schema;

import com.tridium.orion.BIOrionApp;
import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.BSchemaVersion;
import com.tridium.orion.ISchemaUpgrader;
import com.tridium.orion.OrionSession;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.orionTools.BScheduleRec;
import com.tridiumx.entsec.orionTools.SchemaUpgradeSupport;
import com.tridiumx.entsec.threat.BThreatLevelGroupRec;
import com.tridiumx.entsec.threat.BThreatLevelStationJoin;
import java.util.logging.Level;
import javax.baja.rdb.ddl.AddColumn;
import javax.baja.rdb.ddl.DdlCommand;

public class Upgrade_1_0_to_1_1
implements ISchemaUpgrader {
    private static final BSchemaVersion FROM_VERSION = BEnterpriseSecurityService.VERSION_1_0;
    private static final BSchemaVersion TO_VERSION = BEnterpriseSecurityService.VERSION_1_1;

    public BSchemaVersion getFromVersion() {
        return FROM_VERSION;
    }

    public BSchemaVersion getToVersion() {
        return TO_VERSION;
    }

    public void upgrade(BLocalOrionDatabase db, BIOrionApp app, OrionSession session) throws Exception {
        try {
            int i;
            DdlCommand[] ddl = SchemaUpgradeSupport.createTable(BThreatLevelGroupRec.ORION_TYPE, db);
            for (i = 0; i < ddl.length; ++i) {
                session.invokeDdl(ddl[i]);
            }
            ddl = SchemaUpgradeSupport.createTable(BThreatLevelStationJoin.ORION_TYPE, db);
            for (i = 0; i < ddl.length; ++i) {
                session.invokeDdl(ddl[i]);
            }
            AddColumn columnDdl = SchemaUpgradeSupport.addColumnAsLastProperty(BScheduleRec.ORION_TYPE, BScheduleRec.scheduleUsage, db);
            session.invokeDdl((DdlCommand)columnDdl);
            columnDdl = SchemaUpgradeSupport.addColumnAsLastProperty(BScheduleRec.ORION_TYPE, BScheduleRec.trueText, db);
            session.invokeDdl((DdlCommand)columnDdl);
            columnDdl = SchemaUpgradeSupport.addColumnAsLastProperty(BScheduleRec.ORION_TYPE, BScheduleRec.falseText, db);
            session.invokeDdl((DdlCommand)columnDdl);
            SchemaUpgradeSupport.skipConvertTimestampToLong(BThreatLevelGroupRec.ORION_TYPE, BThreatLevelGroupRec.lastModified);
            SchemaUpgradeSupport.skipConvertTimestampToLong(BThreatLevelStationJoin.ORION_TYPE, BThreatLevelStationJoin.lastModified);
        }
        catch (Exception e) {
            BEnterpriseSecurityService.LOG.log(Level.FINE, "Upgrade_1_0_to_1_1 Schema Upgrade either not needed or failed", e);
        }
    }
}

