/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.photoID.video;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.util.FoxRpcUtil;
import com.tridium.ui.UiEnv;
import com.tridium.videoDriver.ui.multistream.BVideoMultistreamDragAndDropCamera;
import com.tridiumx.entsec.photoID.BPhotoIDNetwork;
import com.tridiumx.entsec.photoID.video.BPhotoIDPlayer;
import com.tridiumx.entsec.photoID.video.BPhotoIDViewerComponent;
import java.util.Optional;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BISpaceNode;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.util.Lexicon;

@NiagaraType
public class BSecVideoMultistreamDragAndDropCamera
extends BVideoMultistreamDragAndDropCamera {
    public static final Type TYPE = Sys.loadType(BSecVideoMultistreamDragAndDropCamera.class);
    BPhotoIDPlayer viewer;
    BOrd cameraOrd;

    public Type getType() {
        return TYPE;
    }

    public BSecVideoMultistreamDragAndDropCamera(BPhotoIDPlayer viewer, BOrd cameraOrd) {
        this.viewer = viewer;
        this.cameraOrd = cameraOrd;
    }

    public void mousePressed(BMouseEvent event) {
        if (event.isButton3Down()) {
            BMenu menu = new BMenu();
            if (this.viewer.videoPlaybackMultistream.getPermissions(this.viewer.getCurrentContext()).hasAdminWrite()) {
                menu.add("removeCommand", (Command)new RemoveCameraCommand());
            }
            menu.add("removeFromPaneCommand", (Command)new RemoveCameraFromPaneCommand());
            if (menu != null) {
                menu.open(event);
            }
        }
        super.mousePressed(event);
    }

    public void mouseEntered(BMouseEvent event) {
        boolean isPlacedOnce = false;
        String text = Lexicon.make(BSecVideoMultistreamDragAndDropCamera.class).getText("SecVideoMultistreamDragAndDropCamera.tooltip.text");
        for (int i = 1; i <= 9; ++i) {
            if (!this.viewer.videoPlaybackMultistream.get("camera" + i).toString().equalsIgnoreCase(this.cameraOrd.toString())) continue;
            text = isPlacedOnce ? text + ", " : text + " ";
            text = text + i;
            isPlacedOnce = true;
        }
        if (!isPlacedOnce) {
            text = "";
        }
        if (text != null && text.length() > 0) {
            double x = this.getX();
            double y = this.getY();
            UiEnv.get().openBubbleHelp((BWidget)this, x, y, text);
        }
        super.mouseEntered(event);
    }

    public void mouseExited(BMouseEvent event) {
        UiEnv.get().closeBubbleHelp();
        super.mouseExited(event);
    }

    protected class RemoveCameraFromPaneCommand
    extends Command {
        public RemoveCameraFromPaneCommand() {
            super((BWidget)BSecVideoMultistreamDragAndDropCamera.this, TYPE.getModule(), "command.removeFromPane");
        }

        public CommandArtifact doInvoke() throws Exception {
            BSecVideoMultistreamDragAndDropCamera.this.viewer.videoPlaybackMultistream.lease(2);
            for (int i = 1; i <= 16; ++i) {
                BOrd ord = (BOrd)BSecVideoMultistreamDragAndDropCamera.this.viewer.videoPlaybackMultistream.get("camera" + i);
                if (!BSecVideoMultistreamDragAndDropCamera.this.cameraOrd.toString().equalsIgnoreCase(ord.toString())) continue;
                if (!BSecVideoMultistreamDragAndDropCamera.this.viewer.videoPlaybackMultistream.getPermissions(BSecVideoMultistreamDragAndDropCamera.this.viewer.getCurrentContext()).hasAdminWrite()) {
                    Optional optional = FoxRpcUtil.doSilentRpc((BISpaceNode)BSecVideoMultistreamDragAndDropCamera.this.viewer.videoPlaybackMultistream, (String)("setCamera" + i + "RPC"), (Object[])new Object[0]);
                    continue;
                }
                BSecVideoMultistreamDragAndDropCamera.this.viewer.videoPlaybackMultistream.set("camera" + i, (BValue)BOrd.NULL);
            }
            BSecVideoMultistreamDragAndDropCamera.this.viewer.videoPlaybackMultistream.lease(2);
            BSecVideoMultistreamDragAndDropCamera.this.viewer.doLoadValue((BObject)BSecVideoMultistreamDragAndDropCamera.this.viewer.videoPlaybackMultistream, BSecVideoMultistreamDragAndDropCamera.this.viewer.getCurrentContext());
            return null;
        }
    }

    protected class RemoveCameraCommand
    extends Command {
        public RemoveCameraCommand() {
            super((BWidget)BSecVideoMultistreamDragAndDropCamera.this, TYPE.getModule(), "command.remove");
        }

        public CommandArtifact doInvoke() throws Exception {
            if (BDialog.open((BWidget)BSecVideoMultistreamDragAndDropCamera.this.viewer, (String)"Remove", (Object)new BLabel(Lexicon.make(BSecVideoMultistreamDragAndDropCamera.class).getText("command.remove.confirm")), (int)3) != 2) {
                for (int i = 1; i <= 16; ++i) {
                    BOrd ord = (BOrd)BSecVideoMultistreamDragAndDropCamera.this.viewer.videoPlaybackMultistream.get("camera" + i);
                    if (!BSecVideoMultistreamDragAndDropCamera.this.cameraOrd.toString().equalsIgnoreCase(ord.toString())) continue;
                    BSecVideoMultistreamDragAndDropCamera.this.viewer.videoPlaybackMultistream.set("camera" + i, (BValue)BOrd.NULL);
                }
                BSecVideoMultistreamDragAndDropCamera.this.viewer.videoPlaybackMultistream.lease(2);
                BOrdList ordList = (BOrdList)BSecVideoMultistreamDragAndDropCamera.this.viewer.videoPlaybackMultistream.get("currentOrdList");
                for (int i = 0; i < ordList.size(); ++i) {
                    if (!BSecVideoMultistreamDragAndDropCamera.this.cameraOrd.toString().equalsIgnoreCase(ordList.get(i).toString())) continue;
                    ordList = BOrdList.remove((BOrdList)ordList, (int)i);
                }
                BSecVideoMultistreamDragAndDropCamera.this.viewer.videoPlaybackMultistream.set("currentOrdList", (BValue)ordList);
                BSecVideoMultistreamDragAndDropCamera.this.viewer.videoPlaybackMultistream.lease(2);
                BSecVideoMultistreamDragAndDropCamera.this.viewer.doLoadValue((BObject)BSecVideoMultistreamDragAndDropCamera.this.viewer.videoPlaybackMultistream, BSecVideoMultistreamDragAndDropCamera.this.viewer.getCurrentContext());
                BFoxSession foxSession = (BFoxSession)BSecVideoMultistreamDragAndDropCamera.this.viewer.getCurrentValueSession();
                BPhotoIDNetwork photoIdNetwork = (BPhotoIDNetwork)foxSession.getService(BPhotoIDNetwork.TYPE);
                photoIdNetwork.lease();
                BPhotoIDViewerComponent[] comps = (BPhotoIDViewerComponent[])photoIdNetwork.getPhotoIDViewers().getChildren(BPhotoIDViewerComponent.class);
                boolean isPresent = false;
                block2: for (int i = 0; i < comps.length; ++i) {
                    comps[i].lease();
                    if (comps[i].get("currentOrdList") == null) continue;
                    BOrdList ordList2 = (BOrdList)comps[i].get("currentOrdList");
                    for (int k = 0; k < ordList2.size(); ++k) {
                        if (!BSecVideoMultistreamDragAndDropCamera.this.cameraOrd.toString().equalsIgnoreCase(ordList2.get(k).toString())) continue;
                        isPresent = true;
                        continue block2;
                    }
                }
                if (!isPresent) {
                    BComponent object = (BComponent)BSecVideoMultistreamDragAndDropCamera.this.cameraOrd.get((BObject)BSecVideoMultistreamDragAndDropCamera.this.viewer.videoPlaybackMultistream);
                    photoIdNetwork.remove((BComplex)object);
                    photoIdNetwork.lease();
                }
            }
            return null;
        }
    }
}

