/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.photoID.video;

import com.tridium.orion.OrionSession;
import com.tridiumx.entsec.access.orion.BAccReaderRec;
import com.tridiumx.entsec.photoID.BPhotoIDNetwork;
import com.tridiumx.entsec.photoID.video.BPhotoIDPlayer;
import com.tridiumx.entsec.photoID.video.BPhotoIDViewerComponent;
import com.tridiumx.entsec.securityUtil.query.BColumnsProvider;
import com.tridiumx.entsec.securityUtil.query.TypeSpecPath;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.query.BExpression;
import javax.baja.query.BQuery;
import javax.baja.query.expression.BFunctionExpression;
import javax.baja.query.util.Exprs;
import javax.baja.query.util.Funcs;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;
import javax.baja.util.Lexicon;

@NiagaraType
public class BPhotoIDViewersColumnProvider
extends BColumnsProvider {
    public static final Type TYPE = Sys.loadType(BPhotoIDViewersColumnProvider.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public TypeSpecPath[] getDefaultColumns(BQuery query) {
        Array a = new Array(TypeSpecPath.class);
        a.add((Object)TypeSpecPath.DISPLAY_NAME);
        Lexicon lex = Lexicon.make((String)TYPE.getModule().getModuleName());
        BFunctionExpression exp = Funcs.make((String)"entsec:PhotoIDViewersColumnProvider.getCameras", (Type)BString.TYPE, (BExpression)Exprs.simple((BSimple)BString.make((String)"Cameras")));
        TypeSpecPath camerasCol = new TypeSpecPath(BTypeSpec.make((String)"baja:String"), lex.getText("cameras"), null, (BExpression)exp);
        a.add((Object)camerasCol);
        BFunctionExpression exp2 = Funcs.make((String)"entsec:PhotoIDViewersColumnProvider.getReaders", (Type)BString.TYPE, (BExpression)Exprs.simple((BSimple)BString.make((String)"Readers")));
        TypeSpecPath readersCol = new TypeSpecPath(BTypeSpec.make((String)"baja:String"), lex.getText("readers"), null, (BExpression)exp2);
        a.add((Object)readersCol);
        return (TypeSpecPath[])a.trim();
    }

    public static BString getCameras(BObject target, BString name) {
        String strCameras = "";
        BPhotoIDViewerComponent photoIDViewerComp = (BPhotoIDViewerComponent)target;
        BOrdList ordList = (BOrdList)photoIDViewerComp.get("currentOrdList");
        int nCamCount = 0;
        if (ordList != null) {
            for (int i = 0; i < ordList.size(); ++i) {
                String strOrd = ordList.get(i).toString();
                if (BPhotoIDPlayer.isPhotoIDCamera(strOrd)) continue;
                try {
                    BComponent camObject = (BComponent)ordList.get(i).get((BObject)photoIDViewerComp);
                    if (nCamCount == 4) {
                        strCameras = strCameras + "...";
                        break;
                    }
                    if (strCameras.length() > 0) {
                        strCameras = strCameras + ", ";
                    }
                    strCameras = strCameras + SlotPath.unescape((String)camObject.getName());
                    ++nCamCount;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return BString.make((String)(strCameras.length() > 0 ? strCameras : "-"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BString getReaders(BObject target, BString name) {
        String strReaders = "";
        BPhotoIDViewerComponent photoIDViewerComp = (BPhotoIDViewerComponent)target;
        BOrdList ordList = (BOrdList)photoIDViewerComp.get("currentOrdList");
        int nCamCount = 0;
        if (ordList != null) {
            for (int i = 0; i < ordList.size(); ++i) {
                String strOrd = ordList.get(i).toString();
                if (!BPhotoIDPlayer.isPhotoIDCamera(strOrd)) continue;
                String strPhotoIDCameraName = BPhotoIDPlayer.getCameraName(strOrd);
                BPhotoIDNetwork photoIdNetwork = null;
                BComponent tempComp = (BComponent)photoIDViewerComp.getParent();
                while (photoIdNetwork == null) {
                    if (tempComp instanceof BPhotoIDNetwork) {
                        photoIdNetwork = (BPhotoIDNetwork)tempComp;
                        continue;
                    }
                    tempComp = (BComponent)tempComp.getParent();
                }
                photoIdNetwork.lease();
                String displayString = "";
                OrionSession session = null;
                try {
                    session = photoIdNetwork.createSession(null);
                    BAccReaderRec rec = (BAccReaderRec)session.read(BAccReaderRec.ORION_TYPE, (BSimple)BUuid.make((String)strPhotoIDCameraName));
                    displayString = rec.toDisplayString(null);
                }
                catch (Exception exception) {
                }
                finally {
                    if (session != null) {
                        session.close();
                        session = null;
                    }
                }
                if (displayString.equalsIgnoreCase("")) continue;
                if (nCamCount == 4) {
                    strReaders = strReaders + "...";
                    break;
                }
                if (strReaders.length() > 0) {
                    strReaders = strReaders + ", ";
                }
                strReaders = strReaders + displayString;
                ++nCamCount;
            }
        }
        return BString.make((String)(strReaders.length() > 0 ? strReaders : "-"));
    }
}

