/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.photoID.video;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.util.FoxRpcUtil;
import com.tridium.nd.BNiagaraStation;
import com.tridium.orion.OrionSession;
import com.tridium.ui.theme.Theme;
import com.tridium.videoDriver.BIVideoPlayer;
import com.tridium.videoDriver.VideoDriverLexicon;
import com.tridium.videoDriver.camera.BIRemoteVideoCamera;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.dvr.BIVideoDvr;
import com.tridium.videoDriver.enums.BVideoCompressionEnum;
import com.tridium.videoDriver.enums.BVideoFrameRateEnum;
import com.tridium.videoDriver.enums.BVideoResolutionEnum;
import com.tridium.videoDriver.ui.BVideoPlayer;
import com.tridium.videoDriver.ui.multistream.BVideoMultistreamCameraChooserList;
import com.tridium.videoDriver.ui.multistream.BVideoMultistreamCameraDropPane;
import com.tridium.videoDriver.ui.multistream.BVideoMultistreamDragAndDropCamera;
import com.tridium.videoDriver.ui.multistream.BVideoMultistreamLayoutTypesEnumFE;
import com.tridium.videoDriver.ui.multistream.BVideoMultistreamPaneForView;
import com.tridium.videoDriver.ui.multistream.BVideoMultistreamViewer;
import com.tridium.videoDriver.ui.multistream.BVideoSplitPaneSizerPane;
import com.tridium.videoDriver.ui.videoStream.BVideoMultistreamBinding;
import com.tridium.videoDriver.ui.videoStream.BVideoStreamBinding;
import com.tridium.workbench.fieldeditors.BFrozenEnumFE;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.access.orion.BAccReaderRec;
import com.tridiumx.entsec.photoID.BPhotoIDNetwork;
import com.tridiumx.entsec.photoID.video.BAddCameraDialog;
import com.tridiumx.entsec.photoID.video.BAddReaderDialog;
import com.tridiumx.entsec.photoID.video.BPhotoIDCamera;
import com.tridiumx.entsec.photoID.video.BPhotoIDVideoPlayer;
import com.tridiumx.entsec.photoID.video.BPhotoIDViewerComponent;
import com.tridiumx.entsec.photoID.video.BSecVideoMultistreamCameraDropPane;
import com.tridiumx.entsec.photoID.video.BSecVideoMultistreamDragAndDropCamera;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.space.BISpaceNode;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.CommandEvent;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.util.BUuid;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"entsec:PhotoIDViewerComponent"}, requiredPermissions="r")})
public class BPhotoIDPlayer
extends BVideoMultistreamViewer {
    public static final Type TYPE = Sys.loadType(BPhotoIDPlayer.class);
    ListPopulatorThreadGroup listPopulatorThreads = new ListPopulatorThreadGroup();
    protected AddReaderCommand addReader;
    protected AddCameraCommand addCamera;
    protected static final Lexicon SEC_LEX = Lexicon.make(BPhotoIDPlayer.class);
    protected BPhotoIDViewerComponent videoPlaybackMultistream;
    public static final BImage READER_ICON = BImage.make((String)SEC_LEX.getText("PhotoIDPlayer.icons.photoIdCameraIcon"));
    public static final String CURRENT_ORD_LIST = "currentOrdList";
    public static final Logger log = Logger.getLogger("videoDriver.multistreamViewer");

    public Type getType() {
        return TYPE;
    }

    public void doEnableSave() {
    }

    public void drawMultistreamViewer() {
        this.drawCameraChooserPane();
        this.drawLayoutChooserPane();
        this.videoPlaybackMultistream.lease();
        this.loadCamerOrds();
        this.mainLeftPane = new BEdgePane();
        this.mainLeftPane.setCenter((BWidget)this.cameraChooserPane);
        this.mainLeftPane.setBottom((BWidget)this.layoutChooserPane);
        this.cameraChooserAndMain = new BVideoSplitPaneSizerPane(BOrientation.horizontal);
        this.cameraChooserAndMain.setWidget1((BWidget)this.mainLeftPane);
        this.viewingPane = new BEdgePane();
        this.viewingPane.setCenter((BWidget)this.getDefaultLayoutPane());
        this.cameraChooserAndMain.setWidget2((BWidget)this.viewingPane);
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Do load value");
        }
        this.videoPlaybackMultistream = (BPhotoIDViewerComponent)value;
        this.videoPlaybackMultistream.lease(1);
        if (this.videoPlaybackMultistream.get(CURRENT_ORD_LIST) == null) {
            BOrdList ordList = BOrdList.NULL;
            this.videoPlaybackMultistream.add(CURRENT_ORD_LIST, (BValue)ordList);
            this.videoPlaybackMultistream.lease(1);
            this.videoPlaybackMultistream.setFacets(this.videoPlaybackMultistream.getSlot(CURRENT_ORD_LIST), BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
            this.videoPlaybackMultistream.lease(1);
        }
        BOrdList currentOrdList = (BOrdList)this.videoPlaybackMultistream.get(CURRENT_ORD_LIST);
        BOrdList newOrdList = this.cleanDeletedDevices((BOrdList)this.videoPlaybackMultistream.get(CURRENT_ORD_LIST));
        if (!newOrdList.equals((Object)currentOrdList)) {
            if (!this.videoPlaybackMultistream.getPermissions(this.getCurrentContext()).hasAdminWrite()) {
                Object t = FoxRpcUtil.doSilentRpc((BISpaceNode)this.videoPlaybackMultistream, (String)"setCamerasRpc", (Object[])new Object[]{newOrdList}).orElseThrow(() -> new BajaRuntimeException("RPC call to set PhotoIDCamera PhotoIdCamera#setCamerasRpc failed"));
            } else {
                this.videoPlaybackMultistream.set(CURRENT_ORD_LIST, (BValue)newOrdList);
            }
        }
        super.doLoadValue((BObject)this.videoPlaybackMultistream, context);
    }

    protected BObject doSaveValue(BObject value, Context context) throws CannotSaveException, Exception {
        if (!this.videoPlaybackMultistream.getPermissions(context).hasAdminWrite()) {
            Optional returnValue = FoxRpcUtil.doSilentRpc((BISpaceNode)this.videoPlaybackMultistream, (String)"setLytRPC", (Object[])new Object[]{this.videoLayoutChooserFE.saveValue()});
            for (int i = 1; i <= 16; ++i) {
                returnValue = FoxRpcUtil.doSilentRpc((BISpaceNode)this.videoPlaybackMultistream, (String)("setCamera" + i + "RPC"), (Object[])new Object[]{this.multistreamViewerCameraOrds[i - 1]});
            }
            return this.videoPlaybackMultistream;
        }
        return super.doSaveValue(value, context);
    }

    public void updateCameraOrd(int multistreamViewerId, BOrd newViewerOrd) {
        this.doSetModified();
        this.multistreamViewerCameraOrds[multistreamViewerId] = newViewerOrd;
        BNiagaraWbShell niagaraWbShell = (BNiagaraWbShell)this.getWbShell();
        niagaraWbShell.save((BWbView)this);
    }

    protected void drawLayoutChooserPane() {
        this.aspectRatioFE = new BFrozenEnumFE();
        this.videoLayoutChooserFE = new BVideoMultistreamLayoutTypesEnumFE();
        this.frameRateFE = new BFrozenEnumFE();
        this.resolutionFE = new BFrozenEnumFE();
        this.compressionFE = new BFrozenEnumFE();
        this.addReader = new AddReaderCommand();
        this.addCamera = new AddCameraCommand();
        BGridPane layoutChooserGrid = new BGridPane(2);
        layoutChooserGrid.setColumnAlign(BHalign.left);
        layoutChooserGrid.setHalign(BHalign.left);
        if (!this.videoPlaybackMultistream.getHideLayout()) {
            layoutChooserGrid.add("chooseLayout", (BValue)new BLabel(LEX.getText("VideoMultistreamViewer.ChooseLayout")));
            layoutChooserGrid.add("layoutChoice", (BValue)this.videoLayoutChooserFE);
        }
        layoutChooserGrid.add("empty1", (BValue)new BNullWidget());
        layoutChooserGrid.add("empty2", (BValue)new BNullWidget());
        layoutChooserGrid.add("addReaderButton", (BValue)new BBorderPane((BWidget)new BButton((Command)this.addReader), BInsets.make((double)15.0, (double)0.0, (double)0.0, (double)0.0)));
        layoutChooserGrid.add("addCameraButton", (BValue)new BBorderPane((BWidget)new BButton((Command)this.addCamera), BInsets.make((double)15.0, (double)0.0, (double)0.0, (double)0.0)));
        if (!this.videoPlaybackMultistream.getPermissions(this.getCurrentContext()).hasAdminWrite()) {
            this.addCamera.setEnabled(false);
            this.addReader.setEnabled(false);
        }
        this.aspectRatioFE.loadValue((BObject)this.videoPlaybackMultistream.getAspectRatio());
        this.videoLayoutChooserFE.loadValue((BObject)this.videoPlaybackMultistream.getLayout());
        this.frameRateFE.loadValue((BObject)this.videoPlaybackMultistream.getFrameRate());
        this.resolutionFE.loadValue((BObject)this.videoPlaybackMultistream.getResolution());
        this.compressionFE.loadValue((BObject)this.videoPlaybackMultistream.getCompression());
        this.layoutChooserPane = new BBorderPane((BWidget)layoutChooserGrid);
    }

    public BGridPane getCameraStackerGrid() {
        return this.cameraStackerGrid;
    }

    protected void fillCameraChooserPane() {
        try {
            BOrdList camerasInStation = (BOrdList)this.videoPlaybackMultistream.get(CURRENT_ORD_LIST);
            this.populateList(camerasInStation, this.cameraStackerGrid);
        }
        catch (InterruptedException ie) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Interrupted while populating list");
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, "ERROR in reading the list of cameras, ", e);
        }
    }

    protected void populateList(BOrdList camerasInStation, BGridPane cameraStackerGrid) throws InterruptedException {
        this.listPopulatorThreads.stopAll();
        int previousChilds = 0;
        previousChilds = ((BSecVideoMultistreamDragAndDropCamera[])cameraStackerGrid.getChildren(BSecVideoMultistreamDragAndDropCamera.class)).length;
        BFoxSession foxSession = (BFoxSession)this.getCurrentValueSession();
        BPhotoIDNetwork photoIdNetwork = (BPhotoIDNetwork)foxSession.getService(BPhotoIDNetwork.TYPE);
        photoIdNetwork.lease();
        for (int i = 0; i < camerasInStation.size(); ++i) {
            BOrd cameraOrd = camerasInStation.get(i);
            BObject cameraObject = cameraOrd.get((BObject)this.videoPlaybackMultistream);
            BSecVideoMultistreamDragAndDropCamera cameraDragAndDropWidget = new BSecVideoMultistreamDragAndDropCamera(this, cameraOrd);
            cameraDragAndDropWidget.setVideoCameraChooserList(this.videoCameraMultistreamChooserList);
            cameraDragAndDropWidget.setCameraOrd(cameraOrd);
            cameraDragAndDropWidget.setImage(SMALL_LOADING_ICON);
            cameraDragAndDropWidget.setText(BPhotoIDPlayer.getDefaultCameraDragAndDropDescription(cameraObject, true));
            cameraStackerGrid.add("camera" + (i + previousChilds), (BValue)cameraDragAndDropWidget);
            RetrieveListItemThread r = new RetrieveListItemThread(cameraOrd, cameraDragAndDropWidget);
            r.start();
        }
    }

    protected void drawCameraChooserPane() {
        this.videoCameraMultistreamChooserList = new BVideoMultistreamCameraChooserList();
        this.cameraStackerGrid = new BGridPane(1);
        this.cameraStackerGrid.setValign(BValign.top);
        this.cameraStackerGrid.setHalign(BHalign.left);
        BFont labelFont = Theme.label().getBoldText();
        labelFont = BFont.make((String)labelFont.getName(), (double)labelFont.getSize(), (int)5);
        BLabel label = new BLabel(SEC_LEX.getText("PhotoIDPlayer.DraggableCameras"));
        label.setFont(labelFont);
        this.cameraStackerGrid.add("heading", (BValue)label);
        this.videoCameraMultistreamChooserList.setContent((BWidget)this.cameraStackerGrid);
        BBorderPane camraStackerBorderPane = new BBorderPane((BWidget)this.videoCameraMultistreamChooserList);
        BScrollPane cameraStackerScrollPane = new BScrollPane((BWidget)camraStackerBorderPane);
        this.cameraChooserPane = cameraStackerScrollPane;
    }

    public static String getDefaultCameraDragAndDropDescription(Object cameraObject, boolean loadingOrResolving) {
        if (cameraObject instanceof BIRemoteVideoCamera) {
            BComponent cameraComponent = (BComponent)cameraObject;
            try {
                cameraComponent.lease(Integer.MAX_VALUE, 10000L);
                cameraComponent.getComponentSpace().sync();
            }
            catch (Exception e) {
                log.log(Level.FINE, "Unable to sync camera: " + cameraObject);
            }
            BIRemoteVideoCamera remoteVideoCamera = (BIRemoteVideoCamera)cameraObject;
            BNiagaraStation niagaraStation = remoteVideoCamera.getNiagaraStation();
            if (niagaraStation != null) {
                String lexKey = loadingOrResolving ? "MultistreamViewer.CameraList.RemoteCamera.Loading" : "MultistreamViewer.CameraList.RemoteCamera.Offline";
                return LEX.getText(lexKey, new Object[]{niagaraStation.getStationName(), SlotPath.escape((String)cameraComponent.getDisplayName(null))});
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Unable to resolve the BNiagaraStation for the BNiagaraCameraPoint");
            }
        }
        Object arg0 = cameraObject;
        if (cameraObject instanceof BComponent) {
            BComponent cameraComponent = (BComponent)cameraObject;
            arg0 = cameraComponent.getName();
        }
        String lexKey = loadingOrResolving ? "MultistreamViewer.CameraList.CameraDescription.Loading.Label" : "MultistreamViewer.CameraList.CameraDescription.Unavailable.Label";
        return VideoDriverLexicon.getLexString((String)lexKey, (Object)arg0);
    }

    public static BImage getCameraDragAndDropImage(BObject cameraObject) {
        BImage cameraDragAndDropImage;
        if (cameraObject instanceof BComponent) {
            if (cameraObject instanceof BPhotoIDCamera) {
                cameraDragAndDropImage = READER_ICON;
            } else {
                BComponent cameraComponent = (BComponent)cameraObject;
                cameraDragAndDropImage = BImage.make((BIcon)cameraComponent.getIcon());
            }
        } else {
            cameraDragAndDropImage = DEFAULT_CAMERA_IMAGE;
        }
        return cameraDragAndDropImage;
    }

    protected BVideoMultistreamCameraDropPane makeEmptyDropPane(int multistreamViewerId) {
        BPhotoIDVideoPlayer emptyVideoPlayer = new BPhotoIDVideoPlayer();
        BSecVideoMultistreamCameraDropPane dropPaneForNoCamera = new BSecVideoMultistreamCameraDropPane(multistreamViewerId);
        emptyVideoPlayer.setHostTransferWidget((BTransferWidget)dropPaneForNoCamera);
        BBorderPane insetPane = new BBorderPane((BWidget)emptyVideoPlayer, BBorder.inset, BInsets.make((double)0.0));
        dropPaneForNoCamera.setContent((BWidget)insetPane);
        emptyVideoPlayer.add("cameraBinding", (BValue)new BVideoStreamBinding());
        return dropPaneForNoCamera;
    }

    protected BVideoMultistreamCameraDropPane makeVideoCameraDropPaneForStandAloneCamera(BIVideoCamera standAloneCamera, int multistreamViewerId) {
        BPhotoIDVideoPlayer videoPlayerForStandAloneCamera = new BPhotoIDVideoPlayer();
        videoPlayerForStandAloneCamera.setCameraDescription(BPhotoIDPlayer.getDefaultCameraDragAndDropDescription(standAloneCamera, true));
        try {
            videoPlayerForStandAloneCamera.setCompression((BVideoCompressionEnum)this.compressionFE.saveValue());
            videoPlayerForStandAloneCamera.setFrameRate((BVideoFrameRateEnum)this.frameRateFE.saveValue());
            videoPlayerForStandAloneCamera.setResolution((BVideoResolutionEnum)this.resolutionFE.saveValue());
            videoPlayerForStandAloneCamera.setVideoStreamFox(this.videoPlaybackMultistream.getVideoStreamFox());
        }
        catch (CannotSaveException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BSecVideoMultistreamCameraDropPane dropPaneForCamera = new BSecVideoMultistreamCameraDropPane(multistreamViewerId);
        videoPlayerForStandAloneCamera.setHostTransferWidget((BTransferWidget)dropPaneForCamera);
        BBorderPane insetPane = new BBorderPane((BWidget)videoPlayerForStandAloneCamera, BBorder.inset, BInsets.make((double)0.0));
        dropPaneForCamera.setContent((BWidget)insetPane);
        this.addVideoStreamBinding(videoPlayerForStandAloneCamera, standAloneCamera);
        return dropPaneForCamera;
    }

    public BVideoMultistreamCameraDropPane makeVideoCameraDropPaneForMultistreamStreamCamera(Hashtable<BIVideoDvr, BVideoMultistreamPaneForView> multistreamDvrsToMultistreamPanes, Hashtable<BVideoMultistreamPaneForView, Array<BVideoPlayer>> multistreamPanesToVideoPlayers, BIVideoDvr multistreamDvr, BIVideoCamera nextCamera, int multistreamViewerId) {
        BPhotoIDVideoPlayer videoPlayer = new BPhotoIDVideoPlayer();
        videoPlayer.setCameraDescription(nextCamera.getCameraDescription());
        BVideoMultistreamPaneForView multistreamPane = multistreamDvrsToMultistreamPanes.get(multistreamDvr);
        Array videoPlayersForMultistreamPane = multistreamPanesToVideoPlayers.get(multistreamPane);
        if (videoPlayersForMultistreamPane == null) {
            videoPlayersForMultistreamPane = new Array(BVideoPlayer.class);
            multistreamPanesToVideoPlayers.put(multistreamPane, (Array<BVideoPlayer>)videoPlayersForMultistreamPane);
        }
        videoPlayersForMultistreamPane.add((Object)videoPlayer);
        videoPlayer.setMultistreamPaneForView(multistreamPane);
        BSecVideoMultistreamCameraDropPane dropPaneForCamera = new BSecVideoMultistreamCameraDropPane(multistreamViewerId);
        videoPlayer.setHostTransferWidget((BTransferWidget)dropPaneForCamera);
        BVideoStreamBinding videoPlayerBinding = new BVideoStreamBinding();
        videoPlayerBinding.setOrd(((BComponent)nextCamera).getSlotPathOrd());
        videoPlayer.add("cameraBinding", (BValue)videoPlayerBinding);
        BBorderPane insetPane = new BBorderPane((BWidget)videoPlayer, BBorder.inset, BInsets.make((double)0.0));
        dropPaneForCamera.setContent((BWidget)insetPane);
        return dropPaneForCamera;
    }

    protected Array<Object> makeVideoPlayerDropPanes(BOrd[] cameraOrds) {
        Hashtable multistreamDvrsToCameras = new Hashtable(cameraOrds.length);
        Hashtable camerasToMultistreamDvrs = new Hashtable(cameraOrds.length);
        Array allCameras = new Array(BIVideoCamera.class);
        this.indexMultistreamDvrsToCameras(multistreamDvrsToCameras, camerasToMultistreamDvrs, allCameras, cameraOrds);
        Array videoPlayerDropPanes = new Array(BSecVideoMultistreamCameraDropPane.class);
        Hashtable<BIVideoDvr, BVideoMultistreamPaneForView> multistreamDvrsToMultistreamPanes = new Hashtable<BIVideoDvr, BVideoMultistreamPaneForView>(multistreamDvrsToCameras.size());
        Hashtable<BVideoMultistreamPaneForView, Array<BVideoPlayer>> multistreamPanesToVideoPlayers = new Hashtable<BVideoMultistreamPaneForView, Array<BVideoPlayer>>();
        Hashtable multistreamPanesToMultistreamBindings = new Hashtable();
        ListIterator iterateAllCameras = allCameras.iterator();
        int multistreamViewerId = 0;
        while (iterateAllCameras.hasNext()) {
            BSecVideoMultistreamCameraDropPane dropPaneForCamera;
            BIVideoCamera nextCamera = (BIVideoCamera)iterateAllCameras.next();
            if (nextCamera == this.NO_CAMERA) {
                dropPaneForCamera = (BSecVideoMultistreamCameraDropPane)this.makeEmptyDropPane(multistreamViewerId++);
            } else {
                BIVideoDvr multistreamDvr = (BIVideoDvr)camerasToMultistreamDvrs.get(nextCamera);
                boolean isStandAloneCamera = this.isStandAloneCamera(multistreamDvrsToCameras, nextCamera, multistreamDvr);
                if (isStandAloneCamera) {
                    dropPaneForCamera = (BSecVideoMultistreamCameraDropPane)this.makeVideoCameraDropPaneForStandAloneCamera(nextCamera, multistreamViewerId++);
                } else {
                    this.maybeMakeMultistreamPane(multistreamDvrsToMultistreamPanes, multistreamPanesToMultistreamBindings, multistreamDvr);
                    dropPaneForCamera = (BSecVideoMultistreamCameraDropPane)this.makeVideoCameraDropPaneForMultistreamStreamCamera(multistreamDvrsToMultistreamPanes, multistreamPanesToVideoPlayers, multistreamDvr, nextCamera, multistreamViewerId++);
                }
            }
            dropPaneForCamera.setViewer(this);
            videoPlayerDropPanes.add((Object)dropPaneForCamera);
        }
        Array retVal = new Array(Object.class);
        Enumeration multistreamPanes = multistreamPanesToVideoPlayers.keys();
        while (multistreamPanes.hasMoreElements()) {
            BVideoMultistreamPaneForView multistreamPane = (BVideoMultistreamPaneForView)multistreamPanes.nextElement();
            BIVideoPlayer[] biVideoPlayers = this.getVideoPlayersToMultistreamPane(multistreamPane, multistreamPanesToVideoPlayers);
            multistreamPane.setVideoPlayersForView(biVideoPlayers);
            retVal.add((Object)multistreamPane);
        }
        retVal.addAll(videoPlayerDropPanes);
        retVal.push(multistreamPanesToMultistreamBindings);
        return retVal;
    }

    public BVideoMultistreamDragAndDropCamera[] getDragAndDropItems() {
        return (BVideoMultistreamDragAndDropCamera[])this.cameraStackerGrid.getChildren(BSecVideoMultistreamDragAndDropCamera.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void switchVideoLayout(BPane layoutPane, BOrd[] cameraOrds, Property[] paneWidgetProperties) {
        Object object = this.switcherSynchronizer;
        synchronized (object) {
            this.doSetModified();
            BWidget[] childWidgets = this.getChildWidgets();
            for (int i = 0; i < childWidgets.length; ++i) {
                if (!(childWidgets[i] instanceof BVideoMultistreamPaneForView) || !childWidgets[i].getPropertyInParent().isDynamic()) continue;
                this.remove((BComplex)childWidgets[i]);
            }
            Array<Object> miscellaneousObjects = this.makeVideoPlayerDropPanes(cameraOrds);
            this.multistreamPanesToMultistreamBindings = (Hashtable)miscellaneousObjects.pop();
            this.dropPanesInUse = new Array(BVideoMultistreamCameraDropPane.class);
            ListIterator i = miscellaneousObjects.iterator();
            int playerIndex = 0;
            while (i.hasNext()) {
                Object next = i.next();
                if (next instanceof BSecVideoMultistreamCameraDropPane) {
                    if (playerIndex < paneWidgetProperties.length) {
                        BSecVideoMultistreamCameraDropPane nextDropPane = (BSecVideoMultistreamCameraDropPane)((Object)next);
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Adding drop pane: " + nextDropPane.hashCode());
                        }
                        this.dropPanesInUse.add((Object)nextDropPane);
                        layoutPane.set(paneWidgetProperties[playerIndex], (BValue)nextDropPane);
                        ++playerIndex;
                        continue;
                    }
                    throw new IllegalStateException("Too many drop panes for video layout. Please have my program fixed.");
                }
                if (next instanceof BVideoMultistreamPaneForView) {
                    this.add("multistreamPaneForView?", (BValue)((BVideoMultistreamPaneForView)next));
                    continue;
                }
                throw new IllegalStateException("Unsupported array object class: " + next.getClass() + ". Please have my program fixed.");
            }
            this.viewingPane.setCenter((BWidget)layoutPane);
            Enumeration multistreamPanes = this.multistreamPanesToMultistreamBindings.keys();
            while (multistreamPanes.hasMoreElements()) {
                BVideoMultistreamPaneForView multistreamPane = (BVideoMultistreamPaneForView)multistreamPanes.nextElement();
                BVideoMultistreamBinding multistreamPaneBinding = (BVideoMultistreamBinding)this.multistreamPanesToMultistreamBindings.get(multistreamPane);
                multistreamPane.add("multistreamVideoBinding", (BValue)multistreamPaneBinding);
            }
            this.updateVideoPaneStatusBarDescriptions();
            BNiagaraWbShell niagaraWbShell = (BNiagaraWbShell)this.getWbShell();
            niagaraWbShell.save((BWbView)this);
        }
    }

    public void updateVideoPaneStatusBarDescriptions() {
        BSecVideoMultistreamDragAndDropCamera[] dragDropItems = (BSecVideoMultistreamDragAndDropCamera[])this.getDragAndDropItems();
        for (int i = 0; i < dragDropItems.length; ++i) {
            this.updateDescriptionCorrespondingViewPane(dragDropItems[i]);
        }
    }

    public void updateDescriptionCorrespondingViewPane(BSecVideoMultistreamDragAndDropCamera dragDropItem) {
        String dragDropCameraDescription = dragDropItem.getText();
        BOrd cameraOrd = dragDropItem.getCameraOrd();
        if (log.isLoggable(Level.FINE)) {
            log.fine("UD:" + dragDropCameraDescription + ":Updating corresponding view pane description (if camera being viewed)");
        }
        BOrd stationCameraOrd = BOrd.make((String)("station:|" + cameraOrd));
        if (log.isLoggable(Level.FINE)) {
            log.fine("UD:" + dragDropCameraDescription + ":stationCameraOrd=" + stationCameraOrd + " cameraOrd=" + cameraOrd);
        }
        Array dropPanesInUse = this.getDropPanesInUse();
        BSecVideoMultistreamCameraDropPane dropPane2 = null;
        if (log.isLoggable(Level.FINE)) {
            log.fine("UD:" + dragDropCameraDescription + ":Preparing to iterate over drop panes in use.");
        }
        for (BSecVideoMultistreamCameraDropPane dropPane2 : dropPanesInUse) {
            if (dropPane2 == null) continue;
            if (log.isLoggable(Level.FINE)) {
                log.fine("UD:" + dragDropCameraDescription + ":Iterating over drop pane. Finding binding for drop pane. Drop pane = " + dropPane2.hashCode());
            }
            BVideoStreamBinding binding = dropPane2.findVideoPlayerBinding();
            if (log.isLoggable(Level.FINE)) {
                log.fine("UD:" + dragDropCameraDescription + ":Iterating over drop pane. Done finding binding for drop pane");
            }
            if (binding == null) continue;
            if (log.isLoggable(Level.FINE)) {
                log.fine("UD:" + dragDropCameraDescription + ":Iterating over drop pane. Found binding for drop pane");
            }
            BOrd bindingOrd = binding.getOrd();
            if (log.isLoggable(Level.FINE)) {
                log.fine("UD:" + dragDropCameraDescription + ":Iterating over drop pane. bindingOrd=" + bindingOrd + " stationCameraOrd=" + stationCameraOrd + " cameraOrd=" + cameraOrd);
            }
            if ((bindingOrd == null || !bindingOrd.equals((Object)cameraOrd)) && !bindingOrd.equals((Object)stationCameraOrd)) continue;
            if (log.isLoggable(Level.FINE)) {
                log.fine("UD:" + dragDropCameraDescription + ":Getting videoPlayer for drop pane");
            }
            BVideoPlayer videoPlayer = dropPane2.findVideoPlayer();
            if (log.isLoggable(Level.FINE)) {
                log.fine("UD:" + dragDropCameraDescription + ":Got videoPlayer for drop pane");
            }
            videoPlayer.setCameraDescription(dragDropCameraDescription);
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine("UD:" + dragDropCameraDescription + ":Updated description");
        }
    }

    public boolean isDuplicate(BOrdList currentOrdList, BOrd ord) {
        boolean isDuplicate = false;
        for (int i = 0; i < currentOrdList.size(); ++i) {
            if (!currentOrdList.get(i).toString().equalsIgnoreCase(ord.toString())) continue;
            return true;
        }
        return isDuplicate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BOrdList cleanDeletedDevices(BOrdList camerasInStation) {
        BOrdList copiedList = (BOrdList)camerasInStation.newCopy();
        BFoxSession foxSession = (BFoxSession)this.getCurrentValueSession();
        BPhotoIDNetwork photoIdNetwork = (BPhotoIDNetwork)foxSession.getService(BPhotoIDNetwork.TYPE);
        photoIdNetwork.lease();
        for (int i = 0; i < camerasInStation.size(); ++i) {
            BOrd cameraOrd = camerasInStation.get(i);
            try {
                BObject cameraObject = cameraOrd.get((BObject)this.videoPlaybackMultistream);
                if (!(cameraObject instanceof BPhotoIDCamera)) continue;
                BPhotoIDCamera photoIDCamera = (BPhotoIDCamera)cameraObject;
                photoIDCamera.lease();
                String displayString = "";
                BAccReaderRec rec = null;
                OrionSession session = null;
                try {
                    session = photoIdNetwork.createSession(null);
                    try {
                        rec = (BAccReaderRec)session.read(BAccReaderRec.ORION_TYPE, (BSimple)photoIDCamera.getReaderUuid());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        if (session != null) {
                            session.close();
                            session = null;
                        }
                    }
                }
                catch (Exception e) {
                    rec = (BAccReaderRec)FoxRpcUtil.doSilentRpc((BISpaceNode)photoIdNetwork, (String)"readReaderRPC", (Object[])new Object[]{photoIDCamera.getReaderUuid()}).orElseThrow(() -> new BajaRuntimeException("RPC call to RemoteReader ACCReaderRec#readReaderRPC failed"));
                }
                if (rec != null) {
                    displayString = rec.toDisplayString(null);
                }
                photoIDCamera.getVideoDeviceId().setDescription(displayString);
                photoIDCamera.lease();
                if (!displayString.equalsIgnoreCase("")) continue;
                for (int j = 0; j < copiedList.size(); ++j) {
                    if (!cameraOrd.toString().equalsIgnoreCase(copiedList.get(j).toString())) continue;
                    copiedList = BOrdList.remove((BOrdList)copiedList, (int)j);
                }
                for (int k = 1; k <= 16; ++k) {
                    BOrd ord = (BOrd)this.videoPlaybackMultistream.get("camera" + k);
                    if (!cameraOrd.toString().equalsIgnoreCase(ord.toString())) continue;
                    this.videoPlaybackMultistream.set("camera" + k, (BValue)BOrd.NULL);
                }
                this.videoPlaybackMultistream.lease(1);
                continue;
            }
            catch (UnresolvedException noe) {
                String strOrd = cameraOrd.toString();
                if (BPhotoIDPlayer.isPhotoIDCamera(strOrd)) {
                    String strPhotoIDCameraName = BPhotoIDPlayer.getCameraName(strOrd);
                    String displayString = "";
                    BAccReaderRec rec = null;
                    OrionSession session = null;
                    try {
                        session = photoIdNetwork.createSession(null);
                        try {
                            rec = (BAccReaderRec)session.read(BAccReaderRec.ORION_TYPE, (BSimple)BUuid.make((String)strPhotoIDCameraName));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        finally {
                            if (session != null) {
                                session.close();
                                session = null;
                            }
                        }
                    }
                    catch (Exception e) {
                        rec = (BAccReaderRec)FoxRpcUtil.doSilentRpc((BISpaceNode)photoIdNetwork, (String)"readReaderRPC", (Object[])new Object[]{BUuid.make((String)strPhotoIDCameraName)}).orElseThrow(() -> new BajaRuntimeException("RPC call to RemoteReader to get ReaderName ACCReaderRec#readReaderRPC failed"));
                    }
                    if (rec != null) {
                        displayString = rec.toDisplayString(null);
                    }
                    if (!displayString.equalsIgnoreCase("")) {
                        if (this.videoPlaybackMultistream.getPermissions(this.getCurrentContext()).hasAdminWrite()) {
                            BPhotoIDViewerComponent.addPhotoIDCamera(photoIdNetwork, strPhotoIDCameraName, this.getCurrentContext());
                            continue;
                        }
                        Object e = FoxRpcUtil.doSilentRpc((BISpaceNode)this.videoPlaybackMultistream, (String)"addPhotoIDCameraRpc", (Object[])new Object[]{strPhotoIDCameraName}).orElseThrow(() -> new BajaRuntimeException("RPC call to get PhotoIDCamera PhotoIdCamera#addPhotoIDCameraRpc failed"));
                        continue;
                    }
                    for (int j = 0; j < copiedList.size(); ++j) {
                        if (!strOrd.equalsIgnoreCase(copiedList.get(j).toString())) continue;
                        copiedList = BOrdList.remove((BOrdList)copiedList, (int)j);
                    }
                    for (int k = 1; k <= 16; ++k) {
                        BOrd ord = (BOrd)this.videoPlaybackMultistream.get("camera" + k);
                        if (!cameraOrd.toString().equalsIgnoreCase(ord.toString())) continue;
                        this.videoPlaybackMultistream.set("camera" + k, (BValue)BOrd.NULL);
                    }
                    this.videoPlaybackMultistream.lease(1);
                    continue;
                }
                for (int k = 1; k <= 16; ++k) {
                    BOrd ord = (BOrd)this.videoPlaybackMultistream.get("camera" + k);
                    if (!cameraOrd.toString().equalsIgnoreCase(ord.toString())) continue;
                    this.videoPlaybackMultistream.set("camera" + k, (BValue)BOrd.NULL);
                }
                this.videoPlaybackMultistream.lease(1);
                for (int j = 0; j < copiedList.size(); ++j) {
                    if (!cameraOrd.toString().equalsIgnoreCase(copiedList.get(j).toString())) continue;
                    copiedList = BOrdList.remove((BOrdList)copiedList, (int)j);
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return copiedList;
    }

    public static boolean isPhotoIDCamera(String ord) {
        String strOrd = BPhotoIDPlayer.getCameraName(ord);
        try {
            BUuid.DEFAULT.decodeFromString(strOrd);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getCameraName(String ord) {
        String strOrd = ord;
        while (strOrd.indexOf("/") >= 0) {
            strOrd = strOrd.substring(strOrd.indexOf("/") + 1);
        }
        return SlotPath.unescape((String)strOrd);
    }

    public class AddCameraCommand
    extends Command {
        AddCameraCommand() {
            super((BWidget)BPhotoIDPlayer.this, SEC_LEX.getText("PhotoIDPlayer.commands.addCamera"));
        }

        public CommandArtifact doInvoke(CommandEvent event) {
            BFoxSession foxSession = (BFoxSession)BPhotoIDPlayer.this.getCurrentValueSession();
            BPhotoIDNetwork photoIdNetwork = (BPhotoIDNetwork)foxSession.getService(BPhotoIDNetwork.TYPE);
            photoIdNetwork.lease();
            BOrdList camerasOrdList = BAddCameraDialog.open(BPhotoIDPlayer.this.videoPlaybackMultistream, (BWidget)this.getShell(), "Add Camera", true, BPhotoIDPlayer.this.getCurrentContext());
            if (camerasOrdList != null) {
                try {
                    BOrdList currentOrdList = (BOrdList)BPhotoIDPlayer.this.videoPlaybackMultistream.get(BPhotoIDPlayer.CURRENT_ORD_LIST);
                    Array ordsArray = new Array(BOrd.class);
                    for (int j = 0; j < currentOrdList.size(); ++j) {
                        ordsArray.add((Object)currentOrdList.get(j));
                    }
                    for (int k = 0; k < camerasOrdList.size(); ++k) {
                        if (BPhotoIDPlayer.this.isDuplicate(currentOrdList, camerasOrdList.get(k))) continue;
                        ordsArray.add((Object)camerasOrdList.get(k));
                    }
                    BOrd[] ords = new BOrd[ordsArray.size()];
                    for (int p = 0; p < ords.length; ++p) {
                        ords[p] = (BOrd)ordsArray.get(p);
                    }
                    BPhotoIDPlayer.this.videoPlaybackMultistream.set(BPhotoIDPlayer.CURRENT_ORD_LIST, (BValue)BOrdList.make((BOrd[])ords));
                    BPhotoIDPlayer.this.videoPlaybackMultistream.lease(2);
                    BPhotoIDPlayer.this.doLoadValue((BObject)BPhotoIDPlayer.this.videoPlaybackMultistream, BPhotoIDPlayer.this.getCurrentContext());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return null;
        }
    }

    public class AddReaderCommand
    extends Command {
        AddReaderCommand() {
            super((BWidget)BPhotoIDPlayer.this, SEC_LEX.getText("PhotoIDPlayer.commands.addReader"));
        }

        public CommandArtifact doInvoke(CommandEvent event) {
            BPhotoIDPlayer.this.videoPlaybackMultistream.lease(2);
            BFoxSession foxSession = (BFoxSession)BPhotoIDPlayer.this.getCurrentValueSession();
            BPhotoIDNetwork photoIdNetwork = (BPhotoIDNetwork)foxSession.getService(BPhotoIDNetwork.TYPE);
            photoIdNetwork.lease();
            BEnterpriseSecurityService service = (BEnterpriseSecurityService)foxSession.getService(BEnterpriseSecurityService.TYPE);
            service.lease();
            BOrd appOrd = BOrd.make((String)("station:|" + service.getSlotPathOrd().toString()));
            BOrdList readersOrdList = BAddReaderDialog.open(appOrd, photoIdNetwork, BPhotoIDPlayer.this.videoPlaybackMultistream, (BWidget)this.getShell(), "Add Reader", true);
            if (readersOrdList != null) {
                try {
                    BOrdList currentOrdList = (BOrdList)BPhotoIDPlayer.this.videoPlaybackMultistream.get(BPhotoIDPlayer.CURRENT_ORD_LIST);
                    Array ordsArray = new Array(BOrd.class);
                    for (int j = 0; j < currentOrdList.size(); ++j) {
                        ordsArray.add((Object)currentOrdList.get(j));
                    }
                    for (int k = 0; k < readersOrdList.size(); ++k) {
                        if (BPhotoIDPlayer.this.isDuplicate(currentOrdList, readersOrdList.get(k))) continue;
                        ordsArray.add((Object)readersOrdList.get(k));
                    }
                    BOrd[] ords = new BOrd[ordsArray.size()];
                    for (int p = 0; p < ords.length; ++p) {
                        ords[p] = (BOrd)ordsArray.get(p);
                    }
                    BPhotoIDPlayer.this.videoPlaybackMultistream.set(BPhotoIDPlayer.CURRENT_ORD_LIST, (BValue)BOrdList.make((BOrd[])ords));
                    BPhotoIDPlayer.this.videoPlaybackMultistream.lease(2);
                    BPhotoIDPlayer.this.doLoadValue((BObject)BPhotoIDPlayer.this.videoPlaybackMultistream, BPhotoIDPlayer.this.getCurrentContext());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return null;
        }
    }

    public class RetrieveListItemThread
    extends Thread {
        BOrd cameraOrd;
        BSecVideoMultistreamDragAndDropCamera cameraDragAndDropWidget;
        boolean running;

        public RetrieveListItemThread(BOrd cameraOrd, BSecVideoMultistreamDragAndDropCamera cameraDragAndDropWidget) {
            super("MultistreamViewer.RetrieveListItem");
            this.cameraOrd = cameraOrd;
            this.cameraDragAndDropWidget = cameraDragAndDropWidget;
            this.running = true;
            BPhotoIDPlayer.this.listPopulatorThreads.add(this);
        }

        public void pleaseStop() {
            this.running = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (BPhotoIDPlayer.this.isRunning() && this.running) {
                    BObject cameraObject = this.cameraOrd.get((BObject)BPhotoIDPlayer.this.videoPlaybackMultistream);
                    try {
                        String dragDropCameraDescription = BVideoMultistreamViewer.getCameraDragAndDropDescription((BObject)cameraObject);
                        this.cameraDragAndDropWidget.setText(dragDropCameraDescription);
                        this.cameraDragAndDropWidget.setImage(BPhotoIDPlayer.getCameraDragAndDropImage(cameraObject));
                        if (!BPhotoIDPlayer.this.isRunning() || !this.running) continue;
                        this.running = false;
                        Object object = BPhotoIDPlayer.this.switcherSynchronizer;
                        synchronized (object) {
                            if (log.isLoggable(Level.FINE)) {
                                log.fine(dragDropCameraDescription + ":Entered synchronized(switcherSynhronizer) block");
                            }
                            BOrd stationCameraOrd = BOrd.make((String)("station:|" + this.cameraOrd));
                            if (log.isLoggable(Level.FINE)) {
                                log.fine(dragDropCameraDescription + ":stationCameraOrd=" + stationCameraOrd + " cameraOrd=" + this.cameraOrd);
                            }
                            Array dropPanesInUse = BPhotoIDPlayer.this.getDropPanesInUse();
                            BSecVideoMultistreamCameraDropPane dropPane2 = null;
                            if (log.isLoggable(Level.FINE)) {
                                log.fine(dragDropCameraDescription + ":Preparing to iterate over drop panes in use.");
                            }
                            for (BSecVideoMultistreamCameraDropPane dropPane2 : dropPanesInUse) {
                                if (dropPane2 == null) continue;
                                if (log.isLoggable(Level.FINE)) {
                                    log.fine(dragDropCameraDescription + ":Iterating over drop pane. Finding binding for drop pane. Drop pane = " + dropPane2.hashCode());
                                }
                                BVideoStreamBinding binding = dropPane2.findVideoPlayerBinding();
                                if (log.isLoggable(Level.FINE)) {
                                    log.fine(dragDropCameraDescription + ":Iterating over drop pane. Done finding binding for drop pane");
                                }
                                if (binding == null) continue;
                                if (log.isLoggable(Level.FINE)) {
                                    log.fine(dragDropCameraDescription + ":Iterating over drop pane. Found binding for drop pane");
                                }
                                BOrd bindingOrd = binding.getOrd();
                                if (log.isLoggable(Level.FINE)) {
                                    log.fine(dragDropCameraDescription + ":Iterating over drop pane. bindingOrd=" + bindingOrd + " stationCameraOrd=" + stationCameraOrd + " cameraOrd=" + this.cameraOrd);
                                }
                                if ((bindingOrd == null || !bindingOrd.equals((Object)this.cameraOrd)) && !bindingOrd.equals((Object)stationCameraOrd)) continue;
                                if (log.isLoggable(Level.FINE)) {
                                    log.fine(dragDropCameraDescription + ":Getting videoPlayer for drop pane");
                                }
                                BVideoPlayer videoPlayer = dropPane2.findVideoPlayer();
                                if (log.isLoggable(Level.FINE)) {
                                    log.fine(dragDropCameraDescription + ":Got videoPlayer for drop pane");
                                }
                                videoPlayer.setCameraDescription(dragDropCameraDescription);
                                if (!log.isLoggable(Level.FINE)) continue;
                                log.fine(dragDropCameraDescription + ":Updated description");
                            }
                        }
                    }
                    catch (RuntimeException rte) {
                        this.cameraDragAndDropWidget.setImage(BImage.make((BIcon)BIcon.make((BOrd)BOrd.make((String)"module://icons/x16/error.png"))));
                        this.cameraDragAndDropWidget.setText(BPhotoIDPlayer.getDefaultCameraDragAndDropDescription(cameraObject, false));
                        if (!log.isLoggable(Level.FINE)) continue;
                        log.log(Level.FINE, "Exception setting text of a list item.\n>> Ord = " + this.cameraOrd + "\n>> Exception = " + rte, rte);
                    }
                    finally {
                        this.running = false;
                    }
                }
            }
            finally {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("List populator thread stopped. Ord = " + this.cameraOrd);
                }
            }
        }
    }

    public class ListPopulatorThreadGroup {
        LinkedList<RetrieveListItemThread> threads = new LinkedList();

        public synchronized void add(RetrieveListItemThread r) {
            this.threads.add(r);
        }

        public synchronized void stopAll() throws InterruptedException {
            LinkedList<RetrieveListItemThread> itemsToRemove = new LinkedList<RetrieveListItemThread>();
            RetrieveListItemThread r2 = null;
            for (RetrieveListItemThread r2 : this.threads) {
                if (r2 == null || !r2.isAlive()) continue;
                r2.pleaseStop();
                r2.join(100L);
                if (r2.isAlive()) continue;
                itemsToRemove.add(r2);
            }
            this.threads.removeAll(itemsToRemove);
        }
    }
}

