/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.photoID.obix;

import com.tridium.obix.server.BObixAgent;
import com.tridium.obix.util.ObixConstants;
import com.tridium.obix.util.Obj;
import com.tridium.obix.util.WrapperException;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.photoID.BIPhotoIDClientDevice;
import com.tridiumx.entsec.photoID.BPhotoIDDeviceLeaf;
import com.tridiumx.entsec.photoID.BPhotoIDNetwork;
import com.tridiumx.entsec.photoID.obix.EntsecObixUtil;
import java.util.HashMap;
import javax.baja.agent.AgentFilter;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.obix.driver.lobby.BIObixLobbyAgent;
import javax.baja.obix.io.BIObixEncodable;
import javax.baja.obix.io.BIObixInvocable;
import javax.baja.obix.io.ObixDecoder;
import javax.baja.obix.io.ObixEncoder;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.xml.XElem;
import obix.Int;
import obix.Str;

@NiagaraType(agent={@AgentOn(types={"obixDriver:ObixLobby"}, requiredPermissions="r")})
public class BPhotoIDLobbyAgent
extends BObixAgent
implements BIObixLobbyAgent,
BIObixEncodable,
BIObixInvocable,
ObixConstants {
    public static final Type TYPE = Sys.loadType(BPhotoIDLobbyAgent.class);
    static HashMap<String, DiscoveryLeaf> discovered = new HashMap();

    public Type getType() {
        return TYPE;
    }

    public void encode(ObixEncoder out, Context cx) {
        try {
            Obj o = new Obj();
            o.setHref(out.getHref());
            o.setName(this.getLobbyName());
            o.setElement("ref");
            o.setIs(this.getType().toString());
            o.write(out, false);
        }
        catch (Exception x) {
            throw new WrapperException((Throwable)x);
        }
    }

    public void encodeLobbyChild(ObixEncoder out, Context cx) {
        try {
            Obj o = new Obj();
            o.setHref(out.getHref());
            o.setName(this.getLobbyName());
            o.setElement("ref");
            o.setIs(this.getType().toString());
            o.write(out, false);
        }
        catch (Exception x) {
            throw new WrapperException((Throwable)x);
        }
    }

    public String getLobbyName() {
        return "photoID";
    }

    public void invoke(ObixDecoder in, ObixEncoder out) {
        try {
            XElem elem = in.getDocument();
            obix.Obj packet = EntsecObixUtil.getObj(elem);
            String hostName = ((Str)packet.get("hostName")).get();
            String key = ((Str)packet.get("key")).get();
            int port = (int)((Int)packet.get("port")).get();
            String sType = ((Str)packet.get("type")).get();
            Type type = BTypeSpec.make((String)sType).getResolvedType();
            BPhotoIDLobbyAgent.logCommunication(hostName, key, port, type);
            obix.Obj requestObject = packet.get("data");
            requestObject = requestObject.list()[0];
            BPhotoIDNetwork network = (BPhotoIDNetwork)Sys.getService((Type)BPhotoIDNetwork.TYPE);
            BIPhotoIDClientDevice[] devices = (BIPhotoIDClientDevice[])network.getChildren(BIPhotoIDClientDevice.class);
            for (int i = 0; i < devices.length; ++i) {
                if (!devices[i].getKey().equals(key) || !devices[i].getType().is(type)) continue;
                devices[i].invoke(hostName, requestObject, out);
                return;
            }
            BComponent c = new BComponent();
            c.add("commandUri", (BValue)BString.DEFAULT);
            c.add("commandData", (BValue)new BComponent());
            out.encodeFully(OrdTarget.unmounted((BObject)c));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public OrdTarget resolve(String uri, Context cx) {
        BOrd o = this.getSlotPathOrd();
        return o.resolve((BObject)Sys.getStation(), cx);
    }

    public static BPhotoIDDeviceLeaf[] discoverDevices() {
        Array a = new Array(BPhotoIDDeviceLeaf.class);
        for (DiscoveryLeaf leaf : discovered.values()) {
            if (leaf.lastComm.delta(BAbsTime.now()).getMillis() >= EntsecObixUtil.STALE_TIME.getMillis()) continue;
            BPhotoIDDeviceLeaf deviceLeaf = (BPhotoIDDeviceLeaf)Sys.getRegistry().getAgents(leaf.type.getTypeInfo()).filter(AgentFilter.is((Type)BPhotoIDDeviceLeaf.TYPE)).getDefault().getInstance();
            deviceLeaf.initFromDiscovery(leaf.hostName, leaf.key, leaf.port);
            a.add((Object)deviceLeaf);
        }
        return (BPhotoIDDeviceLeaf[])a.trim();
    }

    public static void logCommunication(String hostName, String key, int port, Type type) {
        BEnterpriseSecurityService.LOG.fine("PhotoID Lobby Com:" + hostName);
        discovered.put(key, new DiscoveryLeaf(hostName, key, port, type));
    }

    public static class DiscoveryLeaf {
        public String hostName;
        public String key;
        public int port;
        public Type type;
        public BAbsTime lastComm = BAbsTime.now();

        public DiscoveryLeaf(String hostName, String key, int port, Type type) {
            this.key = key;
            this.hostName = hostName;
            this.port = port;
            this.type = type;
        }
    }
}

