/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.photoID.crop;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.file.BFileChannel;
import com.tridium.fox.sys.file.BFoxFileSpace;
import com.tridiumx.entsec.photoID.crop.BImageCropPane;
import com.tridiumx.entsec.photoID.crop.BPaperRatio;
import com.tridiumx.entsec.photoID.crop.BPaperRatioEnum;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.gx.BImage;
import javax.baja.gx.BTransform;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BDropDown;
import javax.baja.ui.BFrame;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BCanvasPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.BWbShell;

@NiagaraType
@NiagaraAction(name="ratioChanged")
public class BImageCropDialog
extends BDialog {
    public static final Action ratioChanged = BImageCropDialog.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BImageCropDialog.class);
    protected BImageCropPane imageCropPane;
    protected BImage original;
    protected BTextDropDown dropDown;

    public void ratioChanged() {
        this.invoke(ratioChanged, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doRatioChanged(Context cx) throws Exception {
        try {
            String text = this.dropDown.getText();
            BPaperRatio savedRatio = (BPaperRatio)BPaperRatio.DEFAULT.decodeFromString(text);
            this.imageCropPane.setPaperRatio(savedRatio);
            this.imageCropPane.initRatio();
            this.imageCropPane.getCropArea().relayout();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static BImageCropDialog dialog(BWidget parent, BImage image, BPaperRatio paperRatio) {
        BImageCropDialog picker = new BImageCropDialog(parent, image, paperRatio);
        picker.setResizable(false);
        picker.setBoundsCenteredOnOwner();
        picker.setScreenSizeToPreferredSize();
        picker.open();
        return picker;
    }

    public BImageCropDialog(BWidget owner, BImage original) {
        this(owner, original, BPaperRatio.DEFAULT);
    }

    public BImageCropDialog(BWidget owner, BImage original, BPaperRatio paperRatio) {
        super(owner, "", true);
        BWbShell wbShell;
        BFoxSession foxSession;
        this.original = original;
        original.sync();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        double screenWidth = dim.getWidth();
        double screenHeight = dim.getHeight();
        double dialogWidth = screenWidth * 0.66;
        double dialogHeight = screenHeight * 0.66;
        double imageWidth = original.getWidth();
        double imageHeight = original.getHeight();
        double ratioWidth = dialogWidth / imageWidth;
        double ratioHeight = dialogHeight / imageHeight;
        if (ratioWidth > 1.0 || ratioWidth > 1.0) {
            ratioWidth = 1.0;
            ratioHeight = 1.0;
        } else if (ratioWidth < ratioHeight) {
            ratioHeight = ratioWidth;
        } else if (ratioWidth > ratioHeight) {
            ratioWidth = ratioHeight;
        }
        BImage scaled = original.transform(BTransform.makeScale((double)ratioWidth, (double)ratioHeight));
        scaled.sync();
        BWidgetShell shell = owner.getShell();
        BWbShell wwbShell = BWbShell.getWbShell((BWidget)owner);
        if (wwbShell != null) {
            shell = wwbShell;
        }
        BFileSystem fileSpace = BFileSystem.INSTANCE;
        if (shell instanceof BWbShell && (foxSession = (BFoxSession)(wbShell = (BWbShell)shell).getActiveView().getCurrentValueSession()) != null) {
            fileSpace = new BFoxFileSpace((BFileChannel)foxSession.getConnection().getChannels().get("file", BFileChannel.TYPE));
        }
        this.imageCropPane = new BImageCropPane(shell, (BFileSpace)fileSpace);
        this.imageCropPane.setPaperRatio(paperRatio);
        this.imageCropPane.initImage(original, scaled, scaled.getWidth(), scaled.getHeight());
        BGridPane gridPane = new BGridPane(10);
        BTextDropDown dropDown = this.makeTextDropDown(paperRatio);
        this.linkTo("lk0", (BComponent)dropDown, (Slot)BDropDown.valueModified, (Slot)ratioChanged);
        gridPane.add(null, (BValue)dropDown);
        gridPane.add(null, (BValue)new BButton((Command)new SaveCommand((BWidget)this)));
        BEdgePane edgePane = new BEdgePane();
        BCanvasPane canvasPane = new BCanvasPane();
        canvasPane.setViewSize(this.imageCropPane.getViewSize());
        canvasPane.add(null, (BValue)this.imageCropPane);
        edgePane.setCenter((BWidget)canvasPane);
        edgePane.setBottom((BWidget)gridPane);
        this.setContent((BWidget)edgePane);
    }

    public BImageCropPane getImageCropPane() {
        return this.imageCropPane;
    }

    public BTextDropDown makeTextDropDown(BPaperRatio paperRatio) {
        this.dropDown = new BTextDropDown();
        BList list = this.dropDown.getList();
        boolean found = false;
        for (int i = 0; i < BPaperRatio.defaults.length; ++i) {
            String encoded = BPaperRatio.defaults[i].encodeToString();
            list.addItem((Object)encoded);
            if (!encoded.equals(paperRatio.encodeToString())) continue;
            found = true;
        }
        if (!found) {
            list.addItem((Object)paperRatio.encodeToString());
        }
        this.dropDown.setText(paperRatio.encodeToString());
        return this.dropDown;
    }

    public void windowClosing(BWindowEvent event) {
        try {
            this.getImageCropPane().save();
            super.windowClosing(event);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            BFrame f = new BFrame();
            BImage image = BImage.make((BOrd)BOrd.make((String)"local:|file:/D:/frozen.jpg"));
            BPaperRatio paperRatio = BPaperRatio.DEFAULT;
            paperRatio.setUnits(BPaperRatioEnum.ratio);
            BImageCropDialog.dialog((BWidget)f, image, paperRatio);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    protected class SaveCommand
    extends Command {
        public SaveCommand(BWidget owner) {
            super(owner, UiLexicon.bajaui().module, "commands.save");
        }

        public CommandArtifact doInvoke() throws Exception {
            if (BImageCropDialog.this.getImageCropPane().save() == 1) {
                BImageCropDialog.this.close();
            }
            return null;
        }
    }
}

