/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.photoID;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionSession;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.photoID.BPhotoIDDeviceLeaf;
import com.tridiumx.entsec.photoID.BPhotoIDDeviceLearnJob;
import com.tridiumx.entsec.photoID.BPhotoIDNetwork;
import com.tridiumx.entsec.photoID.BPhotoIDPrintInfo;
import com.tridiumx.entsec.photoID.BPhotoIDTemplate;
import com.tridiumx.entsec.photoID.BPhotoIDTemplateData;
import com.tridiumx.entsec.photoID.BPhotoIDTemplateLearnJob;
import com.tridiumx.entsec.photoID.BPhotoIDTemplateNamesLearnJob;
import com.tridiumx.entsec.photoID.asureID.WakeupClientListener;
import com.tridiumx.entsec.photoID.orion.BBadgeTemplate;
import com.tridiumx.entsec.photoID.orion.BPhotoIDTemplateRec;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.driver.BDevice;
import javax.baja.license.LicenseException;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperty(name="templates", type="BFolder", defaultValue="new BFolder()")
@NiagaraActions(value={@NiagaraAction(name="captureImage", returnType="BOrd", flags=16), @NiagaraAction(name="print", parameterType="BPhotoIDPrintInfo", defaultValue="new BPhotoIDPrintInfo()", flags=16), @NiagaraAction(name="submitTemplateNamesDiscoveryJob", returnType="BOrd", flags=4), @NiagaraAction(name="submitTemplateDiscoveryJob", parameterType="BString", defaultValue="BString.DEFAULT", returnType="BOrd", flags=4)})
public abstract class BPhotoIDDevice
extends BDevice {
    public static final Property templates = BPhotoIDDevice.newProperty((int)0, (BValue)new BFolder(), null);
    public static final Action captureImage = BPhotoIDDevice.newAction((int)16, null);
    public static final Action print = BPhotoIDDevice.newAction((int)16, (BValue)new BPhotoIDPrintInfo(), null);
    public static final Action submitTemplateNamesDiscoveryJob = BPhotoIDDevice.newAction((int)4, null);
    public static final Action submitTemplateDiscoveryJob = BPhotoIDDevice.newAction((int)4, (BValue)BString.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BPhotoIDDevice.class);
    private WakeupClientListener wakeupListener = null;
    BPhotoIDNetwork network;
    private static final Logger log = Logger.getLogger("entsec.PhotoIDDevice");

    public BFolder getTemplates() {
        return (BFolder)this.get(templates);
    }

    public void setTemplates(BFolder v) {
        this.set(templates, (BValue)v, null);
    }

    public BOrd captureImage() {
        return (BOrd)this.invoke(captureImage, null, null);
    }

    public void print(BPhotoIDPrintInfo parameter) {
        this.invoke(print, (BValue)parameter, null);
    }

    public BOrd submitTemplateNamesDiscoveryJob() {
        return (BOrd)this.invoke(submitTemplateNamesDiscoveryJob, null, null);
    }

    public BOrd submitTemplateDiscoveryJob(BString parameter) {
        return (BOrd)this.invoke(submitTemplateDiscoveryJob, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getNetworkType() {
        return BPhotoIDNetwork.TYPE;
    }

    public abstract BOrd doCaptureImage() throws Exception;

    public abstract void doPrint(BPhotoIDPrintInfo var1) throws Exception;

    public abstract String[] discoverTemplateNames() throws Exception;

    public abstract BPhotoIDTemplate discoverTemplate(String var1) throws Exception;

    public abstract BPhotoIDDeviceLeaf[] discoverDevices();

    public abstract String getLicenseAttribute();

    public IFuture post(Action action, BValue argument, Context cx) {
        if (action.equals(ping)) {
            return super.post(action, argument, cx);
        }
        new Thread((Runnable)new Invocation((BComponent)this, action, argument, cx)).start();
        return null;
    }

    public IFuture postPing() {
        new Thread((Runnable)new Invocation((BComponent)this, ping, null, null)).start();
        return null;
    }

    public BOrd doSubmitTemplateNamesDiscoveryJob() throws Exception {
        if (this.getStatus().isDisabled()) {
            throw new Exception("Cannot Discover if PhotoIDDevice is {disabled}");
        }
        BPhotoIDTemplateNamesLearnJob job = new BPhotoIDTemplateNamesLearnJob(this);
        return job.submit(null);
    }

    public BOrd doSubmitTemplateDiscoveryJob(BString name) throws Exception {
        if (this.getStatus().isDisabled()) {
            throw new Exception("Cannot Discover if PhotoIDDevice is {disabled}");
        }
        BPhotoIDTemplateLearnJob job = new BPhotoIDTemplateLearnJob(this, name);
        return job.submit(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BPhotoIDTemplate getTemplateForBadge(BRef badgeRef) throws Exception {
        BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        OrionSession session = null;
        try {
            session = service.createSession(null);
            BBadge badge = (BBadge)badgeRef.getTarget(session);
            BBadgeTemplate badgeTemplate = new BBadgeTemplate();
            badgeTemplate.setBadge(BRef.make((BIOrionObject)badge));
            badgeTemplate = (BBadgeTemplate)session.read((BIOrionObject)badgeTemplate);
            if (badgeTemplate == null) {
                throw new IllegalStateException("No Template Found for Badge");
            }
            BPhotoIDTemplateRec templateRec = (BPhotoIDTemplateRec)badgeTemplate.getTemplate().getTarget(session);
            BPhotoIDTemplate original = (BPhotoIDTemplate)templateRec.getMappedOrd().get();
            BPhotoIDTemplate template = (BPhotoIDTemplate)original.newCopy();
            template.add("niagaraTemplateName", (BValue)BString.make((String)original.getName()));
            BPhotoIDTemplateData[] templateData = (BPhotoIDTemplateData[])template.getChildren(BPhotoIDTemplateData.class);
            for (int i = 0; i < templateData.length; ++i) {
                BOrd ord = templateData[i].getDataBinding();
                try {
                    BValue value = (BValue)ord.get((BObject)badge);
                    if (templateData[i].isPhotoData()) {
                        BBlob bytesBlob = (BBlob)value;
                        byte[] bytes = bytesBlob.copyBytes();
                        templateData[i].setDataValue((BValue)BString.make((String)ByteArrayUtil.toHexString((byte[])bytes)));
                        continue;
                    }
                    if (value == null) continue;
                    templateData[i].setDataValue(value);
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Cannot resolve DataBinding for " + ord);
                    e.printStackTrace();
                }
            }
            BPhotoIDTemplate bPhotoIDTemplate = template;
            return bPhotoIDTemplate;
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    public void photoIDStarted() throws Exception {
    }

    public final void started() throws Exception {
        if (this.getParent().getType().equals(BPhotoIDDeviceLearnJob.TYPE)) {
            return;
        }
        try {
            Sys.getLicenseManager().checkFeature("tridium", "secPhotoId");
            this.fwStarted();
            this.getPhotoIDNetwork();
            this.photoIDStarted();
        }
        catch (LicenseException fnle) {
            this.configFatal(fnle.toString());
        }
        super.started();
    }

    public final BPhotoIDNetwork getPhotoIDNetwork() {
        if (this.network != null) {
            return this.network;
        }
        if (!this.isRunning()) {
            throw new NotRunningException();
        }
        throw new LicenseException("Exceeded license limit");
    }

    public final void replace(BPhotoIDDevice newDevice) {
        newDevice.network = this.network;
        this.network = null;
    }

    private void fwStarted() {
        BComplex parent;
        if (this.network != null) {
            return;
        }
        BPhotoIDNetwork n = null;
        for (parent = this.getParent(); !(parent instanceof BPhotoIDNetwork) && parent != null; parent = parent.getParent()) {
        }
        n = (BPhotoIDNetwork)parent;
        if (this.getLicenseAttribute() == null) {
            this.network = n;
            return;
        }
        Object licenseFault = n.fw(501, this.getLicenseAttribute(), null, null, null);
        if (licenseFault != null) {
            this.configFatal("Over license limit");
            return;
        }
        this.network = n;
    }

    public void registerWakeupListener(WakeupClientListener listener) {
        if (listener != null) {
            log.log(Level.FINE, "Set lock applied called");
        }
        this.wakeupListener = listener;
    }

    public WakeupClientListener getWakeupListener() {
        return this.wakeupListener;
    }
}

