/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.orionTools.ui;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.BRef;
import com.tridium.orion.BTypeDependency;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.PropertyValue;
import com.tridiumx.entsec.orionTools.BIBackgroundAssociation;
import com.tridiumx.entsec.orionTools.BIOrdMappable;
import com.tridiumx.entsec.orionTools.BISummaryImage;
import com.tridiumx.entsec.orionTools.EntsecTenantUtil;
import com.tridiumx.entsec.orionTools.ui.BOrionRefSummary;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.BTransform;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"orion:OrionObject"}, requiredPermissions="r")})
@NiagaraAction(name="refChanged")
public class BOrionSummary
extends BWbView {
    public static final Action refChanged = BOrionSummary.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BOrionSummary.class);
    public final BIcon ICON = BIcon.std((String)"propertySheet.png");

    public void refChanged() {
        this.invoke(refChanged, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLoadValue(BObject value, Context cx) {
        BOrionObject o = (BOrionObject)value;
        OrionSession session = null;
        try {
            session = o.getOrionDatabase().createSession(cx);
            OrionType orionType = o.getOrionType();
            BGridPane grid = new BGridPane(1);
            grid.setValign(BValign.top);
            grid.setStretchColumn(0);
            BImage image = null;
            if (o instanceof BISummaryImage) {
                image = ((BISummaryImage)o).getSummaryImage(session);
            }
            if (image != null && !image.equals((Object)BImage.DEFAULT)) {
                image.sync();
                if (image.getHeight() > 200.0) {
                    double ratio = 200.0 / image.getHeight();
                    image = image.transform(BTransform.makeScale((double)ratio, (double)ratio));
                }
                BEdgePane leftPane = new BEdgePane();
                leftPane.setTop(this.makeHeader(o, session));
                leftPane.setBottom(this.makeSummaryProperties(o, session));
                BEdgePane centerPane = new BEdgePane();
                centerPane.setCenter((BWidget)new BLabel(image));
                centerPane.setLeft((BWidget)leftPane);
                grid.add(null, (BValue)centerPane);
            } else {
                grid.add(null, (BValue)this.makeHeader(o, session));
                grid.add(null, (BValue)this.makeSummaryProperties(o, session));
            }
            grid.add(null, (BValue)this.makeReferences(o, session));
            this.setContent((BWidget)grid);
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    public BWidget makeHeader(BOrionObject o, OrionSession session) {
        BGridPane grid = new BGridPane(1);
        grid.setStretchColumn(0);
        BLabel header = new BLabel();
        header.setFont(BFont.make((String)"bold 18pt null"));
        header.setText(o.toDisplayString(this.getCurrentContext()));
        header.setImage(BImage.make((BIcon)o.getIcon()).transform(BTransform.makeTranslate((double)0.0, (double)40.0)));
        grid.add(null, (BValue)header);
        return new BBorderPane((BWidget)grid, BInsets.make((double)10.0));
    }

    public BWidget makeSummaryProperties(BOrionObject o, OrionSession session) {
        BOrionDatabase db = o.getOrionDatabase();
        BGridPane grid = new BGridPane(2);
        grid.setStretchColumn(1);
        Property[] props = o.getPropertiesArray();
        if (o instanceof BIOrdMappable) {
            BLabel mapLabel = new BLabel();
            mapLabel.setImage(BImage.make((BIcon)BIcon.std((String)"hyperlink.png")));
            String mapText = Lexicon.make(((Object)((Object)this)).getClass()).get("orion.mappedOrd") + ":  ";
            mapLabel.setText(mapText);
            grid.add(null, (BValue)mapLabel);
            BOrd hyperlink = ((BIOrdMappable)o).getMappedOrd();
            grid.add(null, (BValue)this.getHyperLinkButton(hyperlink, hyperlink.toString(), null, (BWidget)this));
        }
        BLabel typeLabel = new BLabel();
        typeLabel.setImage(BImage.make((BIcon)BIcon.std((String)"shapes/squareBlue.png")));
        String typeText = Lexicon.make(((Object)((Object)this)).getClass()).get("orion.type") + ":  ";
        typeLabel.setText(typeText);
        grid.add(null, (BValue)typeLabel);
        grid.add(null, (BValue)new BLabel(o.getOrionType().getDisplayName(this.getCurrentContext())));
        for (int i = 0; i < props.length; ++i) {
            if (!Flags.isSummary((BComplex)o, (Slot)props[i])) continue;
            BLabel label = new BLabel();
            if (props[i].getType().is(BRef.TYPE)) {
                BRef ref = (BRef)props[i].getDefaultValue();
                label.setImage(BImage.make((BIcon)ref.getTargetTypeSpec().getInstance().getIcon()));
            } else {
                label.setImage(BImage.make((BIcon)props[i].getType().getTypeSpec().getTypeInfo().getIcon(this.getCurrentContext())));
            }
            String text = props[i].getDefaultDisplayName(this.getCurrentContext()) + ":  ";
            label.setText(text);
            grid.add(null, (BValue)label);
            if (props[i].getType().is(BRef.TYPE)) {
                BRef ref = (BRef)o.get(props[i]);
                if (ref.isBound()) {
                    grid.add(null, (BValue)this.getHyperLinkButton((BOrionObject)ref.getTarget(session), null, (BWidget)this));
                    continue;
                }
                grid.add(null, (BValue)new BLabel(""));
                continue;
            }
            BLabel valueLabel = new BLabel();
            valueLabel.setText(" " + o.get(props[i]).toString());
            grid.add(null, (BValue)valueLabel);
        }
        if (o instanceof BIOrdMappable) {
            try {
                BObject m = ((BIOrdMappable)o).getMappedOrd().get(this.getCurrentValue());
                if (m instanceof BComponent) {
                    BComponent mapped = (BComponent)m;
                    props = mapped.getPropertiesArray();
                    for (int i = 0; i < props.length; ++i) {
                        if (!Flags.isSummary((BComplex)mapped, (Slot)props[i]) || o.getOrionType().getProperty(props[i].getName()) != null) continue;
                        BLabel label = new BLabel();
                        BLabel valueLabel = new BLabel();
                        label.setImage(BImage.make((BIcon)props[i].getType().getTypeSpec().getTypeInfo().getIcon(this.getCurrentContext())));
                        String text = props[i].getDefaultDisplayName(this.getCurrentContext()) + ":  ";
                        label.setText(text);
                        BLabel valueSLabel = new BLabel();
                        valueSLabel.setText(" " + mapped.get(props[i]).toString((Context)mapped.getSlotFacets((Slot)props[i])));
                        grid.add(null, (BValue)label);
                        grid.add(null, (BValue)valueSLabel);
                    }
                }
            }
            catch (UnresolvedException unresolvedException) {
                // empty catch block
            }
        }
        return new BBorderPane((BWidget)grid, BInsets.make((double)10.0, (double)10.0, (double)10.0, (double)20.0));
    }

    public BWidget makeReferences(BOrionObject o, OrionSession session) {
        OrionType oOrionType = o.getOrionType();
        BOrionDatabase db = o.getOrionDatabase();
        BTypeDependency[] refTypes = db.getDependentTypes(oOrionType);
        if (refTypes.length == 0) {
            return new BLabel("");
        }
        BGridPane grid = new BGridPane(refTypes.length);
        grid.setRowAlign(BValign.top);
        for (int i = 0; i < refTypes.length; ++i) {
            String displayName = "";
            BOrionTypeId fromId = refTypes[i].getFromTypeId();
            OrionType orionType = db.getType(fromId);
            BGridPane subGrid = new BGridPane(1);
            if (orionType.is(BIBackgroundAssociation.TYPE)) continue;
            if (orionType.isAssociation()) {
                Property fromProp = orionType.getProperty(refTypes[i].getFromProperty());
                Property[] props = orionType.getProperties();
                for (int j = 0; j < props.length; ++j) {
                    OrionType refOrionType;
                    if (props[j].equals(fromProp) || !props[j].getType().is(BRef.TYPE) || (refOrionType = db.getType(((BRef)props[j].getDefaultValue()).getTargetOrionTypeId())).is(BIBackgroundAssociation.TYPE)) continue;
                    Lexicon lex = Lexicon.make((Class)refOrionType.getTypeClass());
                    String labelText = lex.get(oOrionType.getTypeName() + ".to." + orionType.getTypeName() + ".to." + refOrionType.getTypeName());
                    if (labelText == null) {
                        labelText = lex.get(refOrionType.getTypeName() + ".displayName.plural", refOrionType.getDisplayName(null) + "s");
                    }
                    BLabel label = new BLabel(labelText);
                    label.setFont(BFont.make((String)"underline 12pt null"));
                    BGridPane edit = new BGridPane(2);
                    edit.add(null, (BValue)label);
                    subGrid.add(null, (BValue)edit);
                    int count = EntsecTenantUtil.getCount(orionType, orionType.getProperty(refTypes[i].getFromProperty()), (BSimple)BRef.make((BIOrionObject)o), session);
                    if (count > 6) {
                        BOrionRefSummary refSummary = new BOrionRefSummary(refOrionType.getOrionTypeId());
                        refSummary.loadValue((BObject)o);
                        subGrid.add(null, (BValue)refSummary);
                    } else if (count > 0) {
                        BIOrionObject[] matches = session.select(orionType, new PropertyValue(orionType.getProperty(refTypes[i].getFromProperty()), (BValue)BRef.make((BIOrionObject)o))).toArray();
                        for (int k = 0; k < matches.length; ++k) {
                            BRef ref = (BRef)matches[k].get(props[j]);
                            subGrid.add(null, (BValue)this.getHyperLinkButton((BOrionObject)ref.getTarget(session), (BWidget)this));
                        }
                    }
                    if (count <= 0) continue;
                    grid.add(null, (BValue)new BBorderPane((BWidget)subGrid, BInsets.make((double)10.0)));
                }
                continue;
            }
            Lexicon lex = Lexicon.make((Class)orionType.getTypeClass());
            BLabel label = new BLabel(lex.get(orionType.getTypeName() + ".displayName.plural", orionType.getDisplayName(null) + "s"));
            label.setFont(BFont.make((String)"underline 12pt null"));
            BGridPane edit = new BGridPane(2);
            edit.add(null, (BValue)label);
            Property refProp = orionType.getProperty(refTypes[i].getFromProperty());
            subGrid.add(null, (BValue)edit);
            int count = EntsecTenantUtil.getCount(orionType, orionType.getProperty(refTypes[i].getFromProperty()), (BSimple)BRef.make((BIOrionObject)o), session);
            if (count > 6) {
                BOrionRefSummary refSummary = new BOrionRefSummary(orionType.getOrionTypeId());
                refSummary.loadValue((BObject)o);
                subGrid.add(null, (BValue)refSummary);
            } else if (count > 0) {
                BIOrionObject[] matches = session.select(orionType, new PropertyValue(refProp, (BValue)BRef.make((BIOrionObject)o))).toArray();
                for (int j = 0; j < matches.length; ++j) {
                    subGrid.add(null, (BValue)this.getHyperLinkButton((BOrionObject)matches[j], (BWidget)this));
                }
            }
            if (count <= 0) continue;
            grid.add(null, (BValue)new BBorderPane((BWidget)subGrid, BInsets.make((double)10.0)));
        }
        return grid;
    }

    public void doRefChanged() {
        this.loadValue(this.getCurrentValue(), this.getCurrentContext());
    }

    public BWidget getHyperLinkButton(BOrionObject o, BWidget owner) {
        BButton b = new BButton((Command)new HyperlinkCommand(o, owner));
        b.setButtonStyle(BButtonStyle.toolBar);
        return b;
    }

    public BWidget getHyperLinkButton(BOrionObject o, BImage image, BWidget owner) {
        BButton b = new BButton((Command)new HyperlinkCommand(o, image, owner));
        b.setButtonStyle(BButtonStyle.toolBar);
        return b;
    }

    public BWidget getHyperLinkButton(BOrd ord, String s, BIcon icon, BWidget owner) {
        BButton b = new BButton((Command)new HyperlinkCommand(ord, s, icon, owner));
        b.setButtonStyle(BButtonStyle.toolBar);
        b.setEnabled(false);
        return b;
    }

    public BIcon getIcon() {
        return this.ICON;
    }

    private class HyperlinkCommand
    extends Command {
        private BOrd ord;
        private BOrionObject o;

        public HyperlinkCommand(BOrd ord, String s, BIcon icon, BWidget owner) {
            super(owner, s, BImage.make((BIcon)icon), null, "hyperlink");
            this.ord = ord;
        }

        public HyperlinkCommand(BOrionObject o, BWidget owner) {
            this(o, BImage.make((BIcon)o.getIcon()), owner);
        }

        public HyperlinkCommand(BOrionObject o, BImage image, BWidget owner) {
            super(owner, o.toDisplayString(null), image, null, "hyperlink");
            this.ord = BOrd.make((String)(o.getOrdInSession() + "|view:entsec:OrionSummary"));
            this.o = o;
        }

        public CommandArtifact doInvoke() {
            try {
                if (this.getShell() instanceof BWbShell) {
                    ((BWbShell)this.getShell()).hyperlink(this.ord);
                } else if (this.getShell() instanceof BDialog && this.o != null) {
                    BOrionSummary orionSummary = new BOrionSummary();
                    orionSummary.setReadonly(true);
                    orionSummary.loadValue((BObject)this.o, null);
                    BDialog dialog = (BDialog)this.getShell();
                    BOrionSummary.this.getParent().set(BOrionSummary.this.getPropertyInParent(), (BValue)orionSummary);
                    dialog.setBoundsCenteredOnOwner();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }
}

