/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.orionTools.ui;

import com.tridium.orion.BOrionObject;
import com.tridium.orion.priv.ui.BDynamicTableView;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.CommandBindings;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraTopics;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.TableController;

@NiagaraType
@NiagaraTopics(value={@NiagaraTopic(name="assign", eventType="BOrionObject"), @NiagaraTopic(name="summary", eventType="BOrionObject")})
public class BDynamicTableJoinView
extends BDynamicTableView {
    public static final Topic assign = BDynamicTableJoinView.newTopic((int)0, null);
    public static final Topic summary = BDynamicTableJoinView.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BDynamicTableJoinView.class);
    protected Command summaryCommand;
    protected Command assignCommand;

    public void fireAssign(BOrionObject event) {
        this.fire(assign, (BValue)event, null);
    }

    public void fireSummary(BOrionObject event) {
        this.fire(summary, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doLoadValue(BObject o, Context cx) throws Exception {
        super.doLoadValue(o, cx);
        this.table.setController((TableController)new JoinResultController());
    }

    public CommandBindings makeCommandBindings() {
        CommandBindings result = new CommandBindings();
        this.assignCommand = new AssignCommand();
        result.addCommand(this.assignCommand, BCommandEnablePolicy.anySelection);
        this.summaryCommand = new SummaryCommand();
        result.addCommand(this.summaryCommand, BCommandEnablePolicy.singleSelection);
        return result;
    }

    public Command[] getButtonCommands() {
        this.filter = new BDynamicTableView.FilterCommand((BDynamicTableView)this);
        return new Command[]{this.assignCommand, this.summaryCommand, this.filter};
    }

    protected class SummaryCommand
    extends Command {
        public SummaryCommand() {
            super((BWidget)BDynamicTableJoinView.this, TYPE.getModule(), "command.summary");
        }

        public CommandArtifact doInvoke() {
            try {
                int[] selection = BDynamicTableJoinView.this.table.getSelection().getRows();
                if (selection.length == 1) {
                    BDynamicTableView.ResultModel model = (BDynamicTableView.ResultModel)BDynamicTableJoinView.this.table.getModel();
                    BOrionObject editObj = (BOrionObject)model.getResolvedSubject(selection[0]);
                    BDynamicTableJoinView.this.fireSummary(editObj);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    protected class AssignCommand
    extends Command {
        public AssignCommand() {
            super((BWidget)BDynamicTableJoinView.this, TYPE.getModule(), "command.assign");
        }

        public CommandArtifact doInvoke() {
            try {
                BDynamicTableView.ResultModel model = (BDynamicTableView.ResultModel)BDynamicTableJoinView.this.table.getModel();
                int[] selection = BDynamicTableJoinView.this.table.getSelection().getRows();
                for (int i = 0; i < selection.length; ++i) {
                    BOrionObject editObj = (BOrionObject)model.getResolvedSubject(selection[i]);
                    BDynamicTableJoinView.this.fireAssign(editObj);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public class JoinResultController
    extends BDynamicTableView.ResultController {
        public JoinResultController() {
            super((BDynamicTableView)BDynamicTableJoinView.this);
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            try {
                BDynamicTableJoinView.this.assignCommand.invoke();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

