/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.orionTools.replicate;

import com.tridium.nd.BNiagaraStation;
import com.tridiumx.entsec.orionTools.replicate.BReplicationService;
import com.tridiumx.entsec.orionTools.replicate.ReplicationManager;
import com.tridiumx.entsec.securityUtil.BSafeSimpleJob;
import java.util.logging.Level;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;

public class ReplicationStationRunner
implements Runnable {
    private static final BFacets noMillis = BFacets.make((String)"showMilliseconds", (boolean)false);
    private boolean missingSubordinate = false;
    private BSafeSimpleJob job;
    BNiagaraStation station;
    BAbsTime begin;
    ReplicationManager mgr;
    BReplicationService rs;
    private BAbsTime leastTimestamp;
    private boolean succeeded;

    public ReplicationStationRunner(BSafeSimpleJob job, BNiagaraStation station, BAbsTime begin, ReplicationManager mgr, BAbsTime leastTimestamp, boolean succeeded, BReplicationService rs) {
        this.job = job;
        this.station = station;
        this.begin = begin;
        this.mgr = mgr;
        this.leastTimestamp = leastTimestamp;
        this.succeeded = succeeded;
        this.rs = rs;
    }

    @Override
    public void run() {
        try {
            BAbsTime result = this.mgr.replicateStation(this.station, false);
            if (result == null) {
                this.succeeded = false;
            }
            if (this.leastTimestamp == null || this.leastTimestamp.compareTo((Object)result) > 0) {
                this.leastTimestamp = result;
            }
        }
        catch (Exception e) {
            this.succeeded = false;
            e.printStackTrace();
            String msg = "Failed replicating station " + this.station.getStationName() + ": " + e.getMessage();
            this.logError(msg, e);
            this.rs.generateFailureAlarm(msg);
        }
    }

    private void logError(String msg, Exception e) {
        if (this.job != null) {
            this.job.log().failed(msg, (Throwable)e);
        }
        BReplicationService.LOG.log(Level.SEVERE, msg, e);
    }

    public BAbsTime getLeastTimestamp() {
        return this.leastTimestamp;
    }

    public boolean isSucceeded() {
        return this.succeeded;
    }
}

