/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.orionTools.replicate;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BOrionScheme;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.annotations.NiagaraOrionType;
import com.tridiumx.entsec.orionTools.BIOrdMappable;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import com.tridiumx.entsec.orionTools.replicate.BDeletion;
import com.tridiumx.entsec.orionTools.replicate.BReplicationService;
import com.tridiumx.entsec.orionTools.replicate.Replicator;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraOrionType
@NiagaraProperty(name="lastModified", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=2053, facets={@Facet(name="INDEXED", value="true")})
public abstract class BReplicableObject
extends BOrionObject {
    public static final Property lastModified = BReplicableObject.newProperty((int)2053, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"indexed", (boolean)true));
    public static final Type TYPE = Sys.loadType(BReplicableObject.class);
    public static final OrionType ORION_TYPE = (OrionType)TYPE;
    public static String ALLOW_UI_NULL = "allowUiNull";

    public BAbsTime getLastModified() {
        return (BAbsTime)this.get(lastModified);
    }

    public void setLastModified(BAbsTime v) {
        this.set(lastModified, (BValue)v, null);
    }

    public Type getType() {
        return this.getTypeFromSpace(TYPE);
    }

    public boolean beforeInsert(OrionSession session) {
        this.setLastModified(BAbsTime.now());
        return true;
    }

    public boolean beforeUpdate(OrionSession session) {
        this.setLastModified(BAbsTime.now());
        return true;
    }

    public boolean beforeDelete(OrionSession session) {
        this.createDeletionRecord(session);
        return true;
    }

    public void afterInsert(OrionSession session) {
        if (this.changesShouldReplicate()) {
            this.getReplicationService().schedule(BBoolean.make((boolean)false));
        }
    }

    public void afterUpdate(OrionSession session) {
        if (this.changesShouldReplicate()) {
            this.getReplicationService().schedule(BBoolean.make((boolean)false));
        }
    }

    public void afterDelete(OrionSession session) {
        if (this.changesShouldReplicate()) {
            this.getReplicationService().schedule(BBoolean.make((boolean)false));
        }
    }

    protected final boolean changesShouldReplicate() {
        if (RemoteUtil.isStandalone()) {
            return false;
        }
        if (this instanceof BIOrdMappable) {
            return true;
        }
        return RemoteUtil.isSupervisor() || RemoteUtil.isIndependentSupervisor();
    }

    protected final void createDeletionRecord(OrionSession session) {
        boolean replicating = session.getFacets().getb(Replicator.REPLICATING, false);
        if (!replicating && !RemoteUtil.isStandalone()) {
            session.insert((BIOrionObject)new BDeletion(this.getOrionType().getTypeSpec(), BOrionScheme.encodeKeysToString((BIOrionObject)this)));
        }
    }

    protected final BReplicationService getReplicationService() {
        return (BReplicationService)Sys.getService((Type)BReplicationService.TYPE);
    }

    public boolean isAuditable() {
        return true;
    }
}

