/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.orionTools.history;

import com.tridium.history.collection.ColumnSpec;
import com.tridiumx.entsec.orionTools.history.BSecHistoryRecord;
import com.tridiumx.entsec.orionTools.history.SecHistoryInput;
import java.io.DataInput;
import java.io.IOException;
import javax.baja.history.BHistoryRecord;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Type;

public class SecRecordInput
extends SecHistoryInput {
    private BHistoryRecord rec;
    private boolean uniqueRecs = false;
    private BFacets tableFacets;
    private ColumnSpec[] specs;

    public SecRecordInput(DataInput in) {
        super(in);
    }

    public void setUniqueRecords(boolean unique) {
        this.uniqueRecs = unique;
    }

    public BFacets getTableFacets() {
        return this.tableFacets;
    }

    public ColumnSpec[] getColumnSpecs() {
        return this.specs;
    }

    @Override
    public void doReadHeader(DataInput in) throws IOException {
        this.tableFacets = (BFacets)BFacets.DEFAULT.decode(in);
        if (!in.readBoolean()) {
            return;
        }
        int columnCount = in.readInt();
        this.specs = new ColumnSpec[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            this.specs[i] = ColumnSpec.read((DataInput)in);
        }
    }

    @Override
    public BObject doRead(DataInput in, Context cx) throws IOException {
        BHistoryRecord rec = this.newRecord();
        if (rec instanceof BSecHistoryRecord) {
            return ((BSecHistoryRecord)rec).read(in, cx);
        }
        return rec.read(in);
    }

    private BHistoryRecord newRecord() throws IOException {
        if (this.rec == null) {
            Type recType = this.getObjectType();
            this.rec = (BHistoryRecord)recType.getInstance();
        }
        if (this.uniqueRecs) {
            return (BHistoryRecord)this.rec.newCopy(true);
        }
        return this.rec;
    }
}

