/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.orionTools.history;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public abstract class SecHistoryInput {
    public static final int MARKER1 = 96;
    public static final int MARKER2 = 13;
    private Type type;
    private DataInput in;
    private boolean headerRead = false;

    public SecHistoryInput(DataInput in) {
        this.in = in;
    }

    public Type getObjectType() throws IOException {
        if (!this.headerRead) {
            this.readHeader();
        }
        return this.type;
    }

    public void close() {
        if (this.in instanceof InputStream) {
            try {
                ((InputStream)((Object)this.in)).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final BObject read(Context cx) throws IOException {
        if (!this.headerRead) {
            this.readHeader();
        }
        if (this.in.readBoolean()) {
            BObject o = this.doRead(this.in, cx);
            if (this.in.readByte() != 96) {
                this.corrupt();
            }
            if (this.in.readByte() != 13) {
                this.corrupt();
            }
            return o;
        }
        return null;
    }

    private void readHeader() throws IOException {
        if (this.headerRead) {
            return;
        }
        String specTxt = this.in.readUTF();
        BTypeSpec typeSpec = (BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(specTxt);
        this.type = typeSpec.getResolvedType();
        this.doReadHeader(this.in);
        this.headerRead = true;
    }

    protected void doReadHeader(DataInput in) throws IOException {
    }

    protected abstract BObject doRead(DataInput var1, Context var2) throws IOException;

    private void corrupt() throws IOException {
        if (this.in instanceof InputStream) {
            try {
                ((InputStream)((Object)this.in)).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new IOException("Stream corrupted.");
    }
}

