/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.orionTools.history;

import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.history.BNiagaraHistoryDeviceExt;
import com.tridiumx.entsec.orionTools.history.BOrionHistoryChannel;
import com.tridiumx.entsec.orionTools.history.BOrionHistoryRecord;
import javax.baja.collection.AbstractCursor;
import javax.baja.data.BIDataValue;
import javax.baja.driver.history.BHistoryExport;
import javax.baja.history.BHistoryEvent;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.HistoryEventListener;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="executeOnAppend", type="boolean", defaultValue="false"), @NiagaraProperty(name="minExecuteTime", type="BRelTime", defaultValue="BRelTime.make(5000L)", facets={@Facet(value="BFacets.make(BFacets.MIN,BRelTime.make(0))")})})
public class BOrionNiagaraHistoryExport
extends BHistoryExport
implements BFoxClientConnection.Interest,
HistoryEventListener {
    public static final Property executeOnAppend = BOrionNiagaraHistoryExport.newProperty((int)0, (boolean)false, null);
    public static final Property minExecuteTime = BOrionNiagaraHistoryExport.newProperty((int)0, (BValue)BRelTime.make((long)5000L), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)0L)));
    public static final Type TYPE = Sys.loadType(BOrionNiagaraHistoryExport.class);
    BHistoryId id = null;
    long lastLocalUpdateTicks = -1L;
    Clock.Ticket ticket = null;
    Object lock = new Object();

    public boolean getExecuteOnAppend() {
        return this.getBoolean(executeOnAppend);
    }

    public void setExecuteOnAppend(boolean v) {
        this.setBoolean(executeOnAppend, v, null);
    }

    public BRelTime getMinExecuteTime() {
        return (BRelTime)this.get(minExecuteTime);
    }

    public void setMinExecuteTime(BRelTime v) {
        this.set(minExecuteTime, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFuture post(Action action, BValue arg, Context cx) {
        if (action == execute) {
            long minWrite = this.getMinExecuteTime().getMillis();
            Object object = this.lock;
            synchronized (object) {
                long now = Clock.ticks();
                long elapsedTicks = now - this.lastLocalUpdateTicks;
                if (minWrite > 0L && this.lastLocalUpdateTicks > 0L && elapsedTicks < minWrite) {
                    long waitTime = minWrite - elapsedTicks;
                    if (waitTime < 100L) {
                        waitTime = 100L;
                    }
                    if (this.ticket == null) {
                        this.ticket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)waitTime), (Action)execute, null);
                    }
                    return null;
                }
                this.lastLocalUpdateTicks = Clock.ticks();
                if (this.ticket != null) {
                    this.ticket.cancel();
                }
                this.ticket = null;
            }
        }
        return super.post(action, arg, cx);
    }

    protected IFuture postExecute(Action action, BValue arg, Context cx) {
        BNiagaraStation station = (BNiagaraStation)this.getDevice();
        if (station != null) {
            station.getWorker().postAsync((Runnable)new Invocation((BComponent)this, action, arg, cx));
        }
        return null;
    }

    public boolean isUnoperational() {
        return this.isFatalFault() || this.isDisabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExecute() {
        this.executeInProgress();
        BNiagaraHistoryDeviceExt devicelet = null;
        try {
            devicelet = (BNiagaraHistoryDeviceExt)this.getDeviceExt();
            devicelet.getClientConnection().engageNoRetry((BFoxClientConnection.Interest)this);
        }
        catch (Exception e) {
            this.executeFail(e);
            if (devicelet != null && devicelet.getClientConnection().isEngaged((BFoxClientConnection.Interest)this)) {
                devicelet.getClientConnection().disengage((BFoxClientConnection.Interest)this);
            }
            Object object = this.lock;
            synchronized (object) {
                this.lastLocalUpdateTicks = -1L;
            }
            return;
        }
        try {
            if (this.getHistoryId().isNull()) {
                this.executeFail();
                Object e = this.lock;
                synchronized (e) {
                    this.lastLocalUpdateTicks = -1L;
                }
                return;
            }
            BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            BHistoryDatabase db = service.getDatabase();
            if (db == null) {
                this.executeFail();
                Object object = this.lock;
                synchronized (object) {
                    this.lastLocalUpdateTicks = -1L;
                }
                return;
            }
            BOrionHistoryChannel channel = BOrionNiagaraHistoryExport.channel(devicelet);
            BHistoryId id = this.getHistoryId().fromShorthand(Sys.getStation().getStationName());
            try (HistoryDatabaseConnection conn = db.getDbConnection(null);){
                BIHistory history = conn.getHistory(id);
                BAbsTime startTime = null;
                BOrionHistoryRecord[] previouslyExported = null;
                try {
                    previouslyExported = channel.getLastExports(id, history.getRecordType());
                    if (previouslyExported != null && previouslyExported.length > 0) {
                        startTime = previouslyExported[0].getTimestamp();
                    }
                }
                catch (Exception e) {
                    startTime = channel.getLastTimestamp(id, history.getRecordType());
                }
                if (startTime != null && !startTime.isNull()) {
                    startTime = startTime.add(BRelTime.make((long)1L));
                }
                Object c = conn.timeQuery(history, startTime, null).cursor();
                if (previouslyExported != null && previouslyExported.length > 0) {
                    c = new OrionHistoryExportCursor((Cursor<?>)c, previouslyExported);
                }
                channel.consolidate(id, (Cursor<?>)c);
                this.executeOk();
            }
        }
        catch (Exception e) {
            this.executeFail(e);
            Object object = this.lock;
            synchronized (object) {
                this.lastLocalUpdateTicks = -1L;
            }
        }
        finally {
            devicelet.getClientConnection().disengage((BFoxClientConnection.Interest)this);
        }
    }

    static BOrionHistoryChannel channel(BNiagaraHistoryDeviceExt devicelet) {
        BFoxChannelRegistry chanReg = ((BNiagaraStation)devicelet.getParent()).getClientConnection().getChannels();
        return (BOrionHistoryChannel)chanReg.get("orionHistory", BOrionHistoryChannel.TYPE);
    }

    public void started() {
        this.id = this.getHistoryId().fromShorthand(Sys.getStation().getStationName());
        this.updateHistoryEventRegistration(this.getExecuteOnAppend());
        if (this.getExecuteOnAppend()) {
            Clock.schedule((BComponent)this, (BRelTime)BRelTime.makeSeconds((int)15), (Action)execute, null);
        }
    }

    public void stationStarted() throws Exception {
        super.started();
        this.updateHistoryEventRegistration(this.getExecuteOnAppend());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopped() throws Exception {
        this.updateHistoryEventRegistration(false);
        Object object = this.lock;
        synchronized (object) {
            this.lastLocalUpdateTicks = -1L;
            if (this.ticket != null) {
                this.ticket.cancel();
            }
            this.ticket = null;
        }
        super.stopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == executeOnAppend) {
            this.updateHistoryEventRegistration(this.getExecuteOnAppend());
        } else if (property == historyId) {
            this.id = this.getHistoryId().fromShorthand(Sys.getStation().getStationName());
        } else if (property == minExecuteTime) {
            Object object = this.lock;
            synchronized (object) {
                if (this.ticket != null) {
                    this.ticket.cancel();
                    this.ticket = null;
                    this.execute();
                }
            }
        }
    }

    private void updateHistoryEventRegistration(boolean register) {
        try {
            BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            BHistoryDatabase db = service.getDatabase();
            if (register) {
                db.addHistoryEventListener((HistoryEventListener)this);
            } else {
                db.removeHistoryEventListener((HistoryEventListener)this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void historyEvent(BHistoryEvent event) {
        if (this.getExecuteOnAppend() && event.getId() == 2 && this.id.equals((Object)event.getHistoryId())) {
            this.execute();
        }
    }

    static class OrionHistoryExportCursor
    extends AbstractCursor<Object> {
        Cursor<?> cursor;
        BOrionHistoryRecord[] excludeList;
        int len;
        BAbsTime timestamp;

        OrionHistoryExportCursor(Cursor<?> cursor, BOrionHistoryRecord[] excludeList) {
            this.cursor = cursor;
            this.excludeList = excludeList;
            this.len = excludeList.length;
            this.timestamp = excludeList[0].getTimestamp();
        }

        public Context getContext() {
            return this.cursor.getContext();
        }

        public boolean nextComponent() {
            while (this.cursor.next()) {
                BHistoryRecord rec = (BHistoryRecord)this.cursor.get();
                if (this.isMatch(rec)) continue;
                return true;
            }
            return false;
        }

        public boolean next(Class<?> cls) {
            while (this.cursor.next()) {
                BHistoryRecord rec = (BHistoryRecord)this.cursor.get();
                if (this.isMatch(rec)) continue;
                return true;
            }
            return false;
        }

        public boolean advanceCursor() {
            return this.next(null);
        }

        protected BObject doGet() {
            return (BObject)this.cursor.get();
        }

        boolean isMatch(BHistoryRecord rec) {
            if (!this.timestamp.equals((Object)rec.getTimestamp())) {
                return false;
            }
            Property[] props = rec.getFrozenPropertiesArray();
            int propLen = props.length;
            for (int j = 0; j < this.len; ++j) {
                boolean match = true;
                for (int i = 0; i < propLen; ++i) {
                    String str;
                    int width;
                    BValue hRecVal = rec.get(props[i]);
                    Property slot = this.excludeList[j].getProperty(props[i].getName());
                    BValue oRecVal = this.excludeList[j].get(slot);
                    if (hRecVal instanceof BString && (width = this.excludeList[j].getSlotFacets((Slot)slot).geti("width", -1)) >= 0 && (str = ((BString)hRecVal).getString()) != null && str.length() > width) {
                        str = TextUtil.truncate((String)str, (int)width);
                        hRecVal = BString.make((String)str);
                    }
                    if (hRecVal.equals((Object)oRecVal)) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                return true;
            }
            return false;
        }
    }
}

