/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.orionTools.history;

import com.tridium.orion.BOrionObject;
import com.tridium.orion.OrionType;
import com.tridium.orion.annotations.NiagaraOrionType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.agent.BIAgent;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraOrionType
@NiagaraProperties(value={@NiagaraProperty(name="id", type="int", defaultValue="0", flags=4, facets={@Facet(value="ID_KEY")}), @NiagaraProperty(name="timestamp", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=8, facets={@Facet(name="INDEXED", value="true"), @Facet(name="BFacets.SHOW_SECONDS", value="true")}), @NiagaraProperty(name="stationName", type="String", defaultValue="", flags=8, facets={@Facet(name="INDEXED", value="true"), @Facet(name="WIDTH", value="128")}), @NiagaraProperty(name="historyName", type="String", defaultValue="", facets={@Facet(name="INDEXED", value="true"), @Facet(name="WIDTH", value="BHistoryId.MAX_NAME_LENGTH")})})
public abstract class BOrionHistoryRecord
extends BOrionObject
implements BIAgent,
Externalizable {
    private static final long serialVersionUID = 1L;
    public static final Property id = BOrionHistoryRecord.newProperty((int)4, (int)0, (BFacets)ID_KEY);
    public static final Property timestamp = BOrionHistoryRecord.newProperty((int)8, (BValue)BAbsTime.DEFAULT, (BFacets)BFacets.make((BFacets)BFacets.make((String)"indexed", (boolean)true), (BFacets)BFacets.make((String)"showSeconds", (boolean)true)));
    public static final Property stationName = BOrionHistoryRecord.newProperty((int)8, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"indexed", (boolean)true), (BFacets)BFacets.make((String)"width", (int)128)));
    public static final Property historyName = BOrionHistoryRecord.newProperty((int)0, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"indexed", (boolean)true), (BFacets)BFacets.make((String)"width", (int)200)));
    public static final Type TYPE = Sys.loadType(BOrionHistoryRecord.class);
    public static final OrionType ORION_TYPE = (OrionType)TYPE;
    private static final HashMap<Type, Type> cache = new HashMap();
    private static final AgentFilter filter = AgentFilter.is((Type)TYPE);

    public int getId() {
        return this.getInt(id);
    }

    public void setId(int v) {
        this.setInt(id, v, null);
    }

    public BAbsTime getTimestamp() {
        return (BAbsTime)this.get(timestamp);
    }

    public void setTimestamp(BAbsTime v) {
        this.set(timestamp, (BValue)v, null);
    }

    public String getStationName() {
        return this.getString(stationName);
    }

    public void setStationName(String v) {
        this.setString(stationName, v, null);
    }

    public String getHistoryName() {
        return this.getString(historyName);
    }

    public void setHistoryName(String v) {
        this.setString(historyName, v, null);
    }

    public Type getType() {
        return this.getTypeFromSpace(TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BOrionHistoryRecord make(BHistoryId id, BHistoryRecord rec) {
        if (rec == null) {
            return null;
        }
        Type recType = rec.getType();
        BOrionHistoryRecord orionRec = null;
        Type orionRecType = null;
        if (cache.containsKey(recType)) {
            orionRecType = cache.get(recType);
            if (orionRecType != null) {
                orionRec = (BOrionHistoryRecord)orionRecType.getInstance();
            }
        } else {
            AgentList agentList = rec.getAgents().filter(filter);
            if (agentList.size() == 1) {
                orionRec = (BOrionHistoryRecord)agentList.get(0).getInstance();
                orionRecType = orionRec.getType();
            }
            HashMap<Type, Type> hashMap = cache;
            synchronized (hashMap) {
                cache.put(recType, orionRecType);
            }
        }
        if (orionRec != null) {
            if (id != null) {
                orionRec.setRecordPropertyValue(stationName, (BValue)BString.make((String)id.getDeviceName()), null);
                orionRec.setRecordPropertyValue(historyName, (BValue)BString.make((String)id.getHistoryName()), null);
            }
            orionRec.mapFrom(rec);
        }
        return orionRec;
    }

    public Property timestampProperty() {
        return timestamp;
    }

    public void mapFrom(BHistoryRecord rec) {
        Property[] props = rec.getFrozenPropertiesArray();
        for (int i = 0; i < props.length; ++i) {
            this.setRecordPropertyValue(props[i].getName(), rec.get(props[i]), null);
        }
    }

    public void setRecordPropertyValue(String propName, BValue value, Context cx) {
        this.setRecordPropertyValue(this.getProperty(propName), value, cx);
    }

    public void setRecordPropertyValue(Property prop, BValue value, Context cx) {
        String str;
        int width;
        if (value instanceof BString && (width = this.getSlotFacets((Slot)prop).geti("width", -1)) >= 0 && (str = ((BString)value).getString()) != null && str.length() > width) {
            str = TextUtil.truncate((String)str, (int)width);
            this.set(prop, (BValue)BString.make((String)str), cx);
            return;
        }
        this.set(prop, value, cx);
    }

    public String toString(Context cx) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getStationName()).append("/");
        sb.append(this.getHistoryName()).append(" ");
        return this.getTimestamp().toString(cx);
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException {
        this.read(in);
    }

    public final BOrionHistoryRecord read(DataInput in) throws IOException {
        this.setId(in.readInt());
        this.setTimestamp((BAbsTime)BAbsTime.DEFAULT.decode(in));
        this.setStationName(in.readUTF());
        this.setHistoryName(in.readUTF());
        this.doRead(in);
        return this;
    }

    protected abstract void doRead(DataInput var1) throws IOException;

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        this.write(out);
    }

    public final BOrionHistoryRecord write(DataOutput out) throws IOException {
        out.writeInt(this.getId());
        this.getTimestamp().encode(out);
        out.writeUTF(this.getStationName());
        out.writeUTF(this.getHistoryName());
        this.doWrite(out);
        return this;
    }

    protected abstract void doWrite(DataOutput var1) throws IOException;
}

