/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.orionTools.history;

import com.tridium.bql.util.BDynamicTimeRangeType;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.dt.BDynamicTable;
import com.tridium.orion.priv.dt.BDynamicTableColumn;
import com.tridium.orion.priv.dt.BDynamicTableColumnsProvider;
import com.tridiumx.entsec.filter.BBadgeStringFilter;
import com.tridiumx.entsec.filter.BPersonStringFilter;
import com.tridiumx.entsec.filter.BReaderStringFilter;
import com.tridiumx.entsec.filter.BRefStringFilter;
import com.tridiumx.entsec.filter.BSecAbsTimeFilter;
import com.tridiumx.entsec.filter.BStationStringFilter;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"entsec:OrionHistoryRecord"})})
public class BOrionHistoryColumnsProvider
extends BDynamicTableColumnsProvider {
    public static final Type TYPE = Sys.loadType(BOrionHistoryColumnsProvider.class);

    public Type getType() {
        return TYPE;
    }

    public int getDefaultSortColumnIndex(BDynamicTable dt, Context cx) {
        BDynamicTableColumn[] columns = dt.getWorkingColumns(cx);
        for (int i = 0; i < columns.length; ++i) {
            BDynamicTableColumn column = columns[i];
            if (column.getHiddenKey()) continue;
            OrionType orionType = (OrionType)column.getFromType().getTypeSpec().getResolvedType();
            Property p = orionType.getProperty(column.getFromProperty());
            BObject obj = orionType.getInstance();
            if (obj.isComplex() && Flags.isHidden((BComplex)((BComplex)obj), (Slot)p) || !p.getType().equals(BAbsTime.TYPE)) continue;
            return i;
        }
        return -1;
    }

    public BValue getDefaultFilter(BDynamicTable dt, BDynamicTableColumn column) {
        OrionType orionType = (OrionType)column.getFromType().getTypeSpec().getResolvedType();
        Property p = orionType.getProperty(column.getFromProperty());
        BObject obj = orionType.getInstance();
        if (obj.isComplex() && Flags.isHidden((BComplex)((BComplex)obj), (Slot)p)) {
            return null;
        }
        if (p.getType().equals(BAbsTime.TYPE)) {
            BSecAbsTimeFilter filter = new BSecAbsTimeFilter();
            filter.setTimeRangeType(BDynamicTimeRangeType.today);
            return filter;
        }
        if (p.getName().equals("stationName")) {
            return new BStationStringFilter();
        }
        if (p.getName().equals("owner")) {
            return new BPersonStringFilter();
        }
        if (p.getName().equals("badge")) {
            return new BBadgeStringFilter();
        }
        if (p.getName().equals("reader")) {
            return new BReaderStringFilter();
        }
        return null;
    }

    public BDynamicTableColumn[] getDefaultColumns(BDynamicTable dt) {
        BDynamicTableColumn[] columns = super.getDefaultColumns(dt);
        for (int i = 0; i < columns.length; ++i) {
            if (!(columns[i].getDefaultFilter() instanceof BStationStringFilter) && !(columns[i].getDefaultFilter() instanceof BRefStringFilter)) continue;
            columns[i].setFlags((Slot)BDynamicTableColumn.defaultFilter, columns[i].getFlags((Slot)BDynamicTableColumn.defaultFilter) | 0x10000000);
        }
        return columns;
    }
}

