/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.orionTools;

import com.tridium.orion.OrionType;
import com.tridium.orion.annotations.NiagaraOrionType;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.nav.BAbstractScheduleRec;
import com.tridiumx.entsec.orionTools.BIOrdMappable;
import com.tridiumx.entsec.orionTools.BMappedScheduleExt;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.schedule.BControlSchedule;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"schedule:BooleanSchedule"})})
@NiagaraOrionType
@NiagaraProperties(value={@NiagaraProperty(name="scheduleUsage", type="String", defaultValue="", flags=8, facets={@Facet(name="WIDTH", value="64"), @Facet(name="BFacets.ALLOW_NULL", value="true")}), @NiagaraProperty(name="trueText", type="String", defaultValue="", facets={@Facet(name="WIDTH", value="64"), @Facet(name="BFacets.ALLOW_NULL", value="true")}), @NiagaraProperty(name="falseText", type="String", defaultValue="", facets={@Facet(name="WIDTH", value="64"), @Facet(name="BFacets.ALLOW_NULL", value="true")})})
public class BScheduleRec
extends BAbstractScheduleRec
implements BIOrdMappable {
    public static final Property scheduleUsage = BScheduleRec.newProperty((int)8, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"width", (int)64), (BFacets)BFacets.make((String)"allowNull", (boolean)true)));
    public static final Property trueText = BScheduleRec.newProperty((int)0, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"width", (int)64), (BFacets)BFacets.make((String)"allowNull", (boolean)true)));
    public static final Property falseText = BScheduleRec.newProperty((int)0, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"width", (int)64), (BFacets)BFacets.make((String)"allowNull", (boolean)true)));
    public static final Type TYPE = Sys.loadType(BScheduleRec.class);
    public static final OrionType ORION_TYPE = (OrionType)TYPE;
    public static final String USAGE = "usage";

    public String getScheduleUsage() {
        return this.getString(scheduleUsage);
    }

    public void setScheduleUsage(String v) {
        this.setString(scheduleUsage, v, null);
    }

    public String getTrueText() {
        return this.getString(trueText);
    }

    public void setTrueText(String v) {
        this.setString(trueText, v, null);
    }

    public String getFalseText() {
        return this.getString(falseText);
    }

    public void setFalseText(String v) {
        this.setString(falseText, v, null);
    }

    @Override
    public Type getType() {
        return this.getTypeFromSpace(TYPE);
    }

    @Override
    protected void insertInCache() {
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        service.getDbCache().insertScheduleRec(this);
    }

    @Override
    protected void updateCache() {
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        service.getDbCache().updateScheduleRec(this);
    }

    @Override
    protected void deleteFromCache() {
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        service.getDbCache().deleteScheduleRec(this);
    }

    @Override
    public void mapFrom(BObject source) {
        super.mapFrom(source);
        BBooleanSchedule schedule = (BBooleanSchedule)source;
        this.setScheduleUsage(schedule.getFacets().gets(USAGE, ""));
        this.setTrueText(schedule.getFacets().gets("trueText", "true"));
        this.setFalseText(schedule.getFacets().gets("falseText", "false"));
    }

    @Override
    protected BMappedScheduleExt newMappedExt() {
        return new BMappedScheduleExt();
    }

    @Override
    protected BMappedScheduleExt getMixIn(BControlSchedule schedule) {
        return (BMappedScheduleExt)schedule.getMixIn(BMappedScheduleExt.TYPE);
    }
}

