/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.nav;

import com.tridium.alarm.BConsoleRecipient;
import com.tridium.file.types.text.BNavFile;
import com.tridium.videoDriver.ui.alarm.BVideoAlarmRecipient;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.nav.BEntsecNavContainer;
import com.tridiumx.entsec.nav.EntsecNavQuery;
import java.io.OutputStream;
import java.util.logging.Level;
import javax.baja.alarm.BAlarmService;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFileStore;
import javax.baja.file.BMemoryFileStore;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BTypeSpec;

@NiagaraType(ordScheme="entsecnav")
@NiagaraSingleton
public class BEntsecNavScheme
extends BOrdScheme {
    public static final BEntsecNavScheme INSTANCE = new BEntsecNavScheme();
    public static final Type TYPE = Sys.loadType(BEntsecNavScheme.class);

    public Type getType() {
        return TYPE;
    }

    private BEntsecNavScheme() {
        super("entsecnav");
    }

    public OrdQuery parse(String body) {
        return new EntsecNavQuery(body);
    }

    public OrdTarget resolve(OrdTarget base, OrdQuery query) throws UnresolvedException {
        try {
            BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
            BINavNode navRoot = service.getNavTree(base.getUser()).getRoot();
            EntsecNavQuery navQuery = (EntsecNavQuery)query;
            if (navQuery.isSpecial()) {
                return this.resolveSpecial(base, navQuery);
            }
            String[] path = ((EntsecNavQuery)query).getPath();
            if (path.length == 0) {
                return new OrdTarget(base, (BObject)new BEntsecNavContainer(navRoot));
            }
            BINavNode container = navRoot;
            for (int i = 0; i < path.length; ++i) {
                container = container.resolveNavChild(path[i]);
            }
            return new OrdTarget(base, (BObject)new BEntsecNavContainer(container));
        }
        catch (UnresolvedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new UnresolvedException("Cannot resolve nav path.", (Throwable)ex);
        }
    }

    public OrdTarget resolveSpecial(OrdTarget base, EntsecNavQuery navQuery) {
        String special = navQuery.getSpecial();
        if (special.equals("alarmConsole")) {
            BComponent console;
            BUser user = base.getUser();
            if (user != null) {
                Type alarmOptionsType = BTypeSpec.make((String)"entsec", (String)"SecurityAlarmConsoleOptions").getResolvedType();
                SlotCursor c = user.getProperties();
                while (c.next()) {
                    BComplex options;
                    BOrd defConsole;
                    if (c.get().getType() != alarmOptionsType || (defConsole = (BOrd)(options = (BComplex)c.get()).get("defaultAlarmConsole")).isNull()) continue;
                    BObject target = null;
                    try {
                        target = BOrd.make((String)("station:|" + defConsole)).get();
                    }
                    catch (Exception ex) {
                        BAccessControlService.LOG.log(Level.FINE, "Cannot resolve Default Alarm Console:" + defConsole, ex);
                    }
                    if (!(target instanceof BConsoleRecipient)) continue;
                    return new OrdTarget(base, target);
                }
            }
            BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            SlotCursor consoles = alarmService.getProperties();
            while (consoles.next(BConsoleRecipient.class)) {
                console = (BComponent)consoles.get();
                if (!console.getPermissions((Context)base).hasOperatorRead()) continue;
                return new OrdTarget(base, (BObject)console);
            }
            if (user != null && user.getName().equals("guest") && !user.getEnabled() && (consoles = (alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE)).getProperties()).next(BConsoleRecipient.class)) {
                console = (BComponent)consoles.get();
                return new OrdTarget(base, (BObject)console);
            }
            throw new UnresolvedException(special);
        }
        if (special.startsWith("videoAlarmRecipient") && BEnterpriseSecurityService.isVideoDriverAvailable()) {
            BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            SlotCursor consoles = alarmService.getProperties();
            while (consoles.next(BVideoAlarmRecipient.class)) {
                BComponent console = (BComponent)consoles.get();
                if (!console.getPermissions((Context)base).hasOperatorRead()) continue;
                return new OrdTarget(base, (BObject)console);
            }
            throw new UnresolvedException(special);
        }
        if (special.startsWith("homeNavOrd")) {
            String home = SlotPath.unescape((String)special.substring("homeNavOrd".length()));
            BOrd navOrd = BOrd.make((String)home);
            BMemoryFileStore store = new BMemoryFileStore((BFileSpace)BFileSystem.INSTANCE, new FilePath(SlotPath.escape((String)navOrd.toString())));
            StringBuffer b = new StringBuffer();
            b.append("<?xml version='1.0' encoding='UTF-8'?>\n");
            b.append("<nav version='1.0'>\n");
            b.append("<node name='Home' ord='station:|");
            b.append(navOrd);
            b.append("' icon='module://icons/x16/home.png'/>\n");
            b.append("</nav>\n");
            try (OutputStream outputStream = store.getOutputStream();){
                outputStream.write(b.toString().getBytes());
            }
            catch (Exception e) {
                throw new UnresolvedException(e.getMessage(), (Throwable)e);
            }
            BNavFile navFile = new BNavFile((BIFileStore)store);
            return new OrdTarget(base, (BObject)navFile);
        }
        throw new UnresolvedException(special);
    }
}

