/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.nav;

import com.tridiumx.entsec.nav.BEntsecNav;
import com.tridiumx.entsec.nav.BEntsecNavGroup;
import com.tridiumx.entsec.nav.BEntsecNavLink;
import com.tridiumx.entsec.nav.BEntsecNavScheme;
import com.tridiumx.entsec.nav.EntsecNavQuery;
import java.util.logging.Logger;
import javax.baja.agent.AgentInfo;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BICategorizable;
import javax.baja.naming.BOrd;
import javax.baja.naming.BViewScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.naming.ViewQuery;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavContainer;
import javax.baja.nav.NavEvent;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.web.BIWebProfile;
import javax.baja.web.BWebProfileConfig;

@NiagaraType
public class BEntsecNavNode
extends BNavContainer
implements BIProtected {
    public static final Type TYPE = Sys.loadType(BEntsecNavNode.class);
    private final Logger log = Logger.getLogger("entsec");
    private Lexicon lex = Lexicon.make((String)"entsec");
    private static final BTypeSpec[] NO_CHILD_TYPES = new BTypeSpec[0];
    private static final BIcon defaultIcon = BIcon.std((String)"object.png");
    private BEntsecNav nav;
    private BOrd targetOrd;
    private BIcon navIcon;
    private BINavNode inner;
    private BEntsecNavLink link;
    private int index;
    private boolean temporary = false;
    private boolean dynamic = false;

    public Type getType() {
        return TYPE;
    }

    public static BEntsecNavNode makeFor(BINavNode target) {
        Property p;
        BEntsecNavNode newNode = new BEntsecNavNode(target.getNavName());
        newNode.inner = target;
        if (target instanceof BComplex && (p = ((BComplex)target).getProperty("index")) != null) {
            newNode.index = ((BComplex)target).getInt(p);
        }
        return newNode;
    }

    public static BEntsecNavNode makeFor(BEntsecNav nav, BINavNode target) {
        BEntsecNavNode newNode = new BEntsecNavNode(nav == null ? target.getNavName() : nav.getNavNodeName());
        newNode.nav = nav;
        newNode.inner = target;
        newNode.index = nav.getIndex();
        return newNode;
    }

    public static BEntsecNavNode makeForLink(BEntsecNavLink link) {
        BEntsecNavNode newNode = new BEntsecNavNode(link.getNavName());
        newNode.link = link;
        newNode.index = link.getIndex();
        return newNode;
    }

    public static BEntsecNavNode makeDynamic(BINavNode target) {
        BEntsecNavNode newNode = new BEntsecNavNode(target.getNavName());
        newNode.inner = target;
        newNode.dynamic = true;
        return newNode;
    }

    public static BEntsecNavNode makeTemporary(String name, BOrd targetOrd, BIcon icon) {
        BEntsecNavNode newNode = new BEntsecNavNode(name);
        newNode.targetOrd = targetOrd;
        newNode.navIcon = icon;
        newNode.temporary = true;
        return newNode;
    }

    private BEntsecNavNode(String name) {
        super(name);
    }

    public String getNavName() {
        String result = null;
        if (this.nav != null) {
            result = this.nav.getNavNodeName();
        } else if (this.link != null) {
            result = this.link.getNavName();
        } else if (this.inner != null) {
            result = this.inner.getNavName();
        }
        if (result == null) {
            result = super.getNavName();
        }
        return result;
    }

    public BFormat getDisplayFormat() {
        if (this.nav != null) {
            return this.nav.getNavDisplayFormat();
        }
        if (this.link != null) {
            return this.link.getNavDisplayFormat();
        }
        return BFormat.DEFAULT;
    }

    public String getNavDisplayName(Context cx) {
        BFormat navDisplay = this.getDisplayFormat();
        BINavNode navTarget = null;
        if (this.inner != null) {
            navTarget = this.inner;
        }
        if (this.link != null) {
            try {
                navTarget = this.link.resolveTarget(cx);
            }
            catch (UnresolvedException unresolvedException) {
                // empty catch block
            }
        }
        if (navDisplay != BFormat.DEFAULT) {
            if (navTarget == null) {
                return navDisplay.format((Object)this, cx);
            }
            return navDisplay.format((Object)navTarget, cx);
        }
        if (navTarget == null) {
            return this.getNavName();
        }
        return navTarget.getNavDisplayName(cx);
    }

    public BOrd getNavView() {
        if (this.nav != null) {
            return this.nav.getNavView();
        }
        if (this.link != null) {
            return this.link.getNavView();
        }
        return BOrd.NULL;
    }

    public String getParentPath() {
        Array path = new Array(String.class);
        for (BINavNode parent = this.getNavParent(); parent != null; parent = parent.getNavParent()) {
            if (parent.getNavParent() == null) continue;
            path.add((Object)parent.getNavName());
        }
        path = path.reverse();
        String result = "/" + TextUtil.join((String[])((String[])path.trim()), (char)'/');
        return result;
    }

    public BOrd getNavOrd() {
        BOrd viewOrd;
        BOrd result = null;
        if (this.targetOrd != null) {
            result = this.targetOrd;
        } else if (this.link != null) {
            result = this.link.getTargetOrd();
            viewOrd = this.link.getNavView();
            if (!viewOrd.isNull()) {
                result = BOrd.make((BOrd)result, (BOrd)viewOrd);
            }
        } else {
            result = this.inner != null ? (this.inner instanceof BEntsecNavGroup ? this.getEntsecNavOrd() : this.inner.getNavOrd()) : BOrd.NULL;
        }
        if (this.nav != null && !(viewOrd = this.nav.getNavView()).isNull()) {
            result = BOrd.make((BOrd)result, (BOrd)viewOrd);
        }
        return result;
    }

    public BOrd getEntsecNavOrd() {
        Array reversePath = new Array(String.class);
        reversePath.add((Object)this.getNavName());
        for (BINavNode parent = this.getNavParent(); parent != null && parent.getNavParent() != null; parent = parent.getNavParent()) {
            reversePath.add((Object)parent.getNavName());
        }
        StringBuffer s = new StringBuffer(reversePath.size() * 16);
        s.append("station:|entsecnav:");
        for (int i = reversePath.size() - 1; i >= 0; --i) {
            s.append("/").append((String)reversePath.get(i));
        }
        return BOrd.make((String)s.toString());
    }

    public static BIcon getNavIcon(BINavNode navNode, Context cx) {
        if (navNode instanceof BEntsecNavNode) {
            return ((BEntsecNavNode)navNode).getNavIcon(cx);
        }
        return navNode.getNavIcon();
    }

    public BIcon getNavIcon() {
        throw new UnsupportedOperationException("Context required.");
    }

    public BIcon getNavIcon(Context cx) {
        if (this.navIcon != null) {
            return this.navIcon;
        }
        if (this.nav != null && !this.nav.getIconOverride().equals((Object)BIcon.DEFAULT)) {
            return this.nav.getIconOverride();
        }
        if (this.link != null) {
            BIcon linkIconOverride = this.link.getIconOverride();
            if (!linkIconOverride.equals((Object)BIcon.DEFAULT)) {
                return linkIconOverride;
            }
            BINavNode linkTarget = null;
            try {
                linkTarget = this.link.resolveTarget(cx);
            }
            catch (UnresolvedException unresolvedException) {
                // empty catch block
            }
            if (linkTarget != null) {
                return linkTarget.getNavIcon();
            }
        } else if (this.inner != null) {
            return this.inner.getNavIcon();
        }
        return defaultIcon;
    }

    public int getIndex() {
        return this.index;
    }

    public String getChildTypes() {
        if (this.nav != null) {
            return this.nav.getChildTypes();
        }
        if (this.link != null) {
            return this.link.getChildTypes();
        }
        return "";
    }

    public BTypeSpec[] getChildTypeSpecs() {
        if (this.nav != null) {
            return this.nav.getChildTypeSpecs();
        }
        if (this.link != null) {
            return this.link.getChildTypeSpecs();
        }
        return NO_CHILD_TYPES;
    }

    public BIcon getIconOverride() {
        if (this.nav != null) {
            return BIcon.DEFAULT;
        }
        if (this.link != null) {
            return this.link.getIconOverride();
        }
        return BIcon.DEFAULT;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public boolean isDynamicGroup() {
        return this.nav != null && this.nav.getIsGroup();
    }

    public boolean isNavGroup() {
        return this.isDynamicGroup() || this.inner instanceof BEntsecNavGroup;
    }

    public boolean isSpecial() {
        if (this.link == null) {
            return false;
        }
        BOrd linkOrd = this.link.getTargetOrd();
        OrdQuery[] queries = linkOrd.parse();
        int index = queries.length - 1;
        OrdQuery last = queries[index];
        while (last.getScheme().equals(BViewScheme.INSTANCE.getId())) {
            if (--index < 0) {
                return false;
            }
            last = queries[index];
        }
        if (last.getScheme().equals(BEntsecNavScheme.INSTANCE.getId())) {
            return ((EntsecNavQuery)last).isSpecial();
        }
        return false;
    }

    public BINavNode getWrappedTarget() {
        return this.inner;
    }

    public BEntsecNavLink getLink() {
        return this.link;
    }

    public BEntsecNav getNavHint() {
        return this.nav;
    }

    protected void fireNavEvent(NavEvent event) {
    }

    public boolean include(Context cx) {
        if (this.link == null) {
            return true;
        }
        try {
            BINavNode target = this.link.resolveTarget(cx);
            return target != null;
        }
        catch (UnresolvedException ex) {
            return false;
        }
    }

    public BINavNode getTarget(Context cx) {
        if (this.inner != null) {
            return this.inner;
        }
        if (this.link != null) {
            try {
                return this.link.resolveTarget(cx);
            }
            catch (UnresolvedException ex) {
                return null;
            }
        }
        if (this.targetOrd != null) {
            try {
                BObject target = this.targetOrd.resolve(null, cx).get();
                if (target instanceof BINavNode) {
                    return (BINavNode)target;
                }
            }
            catch (UnresolvedException ex) {
                return null;
            }
        }
        return null;
    }

    public boolean canRead(OrdTarget cx) {
        BINavNode target = this.getTarget((Context)cx);
        if (target == null) {
            return false;
        }
        if (target instanceof BIProtected) {
            return ((BIProtected)target).canRead(cx);
        }
        return true;
    }

    public boolean canWrite(OrdTarget cx) {
        BINavNode target = this.getTarget((Context)cx);
        if (target == null) {
            return false;
        }
        if (target instanceof BIProtected) {
            return ((BIProtected)target).canWrite(cx);
        }
        return true;
    }

    public boolean canInvoke(OrdTarget cx) {
        BINavNode target = this.getTarget((Context)cx);
        if (target == null) {
            return false;
        }
        if (target instanceof BIProtected) {
            return ((BIProtected)target).canInvoke(cx);
        }
        return true;
    }

    public BPermissions getPermissions(Context cx) {
        BComponent component;
        BINavNode target = this.getTarget(cx);
        if (target == null) {
            return BPermissions.none;
        }
        if (target instanceof BComponent && (component = (BComponent)target).getParent() != null && Flags.isHidden((BComplex)component.getParent(), (Slot)component.getPropertyInParent())) {
            return BPermissions.none;
        }
        if (target instanceof BIProtected) {
            BPermissions permissions = ((BIProtected)target).getPermissions(cx);
            OrdQuery[] parsed = this.getNavOrd().parse();
            if (parsed.length > 0 && parsed[parsed.length - 1] instanceof ViewQuery) {
                BWebProfileConfig config;
                ViewQuery viewQuery = (ViewQuery)parsed[parsed.length - 1];
                AgentInfo agentInfo = null;
                String viewId = viewQuery.getViewId();
                try {
                    if (viewId == null) {
                        if (!viewQuery.getParameters().isEmpty()) {
                            return permissions;
                        }
                        this.log.warning(this.lex.getText("entsecNavNode.viewUnavailable.message", new Object[]{viewId}));
                        return BPermissions.none;
                    }
                    agentInfo = BTypeSpec.make((String)viewId).getTypeInfo().getAgentInfo();
                }
                catch (Exception e) {
                    this.log.warning(this.lex.getText("entsecNavNode.viewUnavailable.message", new Object[]{viewId}));
                    return BPermissions.none;
                }
                if (!permissions.has(agentInfo.getRequiredPermissions())) {
                    return BPermissions.none;
                }
                String viewAppName = agentInfo.getAppName();
                if (viewAppName != null && (config = (BWebProfileConfig)cx.getUser().getMixIn(BWebProfileConfig.TYPE)) != null) {
                    BIWebProfile profile = (BIWebProfile)config.make();
                    String[] appNames = profile.getAppNames();
                    for (int i = 0; i < appNames.length; ++i) {
                        if (!appNames[i].equals(viewAppName)) continue;
                        return permissions;
                    }
                    return BPermissions.none;
                }
            }
            return permissions;
        }
        return BPermissions.all;
    }

    public BCategoryMask getCategoryMask() {
        BINavNode target = this.getTarget(null);
        if (target == null) {
            return BCategoryMask.NULL;
        }
        if (target instanceof BICategorizable) {
            return ((BICategorizable)target).getCategoryMask();
        }
        return BCategoryMask.NULL;
    }

    public BCategoryMask getAppliedCategoryMask() {
        BINavNode target = this.getTarget(null);
        if (target == null) {
            return BCategoryMask.NULL;
        }
        if (target instanceof BICategorizable) {
            return ((BICategorizable)target).getAppliedCategoryMask();
        }
        return BCategoryMask.NULL;
    }
}

