/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.nav;

import com.tridiumx.entsec.nav.BIEntsecNavNode;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="targetOrd", type="BOrd", defaultValue="BOrd.NULL"), @NiagaraProperty(name="navDisplayFormat", type="BFormat", defaultValue="BFormat.DEFAULT"), @NiagaraProperty(name="navView", type="BOrd", defaultValue="BOrd.NULL"), @NiagaraProperty(name="parentPath", type="String", defaultValue="/"), @NiagaraProperty(name="childTypes", type="String", defaultValue=""), @NiagaraProperty(name="iconOverride", type="BIcon", defaultValue="BIcon.DEFAULT"), @NiagaraProperty(name="index", type="int", defaultValue="0")})
public class BEntsecNavLink
extends BComponent
implements BIEntsecNavNode {
    public static final Property targetOrd = BEntsecNavLink.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property navDisplayFormat = BEntsecNavLink.newProperty((int)0, (BValue)BFormat.DEFAULT, null);
    public static final Property navView = BEntsecNavLink.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property parentPath = BEntsecNavLink.newProperty((int)0, (String)"/", null);
    public static final Property childTypes = BEntsecNavLink.newProperty((int)0, (String)"", null);
    public static final Property iconOverride = BEntsecNavLink.newProperty((int)0, (BValue)BIcon.DEFAULT, null);
    public static final Property index = BEntsecNavLink.newProperty((int)0, (int)0, null);
    public static final Type TYPE = Sys.loadType(BEntsecNavLink.class);
    private static final BIcon icon = BIcon.std((String)"link.png");
    private Array<BTypeSpec> ctypes = null;
    private String navName;

    public BOrd getTargetOrd() {
        return (BOrd)this.get(targetOrd);
    }

    public void setTargetOrd(BOrd v) {
        this.set(targetOrd, (BValue)v, null);
    }

    public BFormat getNavDisplayFormat() {
        return (BFormat)this.get(navDisplayFormat);
    }

    public void setNavDisplayFormat(BFormat v) {
        this.set(navDisplayFormat, (BValue)v, null);
    }

    public BOrd getNavView() {
        return (BOrd)this.get(navView);
    }

    public void setNavView(BOrd v) {
        this.set(navView, (BValue)v, null);
    }

    public String getParentPath() {
        return this.getString(parentPath);
    }

    public void setParentPath(String v) {
        this.setString(parentPath, v, null);
    }

    public String getChildTypes() {
        return this.getString(childTypes);
    }

    public void setChildTypes(String v) {
        this.setString(childTypes, v, null);
    }

    public BIcon getIconOverride() {
        return (BIcon)this.get(iconOverride);
    }

    public void setIconOverride(BIcon v) {
        this.set(iconOverride, (BValue)v, null);
    }

    public int getIndex() {
        return this.getInt(index);
    }

    public void setIndex(int v) {
        this.setInt(index, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BEntsecNavLink() {
    }

    public BEntsecNavLink(String parentPath, BFormat displayFormat, BOrd targetOrd, String childTypes, BOrd navView, int index) {
        this(parentPath, displayFormat, targetOrd, childTypes, navView, null, index);
    }

    public BEntsecNavLink(String parentPath, BFormat displayFormat, BOrd targetOrd, String childTypes, BOrd navView, BIcon iconOverride, int index) {
        this.setParentPath(parentPath);
        this.setNavDisplayFormat(displayFormat);
        this.setTargetOrd(targetOrd);
        this.setChildTypes(childTypes);
        if (navView != null) {
            this.setNavView(navView);
        }
        if (iconOverride != null) {
            this.setIconOverride(iconOverride);
        }
        this.setIndex(index);
    }

    public String getNavName() {
        if (this.isMounted()) {
            return super.getNavName();
        }
        return this.navName;
    }

    public void setNavName(String navName) {
        this.navName = navName;
    }

    public BINavNode resolveTarget(Context cx) {
        try {
            BOrd targetOrd = this.getTargetOrd();
            if (targetOrd.isNull()) {
                return null;
            }
            if (this.isMounted()) {
                return (BINavNode)targetOrd.get((BObject)this, cx);
            }
            return (BINavNode)targetOrd.get(null, cx);
        }
        catch (UnresolvedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new UnresolvedException("Cannot resolve nav link: " + this.getTargetOrd(), (Throwable)ex);
        }
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (p == childTypes) {
            this.ctypes = null;
        }
    }

    private void parseChildTypes() {
        String childTypes = this.getChildTypes();
        if (childTypes.length() == 0) {
            this.ctypes = new Array(BTypeSpec.class);
        } else {
            this.ctypes = new Array(BTypeSpec.class);
            String[] specs = TextUtil.split((String)childTypes, (char)';');
            for (int i = 0; i < specs.length; ++i) {
                this.ctypes.add((Object)BTypeSpec.make((String)specs[i]));
            }
            this.ctypes.trim();
        }
    }

    public BTypeSpec[] getChildTypeSpecs() {
        if (this.ctypes == null) {
            this.parseChildTypes();
        }
        Array<BTypeSpec> ctypes = this.ctypes;
        BTypeSpec[] specs = new BTypeSpec[ctypes.size()];
        System.arraycopy(ctypes.trim(), 0, specs, 0, ctypes.size());
        return specs;
    }

    public BIcon getIcon() {
        return icon;
    }
}

