/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.ldap.importsteps;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.BSqlQuery;
import com.tridiumx.entsec.access.orion.BAccessRight;
import com.tridiumx.entsec.access.orion.BAccessRightLdapGroupJoin;
import com.tridiumx.entsec.access.orion.BLdapGroup;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.access.orion.BPersonAccJoin;
import com.tridiumx.entsec.ldap.importconfig.BLdapImportConfig;
import com.tridiumx.entsec.ldap.importsteps.LdapImportMakeDatabaseEntry;
import com.tridiumx.entsec.ldap.importutil.AuditLogEntryStatus;
import com.tridiumx.entsec.ldap.importutil.ColumnDetails;
import com.tridiumx.entsec.ldap.importutil.LdapImportLogEntry;
import com.tridiumx.entsec.ldap.importutil.LdapImportUtils;
import com.tridiumx.entsec.ldap.importutil.RecordStatus;
import com.tridiumx.ldapDriver.BLdapAttributeValuePair;
import com.tridiumx.ldapDriver.BLdapGroupValuePair;
import com.tridiumx.ldapDriver.BLdapServer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.baja.query.BExpression;
import javax.baja.query.BQuery;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BVector;
import javax.baja.sys.Property;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;

public class LdapImportMakePersonAccJoinEntry
extends LdapImportMakeDatabaseEntry {
    private BRef accessRightRef = BRef.NULL;
    private BRef personRef = BRef.NULL;

    public LdapImportMakePersonAccJoinEntry(BLdapServer server, Map<String, ColumnDetails> mappingDetails, OrionSession session) {
        super(server, mappingDetails, session);
    }

    @Override
    public boolean execute() {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Entering the step PersonAccJoinStep for user ");
        }
        BPerson person = null;
        person = (BPerson)this.steps[0].getStepData();
        BPersonAccJoin personAccJoin = (BPersonAccJoin)((Object)this.getStepData());
        this.personRef = BRef.make((BTypeSpec)BPerson.ORION_TYPE.getTypeSpec(), (BSimple)person.getPersonId());
        personAccJoin.setPerson(this.personRef);
        Map<String, List<BAccessRight>> ldapGroupsMap = this.getLDAPGroups();
        BVector groupListHolder = this.user.getGroupNameList();
        Object groupName = null;
        HashSet<String> accessRightsAdded = new HashSet<String>();
        if (groupListHolder != null) {
            BLdapGroupValuePair[] groupSlotList = (BLdapGroupValuePair[])groupListHolder.getChildren(BLdapGroupValuePair.class);
            BLdapImportConfig importConfig = (BLdapImportConfig)this.server.getMixIn(BLdapImportConfig.TYPE);
            if (importConfig != null) {
                String accExpAttr = importConfig.getAccountExpiryDateTimeAttribute();
                BLdapAttributeValuePair attrPair = (BLdapAttributeValuePair)this.user.getAttributeList().get(accExpAttr);
                if (attrPair != null) {
                    String expTimeStr = attrPair.getAttrValue();
                    try {
                        BAbsTime endTime = LdapImportUtils.parseLdapDate(expTimeStr);
                        personAccJoin.setEndDate(endTime);
                    }
                    catch (Exception ex) {
                        this.log.log(Level.WARNING, "Invalid LDAP date time format. Skipping end date property ", ex);
                    }
                }
                if (!LdapImportUtils.isLDAPUserStatusActive(this.user, importConfig)) {
                    personAccJoin.setEndDate(BAbsTime.now().subtract(BRelTime.DAY));
                }
            }
            for (int i = 0; i < groupSlotList.length; ++i) {
                ArrayList accessRightList = (ArrayList)ldapGroupsMap.get(groupSlotList[i].getGroupValue());
                if (accessRightList == null) continue;
                for (BAccessRight accessRight : accessRightList) {
                    accessRightsAdded.add(accessRight.getAccessRightName());
                    this.accessRightRef = BRef.make((BTypeSpec)BAccessRight.ORION_TYPE.getTypeSpec(), (BSimple)accessRight.getAccessRightId());
                    personAccJoin.setAccessRight(this.accessRightRef);
                    boolean associated = false;
                    try {
                        associated = this.insertOrionObject(personAccJoin);
                    }
                    catch (Exception ex) {
                        this.log.log(Level.WARNING, "Failed to associate the Access rights " + accessRight.getAccessRightName() + " to the user :" + this.user.getDistinguishedName(), ex);
                    }
                    if (associated) {
                        this.getLogList().add(new LdapImportLogEntry("Associated the Access rights " + accessRight.getAccessRightName() + " to the :" + this.user.getDistinguishedName(), AuditLogEntryStatus.INFO, true));
                        continue;
                    }
                    this.getLogList().add(new LdapImportLogEntry("Failed to associate the Access rights " + accessRight.getAccessRightName() + " to the :" + this.user.getDistinguishedName(), AuditLogEntryStatus.WARNING, true));
                }
                ldapGroupsMap.remove(groupSlotList[i].getGroupValue());
            }
        }
        for (String key : ldapGroupsMap.keySet()) {
            ArrayList accessRightList = (ArrayList)ldapGroupsMap.get(key);
            BAccessRight accessRightToRemove2 = null;
            if (accessRightList == null) continue;
            for (BAccessRight accessRightToRemove2 : accessRightList) {
                if (accessRightsAdded.contains(accessRightToRemove2.getAccessRightName())) continue;
                this.accessRightRef = BRef.make((BTypeSpec)BAccessRight.ORION_TYPE.getTypeSpec(), (BSimple)accessRightToRemove2.getAccessRightId());
                personAccJoin.setPerson(BRef.make((BTypeSpec)BPerson.ORION_TYPE.getTypeSpec(), (BSimple)person.getPersonId()));
                personAccJoin.setAccessRight(BRef.make((BTypeSpec)BAccessRight.ORION_TYPE.getTypeSpec(), (BSimple)accessRightToRemove2.getAccessRightId()));
                RecordStatus recStatus = this.recordExists(personAccJoin);
                if (!recStatus.isExists()) continue;
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Remove Person access rights record ");
                }
                boolean disassociated = false;
                try {
                    disassociated = this.session.delete((BIOrionObject)recStatus.get());
                }
                catch (Exception ex) {
                    this.log.log(Level.WARNING, "Failed to disassociate the Access rights " + accessRightToRemove2.getAccessRightName() + " to the user :" + this.user.getDistinguishedName(), ex);
                }
                if (disassociated) {
                    this.getLogList().add(new LdapImportLogEntry("Disassociated the Access rights " + accessRightToRemove2.getAccessRightName() + " From  :" + this.user.getDistinguishedName(), AuditLogEntryStatus.INFO, true));
                    continue;
                }
                this.getLogList().add(new LdapImportLogEntry("Failed to Disassociated the Access rights " + accessRightToRemove2.getAccessRightName() + " From :" + this.user.getDistinguishedName(), AuditLogEntryStatus.WARNING, true));
            }
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Completed the step PersonAccJoinStep");
        }
        return true;
    }

    @Override
    public OrionType getDataBaseEntryType() {
        return BPersonAccJoin.ORION_TYPE;
    }

    public boolean insertOrionObject(BPersonAccJoin orionObject) {
        boolean isTraceON = this.log.isLoggable(Level.FINE);
        if (isTraceON) {
            this.log.fine("Entering the step LdapImportMakeDatabaseEntry");
        }
        Map<String, ColumnDetails> mappingDetails = this.getLdapEntSecMappingDetails();
        boolean populated = false;
        if (mappingDetails != null && this.user != null && (populated = this.populateOrionObject(mappingDetails))) {
            String type = "";
            try {
                if (orionObject.getType() == BPersonAccJoin.TYPE) {
                    BPersonAccJoin bPersonAccJoin = orionObject;
                }
                type = orionObject.getType().getTypeSpec().encodeToString();
                RecordStatus recStatus = this.recordExists(orionObject);
                orionObject = (BPersonAccJoin)recStatus.get();
                if (recStatus.isExists()) {
                    if (isTraceON) {
                        this.log.fine("Updating record " + type);
                    }
                    this.session.update((BIOrionObject)recStatus.get());
                } else {
                    if (isTraceON) {
                        this.log.fine("Inserting record " + type);
                    }
                    this.session.insert((BIOrionObject)orionObject);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
        }
        if (isTraceON) {
            this.log.fine("Completed the step LdapImportMakeDatabaseEntry");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecordStatus recordExists(BOrionObject obj) {
        boolean recordExists = false;
        BPersonAccJoin join = null;
        if (this.steps.length == 1 && !this.personRef.equals((Object)BRef.NULL) && !this.accessRightRef.equals((Object)BRef.NULL)) {
            try (OrionCursor c = null;){
                BSqlQuery query = BSqlQuery.make((OrionType)BPersonAccJoin.ORION_TYPE);
                BExpression exp1 = Predicates.eq((String)"accessRight", (BSimple)this.accessRightRef);
                BExpression exp2 = Predicates.eq((String)"person", (BSimple)this.personRef);
                query = query.where(Predicates.and((BExpression)exp1, (BExpression)exp2));
                c = this.session.select((BQuery)query);
                if (c.next()) {
                    recordExists = true;
                    join = (BPersonAccJoin)((Object)c.get());
                }
            }
        }
        return new RecordStatus(recordExists && join != null ? join : obj, recordExists);
    }

    @Override
    public Property[] getMandatoryProperties() {
        return new Property[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<BAccessRight>> getLDAPGroups() {
        TreeMap<String, List<BAccessRight>> ldapGroupsMap = new TreeMap<String, List<BAccessRight>>();
        List<BAccessRight> accessRightsList = new ArrayList<BAccessRight>();
        BLdapGroup group = null;
        BAccessRight groupAccessRight = null;
        BSqlQuery query = BSqlQuery.make((OrionType)BLdapGroup.ORION_TYPE);
        BExpression exp = Predicates.eq((String)"ldapServer", (BSimple)this.getLDAPServerReference());
        query = (BSqlQuery)query.where(exp);
        try (OrionCursor cur = null;){
            cur = this.session.select((BQuery)query);
            while (cur.next()) {
                group = (BLdapGroup)((Object)cur.get());
                BLdapGroup.AccessRightsCursor groupAccessRightCursor = group.getAccessRights(this.session);
                while (groupAccessRightCursor.next()) {
                    groupAccessRight = groupAccessRightCursor.getAccessRight();
                    if (ldapGroupsMap.get(group.getGroupName()) == null) {
                        accessRightsList = new ArrayList();
                        accessRightsList.add(groupAccessRight);
                        ldapGroupsMap.put(group.getGroupName(), accessRightsList);
                        continue;
                    }
                    accessRightsList = (List)ldapGroupsMap.get(group.getGroupName());
                    accessRightsList.add(groupAccessRight);
                    ldapGroupsMap.put(group.getGroupName(), accessRightsList);
                }
            }
        }
        return ldapGroupsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BRef getAccessRightRef(BRef grpRef) {
        BRef accessRightRef = BRef.NULL;
        BSqlQuery query = BSqlQuery.make((OrionType)BAccessRightLdapGroupJoin.ORION_TYPE);
        query = (BSqlQuery)query.where(Predicates.eq((String)"ldapGroup", (BSimple)grpRef));
        try (OrionCursor cur = null;){
            cur = this.session.select((BQuery)query);
            if (cur.next()) {
                BAccessRightLdapGroupJoin join = (BAccessRightLdapGroupJoin)((Object)cur.get());
                accessRightRef = join.getAccessRight();
            }
        }
        return accessRightRef;
    }

    private BUuid getLDAPServerReference() {
        return LdapImportUtils.getLDAPServerReference(this.server.getName());
    }
}

