/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.ldap;

import com.tridiumx.accessDriver.enums.activity.BLDAPActivityEnum;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.history.BLDAPAuditRecord;
import com.tridiumx.entsec.access.orion.BBadgeLdapServerJoin;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.access.orion.BPersonLdapServerJoin;
import com.tridiumx.entsec.ldap.BExportLastJobProperties;
import com.tridiumx.entsec.ldap.util.ExportPersonsDataUtility;
import com.tridiumx.entsec.ldap.util.LdapValidationUtil;
import com.tridiumx.entsec.securityUtil.HistoryManager;
import com.tridiumx.ldapDriver.BLdapAttributeValuePair;
import com.tridiumx.ldapDriver.BLdapServer;
import com.tridiumx.ldapDriver.attributes.BDiscoverableClassDef;
import com.tridiumx.ldapDriver.users.BLdapUser;
import com.tridiumx.ldapDriver.users.BLdapUserOperationResponse;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.baja.hx.HxOp;
import javax.baja.job.BJob;
import javax.baja.job.BSimpleJob;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BPassword;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public class BLdapJoinAllJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType(BLdapJoinAllJob.class);
    static Lexicon lex = Lexicon.make(BLdapJoinAllJob.class);
    HxOp op;
    HashMap<String, String> attributesMap;
    Object[] personList;
    BLdapServer selectedLdapServer;
    ArrayList<String> distinguishNames;
    boolean badgeMapped = false;

    public Type getType() {
        return TYPE;
    }

    public BLdapJoinAllJob() {
    }

    public BLdapJoinAllJob(HashMap<String, String> attributesMap, HxOp op, Object[] personList, BLdapServer selectedLdapServer, ArrayList<String> distinguishNames) {
        this.op = op;
        this.attributesMap = attributesMap;
        this.personList = personList;
        this.selectedLdapServer = selectedLdapServer;
        this.distinguishNames = distinguishNames;
    }

    public void run(Context cx) throws Exception {
        Thread thread = Thread.currentThread();
        int jobId = (int)thread.getId();
        BExportLastJobProperties exportStatus = (BExportLastJobProperties)this.selectedLdapServer.getMixIn(BExportLastJobProperties.TYPE);
        exportStatus.setLastAttempt(Clock.time());
        if (!LdapValidationUtil.checkDistinguishNamesExists(this.distinguishNames)) {
            this.log().failed(lex.getText("ldap.noAttributes.Error"), (Throwable)new Exception(lex.getText("ldap.noAttributes.Exception")));
            throw new Exception(lex.getText("ldap.noAttributes.Exception"));
        }
        String mandatoryAttributes = LdapValidationUtil.validateMandatoryAttributes(this.attributesMap, this.selectedLdapServer);
        if (mandatoryAttributes.length() > 0) {
            this.log().failed(lex.getText("ldap.mandatoryAttributes.Error", new Object[]{mandatoryAttributes}), (Throwable)new Exception(lex.getText("ldap.mandatoryAttributes.Exception", new Object[]{mandatoryAttributes})));
            throw new Exception(lex.getText("ldap.mandatoryAttributes.Exception", new Object[]{mandatoryAttributes}));
        }
        this.progress(10);
        ArrayList<BLdapUser> ldapUsers = new ArrayList<BLdapUser>();
        HashMap<String, BPersonLdapServerJoin> personLdapJoinMap = new HashMap<String, BPersonLdapServerJoin>();
        HashMap<String, BBadgeLdapServerJoin> badgeLdapJoinMap = new HashMap<String, BBadgeLdapServerJoin>();
        ArrayList<BLDAPAuditRecord> auditRecords = new ArrayList<BLDAPAuditRecord>();
        try {
            BDiscoverableClassDef[] objectClsList = ExportPersonsDataUtility.getObjectClassList(this.selectedLdapServer);
            for (int i = 0; i < this.personList.length; ++i) {
                BPerson person = (BPerson)this.personList[i];
                BLdapUser user = new BLdapUser();
                BComponent compObjectClass = user.getObjectClassList();
                for (int l = 0; l < objectClsList.length; ++l) {
                    compObjectClass.add(null, (BValue)BLdapAttributeValuePair.make((String)"objectClass", (String)objectClsList[l].getObjectClass()));
                }
                BComponent attrProp = user.getAttributeList();
                String distinguishName = "";
                Set<String> keySet = this.attributesMap.keySet();
                Iterator<String> itr = keySet.iterator();
                String attrName = "";
                String attrValue = "";
                String propValue = "";
                while (itr.hasNext()) {
                    attrName = itr.next();
                    attrValue = this.attributesMap.get(attrName);
                    String attrPropValue = "";
                    if (attrValue.indexOf(";") > 1) {
                        propValue = this.getBadgeAndPersonInfoAttributeValue(person, attrValue);
                        if (propValue.length() > 0) {
                            attrProp.add(attrName, (BValue)BLdapAttributeValuePair.make((String)attrName, (String)propValue));
                        }
                    } else {
                        propValue = person.get(attrValue).toString();
                        if (attrValue.equals("pinNumber")) {
                            propValue = AccessController.doPrivileged(() -> ((BPassword)person.getPinNumber()).getValue());
                        }
                        attrProp.add(attrName, (BValue)BLdapAttributeValuePair.make((String)attrName, (String)propValue));
                    }
                    distinguishName = ExportPersonsDataUtility.getDistinguishName(this.distinguishNames, distinguishName, attrName, propValue);
                }
                user.setDistinguishedName(distinguishName);
                ldapUsers.add(user);
                personLdapJoinMap.put(distinguishName, ExportPersonsDataUtility.makePersonLdapServerJoinEntry(person, this.selectedLdapServer, this.formDistinguishedNameForJoinEntry(distinguishName), jobId));
                BBadgeLdapServerJoin badgeJoin = ExportPersonsDataUtility.makeBadgeLdapServerJoinEntry(person, this.selectedLdapServer, distinguishName, jobId);
                if (this.badgeExists() && badgeJoin != null) {
                    badgeLdapJoinMap.put(distinguishName, badgeJoin);
                }
                auditRecords.add(this.createLDAPAuditEntry(this.selectedLdapServer, user, jobId, cx, true, "Successfully added Person: " + distinguishName));
            }
            BLdapUserOperationResponse[] result = ExportPersonsDataUtility.addUsersToLdapServer(ldapUsers, this.selectedLdapServer);
            int prevMapSize = personLdapJoinMap.size();
            LdapValidationUtil.validatePersonsAddToLdapServer((BJob)this, result, personLdapJoinMap, auditRecords, badgeLdapJoinMap);
            ExportPersonsDataUtility.addSynchedLdapPersonsDetails(personLdapJoinMap);
            ExportPersonsDataUtility.addSynchedLdapBadgeDetails(badgeLdapJoinMap);
            exportStatus.setLastExportJobId("" + jobId);
            this.jobSuccessLdapUsersMessage(prevMapSize, personLdapJoinMap.size());
            exportStatus.setLastFailure(BAbsTime.NULL);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            exportStatus.setLastFailure(Clock.time());
            throw new Exception("Persons not added successfully .... ");
        }
        finally {
            this.attributesMap = null;
            this.personList = null;
            this.makeAuditLogEntries(auditRecords);
        }
    }

    private String formDistinguishedNameForJoinEntry(String distinguishName) {
        return distinguishName + "," + this.selectedLdapServer.getUserSearchBase();
    }

    private String getBadgeAndPersonInfoAttributeValue(BPerson person, String attrValue) {
        String[] mappedAttr = TextUtil.split((String)attrValue, (char)';');
        String propValue = "";
        if (mappedAttr[0].equalsIgnoreCase("PersonInfo")) {
            propValue = ExportPersonsDataUtility.getPersonInfoAttributeValue(person, mappedAttr[1]);
        } else if (mappedAttr[0].equalsIgnoreCase("Badge")) {
            propValue = ExportPersonsDataUtility.getBadgeAttributeValue(person, mappedAttr);
            this.badgeMapped = true;
        }
        return propValue;
    }

    private void jobSuccessLdapUsersMessage(int prevMapSize, int currMapSize) throws Exception {
        if (prevMapSize != currMapSize) {
            if (prevMapSize > currMapSize && currMapSize > 0) {
                this.log().failed("Partially Success as only some Persons are added ...");
                throw new Exception("Partially added Persons ...");
            }
            throw new Exception("Failed to add persons ...");
        }
        this.log().success("All Persons added successfully");
    }

    public void makeAuditLogEntries(List<BLDAPAuditRecord> ldapAuditRecords) {
        BAccessControlService accessControlService = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        HistoryManager historyManager = accessControlService.getHistoryManager();
        for (BLDAPAuditRecord auditRecord : ldapAuditRecords) {
            historyManager.append(auditRecord);
        }
    }

    public BLDAPAuditRecord createLDAPAuditEntry(BLdapServer server, BLdapUser user, int jobId, Context ctx, boolean status, String details) {
        BLDAPAuditRecord ldapAuditRecord = new BLDAPAuditRecord();
        ldapAuditRecord.setTimestamp(BAbsTime.now());
        ldapAuditRecord.setLdapServerOrd(server.getSlotPathOrd());
        ldapAuditRecord.setActivity(BLDAPActivityEnum.exportPersonnel);
        ldapAuditRecord.setActivityId(jobId);
        ldapAuditRecord.setOwner(ctx.getUser().getUsername());
        ldapAuditRecord.setStatus(status ? BLDAPAuditRecord.successText() : BLDAPAuditRecord.failureText());
        ldapAuditRecord.setDetails(details);
        return ldapAuditRecord;
    }

    private boolean badgeExists() {
        return this.badgeMapped;
    }
}

