/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.isom;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BOrionService;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.BJoin;
import com.tridium.orion.sql.BSqlExtent;
import com.tridium.orion.sql.BSqlField;
import com.tridium.orion.sql.BSqlJoin;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.orion.sql.BatchStatement;
import com.tridiumx.entsec.access.orion.BAccessRight;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.access.orion.BPersonInfo;
import com.tridiumx.entsec.access.orion.BWiegandFormat;
import com.tridiumx.entsec.isom.BOrionObjectUtil;
import com.tridiumx.entsec.isom.BOrionObjectsRefMap;
import com.tridiumx.entsec.isom.ICompatibleWithIsom;
import com.tridiumx.entsec.isom.InstantReplicationRequired;
import com.tridiumx.entsec.orionTools.replicate.BReplicableObject;
import com.tridiumx.entsec.orionTools.replicate.BReplicationService;
import com.tridiumx.isom.BISOMConfig;
import com.tridiumx.isom.InvalidInputDataException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.query.BExpression;
import javax.baja.query.BQuery;
import javax.baja.query.util.Predicates;
import javax.baja.sys.Action;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="queryOrionObjects", parameterType="BSqlQuery", defaultValue="new BSqlQuery()", returnType="BVector"), @NiagaraAction(name="createNewOrionObjects", parameterType="BVector", defaultValue="new BVector()", returnType="BVector"), @NiagaraAction(name="deleteOrionObjects", parameterType="BQuery", defaultValue="new BQuery()", returnType="BBoolean"), @NiagaraAction(name="updateOrionObjectsFromRefMap", parameterType="BOrionObjectsRefMap", defaultValue="new BOrionObjectsRefMap()", returnType="BVector"), @NiagaraAction(name="getAdditionalInfoForOrionObject", parameterType="BOrionObject", defaultValue="new BPerson()", returnType="BOrionObject"), @NiagaraAction(name="getJSONFromOrionObject", parameterType="BOrionObject", defaultValue="new BPerson()", returnType="BString"), @NiagaraAction(name="getRefOrionObject", parameterType="BOrionObjectUtil", defaultValue="new BOrionObjectUtil()", returnType="BVector")})
public class BEntsecISOMConfigImpl
extends BISOMConfig {
    public static final Action queryOrionObjects = BEntsecISOMConfigImpl.newAction((int)0, (BValue)new BSqlQuery(), null);
    public static final Action createNewOrionObjects = BEntsecISOMConfigImpl.newAction((int)0, (BValue)new BVector(), null);
    public static final Action deleteOrionObjects = BEntsecISOMConfigImpl.newAction((int)0, (BValue)new BQuery(), null);
    public static final Action updateOrionObjectsFromRefMap = BEntsecISOMConfigImpl.newAction((int)0, (BValue)new BOrionObjectsRefMap(), null);
    public static final Action getAdditionalInfoForOrionObject = BEntsecISOMConfigImpl.newAction((int)0, (BValue)new BPerson(), null);
    public static final Action getJSONFromOrionObject = BEntsecISOMConfigImpl.newAction((int)0, (BValue)new BPerson(), null);
    public static final Action getRefOrionObject = BEntsecISOMConfigImpl.newAction((int)0, (BValue)new BOrionObjectUtil(), null);
    public static final Type TYPE = Sys.loadType(BEntsecISOMConfigImpl.class);
    public static final Logger LOG = Logger.getLogger("entsec.isom.config");
    private static final Map<String, Property> CREDENTIAL_HOLDER_FIELD_MAP = new HashMap<String, Property>();
    private static final Map<String, Property> CREDENTIAL_FIELD_MAP;

    public BVector queryOrionObjects(BSqlQuery parameter) {
        return (BVector)this.invoke(queryOrionObjects, (BValue)parameter, null);
    }

    public BVector createNewOrionObjects(BVector parameter) {
        return (BVector)this.invoke(createNewOrionObjects, (BValue)parameter, null);
    }

    public BBoolean deleteOrionObjects(BQuery parameter) {
        return (BBoolean)this.invoke(deleteOrionObjects, (BValue)parameter, null);
    }

    public BVector updateOrionObjectsFromRefMap(BOrionObjectsRefMap parameter) {
        return (BVector)this.invoke(updateOrionObjectsFromRefMap, (BValue)parameter, null);
    }

    public BOrionObject getAdditionalInfoForOrionObject(BOrionObject parameter) {
        return (BOrionObject)this.invoke(getAdditionalInfoForOrionObject, (BValue)parameter, null);
    }

    public BString getJSONFromOrionObject(BOrionObject parameter) {
        return (BString)this.invoke(getJSONFromOrionObject, (BValue)parameter, null);
    }

    public BVector getRefOrionObject(BOrionObjectUtil parameter) {
        return (BVector)this.invoke(getRefOrionObject, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public OrionType getOrionType(String entityName) {
        if (entityName.equals("Permissions")) {
            return BAccessRight.ORION_TYPE;
        }
        if (entityName.equals("CredentialHolders")) {
            return BPerson.ORION_TYPE;
        }
        if (entityName.equals("Credentials")) {
            return BBadge.ORION_TYPE;
        }
        return null;
    }

    public Property getIdentifierProperty(String entityName) {
        if (entityName.equals("Permissions")) {
            return BAccessRight.accessRightId;
        }
        if (entityName.equals("CredentialHolders")) {
            return BPerson.personId;
        }
        if (entityName.equals("Credentials")) {
            return BBadge.badgeId;
        }
        return null;
    }

    public Property getIdentifierProperty(OrionType orionType) {
        if (orionType.is((Type)BAccessRight.ORION_TYPE)) {
            return BAccessRight.accessRightId;
        }
        if (orionType.is((Type)BPerson.ORION_TYPE)) {
            return BPerson.personId;
        }
        if (orionType.is((Type)BBadge.ORION_TYPE)) {
            return BBadge.badgeId;
        }
        return null;
    }

    public Property getObjectProperty(String entityName, String fieldName) throws InvalidInputDataException {
        if (fieldName.equals("replicateInstantlyToJace")) {
            return null;
        }
        Property returnValue = null;
        if (entityName.equals("CredentialHolders")) {
            returnValue = CREDENTIAL_HOLDER_FIELD_MAP.get(fieldName);
        } else if (entityName.equals("Credentials")) {
            returnValue = CREDENTIAL_FIELD_MAP.get(fieldName);
        }
        if (returnValue == null) {
            throw new InvalidInputDataException(fieldName);
        }
        return returnValue;
    }

    public BSqlJoin getJoinQuery(Property identifier, BSimple value) {
        BSqlJoin join = null;
        if (identifier == BWiegandFormat.wiegandFormatName) {
            join = this.prepareSQLJoin(BJoin.innerJoin, BWiegandFormat.ORION_TYPE, BWiegandFormat.wiegandFormatId, BBadge.ORION_TYPE, BBadge.wiegandFormat, BWiegandFormat.wiegandFormatName, value);
        } else if (identifier == BPersonInfo.info3) {
            join = this.prepareSQLJoin(BJoin.innerJoin, BPersonInfo.ORION_TYPE, BPersonInfo.person, BPerson.ORION_TYPE, BPerson.personId, BPersonInfo.info3, value);
        }
        return join;
    }

    private BSqlJoin prepareSQLJoin(BJoin joinType, OrionType joinTable, Property joinColumnInJoinTable, OrionType mainTable, Property joinColumnInMainTable, Property joinTableCriteriaColumn, BSimple value) {
        BSqlJoin join = new BSqlJoin();
        join.setJoinKind(joinType);
        join.setJoinTable(new BSqlExtent(joinTable));
        join.setOnExpr(Predicates.and((BExpression)Predicates.eq((BExpression)new BSqlField(joinTable, joinColumnInJoinTable), (BExpression)new BSqlField(mainTable, joinColumnInMainTable)), (BExpression)Predicates.eq((BExpression)new BSqlField(joinTable, joinTableCriteriaColumn), (BSimple)value)));
        return join;
    }

    public boolean isLikeSearch(OrionType orionType, Property identifier) {
        return orionType.is((Type)BBadge.ORION_TYPE) && identifier.equals(BBadge.credential);
    }

    public BOrionObject orionObjectFromJson(JSONObject object, String entityName) throws Exception {
        BReplicableObject orionObject = null;
        if (entityName.equals("CredentialHolders")) {
            orionObject = new BPerson();
        } else if (entityName.equals("Credentials")) {
            orionObject = new BBadge();
        }
        orionObject = this.populateOrionObjectFromJson(object, orionObject);
        return orionObject;
    }

    public BOrionObject populateOrionObjectFromJson(JSONObject jsonObject, BOrionObject orionObject) throws Exception {
        try {
            if (orionObject instanceof ICompatibleWithIsom) {
                ((ICompatibleWithIsom)orionObject).fromJson(this.clearInvalidDataFromJson(jsonObject));
            }
        }
        catch (Exception e) {
            throw new Exception(this.getRootCauseMessage(e));
        }
        return orionObject;
    }

    private JSONObject clearInvalidDataFromJson(JSONObject jsonObject) {
        Iterator iterator = jsonObject.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (!jsonObject.isNull(key) && !jsonObject.get(key).toString().trim().isEmpty()) continue;
            iterator.remove();
        }
        return jsonObject;
    }

    public boolean checkIfOrionObjectHasAdditionalInfo(BOrionObject bOrionObject) {
        return bOrionObject instanceof ICompatibleWithIsom && ((ICompatibleWithIsom)bOrionObject).hasAdditionalInfo();
    }

    public BOrionObject additionalInfoOrionObjectFromJson(JSONObject jsonObject, BOrionObject masterOrionObject) {
        BOrionObject returnAddtionalInforObjects = null;
        if (masterOrionObject instanceof ICompatibleWithIsom) {
            returnAddtionalInforObjects = ((ICompatibleWithIsom)masterOrionObject).getAdditionalInfoOrionObjectsFromJson(this.clearInvalidDataFromJson(jsonObject));
        }
        return returnAddtionalInforObjects;
    }

    public JSONObject jsonFromOrionObject(BOrionObject orionObject) throws Exception {
        JSONObject jsonObject = new JSONObject(this.getJSONFromOrionObject(orionObject).getString());
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BString doGetJSONFromOrionObject(BOrionObject orionObject) throws Exception {
        OrionSession orionSession = null;
        try {
            orionSession = this.getOrionSession();
            if (orionObject instanceof ICompatibleWithIsom) {
                JSONObject jsonObject = ((ICompatibleWithIsom)orionObject).getJSON(orionSession);
                BString bString = BString.make((String)jsonObject.toString());
                return bString;
            }
        }
        finally {
            this.closeOrionSession(orionSession);
        }
        return null;
    }

    public BOrionObject[] queryObjects(BQuery query) {
        BVector orionObjects = this.queryOrionObjects((BSqlQuery)query);
        return this.getOrionObjectsFromVector(orionObjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BVector doQueryOrionObjects(BSqlQuery sqlQuery) {
        BVector orionObjects = new BVector();
        OrionSession orionSession = null;
        try {
            orionSession = this.getOrionSession();
            OrionCursor orionCursor = orionSession.select((BQuery)sqlQuery);
            while (orionCursor.next()) {
                BOrionObject orionObject = (BOrionObject)orionCursor.get();
                orionObjects.add(null, (BValue)orionObject);
                LOG.fine("orionObject: " + orionObject.getName());
            }
        }
        finally {
            this.closeOrionSession(orionSession);
        }
        return orionObjects;
    }

    public BOrionObject[] createNewObjects(BOrionObject[] orionObjects) throws Exception {
        BVector orionObjectsVector = this.getOrionObjectsVectorFromArray(orionObjects);
        BVector newOrionObjectsVector = null;
        try {
            newOrionObjectsVector = this.createNewOrionObjects(orionObjectsVector);
        }
        catch (ActionInvokeException ae) {
            String rootCauseMessage = this.getRootCauseMessage((Exception)((Object)ae));
            throw new Exception(rootCauseMessage);
        }
        return this.getOrionObjectsFromVector(newOrionObjectsVector);
    }

    private BVector getOrionObjectsVectorFromArray(BOrionObject[] orionObjects) {
        BVector orionObjectsVector = new BVector();
        for (int i = 0; i < orionObjects.length; ++i) {
            orionObjectsVector.add(null, orionObjects[i].newCopy());
        }
        return orionObjectsVector;
    }

    private BOrionObject[] getOrionObjectsFromVector(BVector orionObjectsVector) {
        SlotCursor slotCursor = orionObjectsVector.getProperties();
        Array array = new Array(BOrionObject.class);
        while (slotCursor.next(BOrionObject.class)) {
            array.add((Object)((BOrionObject)slotCursor.get()));
        }
        return (BOrionObject[])array.trim();
    }

    public BOrionObject[] createAdditionalInfoObjects(BOrionObject[] addionalInfoOrionObjects) {
        BVector orionObjectsVector = new BVector();
        for (int i = 0; i < addionalInfoOrionObjects.length; ++i) {
            orionObjectsVector.add(null, (BValue)addionalInfoOrionObjects[i]);
        }
        BVector newOrionObjectsVector = this.createNewOrionObjects(orionObjectsVector);
        return this.getOrionObjectsFromVector(newOrionObjectsVector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BVector doCreateNewOrionObjects(BVector orionObjects) throws Exception {
        BOrionObject[] orionObjectsArray = null;
        HashMap<BOrionObject, Map> orionObjectsMap = null;
        BatchStatement orionObjectStatement = null;
        BatchStatement orionObjectUpdateStatement = null;
        BVector newOrionObjectsVector = null;
        OrionSession orionSession = null;
        try {
            orionSession = this.getOrionSession();
            orionObjectsArray = (BOrionObject[])orionObjects.getChildren(BOrionObject.class);
            orionObjectStatement = orionSession.batchInsert(orionObjectsArray[0].getOrionType());
            orionObjectsMap = new HashMap<BOrionObject, Map>();
            Map ref = null;
            for (int i = 0; i < orionObjectsArray.length; ++i) {
                if (orionObjectsArray[i] instanceof ICompatibleWithIsom) {
                    ref = ((ICompatibleWithIsom)orionObjectsArray[i]).removeReferenceObject();
                    orionObjectsMap.put(orionObjectsArray[i], ref);
                }
                orionObjectStatement.add((BIOrionObject)orionObjectsArray[i]);
            }
            orionObjectStatement.execute();
            orionObjectUpdateStatement = orionSession.batchUpdate(orionObjectsArray[0].getOrionType());
            BOrionObject orionObject = null;
            Iterator it = orionObjectsMap.entrySet().iterator();
            boolean initiateInstantReplication = false;
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                ref = (Map)entry.getValue();
                orionObject = (BOrionObject)entry.getKey();
                if (!(orionObject instanceof ICompatibleWithIsom)) continue;
                ((ICompatibleWithIsom)orionObject).addReferenceObject(ref);
                orionObjectUpdateStatement.add((BIOrionObject)orionObject);
                if (!(orionObject instanceof InstantReplicationRequired) || initiateInstantReplication) continue;
                initiateInstantReplication = true;
            }
            orionObjectUpdateStatement.execute();
            orionSession.commit();
            if (initiateInstantReplication) {
                ((BReplicationService)Sys.getService((Type)BReplicationService.TYPE)).execute(BBoolean.make((boolean)true));
            }
            Object resultOrionObject = null;
            newOrionObjectsVector = new BVector();
            BUuid[] personAddedOrUpdated = new BUuid[orionObjectsArray.length];
            for (int i = 0; i < orionObjectsArray.length; ++i) {
                newOrionObjectsVector.add(null, orionObjectsArray[i].newCopy());
            }
        }
        finally {
            this.closeOrionSession(orionSession);
        }
        LOG.fine("doCreateNewOrionObjects: Successfully created " + orionObjectsArray.length + " objects");
        return newOrionObjectsVector;
    }

    public BOrionObject[] updateObjects(JSONObject jsonObject, BOrionObject masterObject) throws Exception {
        BOrionObject[] associatedOrionObjects;
        BOrionObject additionalInfoObject;
        ICompatibleWithIsom iCompatibleOrionObject;
        JSONObject jsonObjectToUpdate = this.clearInvalidDataFromJson(jsonObject);
        BOrionObjectsRefMap refMap = new BOrionObjectsRefMap();
        refMap.setMasterOrionObject((BOrionObject)masterObject.newCopy());
        if (masterObject instanceof ICompatibleWithIsom && (iCompatibleOrionObject = (ICompatibleWithIsom)masterObject).hasAdditionalInfo() && (additionalInfoObject = iCompatibleOrionObject.getAdditionalInfoOrionObjectsFromJson(jsonObjectToUpdate)) != null) {
            refMap.setAdditionalInfoOrionObject((BOrionObject)additionalInfoObject.newCopy());
        }
        if ((associatedOrionObjects = this.getAssociatedOrionObjectsFromJson(jsonObjectToUpdate, masterObject)) != null) {
            refMap.setAssociateOrionObjects(this.getOrionObjectsVectorFromArray(associatedOrionObjects));
        }
        BVector updatedOrionObjectsVector = null;
        try {
            updatedOrionObjectsVector = this.updateOrionObjectsFromRefMap(refMap);
        }
        catch (Exception e) {
            LOG.log(Level.FINE, "Exception occurred while updating Objects", e);
            throw new Exception(this.getRootCauseMessage(e));
        }
        if (updatedOrionObjectsVector == null) {
            return null;
        }
        return this.getOrionObjectsFromVector(updatedOrionObjectsVector);
    }

    private BOrionObject[] getAssociatedOrionObjectsFromJson(JSONObject jsonObject, BOrionObject masterObject) throws Exception {
        JSONObject masterJsonObject = this.clearInvalidDataFromJson(jsonObject);
        BOrionObject[] associatedOrionObjects = null;
        try {
            String typeOfRelation = this.getTypeOfRelation(masterJsonObject);
            if (typeOfRelation == null) {
                return null;
            }
            OrionType orionType = this.getOrionTypeFromRelation(typeOfRelation);
            if (orionType == null) {
                return null;
            }
            BSqlQuery sqlQuery = BSqlQuery.make((OrionType)orionType);
            BSqlExtent extent = (BSqlExtent)sqlQuery.getExtent();
            BSqlField field = new BSqlField(extent, this.getIdentifierProperty(orionType));
            BUuid[] refs = this.getAssociatedObjectUuids(masterJsonObject, typeOfRelation, masterObject);
            sqlQuery.where(Predicates.in((BExpression)field, (BSimple[])refs));
            associatedOrionObjects = this.queryObjects((BQuery)sqlQuery);
            if (associatedOrionObjects == null || associatedOrionObjects.length == 0) {
                throw new Exception("AssociateObject not found");
            }
        }
        catch (BajaRuntimeException e) {
            LOG.log(Level.FINE, "Invalid input received in the request", e);
            throw new InvalidInputDataException(this.getRootCauseMessage((Exception)((Object)e)));
        }
        catch (Exception e) {
            LOG.log(Level.FINE, "Exception occurred while retrieving associate objects", e);
            throw e;
        }
        return associatedOrionObjects;
    }

    private String getTypeOfRelation(JSONObject jsonObject) {
        String typeOfRelation = null;
        if (!jsonObject.isNull("PermissionsFromOtherCredentialHolderRef")) {
            typeOfRelation = "PermissionsFromOtherCredentialHolderRef";
        } else {
            if (jsonObject.isNull("Relation") || ((JSONArray)jsonObject.get("Relation")).isEmpty()) {
                return null;
            }
            JSONArray relations = (JSONArray)jsonObject.get("Relation");
            Iterator keys = ((JSONObject)relations.get(0)).keySet().iterator();
            if (keys.hasNext()) {
                typeOfRelation = (String)keys.next();
            }
        }
        return typeOfRelation;
    }

    private BUuid[] getAssociatedObjectUuids(JSONObject jsonObject, String typeOfRelation, BOrionObject masterObject) throws Exception {
        Array uuidsArray = null;
        if (typeOfRelation.equals("PermissionToCredentialHolder")) {
            if (jsonObject.isNull("Relation")) {
                return null;
            }
            uuidsArray = new Array(BUuid.class);
            BUuid temp = null;
            String associateObjectUUID = null;
            JSONArray relations = (JSONArray)jsonObject.get("Relation");
            for (JSONObject relation : relations) {
                if (relation.isNull("PermissionToCredentialHolder")) continue;
                associateObjectUUID = (String)relation.get("PermissionToCredentialHolder");
                temp = BUuid.make((String)associateObjectUUID);
                uuidsArray.add((Object)temp);
            }
            return (BUuid[])uuidsArray.trim();
        }
        if (typeOfRelation.equals("PermissionsFromOtherCredentialHolderRef")) {
            String associateObjectUUID = (String)jsonObject.get("PermissionsFromOtherCredentialHolderRef");
            BQuery sqlQuery = BSqlQuery.make((OrionType)this.getOrionType("CredentialHolders")).where(Predicates.eq((Property)this.getIdentifierProperty(masterObject.getOrionType()), (BSimple)BUuid.make((String)associateObjectUUID)));
            BOrionObject[] orionObjects = this.getRefObject(sqlQuery, "Permissions");
            uuidsArray = new Array(BUuid.class);
            for (int i = 0; i < orionObjects.length; ++i) {
                String name = this.getIdentifierProperty(orionObjects[i].getOrionType()).getName();
                uuidsArray.add((Object)BUuid.make((String)orionObjects[i].get(orionObjects[i].getProperty(name)).toString()));
            }
            return (BUuid[])uuidsArray.trim();
        }
        return null;
    }

    private OrionType getOrionTypeFromRelation(String credentialHolderToPermissionsRef) {
        if (credentialHolderToPermissionsRef.equals("PermissionToCredentialHolder") || credentialHolderToPermissionsRef.equals("PermissionsFromOtherCredentialHolderRef")) {
            return BAccessRight.ORION_TYPE;
        }
        return null;
    }

    public BVector doUpdateOrionObjectsFromRefMap(BOrionObjectsRefMap refMap) throws Exception {
        OrionSession orionSession = null;
        BVector returnOrionObjects = null;
        try {
            BOrionObject[] associateOrionObjectsArray;
            BVector associateOrionObjects;
            orionSession = this.getOrionSession();
            BOrionObject masterOrionObject = refMap.getMasterOrionObject();
            orionSession.update((BIOrionObject)masterOrionObject);
            BOrionObject additionalInfoObject = refMap.getAdditionalInfoOrionObject();
            if (((ICompatibleWithIsom)masterOrionObject).hasAdditionalInfo() && this.hasValidDataToSave(additionalInfoObject)) {
                BOrionObject additionalInfoObjectFromDB = this.getAdditionalInfoForOrionObject(masterOrionObject);
                if (additionalInfoObjectFromDB != null) {
                    additionalInfoObjectFromDB = this.populateInfoFromAnotherOrionObject(additionalInfoObject, additionalInfoObjectFromDB);
                    orionSession.update((BIOrionObject)additionalInfoObjectFromDB);
                } else {
                    orionSession.insert((BIOrionObject)additionalInfoObject);
                }
            }
            if ((associateOrionObjects = refMap.getAssociateOrionObjects()) != null && (associateOrionObjectsArray = this.getOrionObjectsFromVector(associateOrionObjects)) != null && associateOrionObjectsArray.length > 0) {
                BOrionObject[] joinObjects = ((ICompatibleWithIsom)masterOrionObject).associateObject(associateOrionObjectsArray);
                for (int i = 0; i < joinObjects.length; ++i) {
                    if (orionSession.exists((BIOrionObject)joinObjects[i])) continue;
                    orionSession.insert((BIOrionObject)joinObjects[i]);
                }
            }
            boolean initiateInstantReplication = false;
            if (masterOrionObject instanceof InstantReplicationRequired) {
                initiateInstantReplication = true;
            }
            returnOrionObjects = new BVector();
            returnOrionObjects.add(null, masterOrionObject.newCopy());
            orionSession.commit();
            if (initiateInstantReplication) {
                ((BReplicationService)Sys.getService((Type)BReplicationService.TYPE)).execute(BBoolean.make((boolean)true));
            }
        }
        catch (Exception e) {
            LOG.log(Level.FINE, "Exception occurred while updating Objects", e);
            throw new Exception(this.getRootCauseMessage(e));
        }
        finally {
            this.closeOrionSession(orionSession);
        }
        return returnOrionObjects;
    }

    private boolean hasValidDataToSave(BOrionObject orionObject) {
        SlotCursor c = orionObject.getProperties();
        while (c.next()) {
            Property prop = c.property();
            BValue value = orionObject.get(prop);
            if (value.isNull() || prop.isEquivalentToDefaultValue(value)) continue;
            return true;
        }
        return false;
    }

    private BOrionObject populateInfoFromAnotherOrionObject(BOrionObject sourceOrionObject, BOrionObject targetOrionObject) {
        SlotCursor c = sourceOrionObject.getProperties();
        while (c.next()) {
            Property prop = c.property();
            BValue value = sourceOrionObject.get(prop);
            if (value.isNull() || prop.isEquivalentToDefaultValue(value)) continue;
            targetOrionObject.set(prop, value);
        }
        return targetOrionObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BOrionObject doGetAdditionalInfoForOrionObject(BOrionObject masterOrionObject) {
        OrionSession orionSession = null;
        BOrionObject returnObject = null;
        try {
            orionSession = this.getOrionSession();
            if (masterOrionObject instanceof ICompatibleWithIsom) {
                returnObject = ((ICompatibleWithIsom)masterOrionObject).getAdditionalInfoOrionObjects(orionSession);
            }
            if (returnObject != null) {
                BOrionObject bOrionObject = (BOrionObject)returnObject.newCopy();
                return bOrionObject;
            }
        }
        finally {
            this.closeOrionSession(orionSession);
        }
        return null;
    }

    public boolean deleteObjects(BQuery query) {
        return this.deleteOrionObjects(query).getBoolean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BBoolean doDeleteOrionObjects(BQuery query) {
        boolean deleteStatus = false;
        BOrionObject[] orionObjects = this.queryObjects(query);
        if (orionObjects == null || orionObjects.length == 0) {
            LOG.fine("deleteOrionObjects: No matching objects to delete");
        } else {
            OrionSession orionSession = null;
            try {
                orionSession = this.getOrionSession();
                deleteStatus = orionSession.delete((BIOrionObject)orionObjects[0]);
                boolean initiateInstantReplication = false;
                if (orionObjects[0] instanceof InstantReplicationRequired) {
                    initiateInstantReplication = true;
                }
                orionSession.commit();
                if (initiateInstantReplication) {
                    ((BReplicationService)Sys.getService((Type)BReplicationService.TYPE)).execute(BBoolean.make((boolean)true));
                }
            }
            finally {
                this.closeOrionSession(orionSession);
            }
        }
        return BBoolean.make((boolean)deleteStatus);
    }

    private OrionSession getOrionSession() {
        BOrionDatabase orionDatabase = BOrionService.getService().getOrionDatabases()[0];
        OrionSession orionSession = orionDatabase.createSession(null);
        orionSession.setAutoCommit(false);
        return orionSession;
    }

    private void closeOrionSession(OrionSession orionSession) {
        if (orionSession != null) {
            orionSession.close();
            orionSession = null;
        }
    }

    private String getRootCauseMessage(Exception e) {
        Throwable cause;
        String rootCauseMessage = e.getMessage();
        for (cause = e.getCause(); cause != null; cause = cause.getCause()) {
            rootCauseMessage = cause.getMessage();
        }
        if (rootCauseMessage == null) {
            rootCauseMessage = cause.getMessage();
        }
        if (rootCauseMessage.startsWith("Duplicate entry") || rootCauseMessage.startsWith("integrity constraint violation")) {
            return "Record already exists in the database";
        }
        if (rootCauseMessage.startsWith("Invalid BAbsTime")) {
            return "Invalid DateTime Format";
        }
        if (rootCauseMessage.startsWith("Invalid format for BUuid")) {
            return "Invalid DateTime Format";
        }
        return rootCauseMessage;
    }

    public BOrionObject[] getRefObject(BQuery query, String associatedObjectEntityName) throws Exception {
        BOrionObject[] orionObjects = this.queryObjects(query);
        if (orionObjects == null || orionObjects.length == 0) {
            return null;
        }
        BOrionObjectUtil orionObjectUtil = new BOrionObjectUtil();
        orionObjectUtil.setOrionObject((BOrionObject)orionObjects[0].newCopy());
        orionObjectUtil.setRefObjectOrionType(associatedObjectEntityName);
        BVector refOrionObject = this.getRefOrionObject(orionObjectUtil);
        return this.getOrionObjectsFromVector(refOrionObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BVector doGetRefOrionObject(BOrionObjectUtil orionObjectUtil) {
        BVector newOrionObjectsVector = null;
        BOrionObject[] orionObjectsArray = null;
        OrionSession orionSession = null;
        try {
            orionSession = this.getOrionSession();
            BOrionObject orionObject = orionObjectUtil.getOrionObject();
            orionObjectsArray = ((ICompatibleWithIsom)orionObject).getRefObject(orionSession, (Type)this.getOrionType(orionObjectUtil.getRefObjectOrionType()));
            newOrionObjectsVector = new BVector();
            for (int i = 0; i < orionObjectsArray.length; ++i) {
                newOrionObjectsVector.add(null, orionObjectsArray[i].newCopy());
            }
        }
        finally {
            this.closeOrionSession(orionSession);
        }
        return newOrionObjectsVector;
    }

    static {
        CREDENTIAL_HOLDER_FIELD_MAP.put("EmployeeId", BPerson.employeeId);
        CREDENTIAL_HOLDER_FIELD_MAP.put("Name", BPerson.firstName);
        CREDENTIAL_HOLDER_FIELD_MAP.put("LastName", BPerson.lastName);
        CREDENTIAL_HOLDER_FIELD_MAP.put("externalSystemID", BPersonInfo.info3);
        CREDENTIAL_FIELD_MAP = new HashMap<String, Property>();
        CREDENTIAL_FIELD_MAP.put("CredentialNumber", BBadge.credential);
        CREDENTIAL_FIELD_MAP.put("FacilityCode", BBadge.facilityCode);
        CREDENTIAL_FIELD_MAP.put("WiegandFormatId", BBadge.wiegandFormat);
        CREDENTIAL_FIELD_MAP.put("WiegandFormatName", BWiegandFormat.wiegandFormatName);
    }
}

