/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.intrusion.schema;

import com.tridium.orion.BIOrionApp;
import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BSchemaVersion;
import com.tridium.orion.ISchemaUpgrader;
import com.tridium.orion.OrionSession;
import com.tridium.orion.sql.TableBuilder;
import com.tridiumx.entsec.intrusion.BIntrusionService;
import com.tridiumx.entsec.intrusion.orion.BIntrusionZoneGroup;
import com.tridiumx.entsec.orionTools.SchemaUpgradeSupport;
import java.util.logging.Level;
import javax.baja.rdb.ddl.DdlCommand;

public class Upgrade_1_0_to_1_1
implements ISchemaUpgrader {
    private static final BSchemaVersion FROM_VERSION = BIntrusionService.VERSION_1_0;
    private static final BSchemaVersion TO_VERSION = BIntrusionService.VERSION_1_1;

    public BSchemaVersion getFromVersion() {
        return FROM_VERSION;
    }

    public BSchemaVersion getToVersion() {
        return TO_VERSION;
    }

    public void upgrade(BLocalOrionDatabase db, BIOrionApp app, OrionSession session) throws Exception {
        try {
            TableBuilder tb = new TableBuilder((BOrionDatabase)db, BIntrusionZoneGroup.ORION_TYPE);
            DdlCommand[] ddl = tb.createTable();
            for (int j = 0; j < ddl.length; ++j) {
                session.invokeDdl(ddl[j]);
            }
            SchemaUpgradeSupport.skipConvertTimestampToLong(BIntrusionZoneGroup.ORION_TYPE, BIntrusionZoneGroup.lastModified);
            ((BIntrusionService)app).fix_VERSION_1_0_to_VERSION_1_1 = true;
        }
        catch (Exception e) {
            BIntrusionService.LOG.log(Level.SEVERE, "Upgrade_1_0_to_1_1 Schema Upgrade either not needed or failed", e);
        }
    }
}

