/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.intrusion.orion;

import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.alarm.BNiagaraAlarmDeviceExt;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.OrionSession;
import com.tridiumx.entsec.intrusion.BIntrusionZone;
import com.tridiumx.entsec.intrusion.fox.BIntrusionGroupExt;
import com.tridiumx.entsec.intrusion.orion.BIntrusionZoneRec;
import com.tridiumx.entsec.orionTools.BMappedExt;
import com.tridiumx.entsec.orionTools.MappingSupport;
import com.tridiumx.entsec.orionTools.MergeSupport;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmService;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

@NiagaraType(agent={@AgentOn(types={"entsec:IntrusionZone"})})
public class BMappedIntrusionZoneExt
extends BMappedExt {
    public static final Type TYPE = Sys.loadType(BMappedIntrusionZoneExt.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public Type getMappedType() {
        return BIntrusionZone.TYPE;
    }

    @Override
    public void removeMapping() {
        super.removeMapping();
        BIntrusionZone zone = (BIntrusionZone)this.getParent();
        if (zone != null) {
            zone.purge();
        }
    }

    public static void handlePush(BIntrusionZone remoteZone, BUuid remoteUuid, String remoteName, BIntrusionZone localZone, String remoteStationName, BAlarmService alarmService, OrionSession session) {
        BNiagaraNetwork network;
        BNiagaraStation station;
        BNiagaraAlarmDeviceExt[] alarmExts;
        BIntrusionZoneRec rec = new BIntrusionZoneRec();
        rec.setUuid(remoteUuid);
        rec = (BIntrusionZoneRec)session.read((BIOrionObject)rec);
        if (rec != null && rec.getMappedOrd() != BOrd.DEFAULT) {
            if (localZone == null) {
                localZone = (BIntrusionZone)rec.getMappedOrd().get();
            } else {
                BIntrusionZone zoneFromRec = (BIntrusionZone)rec.getMappedOrd().get();
                if (zoneFromRec != localZone) {
                    throw new IllegalStateException("Intrusion Zone is already present on station");
                }
            }
        } else {
            BAlarmClass lookup = alarmService.lookupAlarmClass(remoteName);
            if (lookup instanceof BIntrusionZone && (localZone = (BIntrusionZone)lookup).getValidGroups().length > 0) {
                boolean stationFound = false;
                BIntrusionGroupExt[] localExts = localZone.getValidGroups();
                for (int i = 0; i < localExts.length; ++i) {
                    if (!localExts[i].getRemoteStation().equals(remoteStationName)) continue;
                    stationFound = true;
                }
                if (!stationFound) {
                    throw new IllegalStateException("Cannot override another intruson zone if zone if its already grouped");
                }
            }
        }
        if (localZone != null) {
            MergeSupport.changeUuidForComponent(remoteUuid, (BComponent)localZone, session);
        }
        if (localZone == null) {
            localZone = new BIntrusionZone();
            MappingSupport.addMappedExt((BComponent)localZone, remoteUuid);
            localZone.copyFrom((BComplex)remoteZone);
            alarmService.add(remoteName, (BValue)localZone);
        }
        if (BIntrusionGroupExt.getExt(localZone, remoteStationName) == null) {
            BIntrusionGroupExt.addExt(localZone, remoteStationName);
        }
        if ((alarmExts = (BNiagaraAlarmDeviceExt[])(station = (BNiagaraStation)(network = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE)).getStation(remoteStationName)).getChildren(BNiagaraAlarmDeviceExt.class)).length > 0) {
            alarmExts[0].setAlarmClass("%alarmClass%");
        }
    }
}

