/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.intrusion.orion;

import com.tridium.nd.BNiagaraStation;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.annotations.NiagaraOrionType;
import com.tridium.orion.annotations.OrionRefCursor;
import com.tridium.orion.priv.util.CountingUtil;
import com.tridium.orion.sql.PropertyValue;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.intrusion.BIntrusionService;
import com.tridiumx.entsec.intrusion.BIntrusionZone;
import com.tridiumx.entsec.intrusion.IntrusionUtil;
import com.tridiumx.entsec.intrusion.fox.BIntrusionGroupExt;
import com.tridiumx.entsec.intrusion.orion.BIntrusionZoneGroup;
import com.tridiumx.entsec.intrusion.orion.BMappedIntrusionZoneExt;
import com.tridiumx.entsec.orionTools.BIOrdMappable;
import com.tridiumx.entsec.orionTools.MappingSupport;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import com.tridiumx.entsec.orionTools.replicate.BReplicableObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

@NiagaraType(agent={@AgentOn(types={"entsec:IntrusionZone"})})
@NiagaraOrionType
@OrionRefCursor(name="Groups", type="BIntrusionZoneGroup", ref="intrusionZone")
@NiagaraProperties(value={@NiagaraProperty(name="uuid", type="BUuid", defaultValue="BUuid.NULL", flags=5, facets={@Facet(name="KEY", value="true")}), @NiagaraProperty(name="intrusionZoneName", type="String", defaultValue="", flags=9, facets={@Facet(name="WIDTH", value="128"), @Facet(name="DISPLAY_ID", value="true")}), @NiagaraProperty(name="stationName", type="String", defaultValue="", flags=1, facets={@Facet(name="WIDTH", value="64"), @Facet(name="INDEXED", value="true")}), @NiagaraProperty(name="intrusionZoneDisplayPath", type="String", defaultValue="", flags=1, facets={@Facet(name="WIDTH", value="256")})})
public class BIntrusionZoneRec
extends BReplicableObject
implements BIOrdMappable {
    public static final Property uuid = BIntrusionZoneRec.newProperty((int)5, (BValue)BUuid.NULL, (BFacets)BFacets.make((String)"key", (boolean)true));
    public static final Property intrusionZoneName = BIntrusionZoneRec.newProperty((int)9, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"width", (int)128), (BFacets)BFacets.make((String)"displayId", (boolean)true)));
    public static final Property stationName = BIntrusionZoneRec.newProperty((int)1, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"width", (int)64), (BFacets)BFacets.make((String)"indexed", (boolean)true)));
    public static final Property intrusionZoneDisplayPath = BIntrusionZoneRec.newProperty((int)1, (String)"", (BFacets)BFacets.make((String)"width", (int)256));
    public static final Type TYPE = Sys.loadType(BIntrusionZoneRec.class);
    public static final OrionType ORION_TYPE = (OrionType)TYPE;
    public static final BIcon ICON = BIntrusionZone.ICON;

    public BUuid getUuid() {
        return (BUuid)this.get(uuid);
    }

    public void setUuid(BUuid v) {
        this.set(uuid, (BValue)v, null);
    }

    public String getIntrusionZoneName() {
        return this.getString(intrusionZoneName);
    }

    public void setIntrusionZoneName(String v) {
        this.setString(intrusionZoneName, v, null);
    }

    @Override
    public String getStationName() {
        return this.getString(stationName);
    }

    public void setStationName(String v) {
        this.setString(stationName, v, null);
    }

    public String getIntrusionZoneDisplayPath() {
        return this.getString(intrusionZoneDisplayPath);
    }

    public void setIntrusionZoneDisplayPath(String v) {
        this.setString(intrusionZoneDisplayPath, v, null);
    }

    public GroupsCursor getGroups(OrionSession session) {
        return new GroupsCursor(session.select(BIntrusionZoneGroup.ORION_TYPE, new PropertyValue(BIntrusionZoneGroup.intrusionZone, (BValue)BRef.make((BIOrionObject)this))));
    }

    @Override
    public Type getType() {
        return this.getTypeFromSpace(TYPE);
    }

    @Override
    public void afterInsert(OrionSession session) {
        super.afterInsert(session);
        BIntrusionZoneGroup group = new BIntrusionZoneGroup();
        group.setIntrusionZone(BRef.make((BIOrionObject)this));
        group.setStationName(Sys.getStation().getStationName());
        session.insert((BIOrionObject)group);
        if (BIntrusionZoneRec.hasNamingCollision(this.getIntrusionZoneName(), session)) {
            Logger.getLogger(BIntrusionService.TYPE.getModule().getModuleName()).log(Level.SEVERE, "There are multiple Intrusion Zones with the same name, but they are not matched:" + this.getIntrusionZoneName());
            BIntrusionService service = (BIntrusionService)Sys.getService((Type)BIntrusionService.TYPE);
            service.setNamingCollision(true);
        }
    }

    @Override
    public boolean beforeUpdate(OrionSession session) {
        if (this.getIntrusionZoneName().length() == 0) {
            return false;
        }
        try {
            int i;
            BEnterpriseSecurityService service;
            BIntrusionZoneRec rec = (BIntrusionZoneRec)session.read((BIOrionObject)this.newCopy());
            String displayName = rec.getIntrusionZoneName();
            if (!this.getIntrusionZoneName().equals(displayName)) {
                BIntrusionZone intrusionZone;
                block14: {
                    Logger.getLogger(BIntrusionService.TYPE.getModule().getModuleName()).fine("rename alarm class from " + this.getIntrusionZoneName() + " to " + displayName);
                    intrusionZone = null;
                    try {
                        intrusionZone = (BIntrusionZone)this.getMappedOrd().get();
                    }
                    catch (UnresolvedException e) {
                        intrusionZone = (BIntrusionZone)rec.getMappedOrd().get();
                        if (intrusionZone.getDisplayName(null).equals(this.getIntrusionZoneName())) break block14;
                        intrusionZone.getParent().asComponent().rename(intrusionZone.getPropertyInParent(), SlotPath.escape((String)this.getIntrusionZoneName()));
                    }
                }
                intrusionZone.zoneRenamed(BString.make((String)SlotPath.escape((String)displayName)));
                service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
                BNiagaraStation[] stations = service.getMonitorSysDefSecurity().getSecuritySubordinateStations();
                BIntrusionGroupExt[] groups = intrusionZone.getValidGroups();
                for (i = 0; i < stations.length; ++i) {
                    boolean found = false;
                    for (int j = 0; j < groups.length; ++j) {
                        if (!groups[j].getRemoteStation().equals(stations[i].getStationName())) continue;
                        found = true;
                    }
                    if (found) continue;
                    try {
                        RemoteUtil.invokeRemote(stations[i].getStationName(), rec.getMappedOrd(), BIntrusionZone.renameZone, (BValue)BString.make((String)SlotPath.escape((String)this.getIntrusionZoneName())));
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (!this.getStationName().equals(Sys.getStation().getStationName())) {
                this.setStationName(Sys.getStation().getStationName());
            }
            String oldStationName = rec.getStationName();
            if (!this.getStationName().equals(oldStationName)) {
                service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
                boolean found = false;
                BNiagaraStation[] stations = service.getMonitorSysDefSecurity().getSecuritySubordinateStations();
                for (i = 0; i < stations.length; ++i) {
                    if (!stations[i].getStationName().equals(this.getStationName()) && !stations[i].getStationName().equals(oldStationName)) continue;
                    found = true;
                }
                if (!found) {
                    Logger.getLogger(BIntrusionService.TYPE.getModule().getModuleName()).fine("rename station from " + this.getStationName() + " to " + oldStationName);
                    BIntrusionZoneGroup oldGroup = new BIntrusionZoneGroup();
                    oldGroup.setIntrusionZone(BRef.make((BIOrionObject)this));
                    oldGroup.setStationName(oldStationName);
                    session.delete((BIOrionObject)oldGroup);
                    BIntrusionZoneGroup newGroup = new BIntrusionZoneGroup();
                    newGroup.setIntrusionZone(BRef.make((BIOrionObject)this));
                    newGroup.setStationName(this.getStationName());
                    session.persist((BIOrionObject)newGroup);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return super.beforeUpdate(session);
    }

    @Override
    public boolean beforeDelete(OrionSession session) {
        BIntrusionZoneRec rec = (BIntrusionZoneRec)session.read((BIOrionObject)this.newCopy());
        if (rec == null) {
            return false;
        }
        if (!BIntrusionZoneRec.hasNamingCollision(this.getIntrusionZoneName(), session)) {
            String name = SlotPath.escape((String)rec.getIntrusionZoneName());
            IntrusionUtil.deleteAlarmClass(name);
        }
        return super.beforeDelete(session);
    }

    public void mapFrom(BObject source) {
        BIntrusionZone intrusionZone = (BIntrusionZone)source;
        BMappedIntrusionZoneExt ext = (BMappedIntrusionZoneExt)intrusionZone.getMixIn(BMappedIntrusionZoneExt.TYPE);
        this.setUuid(ext.getUuid());
        this.setLastModified(BAbsTime.now());
        if (Sys.getStation() != null) {
            this.setStationName(Sys.getStation().getStationName());
        }
        if (intrusionZone.isRunning()) {
            String displayName = intrusionZone.getDisplayName(null);
            if (displayName != null) {
                this.setIntrusionZoneName(displayName);
            } else if (intrusionZone.getName() != null) {
                this.setIntrusionZoneName(intrusionZone.getName());
            } else {
                throw new IllegalStateException("need a name when is running");
            }
            this.setSlotPathOrd(source);
        }
    }

    @Override
    public BOrd getMappedOrd() {
        return MappingSupport.getMappedOrd(this);
    }

    @Override
    public void setSlotPathOrd(BObject source) {
        this.setIntrusionZoneDisplayPath(MappingSupport.getDisplayPath(source));
    }

    @Override
    public String getMappedDisplayPath() {
        return this.getIntrusionZoneDisplayPath();
    }

    public String toString(Context cx) {
        return this.toDisplayString(cx);
    }

    public static boolean hasNamingCollision(String name, OrionSession session) {
        return CountingUtil.getCount((OrionType)ORION_TYPE, (Property)intrusionZoneName, (BSimple)BString.make((String)name), (OrionSession)session) > 1;
    }

    public BIcon getIcon() {
        return ICON;
    }

    public static class GroupsCursor
    implements OrionCursor {
        private final OrionCursor cursor;

        private GroupsCursor(OrionCursor cursor) {
            this.cursor = cursor;
        }

        public Context getContext() {
            return this.cursor.getContext();
        }

        public OrionType getOrionType() {
            return this.cursor.getOrionType();
        }

        public BIOrionObject[] toArray() {
            return this.cursor.toArray();
        }

        public boolean next() {
            return this.cursor.next();
        }

        public boolean nextComponent() {
            return this.cursor.nextComponent();
        }

        public boolean next(Class<?> cls) {
            return this.cursor.next(cls);
        }

        public BObject get() {
            return (BObject)this.cursor.get();
        }

        public OrionSession getSession() {
            return this.cursor.getSession();
        }

        public void close() {
            this.cursor.close();
        }

        public BIntrusionZoneGroup getIntrusionZoneGroup() {
            return (BIntrusionZoneGroup)this.cursor.get();
        }
    }
}

