/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.intrusion.fox;

import com.tridium.fox.sys.NiagaraNetwork;
import com.tridium.fox.sys.NiagaraStation;
import com.tridium.nd.alarm.BNiagaraAlarmDeviceExt;
import com.tridiumx.entsec.intrusion.BIntrusionZone;
import com.tridiumx.entsec.intrusion.BRemoteIntrusionResult;
import com.tridiumx.entsec.intrusion.BRemoteIntrusionSync;
import com.tridiumx.entsec.intrusion.fox.BIRemoteIntrusion;
import com.tridiumx.entsec.intrusion.fox.BNiagaraIntrusionDeviceExt;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUnrestrictedFolder;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="remoteStation", type="String", defaultValue="", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"alarm:RemoteStationFE\"), BFacets.UX_FIELD_EDITOR, BString.make(\"niagaraDriver:RemoteStationEditor\"))")}), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=3)})
@NiagaraAction(name="push")
public class BIntrusionGroupExt
extends BComponent {
    public static final Property remoteStation = BIntrusionGroupExt.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:RemoteStationFE"), (String)"uxFieldEditor", (BIDataValue)BString.make((String)"niagaraDriver:RemoteStationEditor")));
    public static final Property status = BIntrusionGroupExt.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Action push = BIntrusionGroupExt.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BIntrusionGroupExt.class);
    public static final Lexicon lex = Lexicon.make((String)"baja");
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"device.png"), (BIcon)BIcon.std((String)"badges/alarm.png"));
    private static final Logger log = Logger.getLogger("alarm");

    public String getRemoteStation() {
        return this.getString(remoteStation);
    }

    public void setRemoteStation(String v) {
        this.setString(remoteStation, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public void push() {
        this.invoke(push, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void setFault(BRemoteIntrusionResult result) {
        this.setStatus(BStatus.fault);
        String details = result.getRecord().getDetails();
        if (details.length() > 0) {
            details = details + ";";
        }
        result.getRecord().setDetails(details + "Niagara Station Missing: " + this.getRemoteStation());
    }

    public void setFault(BRemoteIntrusionSync sync) {
        this.setStatus(BStatus.fault);
        String details = sync.getRecord().getDetails();
        if (details.length() > 0) {
            details = details + ";";
        }
        sync.getRecord().setDetails(details + "Niagara Station Missing: " + this.getRemoteStation());
    }

    public void clearFault() {
        this.setStatus(BStatus.ok);
    }

    public BRemoteIntrusionSync sync(BRemoteIntrusionSync sync) {
        BIRemoteIntrusion ext = this.getRemoteIntrusionDeviceExt();
        if (ext == null) {
            this.setFault(sync);
            return sync;
        }
        this.clearFault();
        return ext.remoteSync(sync);
    }

    public void doPush() {
        BIRemoteIntrusion ext = this.getRemoteIntrusionDeviceExt();
        if (ext == null) {
            this.setStatus(BStatus.fault);
            return;
        }
        BNiagaraAlarmDeviceExt alarmExt = this.getNiagaraAlarmDeviceExt();
        if (alarmExt != null) {
            alarmExt.setAlarmClass("%alarmClass%");
        }
        this.clearFault();
        BUnrestrictedFolder v = new BUnrestrictedFolder();
        v.add(this.getParent().getName(), this.getParent().newCopy(true));
        ext.push(v);
        BIntrusionZone zone = (BIntrusionZone)this.getParent();
        zone.sync();
    }

    public BRemoteIntrusionResult allowingTimeForDisarm(BRemoteIntrusionResult result) {
        BIRemoteIntrusion ext = this.getRemoteIntrusionDeviceExt();
        if (ext == null) {
            this.setFault(result);
            return result;
        }
        this.clearFault();
        return ext.allowingTimeForDisarm(result);
    }

    public BRemoteIntrusionResult armingTest(BRemoteIntrusionResult result) {
        BIRemoteIntrusion ext = this.getRemoteIntrusionDeviceExt();
        if (ext == null) {
            this.setFault(result);
            return result;
        }
        this.clearFault();
        return ext.armingTest(result);
    }

    public BRemoteIntrusionResult forceArm(BRemoteIntrusionResult result) {
        BIRemoteIntrusion ext = this.getRemoteIntrusionDeviceExt();
        if (ext == null) {
            this.setFault(result);
            return result;
        }
        this.clearFault();
        return ext.forceArm(result);
    }

    public BRemoteIntrusionResult armingSequence(BRemoteIntrusionResult result) {
        BIRemoteIntrusion ext = this.getRemoteIntrusionDeviceExt();
        if (ext == null) {
            this.setFault(result);
            return result;
        }
        this.clearFault();
        return ext.armingSequence(result);
    }

    public BRemoteIntrusionResult disarm(BRemoteIntrusionResult result) {
        BIRemoteIntrusion ext = this.getRemoteIntrusionDeviceExt();
        if (ext == null) {
            this.setFault(result);
            return result;
        }
        this.clearFault();
        return ext.disarm(result);
    }

    public static final BIntrusionGroupExt getExt(BIntrusionZone iz, String stationName) {
        BIntrusionGroupExt[] exts = (BIntrusionGroupExt[])iz.getChildren(BIntrusionGroupExt.class);
        for (int i = 0; i < exts.length; ++i) {
            if (!exts[i].getRemoteStation().equals(stationName)) continue;
            return exts[i];
        }
        return null;
    }

    public static final BIntrusionGroupExt addExt(BIntrusionZone iz, String stationName) {
        BIntrusionGroupExt[] exts = (BIntrusionGroupExt[])iz.getChildren(BIntrusionGroupExt.class);
        for (int i = 0; i < exts.length; ++i) {
            if (!exts[i].getRemoteStation().equals(stationName)) continue;
            return exts[i];
        }
        BIntrusionGroupExt ext = new BIntrusionGroupExt();
        ext.setRemoteStation(stationName);
        iz.add(stationName, (BValue)ext);
        return ext;
    }

    public boolean isValid() {
        return this.getStation() != null;
    }

    public NiagaraStation getStation() {
        Type type = Sys.getType((String)"niagaraDriver:NiagaraNetwork");
        NiagaraNetwork network = (NiagaraNetwork)Sys.getService((Type)type);
        BComponent station = (BComponent)network.getStation(this.getRemoteStation());
        return (NiagaraStation)station;
    }

    private BIRemoteIntrusion getRemoteIntrusionDeviceExt() {
        BComponent station = (BComponent)this.getStation();
        if (station == null || !((BBoolean)station.get("enabled")).getBoolean()) {
            return null;
        }
        return (BIRemoteIntrusion)station.getMixIn(BNiagaraIntrusionDeviceExt.TYPE);
    }

    private BNiagaraAlarmDeviceExt getNiagaraAlarmDeviceExt() {
        BComponent station = (BComponent)this.getStation();
        if (station == null) {
            return null;
        }
        BNiagaraAlarmDeviceExt[] exts = (BNiagaraAlarmDeviceExt[])station.getChildren(BNiagaraAlarmDeviceExt.class);
        if (exts.length > 0) {
            return exts[0];
        }
        return null;
    }

    public BIcon getIcon() {
        return icon;
    }
}

