/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.filter;

import com.tridium.orion.priv.dt.BDynamicTable;
import com.tridium.orion.priv.dt.DTPrefilteringUtil;
import com.tridiumx.entsec.securityUtil.query.QueryUtil;
import javax.baja.query.BQuery;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.ui.options.BOptions;

public abstract class PrefilteringUtil
extends DTPrefilteringUtil {
    public static String PRE_FILTERING = "prefiltering";

    public static boolean getPrefiltering(BQuery query) {
        BBoolean bool = (BBoolean)query.get(PRE_FILTERING);
        if (bool == null) {
            return QueryUtil.getProvider(query).getPrefiltering(query);
        }
        return bool.getBoolean();
    }

    public static void setPrefiltering(BQuery query, boolean prefiltering) {
        if (query.get(PRE_FILTERING) == null) {
            query.add(PRE_FILTERING, (BValue)BBoolean.make((boolean)prefiltering));
        } else {
            query.set(PRE_FILTERING, (BValue)BBoolean.make((boolean)prefiltering));
        }
        if (PrefilteringUtil.isDefaultPrefiltering(query)) {
            PrefilteringUtil.removePrefiltering(query);
        }
    }

    public static boolean isDefaultPrefiltering(BQuery query) {
        BQuery defaultQuery = QueryUtil.makeQueryReset(query);
        return PrefilteringUtil.getPrefiltering(query) == PrefilteringUtil.getPrefiltering(defaultQuery);
    }

    public static void removePrefiltering(BQuery query) {
        if (query.get(PRE_FILTERING) != null) {
            query.remove(PRE_FILTERING);
        }
    }

    public static boolean getPrefiltering(BComponent container, BOptions options, String propName) {
        BBoolean col = (BBoolean)options.get(propName);
        if (col == null) {
            if (container instanceof BQuery) {
                return PrefilteringUtil.getPrefiltering((BQuery)container);
            }
            if (container instanceof BDynamicTable) {
                return PrefilteringUtil.getPrefiltering((BDynamicTable)((BDynamicTable)container));
            }
            throw new IllegalStateException("Container must be BQuery or BDynamicTable");
        }
        return col.getBoolean();
    }

    public static void setPrefiltering(boolean prefiltering, BOptions options, String propName) {
        BBoolean col = BBoolean.make((boolean)prefiltering);
        if (options.get(propName) == null) {
            options.add(propName, (BValue)col);
        } else {
            options.set(propName, (BValue)col);
        }
    }

    public static void removePrefiltering(BOptions options, String propName) {
        if (options.get(propName) != null) {
            options.remove(propName);
        }
    }
}

