/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.util.dbCache.data;

import com.tridiumx.entsec.access.orion.BAccReaderJoin;
import com.tridiumx.entsec.access.orion.BAccReaderRec;
import com.tridiumx.entsec.access.orion.BEntryReaderZoneJoin;
import com.tridiumx.entsec.access.orion.BExitReaderZoneJoin;
import com.tridiumx.entsec.access.util.dbCache.data.AbstractCacheData;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.baja.nre.util.Array;
import javax.baja.util.BUuid;

public class ReaderCacheData
extends AbstractCacheData {
    private static final BUuid[] EMPTY_BUUID_ARRAY = new BUuid[0];
    private static ReentrantReadWriteLock accessRightRWLock = new ReentrantReadWriteLock();
    private static ReentrantReadWriteLock entryZoneRWLock = new ReentrantReadWriteLock();
    private static ReentrantReadWriteLock exitZoneRWLock = new ReentrantReadWriteLock();
    private String readerName = "";
    private Map<BUuid, ReaderAccessRightCacheData> accessRightsMap = new HashMap<BUuid, ReaderAccessRightCacheData>();
    private Map<BUuid, EntryReaderZoneCacheData> entryZonesMap = new HashMap<BUuid, EntryReaderZoneCacheData>();
    private Map<BUuid, ExitReaderZoneCacheData> exitZonesMap = new HashMap<BUuid, ExitReaderZoneCacheData>();

    public ReaderCacheData() {
    }

    public ReaderCacheData(BAccReaderRec rec) {
        this.setReaderData(rec);
    }

    public ReaderCacheData(BAccReaderJoin readerAccJoin) {
        this.insertAccessRight(readerAccJoin);
    }

    public ReaderCacheData(BAccReaderRec rec, BAccReaderJoin readerAccJoin) {
        this.setReaderData(rec);
        this.insertAccessRight(readerAccJoin);
    }

    public ReaderCacheData(BEntryReaderZoneJoin readerZoneJoin) {
        this.insertEntryZone(readerZoneJoin);
    }

    public ReaderCacheData(BAccReaderRec rec, BEntryReaderZoneJoin readerZoneJoin) {
        this.setReaderData(rec);
        this.insertEntryZone(readerZoneJoin);
    }

    public ReaderCacheData(BExitReaderZoneJoin readerZoneJoin) {
        this.insertExitZone(readerZoneJoin);
    }

    public ReaderCacheData(BAccReaderRec rec, BExitReaderZoneJoin readerZoneJoin) {
        this.setReaderData(rec);
        this.insertExitZone(readerZoneJoin);
    }

    public void setReaderData(BAccReaderRec rec) {
        this.setReaderName(rec.getReaderName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertAccessRight(BAccReaderJoin readerAccJoin) {
        if (readerAccJoin != null && !readerAccJoin.isNull()) {
            ReaderCacheData.getWriteLock(accessRightRWLock);
            try {
                BUuid key = (BUuid)readerAccJoin.getAccessRight().getId();
                if (!this.containsAccessRight(key)) {
                    ReaderAccessRightCacheData data = new ReaderAccessRightCacheData(readerAccJoin);
                    this.addAccessRightEntry(key, data);
                }
            }
            finally {
                ReaderCacheData.releaseWriteLock(accessRightRWLock);
            }
        }
    }

    private void addAccessRightEntry(BUuid key, ReaderAccessRightCacheData data) {
        ReaderCacheData.getWriteLock(accessRightRWLock);
        try {
            if (!data.isEmpty()) {
                this.accessRightsMap.put(key, data);
            } else {
                this.deleteAccessRight(key);
            }
        }
        finally {
            ReaderCacheData.releaseWriteLock(accessRightRWLock);
        }
    }

    public void deleteAccessRight(BUuid accessRightUuid) {
        ReaderCacheData.getWriteLock(accessRightRWLock);
        try {
            this.accessRightsMap.remove(accessRightUuid);
        }
        finally {
            ReaderCacheData.releaseWriteLock(accessRightRWLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertEntryZone(BEntryReaderZoneJoin readerZoneJoin) {
        if (readerZoneJoin != null && !readerZoneJoin.isNull()) {
            ReaderCacheData.getWriteLock(entryZoneRWLock);
            try {
                BUuid key = (BUuid)readerZoneJoin.getAccessZone().getId();
                if (!this.containsEntryZone(key)) {
                    EntryReaderZoneCacheData data = new EntryReaderZoneCacheData(readerZoneJoin);
                    this.addEntryZoneEntry(key, data);
                }
            }
            finally {
                ReaderCacheData.releaseWriteLock(entryZoneRWLock);
            }
        }
    }

    private void addEntryZoneEntry(BUuid key, EntryReaderZoneCacheData data) {
        ReaderCacheData.getWriteLock(entryZoneRWLock);
        try {
            if (!data.isEmpty()) {
                this.entryZonesMap.put(key, data);
            } else {
                this.deleteEntryZone(key);
            }
        }
        finally {
            ReaderCacheData.releaseWriteLock(entryZoneRWLock);
        }
    }

    public void deleteEntryZone(BUuid accessZoneUuid) {
        ReaderCacheData.getWriteLock(entryZoneRWLock);
        try {
            this.entryZonesMap.remove(accessZoneUuid);
        }
        finally {
            ReaderCacheData.releaseWriteLock(entryZoneRWLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertExitZone(BExitReaderZoneJoin readerZoneJoin) {
        if (readerZoneJoin != null && !readerZoneJoin.isNull()) {
            ReaderCacheData.getWriteLock(exitZoneRWLock);
            try {
                BUuid key = (BUuid)readerZoneJoin.getAccessZone().getId();
                if (!this.containsExitZone(key)) {
                    ExitReaderZoneCacheData data = new ExitReaderZoneCacheData(readerZoneJoin);
                    this.addExitZoneEntry(key, data);
                }
            }
            finally {
                ReaderCacheData.releaseWriteLock(exitZoneRWLock);
            }
        }
    }

    private void addExitZoneEntry(BUuid key, ExitReaderZoneCacheData data) {
        ReaderCacheData.getWriteLock(exitZoneRWLock);
        try {
            if (!data.isEmpty()) {
                this.exitZonesMap.put(key, data);
            } else {
                this.deleteExitZone(key);
            }
        }
        finally {
            ReaderCacheData.releaseWriteLock(exitZoneRWLock);
        }
    }

    public void deleteExitZone(BUuid accessZoneUuid) {
        ReaderCacheData.getWriteLock(exitZoneRWLock);
        try {
            this.exitZonesMap.remove(accessZoneUuid);
        }
        finally {
            ReaderCacheData.releaseWriteLock(exitZoneRWLock);
        }
    }

    public String getReaderName() {
        return this.readerName;
    }

    public void setReaderName(String value) {
        this.readerName = value != null && value.length() > 0 ? value : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BUuid[] getAccessRightUuids() {
        ReaderCacheData.getReadLock(accessRightRWLock);
        try {
            if (this.accessRightsMap.isEmpty()) {
                BUuid[] bUuidArray = EMPTY_BUUID_ARRAY;
                return bUuidArray;
            }
            Array arr = new Array(BUuid.class);
            Set<Map.Entry<BUuid, ReaderAccessRightCacheData>> set = this.accessRightsMap.entrySet();
            for (Map.Entry<BUuid, ReaderAccessRightCacheData> me : set) {
                BUuid accessRightUuid = me.getKey();
                if (accessRightUuid == null || accessRightUuid.equals((Object)BUuid.DEFAULT)) continue;
                arr.add((Object)accessRightUuid);
            }
            BUuid[] bUuidArray = (BUuid[])arr.trim();
            return bUuidArray;
        }
        finally {
            ReaderCacheData.releaseReadLock(accessRightRWLock);
        }
    }

    public boolean containsAccessRight(BUuid key) {
        ReaderCacheData.getReadLock(accessRightRWLock);
        try {
            boolean bl = this.accessRightsMap.containsKey(key);
            return bl;
        }
        finally {
            ReaderCacheData.releaseReadLock(accessRightRWLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BUuid[] getEntryZoneUuids() {
        ReaderCacheData.getReadLock(entryZoneRWLock);
        try {
            if (this.entryZonesMap.isEmpty()) {
                BUuid[] bUuidArray = EMPTY_BUUID_ARRAY;
                return bUuidArray;
            }
            Array arr = new Array(BUuid.class);
            Set<Map.Entry<BUuid, EntryReaderZoneCacheData>> set = this.entryZonesMap.entrySet();
            for (Map.Entry<BUuid, EntryReaderZoneCacheData> me : set) {
                BUuid accessZoneUuid = me.getKey();
                if (accessZoneUuid == null || accessZoneUuid.equals((Object)BUuid.DEFAULT)) continue;
                arr.add((Object)accessZoneUuid);
            }
            BUuid[] bUuidArray = (BUuid[])arr.trim();
            return bUuidArray;
        }
        finally {
            ReaderCacheData.releaseReadLock(entryZoneRWLock);
        }
    }

    public boolean containsEntryZone(BUuid key) {
        ReaderCacheData.getReadLock(entryZoneRWLock);
        try {
            boolean bl = this.entryZonesMap.containsKey(key);
            return bl;
        }
        finally {
            ReaderCacheData.releaseReadLock(entryZoneRWLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BUuid[] getExitZoneUuids() {
        ReaderCacheData.getReadLock(exitZoneRWLock);
        try {
            if (this.exitZonesMap.isEmpty()) {
                BUuid[] bUuidArray = EMPTY_BUUID_ARRAY;
                return bUuidArray;
            }
            Array arr = new Array(BUuid.class);
            Set<Map.Entry<BUuid, ExitReaderZoneCacheData>> set = this.exitZonesMap.entrySet();
            for (Map.Entry<BUuid, ExitReaderZoneCacheData> me : set) {
                BUuid accessZoneUuid = me.getKey();
                if (accessZoneUuid == null || accessZoneUuid.equals((Object)BUuid.DEFAULT)) continue;
                arr.add((Object)accessZoneUuid);
            }
            BUuid[] bUuidArray = (BUuid[])arr.trim();
            return bUuidArray;
        }
        finally {
            ReaderCacheData.releaseReadLock(exitZoneRWLock);
        }
    }

    public boolean containsExitZone(BUuid key) {
        ReaderCacheData.getReadLock(exitZoneRWLock);
        try {
            boolean bl = this.exitZonesMap.containsKey(key);
            return bl;
        }
        finally {
            ReaderCacheData.releaseReadLock(exitZoneRWLock);
        }
    }

    public BAccReaderRec getReader(BUuid uuid) {
        BAccReaderRec reader = new BAccReaderRec();
        reader.setUuid(uuid);
        reader.setReaderName(this.getReaderName());
        reader.clearAllModified();
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printMap() {
        int i;
        BUuid[] uuids;
        ReaderCacheData.getReadLock(accessRightRWLock);
        try {
            uuids = this.getAccessRightUuids();
            if (uuids.length == 0) {
                System.out.println("    <No Access Rights>");
            } else {
                if (uuids.length == 1) {
                    System.out.println("    Access Right:");
                } else {
                    System.out.println("    Access Rights:");
                }
                for (i = 0; i < uuids.length; ++i) {
                    System.out.println("      " + uuids[i].toString());
                }
            }
        }
        finally {
            ReaderCacheData.releaseReadLock(accessRightRWLock);
        }
        ReaderCacheData.getReadLock(entryZoneRWLock);
        try {
            uuids = this.getEntryZoneUuids();
            if (uuids.length == 0) {
                System.out.println("    <No Entry Zones>");
            } else {
                if (uuids.length == 1) {
                    System.out.println("    Entry Zone:");
                } else {
                    System.out.println("    Entry Zones:");
                }
                for (i = 0; i < uuids.length; ++i) {
                    System.out.println("      " + uuids[i].toString());
                }
            }
        }
        finally {
            ReaderCacheData.releaseReadLock(entryZoneRWLock);
        }
        ReaderCacheData.getReadLock(exitZoneRWLock);
        try {
            uuids = this.getExitZoneUuids();
            if (uuids.length == 0) {
                System.out.println("    <No Exit Zones>");
            } else {
                if (uuids.length == 1) {
                    System.out.println("    Exit Zone:");
                } else {
                    System.out.println("    Exit Zones:");
                }
                for (i = 0; i < uuids.length; ++i) {
                    System.out.println("      " + uuids[i].toString());
                }
            }
        }
        finally {
            ReaderCacheData.releaseReadLock(exitZoneRWLock);
        }
    }

    private class ExitReaderZoneCacheData {
        private ExitReaderZoneCacheData(BExitReaderZoneJoin readerZoneJoin) {
            this.setData(readerZoneJoin);
        }

        private void setData(BExitReaderZoneJoin readerZoneJoin) {
        }

        private boolean isEmpty() {
            return false;
        }
    }

    private class EntryReaderZoneCacheData {
        private EntryReaderZoneCacheData(BEntryReaderZoneJoin readerZoneJoin) {
            this.setData(readerZoneJoin);
        }

        private void setData(BEntryReaderZoneJoin readerZoneJoin) {
        }

        private boolean isEmpty() {
            return false;
        }
    }

    private class ReaderAccessRightCacheData {
        private ReaderAccessRightCacheData(BAccReaderJoin readerAccJoin) {
            this.setData(readerAccJoin);
        }

        private void setData(BAccReaderJoin readerAccJoin) {
        }

        private boolean isEmpty() {
            return false;
        }
    }
}

