/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.util.dbCache.data;

import com.tridium.orion.BRef;
import com.tridium.orion.priv.model.BDynamicOrionObject;
import com.tridiumx.entsec.access.orion.BAccessRight;
import com.tridiumx.entsec.access.orion.BPersonAccJoin;
import com.tridiumx.entsec.access.util.dbCache.data.AbstractCacheData;
import com.tridiumx.entsec.threat.BThreatLevelEntry;
import com.tridiumx.entsec.threat.BThreatLevelOperationEnum;
import javax.baja.util.BUuid;

public class AccessRightCacheData
extends AbstractCacheData {
    private BUuid scheduleRecUuid = BUuid.DEFAULT;
    private BUuid niagaraIntegrationUuid = BUuid.DEFAULT;
    private BUuid threatLevelGroupUuid = BUuid.DEFAULT;
    private int assignedThreatLevel = -1;
    private BThreatLevelOperationEnum threatLevelOperation = BThreatLevelOperationEnum.normal;

    public AccessRightCacheData() {
    }

    public AccessRightCacheData(BAccessRight rec) {
        if (rec != null) {
            this.setData(rec);
        }
    }

    public AccessRightCacheData(BDynamicOrionObject rec) {
        if (rec != null) {
            this.setData(rec);
        }
    }

    public void setData(BAccessRight rec) {
        if (rec.getSchedule().isBound()) {
            this.setScheduleRecUuid((BUuid)rec.getSchedule().getId());
        } else {
            this.setScheduleRecUuid(BUuid.DEFAULT);
        }
        if (rec.getNiagaraIntegrationID().isBound()) {
            this.setNiagaraIntegrationUuid((BUuid)rec.getNiagaraIntegrationID().getId());
        } else {
            this.setNiagaraIntegrationUuid(BUuid.DEFAULT);
        }
        if (rec.getThreatLevelGroup().isBound()) {
            this.setThreatLevelGroupRecUuid((BUuid)rec.getThreatLevelGroup().getId());
            this.setThreatLevelOperation(rec.getThreatLevelOperation());
            this.setAssignedThreatLevel(rec.getDefaultAssignedThreatLevel().getOrdinal());
        } else {
            this.setThreatLevelGroupRecUuid(BUuid.DEFAULT);
        }
    }

    public void setData(BDynamicOrionObject rec) {
        BRef schedule = (BRef)rec.get(BAccessRight.schedule);
        BRef niagaraID = (BRef)rec.get(BAccessRight.niagaraIntegrationID);
        BRef threatLevelGroup = (BRef)rec.get(BAccessRight.threatLevelGroup);
        if (schedule.isBound()) {
            this.setScheduleRecUuid((BUuid)schedule.getId());
        }
        if (niagaraID.isBound()) {
            this.setNiagaraIntegrationUuid((BUuid)niagaraID.getId());
        }
        if (threatLevelGroup.isBound()) {
            this.setThreatLevelGroupRecUuid((BUuid)threatLevelGroup.getId());
            BThreatLevelOperationEnum accThreatEnum = (BThreatLevelOperationEnum)rec.get(BAccessRight.threatLevelOperation);
            BThreatLevelEntry accAssignedThreat = (BThreatLevelEntry)rec.get(BAccessRight.defaultAssignedThreatLevel);
            this.setThreatLevelOperation(accThreatEnum);
            this.setAssignedThreatLevel(accAssignedThreat.getOrdinal());
            BThreatLevelEntry joinAssignedThreat = (BThreatLevelEntry)rec.get(BPersonAccJoin.assignedThreatLevel);
            if (joinAssignedThreat.getOrdinal() != -1) {
                this.setAssignedThreatLevel(joinAssignedThreat.getOrdinal());
            }
        } else {
            this.setThreatLevelGroupRecUuid(BUuid.DEFAULT);
        }
    }

    public BUuid getThreatLevelGroupRecUuid() {
        return this.threatLevelGroupUuid;
    }

    public void setThreatLevelGroupRecUuid(BUuid uuid) {
        this.threatLevelGroupUuid = uuid != null && !uuid.isNull() ? uuid : BUuid.DEFAULT;
    }

    public int getAssignedThreatLevel() {
        return this.assignedThreatLevel;
    }

    public void setAssignedThreatLevel(int assignedThreatLevel) {
        this.assignedThreatLevel = assignedThreatLevel;
    }

    public BThreatLevelOperationEnum getThreatLevelOperation() {
        return this.threatLevelOperation;
    }

    public void setThreatLevelOperation(BThreatLevelOperationEnum threatLevelOperation) {
        this.threatLevelOperation = threatLevelOperation;
    }

    public BUuid getScheduleRecUuid() {
        return this.scheduleRecUuid;
    }

    public void setScheduleRecUuid(BUuid uuid) {
        this.scheduleRecUuid = uuid != null && !uuid.isNull() ? uuid : BUuid.DEFAULT;
    }

    public BUuid getNiagaraIntegrationUuid() {
        return this.niagaraIntegrationUuid;
    }

    public void setNiagaraIntegrationUuid(BUuid uuid) {
        this.niagaraIntegrationUuid = uuid != null && !uuid.isNull() ? uuid : BUuid.DEFAULT;
    }

    @Override
    public boolean isEmpty() {
        return this.scheduleRecUuid.equals((Object)BUuid.DEFAULT);
    }

    public AccessRightCacheData newCopy() {
        AccessRightCacheData data = new AccessRightCacheData();
        data.scheduleRecUuid = this.scheduleRecUuid;
        data.niagaraIntegrationUuid = this.niagaraIntegrationUuid;
        data.threatLevelGroupUuid = this.threatLevelGroupUuid;
        data.assignedThreatLevel = this.assignedThreatLevel;
        data.threatLevelOperation = this.threatLevelOperation;
        return data;
    }
}

