/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.util.dbCache;

import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridiumx.entsec.access.orion.BAccessZoneRec;
import com.tridiumx.entsec.access.util.dbCache.AbstractCache;
import com.tridiumx.entsec.access.util.dbCache.DbCache;
import com.tridiumx.entsec.access.util.dbCache.data.AccessZoneCacheData;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.baja.nre.util.Array;
import javax.baja.util.BUuid;

public abstract class AccessZoneCache
extends AbstractCache {
    private static final BAccessZoneRec[] EMPTY_ACCESS_ZONE_ARRAY = new BAccessZoneRec[0];
    private static ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private static Map<BUuid, AccessZoneCacheData> accessZonesMap = new HashMap<BUuid, AccessZoneCacheData>();

    public static void initAccessZones(DbCache dbCache, OrionSession session) {
        AccessZoneCache.getWriteLock(rwLock);
        try {
            accessZonesMap.clear();
        }
        finally {
            AccessZoneCache.releaseWriteLock(rwLock);
        }
        if (!dbCache.isRunningOnSupervisor()) {
            OrionCursor cursor = session.scan(BAccessZoneRec.ORION_TYPE);
            while (cursor.next()) {
                BAccessZoneRec rec = (BAccessZoneRec)cursor.get();
                AccessZoneCache.insertAccessZone(dbCache, rec);
            }
            cursor.close();
        }
    }

    public static void initAccessZones(DbCache dbCache, BAccessZoneRec[] accessZones) {
        AccessZoneCache.getWriteLock(rwLock);
        try {
            accessZonesMap.clear();
        }
        finally {
            AccessZoneCache.releaseWriteLock(rwLock);
        }
        if (!dbCache.isRunningOnSupervisor()) {
            for (int i = 0; i < accessZones.length; ++i) {
                AccessZoneCache.insertAccessZone(dbCache, accessZones[i]);
            }
        }
    }

    public static void insertAccessZone(DbCache dbCache, BAccessZoneRec rec) {
        if (!dbCache.isRunningOnSupervisor()) {
            AccessZoneCache.getWriteLock(rwLock);
            try {
                AccessZoneCacheData data = AccessZoneCache.getCacheData(rec.getUuid());
                if (data == null) {
                    data = new AccessZoneCacheData(rec);
                } else {
                    data.setData(rec);
                }
                AccessZoneCache.addMapEntry(rec.getUuid(), data);
            }
            finally {
                AccessZoneCache.releaseWriteLock(rwLock);
            }
        }
    }

    public static void updateAccessZone(DbCache dbCache, BAccessZoneRec rec) {
        if (!dbCache.isRunningOnSupervisor()) {
            AccessZoneCache.insertAccessZone(dbCache, rec);
        }
    }

    public static void deleteAccessZone(DbCache dbCache, OrionSession session, BAccessZoneRec accessZone) {
        if (!dbCache.isRunningOnSupervisor()) {
            AccessZoneCache.removeAccessZone(dbCache, session, accessZone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeAccessZone(DbCache dbCache, OrionSession session, BAccessZoneRec accessZone) {
        boolean objectExists = false;
        AccessZoneCache.getWriteLock(rwLock);
        try {
            objectExists = accessZonesMap.remove(accessZone.getUuid()) != null;
        }
        finally {
            AccessZoneCache.releaseWriteLock(rwLock);
        }
        if (objectExists) {
            dbCache.removeAccessZones(session, accessZone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BAccessZoneRec[] getAccessZones() {
        AccessZoneCache.getReadLock(rwLock);
        try {
            Set<Map.Entry<BUuid, AccessZoneCacheData>> set = accessZonesMap.entrySet();
            if (set.isEmpty()) {
                BAccessZoneRec[] bAccessZoneRecArray = EMPTY_ACCESS_ZONE_ARRAY;
                return bAccessZoneRecArray;
            }
            Array arr = new Array(BAccessZoneRec.class);
            for (Map.Entry<BUuid, AccessZoneCacheData> me : set) {
                BAccessZoneRec accessZone;
                AccessZoneCacheData data = me.getValue();
                if (data == null || (accessZone = data.getAccessZone(me.getKey())) == null) continue;
                arr.add((Object)accessZone);
            }
            BAccessZoneRec[] bAccessZoneRecArray = (BAccessZoneRec[])arr.trim();
            return bAccessZoneRecArray;
        }
        finally {
            AccessZoneCache.releaseReadLock(rwLock);
        }
    }

    public static BAccessZoneRec getAccessZone(BUuid accessZoneUuid) {
        AccessZoneCacheData cacheData = AccessZoneCache.getCacheData(accessZoneUuid);
        if (cacheData == null) {
            return null;
        }
        return cacheData.getAccessZone(accessZoneUuid);
    }

    public static int getAccessZonePersonCount(BUuid accessZoneUuid) {
        AccessZoneCacheData cacheData = AccessZoneCache.getCacheData(accessZoneUuid);
        if (cacheData == null) {
            return 0;
        }
        return cacheData.getPersonCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int incrementAccessZonePersonCount(BUuid accessZoneUuid) {
        AccessZoneCache.getWriteLock(rwLock);
        try {
            AccessZoneCacheData cacheData = AccessZoneCache.getCacheData(accessZoneUuid);
            if (cacheData == null) {
                int n = 0;
                return n;
            }
            int count = cacheData.getPersonCount() + 1;
            cacheData.setPersonCount(count);
            AccessZoneCache.addMapEntry(accessZoneUuid, cacheData);
            int n = count;
            return n;
        }
        finally {
            AccessZoneCache.releaseWriteLock(rwLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int decrementAccessZonePersonCount(BUuid accessZoneUuid) {
        AccessZoneCache.getWriteLock(rwLock);
        try {
            AccessZoneCacheData cacheData = AccessZoneCache.getCacheData(accessZoneUuid);
            if (cacheData == null) {
                int n = 0;
                return n;
            }
            int count = cacheData.getPersonCount();
            if (count == 0) {
                int n = 0;
                return n;
            }
            cacheData.setPersonCount(--count);
            AccessZoneCache.addMapEntry(accessZoneUuid, cacheData);
            int n = count;
            return n;
        }
        finally {
            AccessZoneCache.releaseWriteLock(rwLock);
        }
    }

    public static int getAccessZoneSupervisorCount(BUuid accessZoneUuid) {
        AccessZoneCacheData cacheData = AccessZoneCache.getCacheData(accessZoneUuid);
        if (cacheData == null) {
            return 0;
        }
        return cacheData.getSupervisorCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int incrementAccessZoneSupervisorCount(BUuid accessZoneUuid) {
        AccessZoneCache.getWriteLock(rwLock);
        try {
            AccessZoneCacheData cacheData = AccessZoneCache.getCacheData(accessZoneUuid);
            if (cacheData == null) {
                int n = 0;
                return n;
            }
            int count = cacheData.getSupervisorCount() + 1;
            cacheData.setSupervisorCount(count);
            AccessZoneCache.addMapEntry(accessZoneUuid, cacheData);
            int n = count;
            return n;
        }
        finally {
            AccessZoneCache.releaseWriteLock(rwLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int decrementAccessZoneSupervisorCount(BUuid accessZoneUuid) {
        AccessZoneCache.getWriteLock(rwLock);
        try {
            AccessZoneCacheData cacheData = AccessZoneCache.getCacheData(accessZoneUuid);
            if (cacheData == null) {
                int n = 0;
                return n;
            }
            int count = cacheData.getSupervisorCount();
            if (count == 0) {
                int n = 0;
                return n;
            }
            cacheData.setSupervisorCount(--count);
            AccessZoneCache.addMapEntry(accessZoneUuid, cacheData);
            int n = count;
            return n;
        }
        finally {
            AccessZoneCache.releaseWriteLock(rwLock);
        }
    }

    private static AccessZoneCacheData getCacheData(BUuid key) {
        if (key == null) {
            return null;
        }
        AccessZoneCache.getReadLock(rwLock);
        try {
            AccessZoneCacheData accessZoneCacheData = accessZonesMap.get(key);
            return accessZoneCacheData;
        }
        finally {
            AccessZoneCache.releaseReadLock(rwLock);
        }
    }

    private static void addMapEntry(BUuid key, AccessZoneCacheData data) {
        AccessZoneCache.getWriteLock(rwLock);
        try {
            if (!data.isEmpty()) {
                accessZonesMap.put(key, data);
            } else {
                accessZonesMap.remove(key);
            }
        }
        finally {
            AccessZoneCache.releaseWriteLock(rwLock);
        }
    }

    public static int getSize() {
        AccessZoneCache.getReadLock(rwLock);
        try {
            int n = accessZonesMap.size();
            return n;
        }
        finally {
            AccessZoneCache.releaseReadLock(rwLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printMap() {
        AccessZoneCache.getReadLock(rwLock);
        try {
            System.out.println("Access Zone Cache: " + AccessZoneCache.getSize() + " Record(s)");
            Set<Map.Entry<BUuid, AccessZoneCacheData>> set = accessZonesMap.entrySet();
            if (set.isEmpty()) {
                System.out.println("  <empty>\n");
                return;
            }
            for (Map.Entry<BUuid, AccessZoneCacheData> me : set) {
                BUuid key = me.getKey();
                System.out.println("  Access Zone: " + key.toString());
                AccessZoneCacheData data = me.getValue();
                System.out.println("    Name: " + data.getZoneName());
            }
            System.out.println("");
        }
        finally {
            AccessZoneCache.releaseReadLock(rwLock);
        }
    }
}

