/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.util;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridiumx.entsec.access.orion.BAccessZoneRec;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.sys.Clock;

public abstract class CleanupUtil {
    private static Logger entsecLog = Logger.getLogger("entsec");

    public static void cleanupAfterReplication(OrionSession session) throws Exception {
        long tick0 = Clock.ticks();
        BAccessZoneRec.recountCache(session);
        long tickZ = Clock.ticks();
        if (entsecLog.isLoggable(Level.FINE)) {
            entsecLog.fine("cleanupAfterReplication: final" + (tickZ - tick0));
        }
    }

    public static void cleanupOrphanedRecords(OrionSession session) throws Exception {
        long tick0 = Clock.ticks();
        if (RemoteUtil.isSubordinate()) {
            OrionCursor c = session.scan(BBadge.ORION_TYPE);
            while (c.next()) {
                BBadge badge = (BBadge)c.get();
                if (badge.validOnSubordinate(session)) continue;
                session.delete((BIOrionObject)badge);
            }
            c = session.scan(BPerson.ORION_TYPE);
            while (c.next()) {
                BPerson person = (BPerson)c.get();
                if (person.validOnSubordinate(session)) continue;
                session.delete((BIOrionObject)person);
            }
        }
        long tickZ = Clock.ticks();
        if (entsecLog.isLoggable(Level.FINE)) {
            entsecLog.fine("cleanup: final" + (tickZ - tick0));
        }
    }
}

