/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.ui.orion;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionSession;
import com.tridiumx.entsec.access.orion.BAccessRight;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.access.orion.BInfoTemplate;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.access.orion.BPersonInfo;
import com.tridiumx.entsec.orionTools.ui.BAppView;
import com.tridiumx.entsec.orionTools.ui.BJoinFE;
import com.tridiumx.entsec.orionTools.ui.BOrionSummary;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"entsec:Person"}, requiredPermissions="r")})
public class BPersonView
extends BAppView {
    public static final Type TYPE = Sys.loadType(BPersonView.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    protected void doLoadValue(BObject o, Context cx) throws Exception {
        BPersonView.addExtraPersonInfo((BPerson)o, cx);
        super.doLoadValue(o, cx);
    }

    @Override
    protected BObject doSaveValue(BObject o, Context cx) throws Exception {
        BObject returnValue = super.doSaveValue(o, cx);
        BPersonView.saveAdditionalPersonInfo((BPerson)returnValue, cx);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addExtraPersonInfo(BPerson person, Context cx) {
        OrionSession session = null;
        try {
            session = person.getOrionDatabase().createSession(null);
            BPersonInfo personInfo = person.getPersonInfo(session);
            BInfoTemplate[] infoTemplates = BInfoTemplate.getOrderedInfoTemplates(session);
            for (int i = 0; i < infoTemplates.length; ++i) {
                BInfoTemplate infoTemplate = infoTemplates[i];
                String value = infoTemplate.getDefaultValue();
                int id = infoTemplate.getInfoTemplateId();
                if (personInfo != null) {
                    value = personInfo.getValue(infoTemplate);
                }
                if (person.get(SlotPath.escape((String)infoTemplate.getInfoTemplateName())) == null) {
                    person.add(infoTemplate.getInfoTemplateName(), (BValue)BString.make((String)value));
                } else {
                    person.set(SlotPath.escape((String)infoTemplate.getInfoTemplateName()), (BValue)BString.make((String)value));
                }
                if (!infoTemplate.getMultiLine() && !infoTemplate.getSmartSense()) continue;
                Property p = person.getProperty(SlotPath.escape((String)infoTemplate.getInfoTemplateName()));
                BFacets facets = person.getSlotFacets((Slot)p);
                if (infoTemplate.getMultiLine()) {
                    facets = BFacets.make((BFacets)facets, (String)"multiLine", (BIDataValue)BBoolean.TRUE);
                }
                person.setFacets((Slot)p, facets);
            }
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAdditionalPersonInfo(BPerson person, Context cx) {
        OrionSession session = null;
        try {
            session = person.getOrionDatabase().createSession(cx);
            BPersonInfo personInfo = person.getPersonInfo(session);
            if (personInfo == null) {
                personInfo = new BPersonInfo();
                personInfo.setPerson(BRef.make((BIOrionObject)person));
            }
            BInfoTemplate[] infoTemplates = BInfoTemplate.getOrderedInfoTemplates(session);
            for (int i = 0; i < infoTemplates.length; ++i) {
                BInfoTemplate infoTemplate = infoTemplates[i];
                String value = person.get(SlotPath.escape((String)infoTemplate.getInfoTemplateName())).toString();
                if (value.equals(personInfo.getValue(infoTemplate).toString())) continue;
                personInfo.setValue(infoTemplate, value);
            }
            if (personInfo.isDefault(session)) {
                if (session.exists((BIOrionObject)personInfo)) {
                    session.delete((BIOrionObject)personInfo);
                }
            } else if (session.exists((BIOrionObject)personInfo)) {
                session.update((BIOrionObject)personInfo);
            } else {
                session.insert((BIOrionObject)personInfo);
            }
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    @Override
    public BWbFieldEditor[] getFieldEditors(BIOrionObject o) {
        try {
            BAccessRight accessRight = new BAccessRight();
            BBadge badge = new BBadge();
            Array editors = new Array(BWbFieldEditor.class);
            editors.add((Object)new BJoinFE(BAccessRight.ORION_TYPE.getOrionTypeId()));
            editors.add((Object)new BJoinFE(BBadge.ORION_TYPE.getOrionTypeId()));
            return (BWbFieldEditor[])editors.trim();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new BWbFieldEditor[0];
        }
    }

    @Override
    public BWidget getSummaryWidget(BComponent c) {
        BPerson person = (BPerson)c;
        BOrionSummary summary = new BOrionSummary();
        summary.setReadonly(true);
        summary.loadValue((BObject)person);
        return summary;
    }
}

