/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.ui.orion;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionSession;
import com.tridiumx.entsec.access.dyntable.BBadges;
import com.tridiumx.entsec.access.orion.BAccReaderRec;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.access.orion.BWiegandFormat;
import com.tridiumx.entsec.access.ui.fieldeditors.BBadgePickerFE;
import com.tridiumx.entsec.access.ui.orion.BBadgeView;
import com.tridiumx.entsec.orionTools.ui.BAppView;
import com.tridiumx.entsec.orionTools.ui.BJoinFE;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbView;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="readerModified"), @NiagaraAction(name="acceptedFormatChanged")})
public class BEnrollBadgeView
extends BBadgeView {
    public static final Action readerModified = BEnrollBadgeView.newAction((int)0, null);
    public static final Action acceptedFormatChanged = BEnrollBadgeView.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BEnrollBadgeView.class);
    String propertyName = null;
    BBadges badges = null;
    BRef lastEnrollment = null;
    RemoteSubscriber subscriber = null;

    public void readerModified() {
        this.invoke(readerModified, null, null);
    }

    public void acceptedFormatChanged() {
        this.invoke(acceptedFormatChanged, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void stopped() throws Exception {
        super.stopped();
        if (this.subscriber != null) {
            this.subscriber.unsubscribeAll();
            this.subscriber = null;
        }
        if (this.badges != null) {
            this.badges.endSubscription();
            this.badges = null;
        }
    }

    @Override
    protected void doLoadValue(BObject o, Context cx) throws Exception {
        this.lastEnrollment = null;
        this.addEnrollInfo((BBadge)o, cx);
        super.doLoadValue(o, cx);
        BBadge badge = (BBadge)o;
        BWbFieldEditor editor = this.accessEditor.getFieldSheet().getEditor(badge.getProperty("enrollmentReader"));
        this.linkTo((BComponent)editor, (Slot)BWbPlugin.setModified, (Slot)readerModified);
        editor = this.accessEditor.getFieldSheet().getEditor(badge.getProperty("acceptableFormats"));
        if (editor != null) {
            this.linkTo((BComponent)editor, (Slot)BWbPlugin.setModified, (Slot)acceptedFormatChanged);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAcceptedFormatChanged(Context cx) throws Exception {
        BBadge badge = (BBadge)this.getCurrentValue();
        BBadgePickerFE fe = (BBadgePickerFE)this.accessEditor.getFieldSheet().getEditor(badge.getProperty("acceptableFormats"));
        int index = fe.list.getSelectedIndex();
        if (index == -1 || fe.list.getItemCount() == 0) {
            this.accessEditor.getFieldSheet().getEditor(BBadge.credential).loadValue((BObject)BString.DEFAULT);
            this.accessEditor.getFieldSheet().getEditor(BBadge.facilityCode).loadValue((BObject)BString.DEFAULT);
            this.accessEditor.getFieldSheet().getEditor(BBadge.wiegandFormat).loadValue((BObject)BRef.make((BTypeSpec)BWiegandFormat.TYPE.getTypeSpec()), (Context)BBadge.wiegandFormat.getFacets());
            return;
        }
        String lastBadgeRead = this.accessEditor.getFieldSheet().getEditor(badge.getProperty("scannedBadge")).saveValue(cx).toString();
        BOrionDatabase db = badge.getOrionDatabase();
        OrionSession session = null;
        try {
            session = db.createSession(null);
            BBadge[] newBadges = BWiegandFormat.getUnknownBadgeInfo(lastBadgeRead, session);
            BBadge currentBadge = newBadges[index];
            this.accessEditor.getFieldSheet().getEditor(BBadge.credential).loadValue((BObject)BString.make((String)currentBadge.getCredential()));
            this.accessEditor.getFieldSheet().getEditor(BBadge.facilityCode).loadValue((BObject)BString.make((String)currentBadge.getFacilityCode()));
            this.accessEditor.getFieldSheet().getEditor(BBadge.wiegandFormat).loadValue((BObject)currentBadge.getWiegandFormat(), (Context)BFacets.DEFAULT);
            this.accessEditor.getFieldSheet().getEditor(BBadge.wiegandFormat).setModified();
            this.accessEditor.getFieldSheet().getEditor(BBadge.credential).setModified();
            this.accessEditor.getFieldSheet().getEditor(BBadge.facilityCode).setModified();
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    public void doReaderModified(Context cx) throws Exception {
        BBadge badge = (BBadge)this.getCurrentValue();
        BRef ref = (BRef)this.accessEditor.getFieldSheet().getEditor(badge.getProperty("enrollmentReader")).saveValue(cx);
        BWbView view = this.getWbShell().getActiveView();
        if (this.badges == null) {
            this.badges = (BBadges)this.getWbShell().getActiveOrd().get();
        }
        BString prop = this.badges.subscribeToRemoteReader(ref);
        this.propertyName = prop.toString();
        this.badges.getComponentSpace().sync();
        String lastBadgeRead = this.badges.get(this.propertyName).toString();
        if (this.subscriber == null) {
            this.subscriber = new RemoteSubscriber();
            this.subscriber.subscribe((BComponent)this.badges);
        }
        this.lastBadgeReadChanged(lastBadgeRead);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lastBadgeReadChanged(String lastBadgeRead) throws Exception {
        BBadge badge = (BBadge)this.getCurrentValue();
        BOrionDatabase db = badge.getOrionDatabase();
        OrionSession session = null;
        try {
            session = db.createSession(null);
            BBadge newBadge = new BBadge();
            newBadge.setBadgeId(lastBadgeRead);
            BBadge dbBadge = (BBadge)session.read((BIOrionObject)newBadge);
            BBadgePickerFE acceptableEditor = (BBadgePickerFE)this.accessEditor.getFieldSheet().getEditor(badge.getProperty("acceptableFormats"));
            this.accessEditor.getFieldSheet().getEditor(badge.getProperty("scannedBadge")).loadValue((BObject)BString.make((String)lastBadgeRead));
            if (lastBadgeRead.length() == 0) {
                this.accessEditor.getFieldSheet().getEditor(badge.getProperty("acceptableFormats")).loadValue((BObject)new BVector());
                this.doAcceptedFormatChanged(null);
                return;
            }
            if (dbBadge != null) {
                this.accessEditor.getFieldSheet().getEditor(badge.getProperty("enrollmentStatus")).loadValue((BObject)BString.make((String)("Badge Already Exists:  " + dbBadge.toDisplayString(null))));
                this.accessEditor.getFieldSheet().getEditor(badge.getProperty("acceptableFormats")).loadValue((BObject)new BVector());
                this.doAcceptedFormatChanged(null);
                return;
            }
            this.accessEditor.getFieldSheet().getEditor(badge.getProperty("enrollmentStatus")).loadValue((BObject)BString.DEFAULT);
            BBadge[] newBadges = BWiegandFormat.getUnknownBadgeInfo(lastBadgeRead, session);
            if (newBadges.length == 1 && !newBadges[0].getWiegandFormat().isBound()) {
                this.accessEditor.getFieldSheet().getEditor(badge.getProperty("acceptableFormats")).loadValue((BObject)new BVector());
                this.doAcceptedFormatChanged(null);
                return;
            }
            BVector v = new BVector();
            for (int i = 0; i < newBadges.length; ++i) {
                v.add(null, (BValue)BString.make((String)BEnrollBadgeView.getFormatDescription(newBadges[i], session)));
            }
            acceptableEditor.list.setSelectedIndex(-1);
            acceptableEditor.loadValue((BObject)v);
            if (newBadges.length == 1) {
                acceptableEditor.list.setSelectedIndex(0);
            } else {
                acceptableEditor.list.setSelectedIndex(-1);
            }
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    public static String getFormatDescription(BBadge badge, OrionSession session) {
        BWiegandFormat format = badge.resolveWiegandFormat(session);
        return badge.toString() + " " + format.getWiegandFormatName();
    }

    public void addEnrollInfo(BBadge badge, Context cx) {
        Property[] props = new Property[]{BBadge.credential, BBadge.facilityCode, BBadge.wiegandFormat};
        BAppView.setReadonly(badge, props);
        badge.setCredential("");
        badge.setFacilityCode("");
        if (badge.getProperty("acceptableFormats") == null) {
            badge.add("acceptableFormats", (BValue)new BVector(), 0, BFacets.make((String)"fieldEditor", (String)"entsec:BadgePickerFE"), null);
        }
        if (badge.getProperty("enrollmentStatus") == null) {
            badge.add("enrollmentStatus", (BValue)BString.make((String)""), 1, BFacets.DEFAULT, null);
        }
        if (badge.getProperty("scannedBadge") == null) {
            badge.add("scannedBadge", (BValue)BString.make((String)""), 1, BFacets.DEFAULT, null);
        }
        if (badge.getProperty("enrollmentReader") == null) {
            badge.add("enrollmentReader", (BValue)BRef.make((BOrionTypeId)BAccReaderRec.ORION_TYPE.getOrionTypeId()), 0, BFacets.make((String)"allowNull", (BIDataValue)BBoolean.TRUE), null);
        }
    }

    @Override
    public BWbFieldEditor[] getFieldEditors(BIOrionObject o) {
        return new BWbFieldEditor[]{new BJoinFE(BPerson.ORION_TYPE.getOrionTypeId())};
    }

    class RemoteSubscriber
    extends Subscriber {
        public void event(BComponentEvent event) {
            if (event.getSourceComponent() == this.getSubscriptions()[0] && event.getId() == 0 && event.getSlotName().equals(BEnrollBadgeView.this.propertyName)) {
                try {
                    BEnrollBadgeView.this.lastBadgeReadChanged(event.getValue().toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

