/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.schema;

import com.tridium.orion.BIOrionApp;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BSchemaVersion;
import com.tridium.orion.ISchemaUpgrader;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.sql.BatchStatement;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.orion.BAccReaderRec;
import com.tridiumx.entsec.orionTools.SchemaUpgradeSupport;
import java.util.logging.Level;
import javax.baja.rdb.ddl.AddColumn;
import javax.baja.rdb.ddl.DdlCommand;

public class Upgrade_1_15_to_1_16
implements ISchemaUpgrader {
    private static final BSchemaVersion FROM_VERSION = BAccessControlService.VERSION_1_15;
    private static final BSchemaVersion TO_VERSION = BAccessControlService.VERSION_1_16;

    public BSchemaVersion getFromVersion() {
        return FROM_VERSION;
    }

    public BSchemaVersion getToVersion() {
        return TO_VERSION;
    }

    public void upgrade(BLocalOrionDatabase db, BIOrionApp app, OrionSession session) throws Exception {
        try {
            AddColumn addColumn = SchemaUpgradeSupport.addColumnAsLastProperty(BAccReaderRec.ORION_TYPE, BAccReaderRec.readerTypeSpec, db);
            session.invokeDdl((DdlCommand)addColumn);
            addColumn = SchemaUpgradeSupport.addColumnAsLastProperty(BAccReaderRec.ORION_TYPE, BAccReaderRec.remoteDeviceName, db);
            session.invokeDdl((DdlCommand)addColumn);
            this.updateRemoteDeviceName(session);
            SchemaUpgradeSupport.dropIndex((BOrionDatabase)db, session, BAccReaderRec.ORION_TYPE, db.getIndexName(BAccReaderRec.ORION_TYPE, BAccReaderRec.stationName));
        }
        catch (Exception e) {
            BAccessControlService.LOG.log(Level.SEVERE, "Upgrade_1_15_to_1_16 Schema Upgrade either not needed or failed", e);
        }
    }

    private void updateRemoteDeviceName(OrionSession session) {
        OrionCursor cursor = session.scan(BAccReaderRec.ORION_TYPE);
        BatchStatement readerRecUpdater = session.batchUpdate(BAccReaderRec.ORION_TYPE);
        while (cursor.next()) {
            BAccReaderRec readerRec = (BAccReaderRec)cursor.get();
            if (!readerRec.getRemoteDeviceName().equals("")) continue;
            readerRec.setRemoteDeviceName(readerRec.getStationName());
            readerRecUpdater.add((BIOrionObject)readerRec);
        }
        readerRecUpdater.execute();
    }
}

