/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.schema;

import com.tridium.orion.BIOrionApp;
import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.BSchemaVersion;
import com.tridium.orion.ISchemaUpgrader;
import com.tridium.orion.OrionSession;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.orion.BAccessRightLdapGroupJoin;
import com.tridiumx.entsec.access.orion.BBadgeLdapServerJoin;
import com.tridiumx.entsec.access.orion.BLdapGroup;
import com.tridiumx.entsec.access.orion.BLdapServer;
import com.tridiumx.entsec.access.orion.BPersonLdapServerJoin;
import com.tridiumx.entsec.orionTools.SchemaUpgradeSupport;
import java.util.logging.Level;
import javax.baja.rdb.ddl.DdlCommand;

public class Upgrade_1_12_to_1_13
implements ISchemaUpgrader {
    private static final BSchemaVersion FROM_VERSION = BAccessControlService.VERSION_1_12;
    private static final BSchemaVersion TO_VERSION = BAccessControlService.VERSION_1_13;

    public BSchemaVersion getFromVersion() {
        return FROM_VERSION;
    }

    public BSchemaVersion getToVersion() {
        return TO_VERSION;
    }

    public void upgrade(BLocalOrionDatabase db, BIOrionApp biOrionApp, OrionSession session) throws Exception {
        try {
            this.createLdapServerTable(db, session);
            this.createPersonLdapServerMappingTable(db, session);
            this.createBadgeLdapServerMappingTable(db, session);
            this.createLdapGroupTable(db, session);
            this.createAccessRightLdapGroupJoinTable(db, session);
        }
        catch (Exception e) {
            BAccessControlService.LOG.log(Level.SEVERE, "Upgrade_1_12_to_1_13 Schema Upgrade either not needed or failed", e);
        }
    }

    private void createLdapGroupTable(BLocalOrionDatabase db, OrionSession session) {
        DdlCommand[] ddl = SchemaUpgradeSupport.createTable(BLdapGroup.ORION_TYPE, db);
        for (int i = 0; i < ddl.length; ++i) {
            session.invokeDdl(ddl[i]);
        }
    }

    private void createAccessRightLdapGroupJoinTable(BLocalOrionDatabase db, OrionSession session) {
        DdlCommand[] ddl = SchemaUpgradeSupport.createTable(BAccessRightLdapGroupJoin.ORION_TYPE, db);
        for (int i = 0; i < ddl.length; ++i) {
            session.invokeDdl(ddl[i]);
        }
    }

    private void createPersonLdapServerMappingTable(BLocalOrionDatabase db, OrionSession session) {
        DdlCommand[] ddl = SchemaUpgradeSupport.createTable(BPersonLdapServerJoin.ORION_TYPE, db);
        for (int i = 0; i < ddl.length; ++i) {
            session.invokeDdl(ddl[i]);
        }
    }

    private void createLdapServerTable(BLocalOrionDatabase db, OrionSession session) {
        DdlCommand[] ddl = SchemaUpgradeSupport.createTable(BLdapServer.ORION_TYPE, db);
        for (int i = 0; i < ddl.length; ++i) {
            session.invokeDdl(ddl[i]);
        }
    }

    private void createBadgeLdapServerMappingTable(BLocalOrionDatabase db, OrionSession session) {
        DdlCommand[] ddl = SchemaUpgradeSupport.createTable(BBadgeLdapServerJoin.ORION_TYPE, db);
        for (int i = 0; i < ddl.length; ++i) {
            session.invokeDdl(ddl[i]);
        }
    }

    static {
        SchemaUpgradeSupport.skipConvertTimestampToLong(BLdapServer.ORION_TYPE, BLdapServer.lastModified);
        SchemaUpgradeSupport.skipConvertTimestampToLong(BLdapServer.ORION_TYPE, BLdapServer.lastSyncDate);
        SchemaUpgradeSupport.skipConvertTimestampToLong(BPersonLdapServerJoin.ORION_TYPE, BPersonLdapServerJoin.lastModified);
        SchemaUpgradeSupport.skipConvertTimestampToLong(BBadgeLdapServerJoin.ORION_TYPE, BBadgeLdapServerJoin.lastModified);
        SchemaUpgradeSupport.skipConvertTimestampToLong(BLdapGroup.ORION_TYPE, BLdapGroup.lastModified);
        SchemaUpgradeSupport.skipConvertTimestampToLong(BAccessRightLdapGroupJoin.ORION_TYPE, BAccessRightLdapGroupJoin.lastModified);
        SchemaUpgradeSupport.skipConvertTimestampToLong(BLdapServer.ORION_TYPE, BLdapServer.lastModified);
        SchemaUpgradeSupport.skipConvertTimestampToLong(BLdapServer.ORION_TYPE, BLdapServer.lastSyncDate);
        SchemaUpgradeSupport.skipConvertTimestampToLong(BPersonLdapServerJoin.ORION_TYPE, BPersonLdapServerJoin.lastModified);
        SchemaUpgradeSupport.skipConvertTimestampToLong(BBadgeLdapServerJoin.ORION_TYPE, BBadgeLdapServerJoin.lastModified);
        SchemaUpgradeSupport.skipConvertTimestampToLong(BLdapGroup.ORION_TYPE, BLdapGroup.lastModified);
        SchemaUpgradeSupport.skipConvertTimestampToLong(BAccessRightLdapGroupJoin.ORION_TYPE, BAccessRightLdapGroupJoin.lastModified);
    }
}

