/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.schema;

import com.tridium.rdb.aes.AesSysKeyEncoder;
import com.tridiumx.entsec.access.schema.exception.RetainInvalidPinException;
import java.security.AccessController;
import javax.baja.security.BPassword;

abstract class PinConverter {
    PinConverter() {
    }

    public abstract String convert(AesSysKeyEncoder var1, String var2) throws Exception;

    protected String getKeyAlias() {
        return "entsec:";
    }

    protected String getNullPassword(AesSysKeyEncoder aesSysKeyEncoder) throws Exception {
        BPassword defaultPassword = BPassword.DEFAULT;
        String value = defaultPassword != null ? AccessController.doPrivileged(() -> ((BPassword)defaultPassword).getValue()) : "";
        return aesSysKeyEncoder.encrypt(value);
    }

    public boolean isNullifyInvalidPins() {
        return AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.nullifyInvalidPins"));
    }

    protected String nullifyInvalidPins(AesSysKeyEncoder encoder) throws Exception {
        if (this.isNullifyInvalidPins()) {
            return this.getNullPassword(encoder);
        }
        throw new RetainInvalidPinException("Retain Invalid pin in DB as is");
    }
}

