/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.query;

import com.tridium.entsecDriver.BIIOPoint;
import com.tridium.util.CompUtil;
import com.tridiumx.accessDriver.BAccessNetwork;
import com.tridiumx.accessDriver.BAccessReader;
import com.tridiumx.accessDriver.BIAccessDevice;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.securityUtil.query.QueryUtil;
import com.tridiumx.entsec.securityUtil.query.TypeSpecPath;
import com.tridiumx.entsec.securityUtil.query.consolidated.BConsolidatedQuery;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BNullProxyExt;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BExpression;
import javax.baja.query.expression.BFunctionExpression;
import javax.baja.query.util.Funcs;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType
public class BInputs
extends BConsolidatedQuery {
    public static final Type TYPE = Sys.loadType(BInputs.class);
    private static final BIcon icon = BIcon.std((String)"control/booleanPoint.png");

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() {
        super.started();
        if (this.get("base") == null) {
            this.add("base", (BValue)this.getComponentSpace().getRootComponent().getSlotPathOrd());
        } else {
            this.set("base", (BValue)this.getComponentSpace().getRootComponent().getSlotPathOrd());
        }
        QueryUtil.makeQuery(this, BControlPoint.TYPE.getTypeSpec());
        Property p = this.getProperty("extent");
        if (!Flags.isReadonly((BComplex)this, (Slot)p)) {
            this.setFlags((Slot)p, this.getFlags((Slot)p) | 1);
        }
        BFunctionExpression exp = Funcs.make((String)"entsec:Inputs.isInput", (Type)BBoolean.TYPE, (BExpression[])new BExpression[0]);
        this.where(Predicates.eq((BExpression)exp, (BSimple)BBoolean.TRUE));
    }

    public static BObject isInput(BObject target) {
        try {
            if (target instanceof BIIOPoint && ((BIIOPoint)target).isInputPoint()) {
                return BBoolean.TRUE;
            }
            if (target instanceof BControlPoint && CompUtil.closestAncestor((BComplex)((BControlPoint)target), BAccessNetwork.class).isPresent()) {
                BControlPoint point = (BControlPoint)target;
                if (point.isWritablePoint() || Flags.isHidden((BComplex)point.getParent(), (Slot)point.getPropertyInParent()) || point.getParent() instanceof BAccessReader || point.getProxyExt() instanceof BNullProxyExt) {
                    return BBoolean.FALSE;
                }
                return BBoolean.TRUE;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return BBoolean.FALSE;
    }

    @Override
    public TypeSpecPath[] getDefaultColumns() {
        TypeSpecPath[] result = new TypeSpecPath[4];
        Lexicon lex = BAccessControlService.lex;
        result[0] = new TypeSpecPath(BString.TYPE.getTypeSpec(), "displayName", lex.getText("hardware.inputs.description"));
        result[1] = new TypeSpecPath(BInteger.TYPE.getTypeSpec(), "proxyExt.instance", lex.getText("hardware.inputs.termination"));
        BFunctionExpression exp = Funcs.make((String)"entsec:Inputs.getModuleName", (Type)BString.TYPE, (BExpression[])new BExpression[0]);
        result[2] = new TypeSpecPath(BString.TYPE.getTypeSpec(), "module", lex.getText("hardware.inputs.module"), (BExpression)exp);
        result[3] = new TypeSpecPath(BString.TYPE.getTypeSpec(), "toString", lex.getText("hardware.inputs.status"));
        return result;
    }

    @Override
    public String getOptionsKey() {
        String key = super.getOptionsKey();
        return "ConsolidatedInputs" + key;
    }

    public static BObject getModuleName(BObject target) {
        if (!target.isComplex()) {
            return null;
        }
        if (target instanceof BIIOPoint) {
            return ((BIIOPoint)target).getDeviceDisplayName();
        }
        if (CompUtil.closestAncestor((BComplex)((BControlPoint)target), BAccessNetwork.class).isPresent()) {
            for (BComplex parent = target.asComplex().getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof BIAccessDevice)) continue;
                return BString.make((String)parent.getDisplayName(null));
            }
        }
        return null;
    }

    @Override
    public BTypeSpec[] subordinateServiceTypes() {
        return new BTypeSpec[]{BAccessNetwork.TYPE.getTypeSpec()};
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }
}

