/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.orion;

import com.tridium.orion.BIOrionAssociation;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.annotations.NiagaraOrionType;
import com.tridium.orion.annotations.OrionProperties;
import com.tridium.orion.annotations.OrionProperty;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.orion.BAccessRight;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.orionTools.replicate.BReplicableObject;
import com.tridiumx.entsec.threat.BThreatLevelEntry;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraOrionType
@OrionProperties(value={@OrionProperty(name="person", refType="entsec:Person", facets={@Facet(name="KEY", value="true"), @Facet(name="ON_DELETE", value="BOnDelete.CASCADE")}), @OrionProperty(name="accessRight", refType="entsec:AccessRight", facets={@Facet(name="KEY", value="true"), @Facet(name="ON_DELETE", value="BOnDelete.CASCADE")})})
@NiagaraProperties(value={@NiagaraProperty(name="startDate", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"entsec:EffectiveDateFE\")")}), @NiagaraProperty(name="endDate", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"entsec:EffectiveDateFE\")")}), @NiagaraProperty(name="assignedThreatLevel", type="BThreatLevelEntry", defaultValue="BThreatLevelEntry.make(ThreatLevelUtil.NO_THREAT_LEVEL_JOIN_ASSIGNMENT)", facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"entsec:ActiveThreatLevelRangeFE\""), @Facet(name="BFacets.ALLOW_NULL", value="true")})})
public class BPersonAccJoin
extends BReplicableObject
implements BIOrionAssociation {
    public static final Property person = BPersonAccJoin.newProperty((int)0, (BValue)BRef.make((String)"entsec:Person"), (BFacets)BFacets.make((BFacets)BFacets.make((String)"key", (boolean)true), (BFacets)BFacets.make((String)"onDelete", (int)1)));
    public static final Property accessRight = BPersonAccJoin.newProperty((int)0, (BValue)BRef.make((String)"entsec:AccessRight"), (BFacets)BFacets.make((BFacets)BFacets.make((String)"key", (boolean)true), (BFacets)BFacets.make((String)"onDelete", (int)1)));
    public static final Property startDate = BPersonAccJoin.newProperty((int)0, (BValue)BAbsTime.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"entsec:EffectiveDateFE")));
    public static final Property endDate = BPersonAccJoin.newProperty((int)0, (BValue)BAbsTime.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"entsec:EffectiveDateFE")));
    public static final Property assignedThreatLevel = BPersonAccJoin.newProperty((int)0, (BValue)BThreatLevelEntry.make(-1), (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:ActiveThreatLevelRangeFE"), (BFacets)BFacets.make((String)"allowNull", (boolean)true)));
    public static final Type TYPE = Sys.loadType(BPersonAccJoin.class);
    public static final OrionType ORION_TYPE = (OrionType)TYPE;

    public BRef getPerson() {
        return (BRef)this.get(person);
    }

    public void setPerson(BRef v) {
        this.set(person, (BValue)v, null);
    }

    public BPerson resolvePerson(OrionSession session) {
        return (BPerson)this.getPerson().getTarget(session);
    }

    public BRef getAccessRight() {
        return (BRef)this.get(accessRight);
    }

    public void setAccessRight(BRef v) {
        this.set(accessRight, (BValue)v, null);
    }

    public BAccessRight resolveAccessRight(OrionSession session) {
        return (BAccessRight)this.getAccessRight().getTarget(session);
    }

    public BAbsTime getStartDate() {
        return (BAbsTime)this.get(startDate);
    }

    public void setStartDate(BAbsTime v) {
        this.set(startDate, (BValue)v, null);
    }

    public BAbsTime getEndDate() {
        return (BAbsTime)this.get(endDate);
    }

    public void setEndDate(BAbsTime v) {
        this.set(endDate, (BValue)v, null);
    }

    public BThreatLevelEntry getAssignedThreatLevel() {
        return (BThreatLevelEntry)this.get(assignedThreatLevel);
    }

    public void setAssignedThreatLevel(BThreatLevelEntry v) {
        this.set(assignedThreatLevel, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return this.getTypeFromSpace(TYPE);
    }

    public String toString(Context cx) {
        return "" + this.getPerson() + ";" + this.getAccessRight();
    }

    @Override
    public void afterInsert(OrionSession session) {
        super.afterInsert(session);
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        service.getDbCache().insertPersonAccessRight(this);
        BEnterpriseSecurityService.threatReplicationRequired();
    }

    @Override
    public void afterUpdate(OrionSession session) {
        super.afterUpdate(session);
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        service.getDbCache().updatePersonAccessRight(this);
    }

    @Override
    public void afterDelete(OrionSession session) {
        super.afterDelete(session);
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        service.getDbCache().deletePersonAccessRight(this);
        BEnterpriseSecurityService.threatReplicationRequired();
    }
}

