/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.orion;

import com.tridium.json.JSONObject;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.Index;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.annotations.NiagaraOrionType;
import com.tridium.orion.annotations.OrionIndex;
import com.tridium.orion.annotations.OrionLinkedCursor;
import com.tridium.orion.annotations.OrionProperty;
import com.tridium.orion.annotations.OrionRefCursor;
import com.tridium.orion.annotations.OrionRefCursors;
import com.tridium.orion.priv.fox.FoxOrionSession;
import com.tridium.orion.priv.util.CountingUtil;
import com.tridium.orion.sql.PropertyValue;
import com.tridium.rdb.aes.AesSysKeyEncoder;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.orion.BAccessRight;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.access.orion.BPersonAccJoin;
import com.tridiumx.entsec.access.orion.BPersonInfo;
import com.tridiumx.entsec.access.orion.BPersonLdapServerJoin;
import com.tridiumx.entsec.access.orion.BPersonZoneJoin;
import com.tridiumx.entsec.access.orion.BSupervisorZoneJoin;
import com.tridiumx.entsec.isom.ICompatibleWithIsom;
import com.tridiumx.entsec.orionTools.BISummaryImage;
import com.tridiumx.entsec.orionTools.BITenantObject;
import com.tridiumx.entsec.orionTools.BTenant;
import com.tridiumx.entsec.orionTools.MergeSupport;
import com.tridiumx.entsec.orionTools.replicate.BReplicableObject;
import com.tridiumx.entsec.photoID.orion.BPersonPortrait;
import java.security.AccessController;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.gx.BImage;
import javax.baja.license.LicenseException;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.rdb.ddl.BClustered;
import javax.baja.security.BAbstractPasswordEncoder;
import javax.baja.security.BPassword;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraOrionType
@OrionRefCursors(value={@OrionRefCursor(name="Badges", type="BBadge", ref="owner"), @OrionRefCursor(name="PersonInfos", type="BPersonInfo", ref="person"), @OrionRefCursor(name="PersonPortraits", type="BPersonPortrait", ref="person"), @OrionRefCursor(name="PersonLdapServerJoins", type="BPersonLdapServerJoin", ref="person")})
@OrionLinkedCursor(name="AccessRights", type="BAccessRight", link="BPersonAccJoin")
@OrionIndex(name="PersonName", unique=false, clustered="BClustered.unspecified", fields={"lastName", "firstName"})
@NiagaraProperties(value={@NiagaraProperty(name="personId", type="BUuid", defaultValue="BUuid.NULL", flags=1, facets={@Facet(name="KEY", value="true")}), @NiagaraProperty(name="lastName", type="String", defaultValue="", flags=8, facets={@Facet(name="WIDTH", value="30"), @Facet(name="DISPLAY_ID", value="true"), @Facet(name="ALLOW_NULL", value="false")}), @NiagaraProperty(name="firstName", type="String", defaultValue="", flags=8, facets={@Facet(name="WIDTH", value="30"), @Facet(name="DISPLAY_ID", value="true")}), @NiagaraProperty(name="middleInitial", type="String", defaultValue="", facets={@Facet(name="WIDTH", value="5")}), @NiagaraProperty(name="employeeId", type="String", defaultValue="", facets={@Facet(name="WIDTH", value="30")}), @NiagaraProperty(name="department", type="String", defaultValue="", flags=8, facets={@Facet(name="WIDTH", value="30"), @Facet(name="BFacets.FIELD_EDITOR", value="\"entsec:SmartStringFE\"")}), @NiagaraProperty(name="personType", type="String", defaultValue="", flags=8, facets={@Facet(name="WIDTH", value="30"), @Facet(name="BFacets.FIELD_EDITOR", value="\"entsec:SmartStringFE\"")}), @NiagaraProperty(name="supervisor", type="boolean", defaultValue="false"), @NiagaraProperty(name="pinNumber", type="BPassword", defaultValue="BPassword.DEFAULT", facets={@Facet(name="WIDTH", value="255"), @Facet(name="BPinFE.UI_WIDTH", value="8"), @Facet(name="BFacets.FIELD_EDITOR", value="\"entsec:PinFE\""), @Facet(name="BPinFE.ALLOW_ZERO", value="true")}), @NiagaraProperty(name="traceCard", type="boolean", defaultValue="false", facets={@Facet(name="BFacets.TRUE_TEXT", value="BPerson.lex.getText(\"traceOn\")"), @Facet(name="BFacets.FALSE_TEXT", value="BPerson.lex.getText(\"traceOff\")")})})
@OrionProperty(name="tenant", refType="entsec:Tenant", flags=8, facets={@Facet(name="ON_DELETE", value="BOnDelete.NO_ACTION"), @Facet(name="ALLOW_NULL", value="true")})
public class BPerson
extends BReplicableObject
implements BITenantObject,
BISummaryImage,
ICompatibleWithIsom {
    static final Lexicon lex = Lexicon.make(BBadge.class);
    public static final Property personId = BPerson.newProperty((int)1, (BValue)BUuid.NULL, (BFacets)BFacets.make((String)"key", (boolean)true));
    public static final Property lastName = BPerson.newProperty((int)8, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"width", (int)30), (BFacets)BFacets.make((String)"displayId", (boolean)true)), (BFacets)BFacets.make((String)"allowNull", (boolean)false)));
    public static final Property firstName = BPerson.newProperty((int)8, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"width", (int)30), (BFacets)BFacets.make((String)"displayId", (boolean)true)));
    public static final Property middleInitial = BPerson.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"width", (int)5));
    public static final Property employeeId = BPerson.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"width", (int)30));
    public static final Property department = BPerson.newProperty((int)8, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"width", (int)30), (BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:SmartStringFE")));
    public static final Property personType = BPerson.newProperty((int)8, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"width", (int)30), (BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:SmartStringFE")));
    public static final Property tenant = BPerson.newProperty((int)8, (BValue)BRef.make((String)"entsec:Tenant"), (BFacets)BFacets.make((BFacets)BFacets.make((String)"onDelete", (int)0), (BFacets)BFacets.make((String)"allowNull", (boolean)true)));
    public static final Property supervisor = BPerson.newProperty((int)0, (boolean)false, null);
    public static final Property pinNumber = BPerson.newProperty((int)0, (BValue)BPassword.DEFAULT, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"width", (int)255), (BFacets)BFacets.make((String)"uiWidth", (int)8)), (BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:PinFE")), (BFacets)BFacets.make((String)"allowZero", (boolean)true)));
    public static final Property traceCard = BPerson.newProperty((int)0, (boolean)false, (BFacets)BFacets.make((BFacets)BFacets.make((String)"trueText", (String)lex.getText("traceOn")), (BFacets)BFacets.make((String)"falseText", (String)lex.getText("traceOff"))));
    private static final Index[] INDEXES = new Index[]{new Index("PersonName", false, BClustered.unspecified, new Property[]{lastName, firstName}, new boolean[2])};
    public static final Type TYPE = Sys.loadType(BPerson.class);
    public static final OrionType ORION_TYPE = (OrionType)TYPE;
    public static final BIcon ICON = BIcon.make((String)"module://entsec/rc/access/people.png");
    public static final int LAST_NAME_LENGTH_LIMIT = 30;
    public static final int FIRST_NAME_LENGTH_LIMIT = 30;
    public static final int MIDDLE_INITIAL_LENGTH_LIMIT = 5;
    public static final int EMPLOYEE_ID_LENGTH_LIMIT = 30;
    public static final int PIN_LENGTH_LIMIT = 9;
    public static final int SINGLE_LINE_COLUMN_LENGTH_LIMIT = 30;
    private static int count = -1;
    private static int maxLicenseLimit = -1;
    private Logger log = Logger.getLogger("entsec");

    public BUuid getPersonId() {
        return (BUuid)this.get(personId);
    }

    public void setPersonId(BUuid v) {
        this.set(personId, (BValue)v, null);
    }

    public String getLastName() {
        return this.getString(lastName);
    }

    public void setLastName(String v) {
        this.setString(lastName, v, null);
    }

    public String getFirstName() {
        return this.getString(firstName);
    }

    public void setFirstName(String v) {
        this.setString(firstName, v, null);
    }

    public String getMiddleInitial() {
        return this.getString(middleInitial);
    }

    public void setMiddleInitial(String v) {
        this.setString(middleInitial, v, null);
    }

    public String getEmployeeId() {
        return this.getString(employeeId);
    }

    public void setEmployeeId(String v) {
        this.setString(employeeId, v, null);
    }

    public String getDepartment() {
        return this.getString(department);
    }

    public void setDepartment(String v) {
        this.setString(department, v, null);
    }

    public String getPersonType() {
        return this.getString(personType);
    }

    public void setPersonType(String v) {
        this.setString(personType, v, null);
    }

    @Override
    public BRef getTenant() {
        return (BRef)this.get(tenant);
    }

    public void setTenant(BRef v) {
        this.set(tenant, (BValue)v, null);
    }

    public BTenant resolveTenant(OrionSession session) {
        return (BTenant)this.getTenant().getTarget(session);
    }

    public boolean getSupervisor() {
        return this.getBoolean(supervisor);
    }

    public void setSupervisor(boolean v) {
        this.setBoolean(supervisor, v, null);
    }

    public BPassword getPinNumber() {
        return (BPassword)this.get(pinNumber);
    }

    public void setPinNumber(BPassword v) {
        this.set(pinNumber, (BValue)v, null);
    }

    public boolean getTraceCard() {
        return this.getBoolean(traceCard);
    }

    public void setTraceCard(boolean v) {
        this.setBoolean(traceCard, v, null);
    }

    public BadgesCursor getBadges(OrionSession session) {
        return new BadgesCursor(session.select(BBadge.ORION_TYPE, new PropertyValue(BBadge.owner, (BValue)BRef.make((BIOrionObject)this))));
    }

    public PersonInfosCursor getPersonInfos(OrionSession session) {
        return new PersonInfosCursor(session.select(BPersonInfo.ORION_TYPE, new PropertyValue(BPersonInfo.person, (BValue)BRef.make((BIOrionObject)this))));
    }

    public PersonPortraitsCursor getPersonPortraits(OrionSession session) {
        return new PersonPortraitsCursor(session.select(BPersonPortrait.ORION_TYPE, new PropertyValue(BPersonPortrait.person, (BValue)BRef.make((BIOrionObject)this))));
    }

    public PersonLdapServerJoinsCursor getPersonLdapServerJoins(OrionSession session) {
        return new PersonLdapServerJoinsCursor(session.select(BPersonLdapServerJoin.ORION_TYPE, new PropertyValue(BPersonLdapServerJoin.person, (BValue)BRef.make((BIOrionObject)this))));
    }

    public AccessRightsCursor getAccessRights(OrionSession session) {
        return new AccessRightsCursor(session.linkedScan((BIOrionObject)this, BPersonAccJoin.ORION_TYPE, BAccessRight.ORION_TYPE));
    }

    public Index[] getIndexes() {
        return INDEXES;
    }

    @Override
    public Type getType() {
        return this.getTypeFromSpace(TYPE);
    }

    @Override
    public boolean beforeInsert(OrionSession session) {
        BPerson.checkInsert(session);
        return super.beforeInsert(session);
    }

    @Override
    public boolean beforeDelete(OrionSession session) {
        MergeSupport.setReferencesToNull((BIOrionObject)this, session);
        return super.beforeDelete(session);
    }

    public BPersonInfo getPersonInfo(OrionSession session) {
        PersonInfosCursor c = this.getPersonInfos(session);
        if (c.next()) {
            return (BPersonInfo)c.get();
        }
        return null;
    }

    public BPersonPortrait getPersonPortrait(OrionSession session) {
        PersonPortraitsCursor c = this.getPersonPortraits(session);
        if (c.next()) {
            return (BPersonPortrait)c.get();
        }
        return null;
    }

    public BPersonLdapServerJoin getPersonLdapServerJoin(OrionSession session) {
        PersonLdapServerJoinsCursor c = this.getPersonLdapServerJoins(session);
        if (c.next()) {
            return (BPersonLdapServerJoin)c.get();
        }
        return null;
    }

    public String toDisplayString(Context cx) {
        if (this.getLastName().length() > 0 && this.getFirstName().length() > 0) {
            return super.toDisplayString(cx);
        }
        if (this.getLastName().length() > 0) {
            return this.getLastName();
        }
        return this.getFirstName();
    }

    public boolean validOnSubordinate(OrionSession session) throws Exception {
        int count = CountingUtil.getCount((OrionType)BPersonAccJoin.ORION_TYPE, (Property)BPersonAccJoin.person, (BSimple)BRef.make((BIOrionObject)this), (OrionSession)session);
        if (count > 0) {
            return true;
        }
        count = CountingUtil.getCount((OrionType)BSupervisorZoneJoin.ORION_TYPE, (Property)BSupervisorZoneJoin.person, (BSimple)BRef.make((BIOrionObject)this), (OrionSession)session);
        if (count > 0) {
            return true;
        }
        count = CountingUtil.getCount((OrionType)BPersonZoneJoin.ORION_TYPE, (Property)BPersonZoneJoin.person, (BSimple)BRef.make((BIOrionObject)this), (OrionSession)session);
        return count > 0;
    }

    @Override
    public void afterInsert(OrionSession session) {
        this.confirmInsert();
        super.afterInsert(session);
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        service.getDbCache().insertPerson(this);
    }

    @Override
    public void afterUpdate(OrionSession session) {
        super.afterUpdate(session);
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        service.getDbCache().updatePerson(this, true);
    }

    @Override
    public void afterDelete(OrionSession session) {
        this.confirmDelete();
        super.afterDelete(session);
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        service.getDbCache().deletePerson(this);
    }

    @Override
    public Property getTenantProperty() {
        return tenant;
    }

    @Override
    public BImage getSummaryImage(OrionSession session) {
        if (session.getOrionDatabase().getType(BPersonPortrait.ORION_TYPE) == null) {
            return BImage.DEFAULT;
        }
        BPersonPortrait personPortrait = this.getPersonPortrait(session);
        if (personPortrait == null) {
            return BImage.DEFAULT;
        }
        if (session instanceof FoxOrionSession) {
            return BImage.make((byte[])personPortrait.getImage().copyBytes());
        }
        return BImage.make((BOrd)personPortrait.getImageOrd());
    }

    public static void checkInsert(OrionSession session) {
        if (maxLicenseLimit == -1) {
            String limit = ((BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE)).getCredentialLimit();
            if (limit == null) {
                limit = "0";
            }
            maxLicenseLimit = limit.equals("none") ? -2 : Integer.parseInt(limit);
        }
        if (maxLicenseLimit == -2) {
            return;
        }
        boolean orionCounted = false;
        if (count < 0) {
            count = CountingUtil.getCount((OrionType)ORION_TYPE, (OrionSession)session);
            orionCounted = true;
        }
        if (count + 1 > maxLicenseLimit) {
            if (!orionCounted) {
                count = CountingUtil.getCount((OrionType)ORION_TYPE, (OrionSession)session);
            }
            if (count + 1 > maxLicenseLimit) {
                throw new LicenseException("Credential License Limit Reached: " + maxLicenseLimit);
            }
        }
    }

    private void confirmInsert() {
        ++count;
    }

    private void confirmDelete() {
        --count;
    }

    public BIcon getIcon() {
        return ICON;
    }

    @Override
    public void fromJson(JSONObject jsonObject) throws Exception {
        if (jsonObject != null) {
            for (String key : jsonObject.keySet()) {
                if (key.equalsIgnoreCase("Name")) {
                    this.setFirstName(jsonObject.get(key).toString());
                }
                if (!key.equalsIgnoreCase("LastName")) continue;
                this.setLastName(jsonObject.get(key).toString());
            }
        }
    }

    @Override
    public JSONObject getJSON(OrionSession orionSession) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", (Object)this.getPersonId().encodeToString());
        this.setPropertyInfo(jsonObject, "Name", this.getFirstName());
        this.setPropertyInfo(jsonObject, "LastName", this.getLastName());
        this.setPropertyInfo(jsonObject, "MiddleInitial", this.getMiddleInitial());
        this.setPropertyInfo(jsonObject, "Department", this.getDepartment());
        this.setPropertyInfo(jsonObject, "EmployeeId", this.getEmployeeId());
        this.setPropertyInfo(jsonObject, "PersonType", this.getPersonType());
        BPersonInfo personInfo = this.getPersonInfo(orionSession);
        if (personInfo != null) {
            this.setPropertyInfo(jsonObject, "ContactNo", personInfo.getInfo0());
            this.setPropertyInfo(jsonObject, "EmailId", personInfo.getInfo1());
            this.setPropertyInfo(jsonObject, "PhotoRef", personInfo.getInfo2());
            this.setPropertyInfo(jsonObject, "externalSystemID", personInfo.getInfo3());
        }
        return jsonObject;
    }

    private void setPropertyInfo(JSONObject jsonObject, String propertyName, String propertyValue) {
        if (propertyValue != null && propertyValue.trim().length() > 0) {
            jsonObject.put(propertyName, (Object)propertyValue);
        }
    }

    @Override
    public BOrionObject[] getRefObject(OrionSession orionSession, Type refObj) {
        BOrionObject[] returnObjects = null;
        if (refObj.is(BAccessRight.TYPE)) {
            returnObjects = (BOrionObject[])this.getAccessRights(orionSession).toArray();
        }
        return returnObjects;
    }

    @Override
    public BOrionObject[] associateObject(BOrionObject[] orionObjects) {
        BPersonAccJoin join = null;
        Array accessRightsArray = new Array(BPersonAccJoin.class);
        for (int i = 0; i < orionObjects.length; ++i) {
            BOrionObject bOrionObject = orionObjects[i];
            join = new BPersonAccJoin();
            join.setPerson(BRef.make((BIOrionObject)this));
            join.setAccessRight(BRef.make((BIOrionObject)bOrionObject));
            accessRightsArray.add((Object)join);
        }
        return (BOrionObject[])accessRightsArray.trim();
    }

    @Override
    public boolean hasAdditionalInfo() {
        return true;
    }

    @Override
    public BOrionObject getAdditionalInfoOrionObjects(OrionSession orionSession) {
        return this.getPersonInfo(orionSession);
    }

    @Override
    public BOrionObject getAdditionalInfoOrionObjectsFromJson(JSONObject jsonObject) {
        BPersonInfo personInfo = null;
        if (this.hasAdditionalInfoInJSON(jsonObject)) {
            personInfo = new BPersonInfo();
            personInfo.fromJson(jsonObject);
            personInfo.setPerson(BRef.make((BIOrionObject)this));
        }
        return personInfo;
    }

    private boolean hasAdditionalInfoInJSON(JSONObject jsonObject) {
        return jsonObject.has("ContactNo") || jsonObject.has("EmailId") || jsonObject.has("PhotoRef") || jsonObject.has("externalSystemID");
    }

    public String encryptPinNumber(AesSysKeyEncoder aesSysKeyEncoder) {
        String encryptedStringValue = "";
        try {
            encryptedStringValue = aesSysKeyEncoder.encrypt(AccessController.doPrivileged(() -> ((BAbstractPasswordEncoder)this.getPinNumber().getPasswordEncoder()).getValue()));
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Encrypt pin exception", e);
        }
        return encryptedStringValue;
    }

    public boolean isPinNumberInteger() throws Exception {
        return this.isInteger(AccessController.doPrivileged(() -> ((BPassword)this.getPinNumber()).getValue()));
    }

    public boolean isInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Map<String, BObject> removeReferenceObject() {
        return null;
    }

    @Override
    public void addReferenceObject(Map<String, BObject> ref) {
    }

    public static class AccessRightsCursor
    implements OrionCursor {
        private final OrionCursor cursor;

        private AccessRightsCursor(OrionCursor cursor) {
            this.cursor = cursor;
        }

        public Context getContext() {
            return this.cursor.getContext();
        }

        public OrionType getOrionType() {
            return this.cursor.getOrionType();
        }

        public BIOrionObject[] toArray() {
            return this.cursor.toArray();
        }

        public boolean next() {
            return this.cursor.next();
        }

        public boolean nextComponent() {
            return this.cursor.nextComponent();
        }

        public boolean next(Class<?> cls) {
            return this.cursor.next(cls);
        }

        public BObject get() {
            return (BObject)this.cursor.get();
        }

        public OrionSession getSession() {
            return this.cursor.getSession();
        }

        public void close() {
            this.cursor.close();
        }

        public BAccessRight getAccessRight() {
            return (BAccessRight)this.cursor.get();
        }
    }

    public static class PersonLdapServerJoinsCursor
    implements OrionCursor {
        private final OrionCursor cursor;

        private PersonLdapServerJoinsCursor(OrionCursor cursor) {
            this.cursor = cursor;
        }

        public Context getContext() {
            return this.cursor.getContext();
        }

        public OrionType getOrionType() {
            return this.cursor.getOrionType();
        }

        public BIOrionObject[] toArray() {
            return this.cursor.toArray();
        }

        public boolean next() {
            return this.cursor.next();
        }

        public boolean nextComponent() {
            return this.cursor.nextComponent();
        }

        public boolean next(Class<?> cls) {
            return this.cursor.next(cls);
        }

        public BObject get() {
            return (BObject)this.cursor.get();
        }

        public OrionSession getSession() {
            return this.cursor.getSession();
        }

        public void close() {
            this.cursor.close();
        }

        public BPersonLdapServerJoin getPersonLdapServerJoin() {
            return (BPersonLdapServerJoin)((Object)this.cursor.get());
        }
    }

    public static class PersonPortraitsCursor
    implements OrionCursor {
        private final OrionCursor cursor;

        private PersonPortraitsCursor(OrionCursor cursor) {
            this.cursor = cursor;
        }

        public Context getContext() {
            return this.cursor.getContext();
        }

        public OrionType getOrionType() {
            return this.cursor.getOrionType();
        }

        public BIOrionObject[] toArray() {
            return this.cursor.toArray();
        }

        public boolean next() {
            return this.cursor.next();
        }

        public boolean nextComponent() {
            return this.cursor.nextComponent();
        }

        public boolean next(Class<?> cls) {
            return this.cursor.next(cls);
        }

        public BObject get() {
            return (BObject)this.cursor.get();
        }

        public OrionSession getSession() {
            return this.cursor.getSession();
        }

        public void close() {
            this.cursor.close();
        }

        public BPersonPortrait getPersonPortrait() {
            return (BPersonPortrait)this.cursor.get();
        }
    }

    public static class PersonInfosCursor
    implements OrionCursor {
        private final OrionCursor cursor;

        private PersonInfosCursor(OrionCursor cursor) {
            this.cursor = cursor;
        }

        public Context getContext() {
            return this.cursor.getContext();
        }

        public OrionType getOrionType() {
            return this.cursor.getOrionType();
        }

        public BIOrionObject[] toArray() {
            return this.cursor.toArray();
        }

        public boolean next() {
            return this.cursor.next();
        }

        public boolean nextComponent() {
            return this.cursor.nextComponent();
        }

        public boolean next(Class<?> cls) {
            return this.cursor.next(cls);
        }

        public BObject get() {
            return (BObject)this.cursor.get();
        }

        public OrionSession getSession() {
            return this.cursor.getSession();
        }

        public void close() {
            this.cursor.close();
        }

        public BPersonInfo getPersonInfo() {
            return (BPersonInfo)this.cursor.get();
        }
    }

    public static class BadgesCursor
    implements OrionCursor {
        private final OrionCursor cursor;

        private BadgesCursor(OrionCursor cursor) {
            this.cursor = cursor;
        }

        public Context getContext() {
            return this.cursor.getContext();
        }

        public OrionType getOrionType() {
            return this.cursor.getOrionType();
        }

        public BIOrionObject[] toArray() {
            return this.cursor.toArray();
        }

        public boolean next() {
            return this.cursor.next();
        }

        public boolean nextComponent() {
            return this.cursor.nextComponent();
        }

        public boolean next(Class<?> cls) {
            return this.cursor.next(cls);
        }

        public BObject get() {
            return (BObject)this.cursor.get();
        }

        public OrionSession getSession() {
            return this.cursor.getSession();
        }

        public void close() {
            this.cursor.close();
        }

        public BBadge getBadge() {
            return (BBadge)this.cursor.get();
        }
    }
}

