/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.orion;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.annotations.NiagaraOrionType;
import com.tridium.orion.annotations.OrionLinkedCursor;
import com.tridium.orion.annotations.OrionLinkedCursors;
import com.tridium.orion.priv.model.BDynamicOrionObject;
import com.tridium.orion.priv.util.CountingUtil;
import com.tridium.orion.sql.BJoin;
import com.tridium.orion.sql.BSqlExtent;
import com.tridium.orion.sql.BSqlField;
import com.tridium.orion.sql.BSqlJoin;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.orion.sql.SqlColumns;
import com.tridiumx.accessDriver.enums.BEnforcementEnum;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.BAccessZone;
import com.tridiumx.entsec.access.BMappedZoneExt;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.access.orion.BPersonZoneJoin;
import com.tridiumx.entsec.access.orion.BSupervisorZoneJoin;
import com.tridiumx.entsec.orionTools.BIOrdMappable;
import com.tridiumx.entsec.orionTools.MappingSupport;
import com.tridiumx.entsec.orionTools.replicate.BReplicableObject;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BExpression;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.BQuery;
import javax.baja.query.util.Funcs;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;

@NiagaraType(agent={@AgentOn(types={"entsec:AccessZone"})})
@NiagaraOrionType
@OrionLinkedCursors(value={@OrionLinkedCursor(name="Occupants", type="BPerson", link="BPersonZoneJoin"), @OrionLinkedCursor(name="Supervisors", type="BPerson", link="BSupervisorZoneJoin")})
@NiagaraProperties(value={@NiagaraProperty(name="uuid", type="BUuid", defaultValue="BUuid.NULL", flags=1, facets={@Facet(name="KEY", value="true")}), @NiagaraProperty(name="zoneName", type="String", defaultValue="", flags=9, facets={@Facet(name="WIDTH", value="128"), @Facet(name="DISPLAY_ID", value="true")}), @NiagaraProperty(name="stationName", type="String", defaultValue="", flags=9, facets={@Facet(name="WIDTH", value="64"), @Facet(name="INDEXED", value="true")}), @NiagaraProperty(name="zoneDisplayPath", type="String", defaultValue="", flags=1, facets={@Facet(name="WIDTH", value="256")}), @NiagaraProperty(name="fallbackEnforcement", type="BEnforcementEnum", defaultValue="BEnforcementEnum.soft", flags=9), @NiagaraProperty(name="accessZoneTypeSpec", type="BTypeSpec", defaultValue="BTypeSpec.DEFAULT", flags=9, facets={@Facet(name="WIDTH", value="64"), @Facet(name="INDEXED", value="true")})})
public class BAccessZoneRec
extends BReplicableObject
implements BIOrdMappable {
    public static final Property uuid = BAccessZoneRec.newProperty((int)1, (BValue)BUuid.NULL, (BFacets)BFacets.make((String)"key", (boolean)true));
    public static final Property zoneName = BAccessZoneRec.newProperty((int)9, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"width", (int)128), (BFacets)BFacets.make((String)"displayId", (boolean)true)));
    public static final Property stationName = BAccessZoneRec.newProperty((int)9, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"width", (int)64), (BFacets)BFacets.make((String)"indexed", (boolean)true)));
    public static final Property zoneDisplayPath = BAccessZoneRec.newProperty((int)1, (String)"", (BFacets)BFacets.make((String)"width", (int)256));
    public static final Property fallbackEnforcement = BAccessZoneRec.newProperty((int)9, (BValue)BEnforcementEnum.soft, null);
    public static final Property accessZoneTypeSpec = BAccessZoneRec.newProperty((int)9, (BValue)BTypeSpec.DEFAULT, (BFacets)BFacets.make((BFacets)BFacets.make((String)"width", (int)64), (BFacets)BFacets.make((String)"indexed", (boolean)true)));
    public static final Type TYPE = Sys.loadType(BAccessZoneRec.class);
    public static final OrionType ORION_TYPE = (OrionType)TYPE;
    private static boolean hasAccessZones = true;

    public BUuid getUuid() {
        return (BUuid)this.get(uuid);
    }

    public void setUuid(BUuid v) {
        this.set(uuid, (BValue)v, null);
    }

    public String getZoneName() {
        return this.getString(zoneName);
    }

    public void setZoneName(String v) {
        this.setString(zoneName, v, null);
    }

    @Override
    public String getStationName() {
        return this.getString(stationName);
    }

    public void setStationName(String v) {
        this.setString(stationName, v, null);
    }

    public String getZoneDisplayPath() {
        return this.getString(zoneDisplayPath);
    }

    public void setZoneDisplayPath(String v) {
        this.setString(zoneDisplayPath, v, null);
    }

    public BEnforcementEnum getFallbackEnforcement() {
        return (BEnforcementEnum)this.get(fallbackEnforcement);
    }

    public void setFallbackEnforcement(BEnforcementEnum v) {
        this.set(fallbackEnforcement, (BValue)v, null);
    }

    public BTypeSpec getAccessZoneTypeSpec() {
        return (BTypeSpec)this.get(accessZoneTypeSpec);
    }

    public void setAccessZoneTypeSpec(BTypeSpec v) {
        this.set(accessZoneTypeSpec, (BValue)v, null);
    }

    public OccupantsCursor getOccupants(OrionSession session) {
        return new OccupantsCursor(session.linkedScan((BIOrionObject)this, BPersonZoneJoin.ORION_TYPE, BPerson.ORION_TYPE));
    }

    public SupervisorsCursor getSupervisors(OrionSession session) {
        return new SupervisorsCursor(session.linkedScan((BIOrionObject)this, BSupervisorZoneJoin.ORION_TYPE, BPerson.ORION_TYPE));
    }

    @Override
    public Type getType() {
        return this.getTypeFromSpace(TYPE);
    }

    public void mapFrom(BObject source) {
        BAccessZone zone = (BAccessZone)source;
        BMappedZoneExt ext = (BMappedZoneExt)zone.getMixIn(BMappedZoneExt.TYPE);
        this.setUuid(ext.getUuid());
        this.setLastModified(BAbsTime.now());
        if (Sys.getStation() != null) {
            this.setStationName(Sys.getStation().getStationName());
        }
        this.setFallbackEnforcement(zone.getHighestEnforcement());
        if (zone.isRunning()) {
            String displayName = zone.getDisplayName(null);
            if (displayName != null) {
                this.setZoneName(displayName);
            } else if (zone.getName() != null) {
                this.setZoneName(zone.getName());
            } else {
                throw new IllegalStateException("need a name when is running");
            }
            this.setSlotPathOrd(source);
            this.setAccessZoneTypeSpec(zone.getType().getTypeSpec());
        }
    }

    @Override
    public BOrd getMappedOrd() {
        return MappingSupport.getMappedOrd(this);
    }

    @Override
    public void setSlotPathOrd(BObject source) {
        this.setZoneDisplayPath(MappingSupport.getDisplayPath(source));
    }

    @Override
    public String getMappedDisplayPath() {
        return this.getZoneDisplayPath();
    }

    public String toString(Context cx) {
        return this.toDisplayString(cx);
    }

    public BIcon getIcon() {
        return BAccessZone.ICON;
    }

    public int getOccupiedCount(OrionSession session) {
        BSqlQuery q = BSqlQuery.make((OrionType)BPersonZoneJoin.ORION_TYPE);
        q.select(SqlColumns.projection((BProjectionColumn)SqlColumns.make((BExpression)Funcs.count((String)"*"))));
        BSqlField recField = new BSqlField(BPersonZoneJoin.ORION_TYPE, BPersonZoneJoin.accessZone);
        q.where(Predicates.eq((BExpression)recField, (BSimple)BRef.make((BIOrionObject)this)));
        OrionCursor c = session.select((BQuery)q);
        c.next();
        BDynamicOrionObject result = (BDynamicOrionObject)c.get();
        OrionType type = result.getOrionType();
        Property[] dps = type.getProperties();
        int total = ((BInteger)result.get(dps[0])).getInt();
        return total;
    }

    public int getOccupiedSupervisorCount(OrionSession session) {
        BSqlField f1 = new BSqlField(BPersonZoneJoin.ORION_TYPE, BPersonZoneJoin.accessZone);
        BSqlField f2 = new BSqlField(BSupervisorZoneJoin.ORION_TYPE, BSupervisorZoneJoin.accessZone);
        BSqlField f3 = new BSqlField(BPersonZoneJoin.ORION_TYPE, BPersonZoneJoin.person);
        BSqlField f4 = new BSqlField(BSupervisorZoneJoin.ORION_TYPE, BSupervisorZoneJoin.person);
        BSqlExtent joinExtent = new BSqlExtent(BSupervisorZoneJoin.ORION_TYPE);
        BExpression e = Predicates.and((BExpression)Predicates.eq((BExpression)f1, (BExpression)f2), (BExpression)Predicates.eq((BExpression)f3, (BExpression)f4));
        BSqlJoin join = new BSqlJoin(BJoin.innerJoin, joinExtent, e);
        BSqlQuery q = BSqlQuery.make((OrionType)BPersonZoneJoin.ORION_TYPE);
        q.select(SqlColumns.projection((BProjectionColumn)SqlColumns.make((BExpression)Funcs.count((String)"*"))));
        q.join(join);
        q.where(Predicates.eq((BExpression)f1.newExprCopy(), (BSimple)BRef.make((BIOrionObject)this)));
        OrionCursor c = session.select((BQuery)q);
        c.next();
        BDynamicOrionObject result = (BDynamicOrionObject)c.get();
        OrionType type = result.getOrionType();
        Property[] dps = type.getProperties();
        int total = ((BInteger)result.get(dps[0])).getInt();
        return total;
    }

    @Override
    public void afterInsert(OrionSession session) {
        hasAccessZones = true;
        super.afterInsert(session);
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        service.getDbCache().insertAccessZone(this);
    }

    @Override
    public void afterUpdate(OrionSession session) {
        super.afterUpdate(session);
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        service.getDbCache().updateAccessZone(this);
        if (Sys.getStation() != null && Sys.getStation().getStationName().equals(this.getStationName())) {
            BAccessZone accessZone = (BAccessZone)this.getMappedOrd().get();
            accessZone.persistGrouping();
        }
    }

    @Override
    public void afterDelete(OrionSession session) {
        super.afterDelete(session);
        BAccessZoneRec.recountCache(session);
    }

    @Override
    public boolean beforeDelete(OrionSession session) {
        BAccessZoneRec rec = (BAccessZoneRec)session.read((BIOrionObject)this.newCopy());
        if (rec == null) {
            return false;
        }
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        service.getDbCache().deleteAccessZone(session, this);
        return super.beforeDelete(session);
    }

    @Override
    public boolean beforeInsert(OrionSession session) {
        this.updateNewColumns();
        return super.beforeInsert(session);
    }

    @Override
    public boolean beforeUpdate(OrionSession session) {
        this.updateNewColumns();
        return super.beforeUpdate(session);
    }

    private void updateNewColumns() {
        if (this.getAccessZoneTypeSpec().isNull()) {
            this.setAccessZoneTypeSpec(BAccessZone.TYPE.getTypeSpec());
        }
    }

    public static boolean hasAccessZones() {
        return hasAccessZones;
    }

    public static void recountCache(OrionSession session) {
        int count = CountingUtil.getCount((OrionType)ORION_TYPE, (OrionSession)session);
        hasAccessZones = count > 0;
    }

    public static class SupervisorsCursor
    implements OrionCursor {
        private final OrionCursor cursor;

        private SupervisorsCursor(OrionCursor cursor) {
            this.cursor = cursor;
        }

        public Context getContext() {
            return this.cursor.getContext();
        }

        public OrionType getOrionType() {
            return this.cursor.getOrionType();
        }

        public BIOrionObject[] toArray() {
            return this.cursor.toArray();
        }

        public boolean next() {
            return this.cursor.next();
        }

        public boolean nextComponent() {
            return this.cursor.nextComponent();
        }

        public boolean next(Class<?> cls) {
            return this.cursor.next(cls);
        }

        public BObject get() {
            return (BObject)this.cursor.get();
        }

        public OrionSession getSession() {
            return this.cursor.getSession();
        }

        public void close() {
            this.cursor.close();
        }

        public BPerson getPerson() {
            return (BPerson)this.cursor.get();
        }
    }

    public static class OccupantsCursor
    implements OrionCursor {
        private final OrionCursor cursor;

        private OccupantsCursor(OrionCursor cursor) {
            this.cursor = cursor;
        }

        public Context getContext() {
            return this.cursor.getContext();
        }

        public OrionType getOrionType() {
            return this.cursor.getOrionType();
        }

        public BIOrionObject[] toArray() {
            return this.cursor.toArray();
        }

        public boolean next() {
            return this.cursor.next();
        }

        public boolean nextComponent() {
            return this.cursor.nextComponent();
        }

        public boolean next(Class<?> cls) {
            return this.cursor.next(cls);
        }

        public BObject get() {
            return (BObject)this.cursor.get();
        }

        public OrionSession getSession() {
            return this.cursor.getSession();
        }

        public void close() {
            this.cursor.close();
        }

        public BPerson getPerson() {
            return (BPerson)this.cursor.get();
        }
    }
}

