/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.orion;

import com.tridium.entsecDriver.BIAccessReader;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.annotations.NiagaraOrionType;
import com.tridium.orion.annotations.OrionLinkedCursor;
import com.tridium.orion.annotations.OrionLinkedCursors;
import com.tridiumx.accessDriver.BAccessReader;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.BMappedReaderExt;
import com.tridiumx.entsec.access.orion.BAccessZoneRec;
import com.tridiumx.entsec.access.orion.BEntryReaderZoneJoin;
import com.tridiumx.entsec.access.orion.BExitReaderZoneJoin;
import com.tridiumx.entsec.orionTools.BIOrdMappable;
import com.tridiumx.entsec.orionTools.MappingSupport;
import com.tridiumx.entsec.orionTools.replicate.BReplicableObject;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;

@NiagaraType(agent={@AgentOn(types={"entsecDriver:IAccessReader"})})
@NiagaraOrionType
@OrionLinkedCursors(value={@OrionLinkedCursor(name="EntryAccessZones", type="BAccessZoneRec", link="BEntryReaderZoneJoin"), @OrionLinkedCursor(name="ExitAccessZones", type="BAccessZoneRec", link="BExitReaderZoneJoin")})
@NiagaraProperties(value={@NiagaraProperty(name="uuid", type="BUuid", defaultValue="BUuid.NULL", facets={@Facet(name="KEY", value="true")}), @NiagaraProperty(name="readerName", type="String", defaultValue="", flags=8, facets={@Facet(name="WIDTH", value="128"), @Facet(name="DISPLAY_ID", value="true")}), @NiagaraProperty(name="assignment", type="String", defaultValue="", flags=8, facets={@Facet(name="WIDTH", value="128"), @Facet(name="DISPLAY_ID", value="true")}), @NiagaraProperty(name="stationName", type="String", defaultValue="", flags=4, facets={@Facet(name="WIDTH", value="64")}), @NiagaraProperty(name="readerDisplayPath", type="String", defaultValue="", facets={@Facet(name="WIDTH", value="256")}), @NiagaraProperty(name="readerTypeSpec", type="BTypeSpec", defaultValue="BAccessReader.TYPE.getTypeSpec()", flags=9, facets={@Facet(name="WIDTH", value="64"), @Facet(name="INDEXED", value="true")}), @NiagaraProperty(name="remoteDeviceName", type="String", defaultValue="", flags=9, facets={@Facet(name="WIDTH", value="64"), @Facet(name="INDEXED", value="true"), @Facet(name="DISPLAY_ID", value="true")})})
public class BAccReaderRec
extends BReplicableObject
implements BIOrdMappable {
    public static final Property uuid = BAccReaderRec.newProperty((int)0, (BValue)BUuid.NULL, (BFacets)BFacets.make((String)"key", (boolean)true));
    public static final Property readerName = BAccReaderRec.newProperty((int)8, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"width", (int)128), (BFacets)BFacets.make((String)"displayId", (boolean)true)));
    public static final Property assignment = BAccReaderRec.newProperty((int)8, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"width", (int)128), (BFacets)BFacets.make((String)"displayId", (boolean)true)));
    public static final Property stationName = BAccReaderRec.newProperty((int)4, (String)"", (BFacets)BFacets.make((String)"width", (int)64));
    public static final Property readerDisplayPath = BAccReaderRec.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"width", (int)256));
    public static final Property readerTypeSpec = BAccReaderRec.newProperty((int)9, (BValue)BAccessReader.TYPE.getTypeSpec(), (BFacets)BFacets.make((BFacets)BFacets.make((String)"width", (int)64), (BFacets)BFacets.make((String)"indexed", (boolean)true)));
    public static final Property remoteDeviceName = BAccReaderRec.newProperty((int)9, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"width", (int)64), (BFacets)BFacets.make((String)"indexed", (boolean)true)), (BFacets)BFacets.make((String)"displayId", (boolean)true)));
    public static final Type TYPE = Sys.loadType(BAccReaderRec.class);
    public static final OrionType ORION_TYPE = (OrionType)TYPE;
    private static final BIcon ICON = BIcon.std((String)"card.png");

    public BUuid getUuid() {
        return (BUuid)this.get(uuid);
    }

    public void setUuid(BUuid v) {
        this.set(uuid, (BValue)v, null);
    }

    public String getReaderName() {
        return this.getString(readerName);
    }

    public void setReaderName(String v) {
        this.setString(readerName, v, null);
    }

    public String getAssignment() {
        return this.getString(assignment);
    }

    public void setAssignment(String v) {
        this.setString(assignment, v, null);
    }

    @Override
    public String getStationName() {
        return this.getString(stationName);
    }

    public void setStationName(String v) {
        this.setString(stationName, v, null);
    }

    public String getReaderDisplayPath() {
        return this.getString(readerDisplayPath);
    }

    public void setReaderDisplayPath(String v) {
        this.setString(readerDisplayPath, v, null);
    }

    public BTypeSpec getReaderTypeSpec() {
        return (BTypeSpec)this.get(readerTypeSpec);
    }

    public void setReaderTypeSpec(BTypeSpec v) {
        this.set(readerTypeSpec, (BValue)v, null);
    }

    public String getRemoteDeviceName() {
        return this.getString(remoteDeviceName);
    }

    public void setRemoteDeviceName(String v) {
        this.setString(remoteDeviceName, v, null);
    }

    public EntryAccessZonesCursor getEntryAccessZones(OrionSession session) {
        return new EntryAccessZonesCursor(session.linkedScan((BIOrionObject)this, BEntryReaderZoneJoin.ORION_TYPE, BAccessZoneRec.ORION_TYPE));
    }

    public ExitAccessZonesCursor getExitAccessZones(OrionSession session) {
        return new ExitAccessZonesCursor(session.linkedScan((BIOrionObject)this, BExitReaderZoneJoin.ORION_TYPE, BAccessZoneRec.ORION_TYPE));
    }

    @Override
    public Type getType() {
        return this.getTypeFromSpace(TYPE);
    }

    public void mapFrom(BObject source) {
        BIAccessReader reader = (BIAccessReader)source;
        BMappedReaderExt ext = (BMappedReaderExt)reader.getMixIn(BMappedReaderExt.TYPE);
        this.setUuid(ext.getUuid());
        this.setLastModified(BAbsTime.now());
        String assignment = reader.getAssignment();
        if (assignment != null) {
            if (assignment.length() > 120) {
                assignment = assignment.substring(0, 120) + "...";
            }
            this.setAssignment(assignment);
        }
        this.setRemoteDeviceName(reader.getRemoteDeviceName());
        if (Sys.getStation() != null) {
            this.setStationName(Sys.getStation().getStationName());
        }
        if (reader.isRunning()) {
            String displayName = reader.getDisplayName(null);
            if (displayName != null) {
                this.setReaderName(displayName);
            } else if (reader.getName() != null) {
                this.setReaderName(reader.getName());
            } else {
                throw new IllegalStateException("need a name when is running");
            }
            this.setSlotPathOrd(source);
            this.setReaderTypeSpec(reader.getType().getTypeSpec());
        }
    }

    @Override
    public boolean beforeInsert(OrionSession session) {
        this.updateNewColumns();
        return super.beforeInsert(session);
    }

    @Override
    public boolean beforeUpdate(OrionSession session) {
        this.updateNewColumns();
        return super.beforeUpdate(session);
    }

    private void updateNewColumns() {
        if (this.getRemoteDeviceName().equals("")) {
            this.setRemoteDeviceName(this.getStationName());
        }
    }

    @Override
    public BOrd getMappedOrd() {
        return MappingSupport.getMappedOrd(this);
    }

    @Override
    public void setSlotPathOrd(BObject source) {
        this.setReaderDisplayPath(MappingSupport.getDisplayPath(source));
    }

    @Override
    public String getMappedDisplayPath() {
        return this.getReaderDisplayPath();
    }

    public String toString(Context cx) {
        return this.toDisplayString(cx);
    }

    public String toDisplayString(Context cx) {
        return this.getStationName() + ":" + this.getAssignment() + "." + this.getReaderName();
    }

    public String toDisplayString() {
        return this.getStationName() + ":" + this.getAssignment() + "." + this.getReaderName();
    }

    @Override
    public void afterInsert(OrionSession session) {
        super.afterInsert(session);
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        service.getDbCache().insertReaderRec(this);
    }

    @Override
    public void afterUpdate(OrionSession session) {
        super.afterUpdate(session);
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        service.getDbCache().updateReaderRec(this);
    }

    @Override
    public void afterDelete(OrionSession session) {
        super.afterDelete(session);
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        service.getDbCache().deleteReaderRec(this);
    }

    public BIcon getIcon() {
        return ICON;
    }

    public static class ExitAccessZonesCursor
    implements OrionCursor {
        private final OrionCursor cursor;

        private ExitAccessZonesCursor(OrionCursor cursor) {
            this.cursor = cursor;
        }

        public Context getContext() {
            return this.cursor.getContext();
        }

        public OrionType getOrionType() {
            return this.cursor.getOrionType();
        }

        public BIOrionObject[] toArray() {
            return this.cursor.toArray();
        }

        public boolean next() {
            return this.cursor.next();
        }

        public boolean nextComponent() {
            return this.cursor.nextComponent();
        }

        public boolean next(Class<?> cls) {
            return this.cursor.next(cls);
        }

        public BObject get() {
            return (BObject)this.cursor.get();
        }

        public OrionSession getSession() {
            return this.cursor.getSession();
        }

        public void close() {
            this.cursor.close();
        }

        public BAccessZoneRec getAccessZoneRec() {
            return (BAccessZoneRec)this.cursor.get();
        }
    }

    public static class EntryAccessZonesCursor
    implements OrionCursor {
        private final OrionCursor cursor;

        private EntryAccessZonesCursor(OrionCursor cursor) {
            this.cursor = cursor;
        }

        public Context getContext() {
            return this.cursor.getContext();
        }

        public OrionType getOrionType() {
            return this.cursor.getOrionType();
        }

        public BIOrionObject[] toArray() {
            return this.cursor.toArray();
        }

        public boolean next() {
            return this.cursor.next();
        }

        public boolean nextComponent() {
            return this.cursor.nextComponent();
        }

        public boolean next(Class<?> cls) {
            return this.cursor.next(cls);
        }

        public BObject get() {
            return (BObject)this.cursor.get();
        }

        public OrionSession getSession() {
            return this.cursor.getSession();
        }

        public void close() {
            this.cursor.close();
        }

        public BAccessZoneRec getAccessZoneRec() {
            return (BAccessZoneRec)this.cursor.get();
        }
    }
}

