/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.dyntable;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionSession;
import com.tridium.orion.priv.dt.BDynamicTableColumn;
import com.tridiumx.accessDriver.BAccessReader;
import com.tridiumx.accessDriver.BDoorController;
import com.tridiumx.entsec.access.dyntable.BAcTable;
import com.tridiumx.entsec.access.orion.BAccReaderRec;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.filter.BSecFutureAbsTimeFilter;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import java.util.HashMap;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;

@NiagaraType
@NiagaraProperty(name="rowType", type="BOrionTypeId", defaultValue="BOrionTypeId.make(BBadge.TYPE.getTypeSpec())", flags=1, override=true)
@NiagaraActions(value={@NiagaraAction(name="subscribeToRemoteReader", parameterType="BRef", defaultValue="BRef.DEFAULT", returnType="BString", flags=2052), @NiagaraAction(name="endSubscription", flags=2052)})
public class BBadges
extends BAcTable {
    public static final Property rowType = BBadges.newProperty((int)1, (BValue)BOrionTypeId.make((BTypeSpec)BBadge.TYPE.getTypeSpec()), null);
    public static final Action subscribeToRemoteReader = BBadges.newAction((int)2052, (BValue)BRef.DEFAULT, null);
    public static final Action endSubscription = BBadges.newAction((int)2052, null);
    public static final Type TYPE = Sys.loadType(BBadges.class);
    public static final BIcon ICON = BIcon.make((String)"module://entsec/rc/access/cards.png");
    private HashMap<String, RemoteSubscriber> subscribers = new HashMap();

    public BString subscribeToRemoteReader(BRef parameter) {
        return (BString)this.invoke(subscribeToRemoteReader, (BValue)parameter, null);
    }

    public void endSubscription() {
        this.invoke(endSubscription, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void stopped() throws Exception {
        super.stopped();
        Object[] keys = this.subscribers.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            this.endSubscription(keys[i].toString());
        }
    }

    public void setColumns(BDynamicTableColumn[] cols) {
        super.setColumns(cols);
        cols = this.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            if (!cols[i].getFromProperty().equals(BBadge.issueDate.getName().toString())) continue;
            cols[i].setDefaultFilter((BValue)new BSecFutureAbsTimeFilter());
            cols[i].setFlags((Slot)BDynamicTableColumn.defaultFilter, 0x10000000);
        }
    }

    public BIcon getIcon() {
        return ICON;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BString doSubscribeToRemoteReader(BRef readerRef, Context cx) throws Exception {
        BUuid readerUuid = (BUuid)readerRef.getId();
        if (readerUuid == null) {
            return null;
        }
        OrionSession orionSession = null;
        BAccessReader reader = null;
        try {
            orionSession = this.getOrionDatabase().createSession(null);
            BAccReaderRec rec = (BAccReaderRec)orionSession.read(BAccReaderRec.ORION_TYPE, (BSimple)readerUuid);
            String interest = TYPE + ".subscribeToRemoteReader." + BUuid.make().toString();
            BFoxSession foxSession = null;
            String stationName = rec.getStationName();
            if (stationName.equals(Sys.getStation().getStationName())) {
                reader = (BAccessReader)rec.getMappedOrd().get();
            } else {
                BNiagaraNetwork nn = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
                BNiagaraStation station = (BNiagaraStation)nn.getNiagaraStation(stationName);
                foxSession = RemoteUtil.getFoxSession(station);
                foxSession.engageNoRetry(interest);
                BComponent remoteComponent = RemoteUtil.getRemoteComponent(foxSession, rec.getMappedOrd().toString());
                if (remoteComponent instanceof BAccessReader) {
                    remoteComponent.lease();
                    reader = (BAccessReader)remoteComponent;
                }
            }
            reader.setLastBadgeRead("");
            String propertyName = "lastBadgeRead_" + cx.getUser().getUsername();
            if (this.get(propertyName) == null) {
                this.add(propertyName, (BValue)BString.make((String)reader.getLastBadgeRead()), 7);
            } else {
                this.set(propertyName, (BValue)BString.make((String)reader.getLastBadgeRead()));
            }
            RemoteSubscriber subscriber = this.subscribers.get(propertyName);
            if (subscriber != null) {
                subscriber.unsubscribeAll();
            }
            subscriber = new RemoteSubscriber(reader, propertyName, foxSession, interest);
            subscriber.subscribe((BComponent)reader);
            this.subscribers.put(propertyName, subscriber);
            BString bString = BString.make((String)propertyName);
            return bString;
        }
        finally {
            if (orionSession != null) {
                orionSession.close();
                orionSession = null;
            }
        }
    }

    public void doEndSubscription(Context cx) {
        String propertyName = "lastBadgeRead_" + cx.getUser().getUsername();
        this.endSubscription(propertyName);
    }

    public void endSubscription(String propertyName) {
        if (this.get(propertyName) != null) {
            RemoteSubscriber subscriber = this.subscribers.get(propertyName);
            if (subscriber != null) {
                subscriber.unsubscribe((BComponent)this);
                subscriber = null;
                this.subscribers.remove(propertyName);
            }
            this.remove(propertyName);
        }
    }

    class RemoteSubscriber
    extends Subscriber {
        BAccessReader remoteReader;
        String properyName;
        BFoxSession foxSession;
        String interest;

        public RemoteSubscriber(BAccessReader remoteReader, String properyName, BFoxSession foxSession, String interest) {
            this.remoteReader = remoteReader;
            this.properyName = properyName;
            this.foxSession = foxSession;
            this.interest = interest;
        }

        public void event(BComponentEvent event) {
            if (event.getSourceComponent() == this.remoteReader && event.getId() == 0 && event.getSlotName().equals(BDoorController.lastBadgeRead.getName())) {
                BBadges.this.set(this.properyName, (BValue)BString.make((String)event.getValue().toString()));
            }
        }

        protected void unsubscribed(BComponent c, Context cx) {
            if (this.foxSession != null) {
                this.foxSession.disengage(this.interest);
                this.foxSession = null;
            }
        }
    }
}

