/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access;

import com.tridium.nrio.points.BNrioPointDeviceExt;
import com.tridiumx.accessDriver.BActivityAlertExt;
import com.tridiumx.accessDriver.BSecAlarmSourceInfo;
import com.tridiumx.accessDriver.enums.activity.BActivity;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.BBurglarPanelStatusEnum;
import com.tridiumx.entsec.securityUtil.BIAsyncStationStarted;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.data.BIDataValue;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="out", type="BStatusBoolean", defaultValue="new BStatusBoolean(false)", flags=1, facets={@Facet(name="BFacets.TRUE_TEXT", value="BAccessControlService.lex.getText(\"active\")"), @Facet(name="BFacets.FALSE_TEXT", value="BAccessControlService.lex.getText(\"inactive\")")}), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=71), @NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="relayPulseTime", type="BRelTime", defaultValue="BRelTime.make(BRelTime.MILLIS_IN_SECOND * 5)", facets={@Facet(name="BFacets.SHOW_MILLISECONDS", value="false"), @Facet(name="BFacets.MIN", value="BRelTime.make(0)"), @Facet(name="BFacets.MAX", value="BRelTime.makeMinutes(1)")}), @NiagaraProperty(name="armingIn", type="BStatusBoolean", defaultValue="new BStatusBoolean(false, BStatus.nullStatus)", flags=8, facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"entsec:ScheduleOrIntrusionZoneLinkFE\"")}), @NiagaraProperty(name="panelArmStatus", type="BStatusBoolean", defaultValue="new BStatusBoolean(false, BStatus.nullStatus)", flags=8, facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"entsec:BurglarPointLinkChooserFE\"")}), @NiagaraProperty(name="panelArmRelay", type="BStatusBoolean", defaultValue="new BStatusBoolean(false)", flags=8, facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"entsec:BurglarPointKnobChooserFE\"")}), @NiagaraProperty(name="alarmDelay", type="BRelTime", defaultValue="BRelTime.makeMinutes(1)", flags=8, facets={@Facet(name="BFacets.MIN", value="BRelTime.DEFAULT"), @Facet(name="BFacets.MAX", value="BRelTime.makeMinutes(5)")}), @NiagaraProperty(name="burglarPanelMismatch", type="BActivityAlertExt", defaultValue="new BActivityAlertExt(BBurglarPanelStatusEnum.alarm, initAlarmSourceInfo(), false)")})
@NiagaraActions(value={@NiagaraAction(name="turnOffPanelArmRelay", flags=4), @NiagaraAction(name="startStableState", flags=4)})
public class BBurglarPanel
extends BComponent
implements BIAsyncStationStarted {
    public static final Property out = BBurglarPanel.newProperty((int)1, (BValue)new BStatusBoolean(false), (BFacets)BFacets.make((BFacets)BFacets.make((String)"trueText", (String)BAccessControlService.lex.getText("active")), (BFacets)BFacets.make((String)"falseText", (String)BAccessControlService.lex.getText("inactive"))));
    public static final Property faultCause = BBurglarPanel.newProperty((int)71, (String)"", null);
    public static final Property enabled = BBurglarPanel.newProperty((int)0, (boolean)true, null);
    public static final Property relayPulseTime = BBurglarPanel.newProperty((int)0, (BValue)BRelTime.make((long)5000L), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"showMilliseconds", (boolean)false), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)0L))), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.makeMinutes((int)1))));
    public static final Property armingIn = BBurglarPanel.newProperty((int)8, (BValue)new BStatusBoolean(false, BStatus.nullStatus), (BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:ScheduleOrIntrusionZoneLinkFE"));
    public static final Property panelArmStatus = BBurglarPanel.newProperty((int)8, (BValue)new BStatusBoolean(false, BStatus.nullStatus), (BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:BurglarPointLinkChooserFE"));
    public static final Property panelArmRelay = BBurglarPanel.newProperty((int)8, (BValue)new BStatusBoolean(false), (BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:BurglarPointKnobChooserFE"));
    public static final Property alarmDelay = BBurglarPanel.newProperty((int)8, (BValue)BRelTime.makeMinutes((int)1), (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.DEFAULT), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.makeMinutes((int)5))));
    public static final Property burglarPanelMismatch = BBurglarPanel.newProperty((int)0, (BValue)new BActivityAlertExt((BActivity)BBurglarPanelStatusEnum.alarm, BBurglarPanel.initAlarmSourceInfo(), false), null);
    public static final Action turnOffPanelArmRelay = BBurglarPanel.newAction((int)4, null);
    public static final Action startStableState = BBurglarPanel.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BBurglarPanel.class);
    private Clock.Ticket startStableStateTicket = null;
    private Clock.Ticket ticket = null;
    private boolean lastArmingIn = false;
    private boolean lastArmingStatus;
    private boolean stableState = true;
    public static final BIcon ICON = BIcon.std((String)"camera.png");

    public BStatusBoolean getOut() {
        return (BStatusBoolean)this.get(out);
    }

    public void setOut(BStatusBoolean v) {
        this.set(out, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BRelTime getRelayPulseTime() {
        return (BRelTime)this.get(relayPulseTime);
    }

    public void setRelayPulseTime(BRelTime v) {
        this.set(relayPulseTime, (BValue)v, null);
    }

    public BStatusBoolean getArmingIn() {
        return (BStatusBoolean)this.get(armingIn);
    }

    public void setArmingIn(BStatusBoolean v) {
        this.set(armingIn, (BValue)v, null);
    }

    public BStatusBoolean getPanelArmStatus() {
        return (BStatusBoolean)this.get(panelArmStatus);
    }

    public void setPanelArmStatus(BStatusBoolean v) {
        this.set(panelArmStatus, (BValue)v, null);
    }

    public BStatusBoolean getPanelArmRelay() {
        return (BStatusBoolean)this.get(panelArmRelay);
    }

    public void setPanelArmRelay(BStatusBoolean v) {
        this.set(panelArmRelay, (BValue)v, null);
    }

    public BRelTime getAlarmDelay() {
        return (BRelTime)this.get(alarmDelay);
    }

    public void setAlarmDelay(BRelTime v) {
        this.set(alarmDelay, (BValue)v, null);
    }

    public BActivityAlertExt getBurglarPanelMismatch() {
        return (BActivityAlertExt)this.get(burglarPanelMismatch);
    }

    public void setBurglarPanelMismatch(BActivityAlertExt v) {
        this.set(burglarPanelMismatch, (BValue)v, null);
    }

    public void turnOffPanelArmRelay() {
        this.invoke(turnOffPanelArmRelay, null, null);
    }

    public void startStableState() {
        this.invoke(startStableState, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        String faultCause = null;
        if (!this.intrusionLicensed()) {
            faultCause = "Feature \"intrusion\" not licensed";
            this.hideAndSetFaultCause(false, faultCause);
            throw new FeatureNotLicensedException(faultCause);
        }
        this.hideAndSetFaultCause(true, "");
        this.lastArmingIn = this.getArmingIn().getValue();
        this.init();
        if (this.getPanelArmRelay().getStatus().isNull()) {
            this.getPanelArmRelay().setStatus(BStatus.makeNull((BStatus)this.getPanelArmRelay().getStatus(), (boolean)false));
        }
    }

    private void hideAndSetFaultCause(boolean hide, String faultCauseMsg) {
        if (hide) {
            if (!Flags.isHidden((BComplex)this, (Slot)faultCause)) {
                this.setFlags((Slot)faultCause, this.getFlags((Slot)faultCause) | 4);
            }
        } else if (Flags.isHidden((BComplex)this, (Slot)faultCause)) {
            this.setFlags((Slot)faultCause, this.getFlags((Slot)faultCause) & 0xFFFFFFFB);
        }
        this.setFaultCause(faultCauseMsg);
        if (!hide) {
            this.setOut(new BStatusBoolean(false, BStatus.fault));
        }
    }

    private boolean intrusionLicensed() {
        try {
            Sys.getLicenseManager().checkFeature("tridium", "intrusion");
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void stationStarted() throws Exception {
        BEnterpriseSecurityService.postAsyncStationStarted(this);
    }

    @Override
    public void asyncStationStarted() throws Exception {
        if (!this.isRunning()) {
            return;
        }
        this.checkStableStateMismatch();
    }

    public void stopped() throws Exception {
        if (this.ticket != null) {
            this.ticket.cancel();
            this.ticket = null;
        }
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property == relayPulseTime || property == enabled) {
            this.init();
        }
        if (property == armingIn && this.getEnabled() && this.getArmingIn().getValue() != this.lastArmingIn) {
            this.lastArmingIn = this.getArmingIn().getValue();
            this.startCheckForBurglars();
        }
        if (property == panelArmRelay) {
            this.getOut().setValue(this.getPanelArmRelay().getValue());
        }
        if (property == panelArmStatus && this.stableState) {
            try {
                this.checkStableStateMismatch();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void checkStableStateMismatch() throws Exception {
        if (this.getPanelArmStatus().getValue() != this.getArmingIn().getValue()) {
            this.getBurglarPanelMismatch().generateAlert("Stable State Mismatch");
        }
    }

    public void doStartStableState() throws Exception {
        this.stableState = true;
        if (this.getPanelArmStatus().getValue() != this.getArmingIn().getValue()) {
            this.getBurglarPanelMismatch().generateAlert("Alarm Delay Expired");
        }
    }

    public void startCheckForBurglars() {
        this.stableState = false;
        if (this.getAlarmDelay() != BRelTime.DEFAULT) {
            this.setTimer(this.startStableStateTicket, this.getAlarmDelay(), startStableState);
            this.checkForBurglars();
        } else {
            this.checkForBurglars();
            this.startStableState();
        }
    }

    public void doTurnOffPanelArmRelay() {
        this.updatePanelArmRelay(false);
    }

    private void checkForBurglars() {
        if (this.getArmingIn().getValue() != this.lastArmingStatus && this.getArmingIn().getValue() != this.getPanelArmStatus().getValue()) {
            this.updatePanelArmRelay(true);
            return;
        }
        this.updateLastArmingStatus();
    }

    private void init() {
        this.getOut().setValue(false);
        this.updatePanelArmRelay(false);
    }

    private synchronized void updatePanelArmRelay(boolean value) {
        if (!this.isRunning()) {
            return;
        }
        this.updateLastArmingStatus();
        this.getPanelArmRelay().setValue(value);
        if (value) {
            if (this.ticket == null) {
                this.ticket = Clock.schedule((BComponent)this, (BRelTime)this.getRelayPulseTime(), (Action)turnOffPanelArmRelay, null);
            }
        } else if (this.ticket != null) {
            this.ticket.cancel();
            this.ticket = null;
        }
    }

    private synchronized void updateLastArmingStatus() {
        if (!this.isRunning()) {
            return;
        }
        this.lastArmingStatus = this.getArmingIn().getValue();
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BNrioPointDeviceExt;
    }

    private Clock.Ticket setTimer(Clock.Ticket ticket, BRelTime time, Action action) {
        this.cancelTimer(ticket);
        return Clock.schedule((BComponent)this, (BRelTime)time.abs(), (Action)action, null);
    }

    private void cancelTimer(Clock.Ticket ticket) {
        if (ticket != null) {
            ticket.cancel();
        }
        ticket = null;
    }

    static BSecAlarmSourceInfo initAlarmSourceInfo() {
        BSecAlarmSourceInfo asi = new BSecAlarmSourceInfo();
        asi.setFlags((Slot)BAlarmSourceInfo.toFaultText, 4);
        asi.setFlags((Slot)BAlarmSourceInfo.toOffnormalText, 4);
        asi.setFlags((Slot)BAlarmSourceInfo.toNormalText, 4);
        asi.setSourceName(BFormat.make((String)"%parent.parent.displayName%"));
        return asi;
    }

    public BIcon getIcon() {
        return ICON;
    }
}

